/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.EntityResolver;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import uk.ac.starlink.util.StarEntityResolver;

public class NodeEntityResolver
implements EntityResolver {
    private static NodeEntityResolver instance = new NodeEntityResolver();
    private StarEntityResolver localResolver = StarEntityResolver.getInstance();
    private Map cache = new HashMap();

    public static NodeEntityResolver getInstance() {
        return instance;
    }

    private NodeEntityResolver() {
    }

    public InputSource resolveEntity(String publicId, String systemId) throws SAXException, IOException {
        InputSource is = this.localResolver.resolveEntity(publicId, systemId);
        if (is != null) {
            return is;
        }
        if (this.cache.containsKey(systemId)) {
            ByteArrayInputStream istrm = new ByteArrayInputStream((byte[])this.cache.get(systemId));
            InputSource isrc = new InputSource(istrm);
            isrc.setPublicId(publicId);
            isrc.setSystemId(systemId);
            return isrc;
        }
        try {
            URL url = new URL(systemId);
            String proto = url.getProtocol();
            if (!proto.equals("jar") && !proto.equals("file")) {
                ByteArrayOutputStream ostrm = new ByteArrayOutputStream();
                InputStream istrm = url.openStream();
                byte[] buf = new byte[512];
                int nb = istrm.read(buf, 0, 512);
                while (nb > 0) {
                    ostrm.write(buf, 0, nb);
                    nb = istrm.read(buf, 0, 512);
                }
                istrm.close();
                ostrm.close();
                this.cache.put(systemId, ostrm.toByteArray());
                return this.resolveEntity(publicId, systemId);
            }
        }
        catch (MalformedURLException e) {
            return null;
        }
        catch (IOException e) {
            return null;
        }
        return null;
    }
}

