/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import javax.swing.JComponent;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.ExceptionComponentMaker;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.util.Compression;
import uk.ac.starlink.util.DataSource;

public class PlainDataNode
extends DefaultDataNode {
    private DataSource datsrc;
    private String name;
    private Boolean isText;

    public PlainDataNode(DataSource datsrc) throws NoSuchDataException {
        this.datsrc = datsrc.forceCompression(Compression.NONE);
        this.name = datsrc.getName();
        this.setLabel(this.name);
        this.setIconID((short)135);
        this.registerDataObject(DataType.DATA_SOURCE, datsrc);
    }

    public String getName() {
        return this.name;
    }

    public String getNodeTLA() {
        return "DATA";
    }

    public String getNodeType() {
        return "Unknown data";
    }

    public String getPathElement() {
        return this.name;
    }

    public void configureDetail(DetailViewer dv) {
        try {
            byte[] intro = this.datsrc.getIntro();
            if (intro.length > 0 && NodeUtil.isASCII(intro)) {
                dv.addPane("Text view", new ComponentMaker(){

                    public JComponent getComponent() throws IOException {
                        return new TextViewer(PlainDataNode.this.datsrc.getInputStream());
                    }
                });
            }
        }
        catch (IOException e) {
            dv.addPane("Error reading text", new ExceptionComponentMaker(e));
        }
    }
}

