/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.JDBCHandler;
import uk.ac.starlink.table.jdbc.SwingAuthenticator;
import uk.ac.starlink.table.jdbc.TerminalAuthenticator;
import uk.ac.starlink.util.DataSource;

public class StarTableDataNode
extends DefaultDataNode {
    private StarTable startable;
    private String name;
    private String description;
    private static StarTableFactory tabfact;
    static final /* synthetic */ boolean $assertionsDisabled;

    public StarTableDataNode(StarTable startable) {
        this.startable = startable;
        this.name = startable.getName();
        if (this.name == null) {
            this.name = "Table";
        }
        this.setLabel(this.name);
        long nrow = startable.getRowCount();
        this.description = "" + startable.getColumnCount() + 'x' + (nrow > 0L ? Long.toString(nrow) : "*");
        this.setIconID((short)117);
        this.registerDataObject(DataType.TABLE, startable);
    }

    public StarTableDataNode(String loc) throws NoSuchDataException {
        this(StarTableDataNode.makeStarTable(loc));
    }

    public StarTableDataNode(DataSource datsrc) throws NoSuchDataException {
        this(StarTableDataNode.makeStarTable(datsrc));
    }

    public String getName() {
        return this.name;
    }

    public String getDescription() {
        return this.description;
    }

    public String getNodeTLA() {
        return "TAB";
    }

    public String getNodeType() {
        return "StarTable";
    }

    public boolean hasDataObject(DataType dtype) {
        if (DataType.TABLE.equals(dtype)) {
            return true;
        }
        return super.hasDataObject(dtype);
    }

    public Object getDataObject(DataType dtype) throws DataObjectException {
        if (DataType.TABLE.equals(dtype)) {
            if (!$assertionsDisabled && !StarTable.class.equals(dtype.getDataClass())) {
                throw new AssertionError();
            }
            return this.startable;
        }
        return super.getDataObject(dtype);
    }

    public static StarTable makeStarTable(String loc) throws NoSuchDataException {
        try {
            return StarTableDataNode.getTableFactory().makeStarTable(loc);
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
    }

    public static StarTable makeStarTable(DataSource datsrc) throws NoSuchDataException {
        try {
            return StarTableDataNode.getTableFactory().makeStarTable(datsrc);
        }
        catch (IOException e) {
            throw new NoSuchDataException(e);
        }
    }

    public static StarTableFactory getTableFactory() {
        if (tabfact == null) {
            tabfact = new StarTableFactory(false){

                public JDBCHandler getJDBCHandler() {
                    JDBCHandler handler = super.getJDBCHandler();
                    if (handler.getAuthenticator() instanceof TerminalAuthenticator && NodeUtil.hasGUI()) {
                        SwingAuthenticator auth = new SwingAuthenticator();
                        handler.setAuthenticator((JDBCAuthenticator)auth);
                    }
                    return handler;
                }
            };
        }
        return tabfact;
    }

    static {
        $assertionsDisabled = !StarTableDataNode.class.desiredAssertionStatus();
    }
}

