/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import javax.swing.JComponent;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.factory.VODataNodeBuilder;
import uk.ac.starlink.datanode.nodes.ComponentMaker;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.DocumentDataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.VOComponentDataNode;
import uk.ac.starlink.datanode.nodes.XMLDocument;
import uk.ac.starlink.datanode.viewers.StyledTextArea;
import uk.ac.starlink.datanode.viewers.TextViewer;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOElementFactory;

public class VOTableDataNode
extends DocumentDataNode {
    private String name;
    private VOElement vocel;
    private static VOElementFactory vofact = new VOElementFactory();

    public VOTableDataNode(XMLDocument xdoc) throws NoSuchDataException {
        super(xdoc);
        this.checkTopLocalName("VOTABLE");
        this.setIconID((short)140);
    }

    public String getNodeTLA() {
        return "VOT";
    }

    public String getNodeType() {
        return "VOTable";
    }

    public boolean allowsChildren() {
        return true;
    }

    public String getPathSeparator() {
        return "#";
    }

    private VOElement getVOElement() throws IOException, SAXException {
        if (this.vocel == null) {
            this.vocel = vofact.makeVOElement(this.getDocument());
        }
        return this.vocel;
    }

    public Iterator getChildIterator() {
        ArrayList<DataNode> children = new ArrayList<DataNode>();
        try {
            Iterator it = VOComponentDataNode.getChildElements(this.getVOElement()).iterator();
            while (it.hasNext()) {
                VOElement el = (VOElement)it.next();
                DOMSource xsrc = new DOMSource((Node)el, el.getSystemId());
                children.add(this.makeChild(xsrc));
            }
        }
        catch (IOException e) {
            return Collections.singleton(this.makeErrorChild(e)).iterator();
        }
        catch (SAXException e) {
            return Collections.singleton(this.makeErrorChild(e)).iterator();
        }
        return children.iterator();
    }

    public void configureDetail(DetailViewer dv) {
        super.configureDetail(dv);
        dv.addPane("Document Metadata", new ComponentMaker(){

            public JComponent getComponent() {
                VOElement[] infos;
                VOElement voel;
                try {
                    voel = VOTableDataNode.this.getVOElement();
                }
                catch (IOException e) {
                    return new TextViewer(e);
                }
                catch (SAXException e) {
                    return new TextViewer(e);
                }
                StyledTextArea sta = new StyledTextArea();
                sta.setWrap(true);
                String description = voel.getDescription();
                if (description != null) {
                    sta.addSubHead("Description");
                    sta.addText(description);
                }
                if ((infos = voel.getChildrenByName("INFO")).length > 0) {
                    sta.addSubHead("Infos");
                    for (int i = 0; i < infos.length; ++i) {
                        String name = infos[i].getAttribute("name");
                        String value = infos[i].getAttribute("value");
                        if (name == null) continue;
                        sta.addKeyedItem(name, value != null ? value : "null");
                    }
                }
                return sta;
            }
        });
    }

    public DataNodeFactory getChildMaker() {
        DataNodeFactory dfact = super.getChildMaker();
        if (!(dfact.getBuilders().get(0) instanceof VODataNodeBuilder)) {
            dfact = new DataNodeFactory(dfact);
            dfact.getBuilders().add(0, new VODataNodeBuilder());
        }
        return dfact;
    }
}

