/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.util.Iterator;
import javax.xml.transform.Source;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.DetailViewer;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.VOComponentDataNode;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.votable.TableElement;
import uk.ac.starlink.votable.VOElement;
import uk.ac.starlink.votable.VOStarTable;

public class VOTableTableDataNode
extends VOComponentDataNode {
    private TableElement votable;
    private StarTable startable;
    private String desc;

    public VOTableTableDataNode(Source xsrc) throws NoSuchDataException {
        super(xsrc, "TABLE");
        if (!(this.getElement() instanceof TableElement)) {
            throw new NoSuchDataException("Not a TABLE element");
        }
        this.votable = (TableElement)this.getElement();
        long nrows = this.votable.getNrows();
        this.desc = "(" + this.votable.getFields().length + "x" + (nrows >= 0L ? "" + nrows : "?") + ")";
        this.setIconID((short)117);
    }

    public String getNodeTLA() {
        return "TAB";
    }

    public String getNodeType() {
        return "VOTable table data";
    }

    public String getDescription() {
        return this.desc;
    }

    public boolean allowsChildren() {
        return false;
    }

    public void configureDetail(DetailViewer dv) {
        VOElement[] dataChildren;
        super.configureDetail(dv);
        VOElement dat = this.vocel.getChildByName("DATA");
        if (dat != null && (dataChildren = dat.getChildren()).length > 0) {
            String imp = dataChildren[0].getTagName();
            dv.addKeyedItem("Data implementation", imp);
        }
    }

    public boolean hasDataObject(DataType dtype) {
        if (dtype == DataType.TABLE) {
            return true;
        }
        return super.hasDataObject(dtype);
    }

    public Object getDataObject(DataType dtype) throws DataObjectException {
        if (dtype == DataType.TABLE) {
            try {
                return this.getStarTable();
            }
            catch (IOException e) {
                throw new DataObjectException(e);
            }
        }
        return super.getDataObject(dtype);
    }

    private StarTable getStarTable() throws IOException {
        if (this.startable == null) {
            this.startable = Tables.randomTable((StarTable)new VOStarTable(this.votable));
            Iterator it = this.startable.getParameters().iterator();
            while (it.hasNext()) {
                if (!((DescribedValue)it.next()).getInfo().getName().equalsIgnoreCase("Description")) continue;
                it.remove();
            }
        }
        return this.startable;
    }
}

