/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import uk.ac.starlink.ast.Channel;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;

class WCSChannel
extends Channel {
    private long[] pos;
    private int nel;
    private HDSObject hobj;

    WCSChannel(HDSObject hobj) throws NoSuchDataException {
        try {
            if (!hobj.datType().startsWith("_CHAR") || hobj.datShape().length != 1) {
                throw new NoSuchDataException("Not a character array");
            }
            this.hobj = hobj;
            this.pos = new long[]{1L};
            this.nel = (int)hobj.datShape()[0];
        }
        catch (HDSException e) {
            throw new NoSuchDataException(e.getMessage());
        }
    }

    protected String source() throws IOException {
        String line;
        try {
            String next;
            line = this.hobj.datCell(this.pos).datGet0c();
            this.pos[0] = this.pos[0] + 1L;
            while (this.pos[0] <= (long)this.nel && (next = this.hobj.datCell(this.pos).datGet0c()).length() > 0 && next.charAt(0) == '+') {
                line = line + next.substring(1);
                this.pos[0] = this.pos[0] + 1L;
            }
        }
        catch (HDSException e) {
            throw new IOException(e.getMessage());
        }
        return line;
    }

    protected void sink(String line) {
        throw new UnsupportedOperationException("sink() not provided");
    }
}

