/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.nodes;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import javax.xml.transform.dom.DOMSource;
import org.w3c.dom.Document;
import org.xml.sax.Attributes;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.Locator;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;
import org.xml.sax.XMLReader;
import org.xml.sax.helpers.DefaultHandler;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeEntityResolver;
import uk.ac.starlink.util.DataSource;

public class XMLDocument {
    private final DataSource datsrc;
    private String topLocalName;
    private String topNamespaceURI;
    private Attributes topAtts;
    private Set namespaces;
    private List messages;
    private String systemId;
    private String publicId;
    public static final String[] MAGICS = new String[]{"<!", "<?"};
    public static final String[] ENCODINGS = new String[]{"UTF-8", "UTF-16", "UTF-16BE", "UTF-16LE"};

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public XMLDocument(DataSource datsrc) throws NoSuchDataException {
        this.datsrc = datsrc;
        InputStream datstrm = null;
        try {
            try {
                datstrm = datsrc.getHybridInputStream();
                InputSource saxsrc = new InputSource(datstrm);
                saxsrc.setSystemId(datsrc.getSystemId());
                SAXParserFactory spfact = SAXParserFactory.newInstance();
                spfact.setNamespaceAware(true);
                spfact.setValidating(false);
                SAXParser sparser = spfact.newSAXParser();
                XMLReader parser = sparser.getXMLReader();
                parser.setFeature("http://xml.org/sax/features/namespaces", true);
                parser.setEntityResolver(NodeEntityResolver.getInstance());
                this.messages = new ArrayList();
                parser.setErrorHandler(new ErrorHandler(){

                    public void warning(SAXParseException e) {
                        XMLDocument.this.messages.add(e.toString());
                    }

                    public void error(SAXParseException e) {
                        XMLDocument.this.messages.add(e.toString());
                    }

                    public void fatalError(SAXParseException e) throws SAXParseException {
                        throw e;
                    }
                });
                this.namespaces = new HashSet();
                parser.setContentHandler(new DefaultHandler(){
                    boolean started;
                    Locator locator;

                    public void setDocumentLocator(Locator loc) {
                        this.locator = loc;
                    }

                    public void startDocument() {
                        if (this.locator != null) {
                            XMLDocument.this.systemId = this.locator.getSystemId();
                            XMLDocument.this.publicId = this.locator.getPublicId();
                        }
                    }

                    public void startElement(String namespaceURI, String localName, String qName, Attributes atts) {
                        if (!this.started) {
                            XMLDocument.this.topLocalName = localName;
                            XMLDocument.this.topNamespaceURI = namespaceURI;
                            XMLDocument.this.topAtts = atts;
                            this.started = true;
                        }
                    }

                    public void startPrefixMapping(String prefix, String uri) {
                        XMLDocument.this.namespaces.add(uri);
                    }
                });
                parser.parse(saxsrc);
            }
            catch (IOException e) {
                throw new NoSuchDataException("I/O error during SAX parse", e);
            }
            catch (SAXException e) {
                throw new NoSuchDataException("SAX parsing error", e);
            }
            catch (ParserConfigurationException e) {
                throw new NoSuchDataException("Error getting default parser - shouldn't happen", e);
            }
            Object var8_10 = null;
            if (datstrm == null) return;
        }
        catch (Throwable throwable) {
            Object var8_11 = null;
            if (datstrm == null) throw throwable;
            try {
                datstrm.close();
                throw throwable;
            }
            catch (IOException e) {
                // empty catch block
            }
            throw throwable;
        }
        try {}
        catch (IOException e) {}
        datstrm.close();
        return;
    }

    public DataSource getDataSource() {
        return this.datsrc;
    }

    public String getTopLocalName() {
        return this.topLocalName;
    }

    public String getTopNamespaceURI() {
        return this.topNamespaceURI;
    }

    public Attributes getTopAttributes() {
        return this.topAtts;
    }

    public Collection getNamespaces() {
        return this.namespaces;
    }

    public List getMessages() {
        return this.messages;
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getPublicId() {
        return this.publicId;
    }

    public String getName() {
        return this.datsrc.getName();
    }

    public DOMSource parseToDOM(boolean validate, ErrorHandler ehandler) throws SAXException, IOException {
        DocumentBuilder parser;
        try {
            DocumentBuilderFactory dbfact = DocumentBuilderFactory.newInstance();
            dbfact.setValidating(validate);
            parser = dbfact.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw (SAXException)new SAXException("Error configuring normal validating parser").initCause(e);
        }
        parser.setEntityResolver(NodeEntityResolver.getInstance());
        if (ehandler != null) {
            parser.setErrorHandler(ehandler);
        }
        InputStream strm = this.getDataSource().getInputStream();
        Document doc = parser.parse(strm);
        strm.close();
        return new DOMSource(doc, this.datsrc.getSystemId());
    }

    public DOMSource constructDOM(boolean validate) throws NoSuchDataException {
        ErrorHandler ehandler = new ErrorHandler(){

            public void warning(SAXParseException e) {
            }

            public void error(SAXParseException e) {
            }

            public void fatalError(SAXParseException e) throws SAXException {
                throw e;
            }
        };
        try {
            return this.parseToDOM(validate, ehandler);
        }
        catch (IOException e) {
            throw new NoSuchDataException("I/O error during SAX parse", e);
        }
        catch (SAXException e) {
            throw new NoSuchDataException("SAX parsing error", e);
        }
    }

    public static boolean isMagic(byte[] magic) {
        return XMLDocument.getEncoding(magic) != null;
    }

    public static String getEncoding(byte[] magic) {
        for (int i = 0; i < ENCODINGS.length; ++i) {
            String test;
            String encoding = ENCODINGS[i];
            if (Charset.isSupported(encoding)) {
                try {
                    test = new String(magic, encoding);
                }
                catch (UnsupportedEncodingException e) {
                    throw new AssertionError((Object)("Encoding " + encoding + " not supported??"));
                }
            } else {
                System.err.println("Unsupported charset: " + encoding);
                break;
            }
            for (int j = 0; j < MAGICS.length; ++j) {
                if (!test.startsWith(MAGICS[j])) continue;
                if (test.indexOf("<HTML") > 0 || test.indexOf("<html") > 0) {
                    return null;
                }
                return encoding;
            }
        }
        return null;
    }
}

