/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree;

import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionListener;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.TransferHandler;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;
import uk.ac.starlink.connect.ConnectorManager;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.BranchDataNode;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.tree.BasicDropHandler;
import uk.ac.starlink.datanode.tree.DataNodeTransferHandler;
import uk.ac.starlink.datanode.tree.DataNodeTreeCellRenderer;
import uk.ac.starlink.datanode.tree.DataNodeTreeModel;
import uk.ac.starlink.datanode.tree.NodeExpander;
import uk.ac.starlink.datanode.tree.TreeModelNode;

public class DataNodeJTree
extends JTree {
    private DataNodeTreeModel model;
    private TreePath dragStarted;
    private TreePath dragNow;

    public DataNodeJTree(DataNodeTreeModel model) {
        super(model);
        this.setRootVisible(false);
        this.setShowsRootHandles(true);
        this.putClientProperty("JTree.lineStyle", "Angled");
        this.setToggleClickCount(2);
        this.getSelectionModel().setSelectionMode(1);
        this.setDropTarget(new BasicDropHandler(this){

            protected boolean isDropLocation(Point loc) {
                return DataNodeJTree.this.getPathForLocation(loc.x, loc.y) == null;
            }
        });
        this.setTransferHandler(new DataNodeTransferHandler());
        this.setDragEnabled(true);
        this.addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent evt) {
                if (!SwingUtilities.isMiddleMouseButton(evt)) {
                    DataNodeJTree.this.dragStarted = DataNodeJTree.this.getPathForLocation(evt.getX(), evt.getY());
                }
            }

            public void mouseClicked(MouseEvent evt) {
                TransferHandler th;
                if (SwingUtilities.isMiddleMouseButton(evt) && evt.getClickCount() == 1 && (th = DataNodeJTree.this.getTransferHandler()) instanceof DataNodeTransferHandler) {
                    ((DataNodeTransferHandler)th).pasteSystemSelection(DataNodeJTree.this);
                }
            }
        });
        this.addMouseMotionListener(new MouseMotionListener(){

            public void mouseDragged(MouseEvent evt) {
                if (!SwingUtilities.isMiddleMouseButton(evt)) {
                    DataNodeJTree.this.dragNow = DataNodeJTree.this.getPathForLocation(evt.getX(), evt.getY());
                }
            }

            public void mouseMoved(MouseEvent evt) {
            }
        });
        this.setCellRenderer(new DataNodeTreeCellRenderer());
    }

    public DataNodeJTree(DataNode root) {
        this(new DataNodeTreeModel(root));
    }

    public synchronized void setModel(TreeModel model) {
        this.model = (DataNodeTreeModel)model;
        super.setModel(model);
    }

    public Thread recursiveExpand(final DataNode dataNode) {
        TreeModelNode modelNode = this.model.getModelNode(dataNode);
        final TreePath startPath = new TreePath(this.model.getPathToRoot(dataNode));
        final TreeModelListener expanderListener = new TreeModelListener(){

            public void treeNodesInserted(TreeModelEvent evt) {
                TreePath path = evt.getTreePath();
                if (startPath.isDescendant(path) && !DataNodeJTree.this.hasBeenExpanded(path)) {
                    DataNodeJTree.this.expandPathLater(path);
                }
            }

            public void treeNodesChanged(TreeModelEvent evt) {
            }

            public void treeNodesRemoved(TreeModelEvent evt) {
            }

            public void treeStructureChanged(TreeModelEvent evt) {
            }
        };
        this.model.addTreeModelListener(expanderListener);
        Thread expander = new Thread("Recursive expander: " + dataNode){

            public void run() {
                DataNodeJTree.this.recursiveExpand(DataNodeJTree.this.model.getModelNode(dataNode));
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        DataNodeJTree.access$200(5.access$400(this.this$1)).removeTreeModelListener(5.access$300(this.this$1));
                    }
                });
            }

            static /* synthetic */ TreeModelListener access$300(5 x0) {
                return x0.expanderListener;
            }

            static /* synthetic */ DataNodeJTree access$400(5 x0) {
                return x0.DataNodeJTree.this;
            }
        };
        expander.start();
        return expander;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void recursiveExpand(TreeModelNode modelNode) {
        NodeExpander newExpander;
        TreeModelNode treeModelNode = modelNode;
        synchronized (treeModelNode) {
            DataNode dataNode = modelNode.getDataNode();
            if (!this.model.containsNode(dataNode)) {
                return;
            }
            if (!dataNode.allowsChildren()) {
                return;
            }
            NodeExpander expander = modelNode.getExpander();
            if (expander == null) {
                newExpander = new NodeExpander(this.model, modelNode);
            } else if (expander.isComplete()) {
                newExpander = null;
            } else {
                this.model.refreshNode(dataNode);
                modelNode = this.model.getModelNode(dataNode);
                newExpander = new NodeExpander(this.model, modelNode);
            }
            if (newExpander != null) {
                modelNode.setExpander(newExpander);
            }
        }
        if (newExpander != null) {
            newExpander.expandNode();
        }
        Iterator it = modelNode.getChildren().iterator();
        while (it.hasNext()) {
            this.recursiveExpand((TreeModelNode)it.next());
        }
    }

    public void expandPathLater(final TreePath path) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                DataNode node = (DataNode)path.getLastPathComponent();
                if (DataNodeJTree.this.model.containsNode(node)) {
                    DataNodeJTree.this.expandPath(path);
                }
            }
        });
    }

    public DataNode getDraggedNode() {
        return this.dragStarted == null ? null : (DataNode)this.dragStarted.getLastPathComponent();
    }

    public DataNode getDropNode() {
        return this.dragNow == null ? null : (DataNode)this.dragNow.getLastPathComponent();
    }

    public Action[] getConnectionActions(final DataNodeFactory factory) {
        Connector[] connectors = ConnectorManager.getConnectors();
        Action[] connectActions = new Action[connectors.length];
        for (int i = 0; i < connectActions.length; ++i) {
            final Connector connector = connectors[i];
            AbstractAction connAct = new AbstractAction(){

                public void actionPerformed(ActionEvent evt) {
                    DataNodeJTree.this.connectorLogin(connector, factory);
                }
            };
            String name = connector.getName();
            connAct.putValue("Name", name + " Connection");
            connAct.putValue("SmallIcon", connector.getIcon());
            connAct.putValue("ShortDescription", "Browse files in a " + name + " filestore");
            connectActions[i] = connAct;
        }
        return connectActions;
    }

    private void connectorLogin(Connector connector, DataNodeFactory factory) {
        Connection connection = ConnectorManager.showConnectionDialog((Component)this, (Connector)connector);
        if (connection != null) {
            DataNode node;
            Branch branch = connection.getRoot();
            try {
                node = factory.makeDataNode(null, branch);
                if (node instanceof BranchDataNode) {
                    ((BranchDataNode)node).setConnection(connection);
                    ((BranchDataNode)node).setPath(branch.toString());
                }
            }
            catch (NoSuchDataException e) {
                node = factory.makeErrorDataNode(null, e);
            }
            this.model.appendNode(node, (DataNode)this.model.getRoot());
            TreePath tpath = new TreePath(this.model.getPathToRoot(node));
            this.scrollPathToVisible(tpath);
            this.setSelectionPath(tpath);
        }
    }
}

