/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.TransferHandler;
import javax.swing.tree.TreePath;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.tree.DataNodeJTree;
import uk.ac.starlink.datanode.tree.DataNodeTransferable;
import uk.ac.starlink.datanode.tree.DataNodeTreeModel;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.TemporaryFileDataSource;

public class DataNodeTransferHandler
extends TransferHandler {
    private DataNodeFactory nodeMaker;

    public int getSourceActions(JComponent comp) {
        return comp instanceof DataNodeJTree ? 1 : 0;
    }

    public Icon getVisualRepresentation(Transferable trans) {
        Icon icon = trans instanceof DataNodeTransferable ? ((DataNodeTransferable)trans).getDataNode().getIcon() : null;
        return icon;
    }

    protected Transferable createTransferable(JComponent comp) {
        DataNodeJTree tree;
        DataNode node;
        if (comp instanceof DataNodeJTree && (node = (tree = (DataNodeJTree)comp).getDraggedNode()) != null) {
            DataNodeTransferable trans = new DataNodeTransferable(node);
            return trans.getTransferDataFlavors().length > 0 ? trans : null;
        }
        return null;
    }

    public void setNodeMaker(DataNodeFactory nodeMaker) {
        this.nodeMaker = nodeMaker;
    }

    public boolean canImport(JComponent comp, DataFlavor[] flavors) {
        return comp instanceof DataNodeJTree && this.nodeMaker != null;
    }

    public boolean importData(JComponent comp, Transferable trans) {
        if (!(comp instanceof DataNodeJTree) || this.nodeMaker == null) {
            return false;
        }
        DataNodeJTree jtree = (DataNodeJTree)comp;
        DataNode root = (DataNode)jtree.getModel().getRoot();
        int success = 0;
        DataFlavor[] flavors = trans.getTransferDataFlavors();
        for (int i = 0; i < flavors.length; ++i) {
            try {
                DataNode node = this.makeDataNode(trans, flavors[i], root);
                this.importNode(jtree, node);
                ++success;
                return true;
            }
            catch (NoSuchDataException e) {
                continue;
            }
            catch (IOException e) {
                e.printStackTrace();
                continue;
            }
            catch (UnsupportedFlavorException e) {
                e.printStackTrace();
            }
        }
        if (success == 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("Couldn't import transferable " + trans + "; tried flavours " + flavors.length + ":");
            for (int i = 0; i < flavors.length; ++i) {
                msg.append("\n   ").append(flavors[i]);
            }
            NoSuchDataException e = new NoSuchDataException(msg.toString());
            this.importNode(jtree, this.nodeMaker.makeErrorDataNode(root, e));
            return false;
        }
        return true;
    }

    public void pasteSystemSelection(JComponent comp) {
        block7: {
            Clipboard selection = comp.getToolkit().getSystemSelection();
            if (comp instanceof DataNodeJTree && selection != null) {
                DataNodeJTree jtree = (DataNodeJTree)comp;
                DataNode root = (DataNode)jtree.getModel().getRoot();
                Transferable selTrans = selection.getContents(null);
                DataFlavor stringFlavor = DataFlavor.stringFlavor;
                if (selTrans != null && selTrans.isDataFlavorSupported(stringFlavor)) {
                    try {
                        DataNode node;
                        String stringData = (String)selTrans.getTransferData(stringFlavor);
                        stringData = stringData.trim();
                        if (stringData.length() >= 160) break block7;
                        try {
                            node = this.nodeMaker.makeDataNode(root, stringData);
                        }
                        catch (NoSuchDataException e) {
                            node = this.nodeMaker.makeErrorDataNode(root, e);
                            node.setLabel(stringData);
                        }
                        this.importNode(jtree, node);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    catch (UnsupportedFlavorException e) {
                        e.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private DataNode makeDataNode(Transferable trans, DataFlavor flavor, DataNode root) throws NoSuchDataException, IOException, UnsupportedFlavorException {
        Object obj;
        Class<?> clazz;
        if (InputStream.class.isAssignableFrom(clazz = flavor.getRepresentationClass()) && !flavor.isFlavorSerializedObjectType()) {
            InputStream istrm = (InputStream)trans.getTransferData(flavor);
            obj = new TemporaryFileDataSource(istrm, "Transferred");
            return this.nodeMaker.makeDataNode(root, obj);
        } else if (clazz.equals(URL.class)) {
            URL url = (URL)trans.getTransferData(flavor);
            if (url.getProtocol().equals("file")) {
                File file = new File(url.getPath());
                if (!file.exists()) throw new NoSuchDataException("File URL " + url + " not present");
                obj = file;
                return this.nodeMaker.makeDataNode(root, obj);
            } else {
                obj = DataSource.makeDataSource(url);
            }
            return this.nodeMaker.makeDataNode(root, obj);
        } else {
            obj = trans.getTransferData(flavor);
        }
        return this.nodeMaker.makeDataNode(root, obj);
    }

    private void importNode(DataNodeJTree jtree, DataNode node) {
        DataNodeTreeModel treeModel = (DataNodeTreeModel)jtree.getModel();
        DataNode root = (DataNode)treeModel.getRoot();
        treeModel.appendNode(node, root);
        TreePath tpath = new TreePath(treeModel.getPathToRoot(node));
        jtree.scrollPathToVisible(tpath);
        jtree.setSelectionPath(tpath);
    }
}

