/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree;

import java.awt.Component;
import java.awt.Font;
import javax.swing.JTree;
import javax.swing.tree.DefaultTreeCellRenderer;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.tree.DataNodeTreeModel;
import uk.ac.starlink.datanode.tree.NodeExpander;
import uk.ac.starlink.datanode.tree.TreeModelNode;

public class DataNodeTreeCellRenderer
extends DefaultTreeCellRenderer {
    private Font normalFont;
    private Font expandingFont;

    public Component getTreeCellRendererComponent(JTree jtree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        super.getTreeCellRendererComponent(jtree, value, selected, expanded, leaf, row, hasFocus);
        if (value instanceof DataNode) {
            DataNode node = (DataNode)value;
            this.setIcon(node.getIcon());
            String text = NodeUtil.toString(node);
            if (text.trim().length() == 0) {
                text = "...";
            }
            this.setText(text);
            DataNodeTreeModel treeModel = (DataNodeTreeModel)jtree.getModel();
            boolean isExpanding = false;
            if (treeModel.containsNode(node)) {
                TreeModelNode modelNode = treeModel.getModelNode(node);
                NodeExpander expander = modelNode.getExpander();
                isExpanding = expander != null && !expander.isStopped();
            }
            this.configureNode(node, isExpanding);
        }
        return this;
    }

    protected void configureNode(DataNode node, boolean isExpanding) {
        if (this.normalFont == null) {
            this.normalFont = this.getFont();
            this.expandingFont = this.normalFont.deriveFont(2);
        }
        this.setFont(isExpanding ? this.expandingFont : this.normalFont);
    }
}

