/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree;

import java.awt.Component;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.JButton;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.CompressedDataNode;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DataObjectException;
import uk.ac.starlink.datanode.nodes.DataType;
import uk.ac.starlink.datanode.nodes.HistoryDataNode;
import uk.ac.starlink.datanode.nodes.JDBCDataNode;
import uk.ac.starlink.datanode.nodes.NDFDataNode;
import uk.ac.starlink.datanode.nodes.NdxDataNode;
import uk.ac.starlink.datanode.nodes.StarTableDataNode;
import uk.ac.starlink.datanode.nodes.TableHDUDataNode;
import uk.ac.starlink.datanode.nodes.VOComponentDataNode;
import uk.ac.starlink.datanode.nodes.VOTableDataNode;
import uk.ac.starlink.datanode.nodes.XMLDataNode;
import uk.ac.starlink.datanode.tree.TreeNodeChooser;
import uk.ac.starlink.ndx.Ndx;
import uk.ac.starlink.util.gui.ErrorDialog;

public class NdxNodeChooser
extends TreeNodeChooser {
    private DataNodeFactory nodeFact;
    private int minDims = 1;
    private int maxDims = Integer.MAX_VALUE;
    private static List shunnedClassList;
    private static List deprecatedClassList;
    private static List preferredClassList;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NdxNodeChooser() {
        Action findSelectedAction = this.getSearchSelectedAction();
        Action findAllAction = this.getSearchAllAction();
        findSelectedAction.putValue("ShortDescription", "Locate all NDXs under selected node");
        findAllAction.putValue("ShortDescription", "Locate all NDXs in the tree");
        this.getButtonPanel().add(new JButton(findSelectedAction));
        this.getButtonPanel().add(Box.createHorizontalStrut(10));
        this.getButtonPanel().add(new JButton(findAllAction));
    }

    public void setRoot(DataNode root) {
        NdxNodeChooser.customiseFactory(root.getChildMaker());
        super.setRoot(root);
    }

    public synchronized DataNodeFactory getNodeMaker() {
        if (this.nodeFact == null) {
            this.nodeFact = new DataNodeFactory();
            NdxNodeChooser.customiseFactory(this.nodeFact);
        }
        return this.nodeFact;
    }

    public void setMinDims(int minDims) {
        this.minDims = minDims;
    }

    public void setMaxDims(int maxDims) {
        this.maxDims = maxDims;
    }

    protected boolean isChoosable(DataNode node) {
        return node.hasDataObject(DataType.NDX);
    }

    public Ndx chooseNdx(Component parent, String buttonText, String title) {
        DataNode node = this.chooseDataNode(parent, buttonText, title);
        try {
            return node == null ? null : this.makeNdx(node);
        }
        catch (IOException e) {
            ErrorDialog.showError(parent, "Bad NDX", (Throwable)e, "Failed to make NDX from " + node);
            return null;
        }
    }

    public Ndx chooseNdx(Component parent) {
        return this.chooseNdx(parent, "Open NDX", "NDX browser");
    }

    public Ndx makeNdx(DataNode node) throws IOException {
        if (this.isChoosable(node)) {
            if (!$assertionsDisabled && !node.hasDataObject(DataType.NDX)) {
                throw new AssertionError();
            }
            try {
                return (Ndx)node.getDataObject(DataType.NDX);
            }
            catch (DataObjectException e) {
                throw (IOException)new IOException(e.getMessage()).initCause(e);
            }
        }
        throw new IllegalArgumentException(node + " is not an NDX");
    }

    private static void customiseFactory(DataNodeFactory fact) {
        if (shunnedClassList == null) {
            String[] shunned = new String[]{CompressedDataNode.class.getName(), JDBCDataNode.class.getName(), StarTableDataNode.class.getName(), TableHDUDataNode.class.getName(), VOComponentDataNode.class.getName(), VOTableDataNode.class.getName(), NDFDataNode.class.getName(), HistoryDataNode.class.getName()};
            ArrayList classes = new ArrayList();
            for (int i = 0; i < shunned.length; ++i) {
                try {
                    Class<?> clazz = Class.forName(shunned[i], true, Thread.currentThread().getContextClassLoader());
                    classes.add(clazz);
                    continue;
                }
                catch (ClassNotFoundException e) {
                    // empty catch block
                }
            }
            shunnedClassList = classes;
            deprecatedClassList = Arrays.asList(XMLDataNode.class);
            preferredClassList = Arrays.asList(NdxDataNode.class);
        }
        Iterator it = shunnedClassList.iterator();
        while (it.hasNext()) {
            fact.removeNodeClass((Class)it.next());
        }
        it = deprecatedClassList.iterator();
        while (it.hasNext()) {
            fact.setDeprecatedClass((Class)it.next());
        }
        it = preferredClassList.iterator();
        while (it.hasNext()) {
            fact.setPreferredClass((Class)it.next());
        }
    }

    static {
        $assertionsDisabled = !NdxNodeChooser.class.desiredAssertionStatus();
    }
}

