/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.border.Border;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;
import uk.ac.starlink.connect.ConnectorAction;
import uk.ac.starlink.datanode.factory.CreationState;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.IconFactory;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.nodes.NodeUtil;
import uk.ac.starlink.datanode.tree.DataNodeJTree;
import uk.ac.starlink.datanode.tree.DataNodeTreeCellRenderer;
import uk.ac.starlink.datanode.tree.DataNodeTreeModel;
import uk.ac.starlink.datanode.tree.InfoPanel;
import uk.ac.starlink.datanode.tree.select.NodeRootComboBox;
import uk.ac.starlink.datanode.tree.select.NodeRootModel;

public class TreeNodeChooser
extends JPanel
implements TreeSelectionListener {
    private DataNodeJTree jtree;
    private DataNodeFactory nodeMaker = new DataNodeFactory();
    private InfoPanel infoPanel;
    private NodeRootComboBox rootSelector;
    private JLabel nameLabel;
    private JLabel typeLabel;
    private JLabel descLabel;
    private final JComponent logBox;
    private final JButton logButton;
    private final JLabel logLabel;
    private JTextField gotoField;
    private Action chooseAction;
    private Action cancelAction;
    private Action upAction;
    private Action downAction;
    private Action homeAction;
    private Action searchSelectedAction;
    private Action searchAllAction;
    private DataNode chosenNode;
    private JDialog currentDialog;
    private Box buttonBox;
    private JComponent buttonPanel;
    private static Cursor busyCursor = new Cursor(3);
    private static Font yesFont;
    private static Font noFont;

    public TreeNodeChooser() {
        this.setLayout(new BorderLayout());
        Border gapBorder = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        Border etchedBorder = BorderFactory.createEtchedBorder();
        this.setBorder(gapBorder);
        Box topBox = Box.createVerticalBox();
        JPanel mainPanel = new JPanel();
        Box bottomBox = Box.createVerticalBox();
        this.add((Component)topBox, "North");
        this.add((Component)bottomBox, "South");
        Box rootBox = Box.createHorizontalBox();
        this.rootSelector = new NodeRootComboBox(this.nodeMaker);
        this.rootSelector.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (evt.getStateChange() == 1) {
                    DataNode node = (DataNode)evt.getItem();
                    if (node != null) {
                        TreeNodeChooser.this.setRootNode(node);
                    }
                    TreeNodeChooser.this.setConnectorAction(TreeNodeChooser.this.rootSelector.getConnectorAction());
                }
            }
        });
        rootBox.add(this.rootSelector);
        Action[] actions = this.configureActions();
        for (int i = 0; i < actions.length; ++i) {
            rootBox.add(Box.createHorizontalStrut(10));
            JButton butt = new JButton(actions[i]);
            butt.setMaximumSize(new Dimension(100, 100));
            butt.setText(null);
            rootBox.add(butt);
        }
        topBox.add(rootBox);
        topBox.add(Box.createVerticalStrut(5));
        this.logBox = Box.createHorizontalBox();
        this.logButton = new JButton();
        this.logLabel = new JLabel();
        this.logBox.add(this.logLabel);
        this.logBox.add(Box.createHorizontalStrut(5));
        this.logBox.add(this.logButton);
        this.logBox.add(Box.createHorizontalGlue());
        topBox.add(this.logBox);
        topBox.add(Box.createVerticalStrut(5));
        this.jtree = new DataNodeJTree(new DataNodeTreeModel());
        this.jtree.addTreeSelectionListener(this);
        JScrollPane scroller = new JScrollPane(this.jtree);
        scroller.setBorder(etchedBorder);
        scroller.setPreferredSize(new Dimension(400, 300));
        this.add((Component)scroller, "Center");
        this.jtree.setCellRenderer(new DataNodeTreeCellRenderer(){
            Font[] fonts;

            protected void configureNode(DataNode node, boolean isExpanding) {
                if (this.fonts == null) {
                    this.fonts = new Font[4];
                    this.fonts[0] = this.getFont();
                    this.fonts[1] = this.fonts[0].deriveFont(2);
                    this.fonts[2] = this.fonts[0].deriveFont(1);
                    this.fonts[3] = this.fonts[1].deriveFont(1);
                }
                boolean isChoosable = node != null && TreeNodeChooser.this.isChoosable(node);
                this.setFont(this.fonts[(isExpanding ? 1 : 0) + (isChoosable ? 2 : 0)]);
            }
        });
        this.buttonBox = Box.createVerticalBox();
        bottomBox.add(this.buttonBox);
        this.infoPanel = new InfoPanel();
        this.nameLabel = new JLabel();
        this.typeLabel = new JLabel();
        this.descLabel = new JLabel();
        this.infoPanel.addItem(new JLabel("Name:"), this.nameLabel);
        this.infoPanel.addItem(new JLabel("Type:"), this.typeLabel);
        this.infoPanel.addItem(new JLabel("Description:"), this.descLabel);
        this.infoPanel.setBorder(BorderFactory.createCompoundBorder(etchedBorder, gapBorder));
        bottomBox.add(Box.createVerticalStrut(10));
        bottomBox.add(this.infoPanel);
        Box gotoBox = Box.createHorizontalBox();
        gotoBox.add(new JLabel("Go to: "));
        this.gotoField = new JTextField();
        gotoBox.add(this.gotoField);
        this.gotoField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                TreeNodeChooser.this.attemptSetRootObject(TreeNodeChooser.this.gotoField.getText());
            }
        });
        bottomBox.add(Box.createVerticalStrut(10));
        bottomBox.add(gotoBox);
        this.cancelAction = new DoneAction(false, "Cancel", "Abort chooser dialog");
        this.chooseAction = new DoneAction(true, "Open", "Open selected item");
        Box buttonBox = Box.createHorizontalBox();
        buttonBox.add(Box.createHorizontalGlue());
        buttonBox.add(new JButton(this.chooseAction));
        buttonBox.add(Box.createHorizontalStrut(5));
        buttonBox.add(new JButton(this.cancelAction));
        bottomBox.add(Box.createVerticalStrut(10));
        bottomBox.add(buttonBox);
        this.addAncestorListener(new AncestorListener(){

            public void ancestorAdded(AncestorEvent evt) {
                TreeNodeChooser.this.configureActionAvailability(null);
                TreeNodeChooser.this.removeAncestorListener(this);
            }

            public void ancestorMoved(AncestorEvent evt) {
            }

            public void ancestorRemoved(AncestorEvent evt) {
            }
        });
        this.rootSelector.addDefaultRoots();
    }

    public void setRootObject(Object obj) throws NoSuchDataException {
        DataNode node = this.nodeMaker.makeDataNode(null, obj);
        this.nodeMaker.fillInAncestors(node);
        this.setRootNode(node);
    }

    private void attemptSetRootObject(Object obj) {
        try {
            this.setRootObject(obj);
        }
        catch (NoSuchDataException e) {
            Toolkit.getDefaultToolkit().beep();
        }
    }

    private void setRootNode(DataNode root) {
        DataNode oldRoot = (DataNode)this.jtree.getModel().getRoot();
        if (oldRoot == root || oldRoot != null && root != null && ("" + oldRoot).equals("" + root) && ("" + NodeUtil.getNodePath(oldRoot)).equals("" + NodeUtil.getNodePath(root))) {
            return;
        }
        this.jtree.setModel(new DataNodeTreeModel(root));
        this.setBusy(false);
        this.configureActionAvailability(null);
        this.jtree.expandPathLater(new TreePath(root));
        this.rootSelector.getModel().setSelectedItem(root);
    }

    public NodeRootComboBox getRootSelector() {
        return this.rootSelector;
    }

    public void clear() {
        ((NodeRootModel)this.rootSelector.getModel()).removeAllElements();
    }

    public void setRoot(DataNode node) {
        this.getNodeMaker().fillInAncestors(node);
        this.setRootNode(node);
    }

    public DataNode getRoot() {
        return (DataNode)this.jtree.getModel().getRoot();
    }

    public JComponent getButtonPanel() {
        if (this.buttonPanel == null) {
            this.buttonBox.add(Box.createVerticalStrut(10));
            this.buttonPanel = Box.createHorizontalBox();
            this.buttonBox.add(this.buttonPanel);
        }
        return this.buttonPanel;
    }

    protected void selectNode(DataNode node) {
    }

    public DataNode chooseDataNode(Component parent, String buttonText, String title) {
        this.currentDialog = this.createDialog(parent);
        if (!this.currentDialog.isModal()) {
            throw new IllegalStateException("Return from createDialog is not modal");
        }
        this.chooseAction.putValue("Name", buttonText == null ? "Choose" : buttonText);
        this.currentDialog.setTitle(title == null ? "Hierarchical browser" : title);
        this.chosenNode = null;
        this.currentDialog.show();
        return this.chosenNode;
    }

    public String getChosenPath() {
        return this.chosenNode == null ? null : NodeUtil.getNodePath(this.chosenNode);
    }

    protected JDialog createDialog(Component parent) {
        Frame frame = parent instanceof Frame ? (Frame)parent : (Frame)SwingUtilities.getAncestorOfClass(Frame.class, parent);
        String title = "Select node";
        JDialog dialog = new JDialog(frame, title, true);
        dialog.getContentPane().setLayout(new BorderLayout());
        dialog.getContentPane().add((Component)this, "Center");
        dialog.pack();
        dialog.setLocationRelativeTo(parent);
        return dialog;
    }

    protected void showNodeDetail(DataNode node) {
        this.infoPanel.setIcon(node == null ? null : node.getIcon());
        if (yesFont == null) {
            yesFont = this.nameLabel.getFont();
            noFont = yesFont.deriveFont(0);
        }
        Font font = node != null && this.isChoosable(node) ? yesFont : noFont;
        this.nameLabel.setFont(font);
        this.typeLabel.setFont(font);
        this.descLabel.setFont(font);
        this.nameLabel.setText(node == null ? null : node.getName());
        this.typeLabel.setText(node == null ? null : node.getNodeType());
        this.descLabel.setText(node == null ? null : node.getDescription());
    }

    protected boolean isChoosable(DataNode node) {
        return node != null;
    }

    private void setBusy(boolean busy) {
        this.jtree.setCursor(busy ? busyCursor : null);
    }

    private void setConnectorAction(ConnectorAction act) {
        this.logButton.setAction((Action)act);
        this.logLabel.setText(act == null ? null : act.getConnector().getName());
        this.logBox.setVisible(act != null);
    }

    private Action[] configureActions() {
        this.upAction = new BasicAction("Up", IconFactory.getIcon((short)32), "Move root up one level"){

            public void actionPerformed(ActionEvent evt) {
                TreeNodeChooser.this.setRootNode(TreeNodeChooser.getParent(TreeNodeChooser.this.getRoot()));
            }
        };
        this.downAction = new BasicAction("Down", IconFactory.getIcon((short)33), "Set root to selected node"){

            public void actionPerformed(ActionEvent evt) {
                TreePath tpath = TreeNodeChooser.this.jtree.getSelectionPath();
                if (tpath != null) {
                    TreeNodeChooser.this.setRootNode((DataNode)tpath.getLastPathComponent());
                }
            }
        };
        BasicAction homeAction = new BasicAction("Home", IconFactory.getIcon((short)34), "User home directory"){

            public void actionPerformed(ActionEvent evt) {
                String home = System.getProperty("user.home");
                TreeNodeChooser.this.attemptSetRootObject(new File(home));
            }
        };
        this.searchAllAction = new BasicAction("Search Tree", null, "Search the whole tree"){

            public void actionPerformed(ActionEvent evt) {
                TreeNodeChooser.this.showAllChoosable(TreeNodeChooser.this.getRoot());
            }
        };
        this.searchSelectedAction = new BasicAction("Search Selected", null, "Search the selected node"){

            public void actionPerformed(ActionEvent evt) {
                TreePath tpath = TreeNodeChooser.this.jtree.getSelectionPath();
                if (tpath != null) {
                    TreeNodeChooser.this.showAllChoosable((DataNode)tpath.getLastPathComponent());
                }
            }
        };
        return new Action[]{this.upAction, this.downAction, homeAction};
    }

    public void valueChanged(TreeSelectionEvent evt) {
        TreePath path = evt.getPath();
        DataNode node = path == null ? null : (DataNode)path.getLastPathComponent();
        this.configureActionAvailability(node);
    }

    private void configureActionAvailability(DataNode selectedNode) {
        this.showNodeDetail(selectedNode);
        boolean isSelectedChoosable = selectedNode != null && this.isChoosable(selectedNode);
        boolean isSelectedParent = selectedNode != null && selectedNode.allowsChildren();
        this.upAction.setEnabled(TreeNodeChooser.getParent((DataNode)this.jtree.getModel().getRoot()) != null);
        this.chooseAction.setEnabled(isSelectedChoosable);
        this.downAction.setEnabled(isSelectedParent);
        this.searchSelectedAction.setEnabled(isSelectedParent);
    }

    public DataNodeFactory getNodeMaker() {
        return this.nodeMaker;
    }

    public void setNodeMaker(DataNodeFactory nodeMaker) {
        this.nodeMaker = nodeMaker;
    }

    public Thread showAllChoosable(final DataNode startNode) {
        final DataNodeTreeModel model = (DataNodeTreeModel)this.jtree.getModel();
        final TreePath startPath = new TreePath(model.getPathToRoot(startNode));
        final TreeModelListener finderListener = new TreeModelListener(){

            public void treeNodesInserted(TreeModelEvent evt) {
                TreePath path = evt.getTreePath();
                if (startPath.isDescendant(path) && !TreeNodeChooser.this.jtree.hasBeenExpanded(path)) {
                    Object[] children = evt.getChildren();
                    for (int i = 0; i < children.length; ++i) {
                        if (!TreeNodeChooser.this.isChoosable((DataNode)children[i])) continue;
                        TreeNodeChooser.this.jtree.expandPathLater(path);
                    }
                }
            }

            public void treeNodesChanged(TreeModelEvent evt) {
            }

            public void treeNodesRemoved(TreeModelEvent evt) {
            }

            public void treeStructureChanged(TreeModelEvent evt) {
            }
        };
        model.addTreeModelListener(finderListener);
        Thread finder = new Thread("Choosable finder: " + startNode){

            public void run() {
                TreeNodeChooser.this.jtree.recursiveExpand(model.getModelNode(startNode));
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 11 this$1;
                    {
                        this.this$1 = this$1;
                    }

                    public void run() {
                        11.access$900(this.this$1).removeTreeModelListener(11.access$800(this.this$1));
                        if (11.access$900(this.this$1) == TreeNodeChooser.access$700(11.access$1000(this.this$1)).getModel()) {
                            TreeNodeChooser.access$1100(11.access$1000(this.this$1), false);
                        }
                    }
                });
            }

            static /* synthetic */ TreeModelListener access$800(11 x0) {
                return x0.finderListener;
            }

            static /* synthetic */ DataNodeTreeModel access$900(11 x0) {
                return x0.model;
            }

            static /* synthetic */ TreeNodeChooser access$1000(11 x0) {
                return x0.TreeNodeChooser.this;
            }
        };
        this.setBusy(true);
        finder.start();
        return finder;
    }

    public Action getSearchSelectedAction() {
        return this.searchSelectedAction;
    }

    public Action getSearchAllAction() {
        return this.searchAllAction;
    }

    private static DataNode getParent(DataNode node) {
        CreationState creator = node.getCreator();
        return creator == null ? null : creator.getParent();
    }

    static /* synthetic */ void access$1100(TreeNodeChooser x0, boolean x1) {
        x0.setBusy(x1);
    }

    private class DoneAction
    extends BasicAction {
        boolean useSelection;

        DoneAction(boolean useSelection, String name, String shortdesc) {
            super(name, null, shortdesc);
            this.useSelection = useSelection;
        }

        public void actionPerformed(ActionEvent evt) {
            DataNode node = this.useSelection ? (DataNode)TreeNodeChooser.this.jtree.getSelectionPath().getLastPathComponent() : null;
            TreeNodeChooser.this.chosenNode = node;
            if (TreeNodeChooser.this.currentDialog != null) {
                TreeNodeChooser.this.currentDialog.dispose();
                TreeNodeChooser.this.currentDialog = null;
            }
            TreeNodeChooser.this.selectNode(node);
        }
    }

    private abstract class BasicAction
    extends AbstractAction {
        public BasicAction(String name, Icon icon, String shortdesc) {
            super(name, icon);
            this.putValue("ShortDescription", shortdesc);
        }
    }
}

