/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree.select;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Arrays;
import java.util.Iterator;
import javax.swing.Icon;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.Connector;
import uk.ac.starlink.connect.ConnectorAction;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;

class ConnectorDataNode
extends DefaultDataNode
implements PropertyChangeListener {
    private final ConnectorAction connAct_;
    private final Connector connector_;
    private DataNode rootNode_;

    public ConnectorDataNode(ConnectorAction connAct) {
        this.connAct_ = connAct;
        this.connector_ = connAct.getConnector();
        this.setLabel(this.connector_.getName());
        this.connAct_.addPropertyChangeListener((PropertyChangeListener)this);
    }

    public String getName() {
        return this.rootNode_ == null ? this.connector_.getName() : this.rootNode_.getName();
    }

    public ConnectorAction getConnectorAction() {
        return this.connAct_;
    }

    public Icon getIcon() {
        return this.rootNode_ == null ? this.connector_.getIcon() : this.rootNode_.getIcon();
    }

    public String getNodeTLA() {
        return "CON";
    }

    public String getNodeType() {
        return "Remote Connector";
    }

    public boolean allowsChildren() {
        return true;
    }

    public Iterator getChildIterator() {
        return this.rootNode_ == null ? Arrays.asList(new DataNode[0]).iterator() : this.rootNode_.getChildIterator();
    }

    public void propertyChange(PropertyChangeEvent evt) {
        if (evt.getPropertyName().equals("connection")) {
            Connection conn = this.connAct_.getConnection();
            if (conn == null) {
                this.rootNode_ = null;
            } else {
                Branch root = conn.getRoot();
                this.rootNode_ = this.getChildMaker().makeChildNode(null, root);
            }
        }
    }
}

