/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree.select;

import java.util.ArrayList;
import java.util.Collections;
import uk.ac.starlink.connect.ConnectorAction;
import uk.ac.starlink.datanode.factory.CreationState;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.tree.select.ConnectorDataNode;

class NodeChain {
    private final DataNodeFactory factory_;
    private final ConnectorAction connAct_;
    private DataNode[] nodes_;

    public NodeChain(DataNode node) {
        this.setNode(node);
        DataNode root = this.nodes_[0];
        this.factory_ = root.getChildMaker();
        this.connAct_ = root instanceof ConnectorDataNode ? ((ConnectorDataNode)root).getConnectorAction() : null;
    }

    public void setNode(DataNode node) {
        ArrayList<DataNode> ancestors = new ArrayList<DataNode>();
        DataNode ancestor = node;
        while (ancestor != null) {
            ancestors.add(ancestor);
            CreationState creator = ancestor.getCreator();
            ancestor = creator == null ? null : creator.getParent();
        }
        Collections.reverse(ancestors);
        this.nodes_ = ancestors.toArray(new DataNode[0]);
    }

    public DataNode getNode() {
        return this.nodes_[this.nodes_.length - 1];
    }

    public DataNode getRoot() {
        return this.nodes_[0];
    }

    public int getDepth() {
        return this.nodes_.length;
    }

    public DataNode getAncestor(int level) {
        return this.nodes_[level];
    }

    public ConnectorAction getConnectorAction() {
        return this.connAct_;
    }
}

