/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree.select;

import java.io.File;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import uk.ac.starlink.connect.ConnectorAction;
import uk.ac.starlink.connect.ConnectorManager;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.NoSuchDataException;
import uk.ac.starlink.datanode.tree.select.ConnectorDataNode;
import uk.ac.starlink.datanode.tree.select.NodeChain;
import uk.ac.starlink.datanode.tree.select.NodeListCellRenderer;
import uk.ac.starlink.datanode.tree.select.NodeRootModel;

public class NodeRootComboBox
extends JComboBox {
    private NodeRootModel model_;
    private final DataNodeFactory factory_;
    private static final Logger logger_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public NodeRootComboBox(DataNodeFactory factory) {
        super(new NodeRootModel(factory));
        this.factory_ = factory;
        if (!$assertionsDisabled && !(this.model_ instanceof NodeRootModel)) {
            throw new AssertionError();
        }
        this.setRenderer(new NodeListCellRenderer(this.getRenderer()));
    }

    public void setModel(ComboBoxModel model) {
        this.model_ = (NodeRootModel)model;
        super.setModel(model);
    }

    public ComboBoxModel getModel() {
        if (!$assertionsDisabled && this.model_ != super.getModel()) {
            throw new AssertionError();
        }
        return this.model_;
    }

    public DataNode getSelectedNode() {
        return this.model_.getSelectedNode();
    }

    public ConnectorAction getConnectorAction() {
        return this.model_.getConnectorAction();
    }

    public void addDefaultRoots() {
        DataNode node;
        File[] fileRoots = File.listRoots();
        for (int i = 0; i < fileRoots.length; ++i) {
            File dir = fileRoots[i];
            if (dir.isDirectory() && dir.canRead()) {
                try {
                    DataNode dirNode = this.factory_.makeDataNode(null, dir);
                    this.model_.addChain(new NodeChain(dirNode));
                }
                catch (NoSuchDataException e) {
                    logger_.warning("Can't read directory " + dir + ": " + e);
                }
                continue;
            }
            logger_.info("Local filesystem root " + dir + " is not a readable directory");
        }
        ConnectorAction[] actions = ConnectorManager.getConnectorActions();
        for (int i = 0; i < actions.length; ++i) {
            node = new ConnectorDataNode(actions[i]);
            this.factory_.configureDataNode(node, null, actions[i]);
            this.model_.addChain(new NodeChain(node));
        }
        File dir = new File(".");
        try {
            dir = new File(System.getProperty("user.dir"));
        }
        catch (SecurityException e) {
            logger_.warning("Can't get current directory");
        }
        if (dir.isDirectory()) {
            try {
                node = this.factory_.makeDataNode(null, dir);
                this.factory_.fillInAncestors(node);
                this.model_.setSelectedItem(node);
            }
            catch (NoSuchDataException e) {
                logger_.warning("Can't create node from current directory: " + e);
            }
        } else {
            logger_.warning("Can't read current directory");
        }
    }

    static {
        $assertionsDisabled = !NodeRootComboBox.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.datanode.tree.select");
    }
}

