/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.tree.select;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxModel;
import uk.ac.starlink.connect.Branch;
import uk.ac.starlink.connect.Connection;
import uk.ac.starlink.connect.ConnectorAction;
import uk.ac.starlink.datanode.factory.CreationState;
import uk.ac.starlink.datanode.factory.DataNodeFactory;
import uk.ac.starlink.datanode.nodes.BranchDataNode;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.tree.select.ConnectorDataNode;
import uk.ac.starlink.datanode.tree.select.NodeChain;

public class NodeRootModel
extends AbstractListModel
implements ComboBoxModel {
    private NodeChain[] chains_ = new NodeChain[0];
    private int selected_ = -1;
    private final DataNodeFactory factory_;

    public NodeRootModel(DataNodeFactory factory) {
        this.factory_ = factory;
    }

    public int getSize() {
        int size = 0;
        for (int i = 0; i < this.chains_.length; ++i) {
            size += this.chains_[i].getDepth();
        }
        return size;
    }

    public Object getElementAt(int index) {
        for (int i = 0; i < this.chains_.length; ++i) {
            NodeChain chain = this.chains_[i];
            int depth = chain.getDepth();
            if (index < depth) {
                return chain.getAncestor(index);
            }
            index -= depth;
        }
        return null;
    }

    public Object getSelectedItem() {
        return this.getSelectedNode();
    }

    public void setSelectedItem(Object item) {
        this.setSelectedNode((DataNode)item);
    }

    public DataNode getSelectedNode() {
        return this.selected_ >= 0 ? this.chains_[this.selected_].getNode() : null;
    }

    private void setSelectedNode(DataNode node) {
        DataNode root = new NodeChain(node).getRoot();
        for (int i = 0; i < this.chains_.length; ++i) {
            if (!this.sameData(root, this.chains_[i].getRoot())) continue;
            this.chains_[i].setNode(node);
            this.selected_ = i;
            this.fireContentsChanged(this, -1, -1);
            return;
        }
        this.addChain(new NodeChain(node));
        this.selected_ = this.chains_.length - 1;
        this.fireContentsChanged(this, -1, -1);
    }

    public void addChain(final NodeChain chain) {
        DataNode node;
        int oldSize = this.getSize();
        ArrayList<NodeChain> clist = new ArrayList<NodeChain>(Arrays.asList(this.chains_));
        clist.add(chain);
        this.chains_ = clist.toArray(new NodeChain[0]);
        this.fireIntervalAdded(this, Math.max(0, oldSize - 1), this.getSize() - 1);
        if (this.selected_ < 0) {
            this.setSelectedNode(chain.getNode());
        }
        if ((node = chain.getNode()) instanceof ConnectorDataNode) {
            final ConnectorDataNode cnode = (ConnectorDataNode)node;
            cnode.getConnectorAction().addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    if (evt.getPropertyName().equals("connection")) {
                        DataNode snode;
                        Connection conn = (Connection)evt.getNewValue();
                        int oldSize = NodeRootModel.this.getSize();
                        if (conn == null) {
                            snode = cnode;
                        } else {
                            Branch root = conn.getRoot();
                            snode = NodeRootModel.this.factory_.makeChildNode(null, root);
                            if (snode instanceof BranchDataNode) {
                                ((BranchDataNode)snode).setConnection(conn);
                            }
                        }
                        chain.setNode(snode);
                        NodeRootModel.this.fireContentsChanged(this, 0, Math.max(oldSize, NodeRootModel.this.getSize()));
                    }
                }
            });
        }
    }

    private boolean sameData(DataNode n1, DataNode n2) {
        if (n1.equals(n2)) {
            return true;
        }
        CreationState creator1 = n1.getCreator();
        CreationState creator2 = n2.getCreator();
        if (creator1 != null && creator2 != null) {
            Object dataObj1 = creator1.getObject();
            Object dataObj2 = creator2.getObject();
            if (dataObj1 != null && dataObj2 != null && dataObj1.equals(dataObj2)) {
                return true;
            }
        }
        return false;
    }

    public void removeAllElements() {
        int oldSize = this.getSize();
        this.chains_ = new NodeChain[0];
        this.selected_ = -1;
        this.fireContentsChanged(this, 0, oldSize);
    }

    public ConnectorAction getConnectorAction() {
        return this.selected_ >= 0 ? this.chains_[this.selected_].getConnectorAction() : null;
    }
}

