/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.viewers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Insets;
import java.io.IOException;
import java.lang.reflect.Array;
import javax.swing.BorderFactory;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.UIManager;
import javax.swing.border.MatteBorder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.array.ArrayAccess;
import uk.ac.starlink.array.BadHandler;
import uk.ac.starlink.array.NDArray;
import uk.ac.starlink.array.NDShape;
import uk.ac.starlink.array.Order;
import uk.ac.starlink.array.OrderedNDShape;
import uk.ac.starlink.array.Type;
import uk.ac.starlink.hds.ArrayStructure;
import uk.ac.starlink.hds.HDSException;
import uk.ac.starlink.hds.HDSObject;
import uk.ac.starlink.hds.HDSType;
import uk.ac.starlink.table.gui.NumericCellRenderer;
import uk.ac.starlink.table.gui.StarJTable;

public class ArrayBrowser
extends JPanel {
    private static final Object BAD_CELL = new Object();

    public ArrayBrowser(NDArray nda) throws IOException {
        this(ArrayBrowser.makeCellGetter(nda), nda.getShape());
    }

    public ArrayBrowser(ArrayStructure ary) throws HDSException {
        this(ArrayBrowser.makeCellGetter(ary), ary.getShape());
    }

    private ArrayBrowser(final CellGetter cg, final OrderedNDShape shape) {
        int ndim = shape.getNumDims();
        long[] dims = shape.getDims();
        long[] origin = shape.getOrigin();
        DefaultTableCellRenderer hrend = new DefaultTableCellRenderer();
        hrend.setFont(UIManager.getFont("TableHeader.font"));
        hrend.setBackground(UIManager.getColor("TableHeader.background"));
        hrend.setForeground(UIManager.getColor("TableHeader.foreground"));
        hrend.setHorizontalAlignment(4);
        final NumericCellRenderer crend = new NumericCellRenderer(cg.getContentClass());
        crend.setBadValue(BAD_CELL);
        crend.setCellFont(new Font("Monospaced", 0, crend.getFont().getSize()));
        JScrollPane scroller = new JScrollPane(){

            public Dimension getPreferredSize() {
                Dimension size = ArrayBrowser.this.getSize();
                Insets insets1 = ArrayBrowser.this.getInsets();
                Insets insets2 = this.getInsets();
                int x = size.width - insets1.left - insets1.right - insets2.left - insets2.right;
                int y = size.height - insets1.top - insets1.bottom - insets2.top - insets2.bottom;
                return new Dimension(x, y - 1);
            }
        };
        scroller.setAlignmentX(0.0f);
        scroller.setAlignmentY(0.0f);
        this.add(scroller);
        if (ndim == 2) {
            final int ncol = (int)dims[0];
            final int nrow = (int)dims[1];
            final long o0 = origin[0];
            final long o1 = origin[1];
            AbstractTableModel dataModel = new AbstractTableModel(){

                public int getRowCount() {
                    return nrow;
                }

                public int getColumnCount() {
                    return ncol;
                }

                public Object getValueAt(int irow, int icol) {
                    long p0 = o0 + (long)icol;
                    long p1 = o1 + ((long)nrow - 1L - (long)irow);
                    long[] pos = new long[]{p0, p1};
                    int index = (int)shape.positionToOffset(pos);
                    return cg.getValueAt(index);
                }
            };
            AbstractTableModel rowModel = new AbstractTableModel(){

                public int getRowCount() {
                    return nrow;
                }

                public int getColumnCount() {
                    return 1;
                }

                public Object getValueAt(int irow, int icol) {
                    return new Long(o1 + (long)nrow - 1L - (long)irow) + "  ";
                }
            };
            AbstractTableModel colModel = new AbstractTableModel(){

                public int getRowCount() {
                    return 1;
                }

                public int getColumnCount() {
                    return ncol;
                }

                public Object getValueAt(int irow, int icol) {
                    return new Long(o0 + (long)icol) + "  ";
                }
            };
            JTable rowHead = new JTable(rowModel);
            JTable colHead = new JTable(colModel);
            JTable dataTab = new JTable(dataModel){

                protected void configureEnclosingScrollPane() {
                }

                public TableCellRenderer getCellRenderer(int irow, int icol) {
                    return crend;
                }
            };
            scroller.setViewportView(dataTab);
            scroller.setRowHeaderView(rowHead);
            scroller.setColumnHeaderView(colHead);
            Color bcol = Color.BLACK;
            MatteBorder cb = BorderFactory.createMatteBorder(0, 0, 2, 0, bcol);
            colHead.setBorder(cb);
            MatteBorder rb = BorderFactory.createMatteBorder(0, 0, 0, 2, bcol);
            rowHead.setBorder(rb);
            JPanel box = new JPanel();
            box.setBorder(BorderFactory.createMatteBorder(0, 0, 2, 2, bcol));
            scroller.setCorner("UPPER_LEFT_CORNER", box);
            rowHead.setDefaultRenderer(Object.class, hrend);
            colHead.setDefaultRenderer(Object.class, hrend);
            JTable[] tables = new JTable[]{dataTab, rowHead, colHead};
            for (int i = 0; i < tables.length; ++i) {
                JTable table = tables[i];
                table.setAutoResizeMode(0);
                table.setTableHeader(null);
                table.setPreferredScrollableViewportSize(table.getPreferredSize());
                table.setColumnSelectionAllowed(false);
                table.setRowSelectionAllowed(false);
            }
            int cwidth = crend.getCellWidth();
            TableColumnModel dataTcm = dataTab.getColumnModel();
            TableColumnModel colTcm = colHead.getColumnModel();
            for (int i = 0; i < ncol; ++i) {
                dataTcm.getColumn(i).setPreferredWidth(cwidth);
                colTcm.getColumn(i).setPreferredWidth(cwidth);
            }
            int rwidth = 8 + Math.max(StarJTable.getCellWidth((JTable)rowHead, (int)0, (int)0), StarJTable.getCellWidth((JTable)rowHead, (int)(nrow - 1), (int)0));
            rowHead.getColumnModel().getColumn(0).setPreferredWidth(rwidth);
            rowHead.getPreferredScrollableViewportSize().width = rwidth;
        } else {
            final int nrow = (int)shape.getNumPixels();
            final boolean alignRight = crend.getHorizontalAlignment() == 4;
            AbstractTableModel dataModel = new AbstractTableModel(){

                public int getRowCount() {
                    return nrow;
                }

                public int getColumnCount() {
                    return 2 + (alignRight ? 1 : 0);
                }

                public Object getValueAt(int irow, int icol) {
                    if (icol == 0) {
                        long[] pos = shape.offsetToPosition((long)irow);
                        return NDShape.toString((long[])pos) + "  ";
                    }
                    if (icol == 1) {
                        return cg.getValueAt(irow);
                    }
                    return null;
                }
            };
            JTable tab = new JTable(dataModel);
            scroller.setViewportView(tab);
            tab.setTableHeader(null);
            tab.setShowVerticalLines(false);
            TableColumnModel tcm = tab.getColumnModel();
            TableColumn tcol0 = tcm.getColumn(0);
            TableColumn tcol1 = tcm.getColumn(1);
            tcol0.setCellRenderer(hrend);
            tcol1.setCellRenderer((TableCellRenderer)crend);
            int w0 = Math.max(StarJTable.getCellWidth((JTable)tab, (int)0, (int)0), StarJTable.getCellWidth((JTable)tab, (int)(nrow - 1), (int)0)) + 8;
            tcol0.setMinWidth(w0);
            tcol0.setMaxWidth(w0);
            tcol0.setPreferredWidth(w0);
            if (alignRight) {
                int w1 = crend.getCellWidth() + 20;
                tcol1.setMinWidth(w1);
                tcol1.setMaxWidth(w1);
            }
        }
    }

    private static CellGetter makeCellGetter(NDArray nda) throws IOException {
        if (!nda.isRandom()) {
            throw new IOException("NDArray " + nda + " does not have random access");
        }
        final BadHandler bh = nda.getBadHandler();
        final Object buf = nda.getType().newArray(1);
        final ArrayAccess acc = nda.getAccess();
        final Class clazz = ArrayBrowser.getWrapperClass(nda.getType());
        CellGetter cg = new CellGetter(){

            public Object getValueAt(int index) {
                try {
                    acc.setOffset((long)index);
                    acc.read(buf, 0, 1);
                    Number val = bh.makeNumber(buf, 0);
                    return val == null ? BAD_CELL : val;
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return BAD_CELL;
                }
            }

            public Class getContentClass() {
                return clazz;
            }
        };
        return cg;
    }

    private static CellGetter makeCellGetter(ArrayStructure ary) throws HDSException {
        final HDSObject datobj = ary.getData();
        final OrderedNDShape dshape = new OrderedNDShape(datobj.datShape(), Order.COLUMN_MAJOR);
        HDSType htype = ary.getType();
        Class clazz = htype == null ? Object.class : ArrayBrowser.getWrapperClass(ary.getType().getJavaType());
        final Class clazz2 = clazz;
        CellGetter cg = new CellGetter(){

            public Object getValueAt(int index) {
                try {
                    long[] pos = dshape.offsetToPosition((long)index);
                    HDSObject cellobj = datobj.datCell(pos);
                    return cellobj.datGet0c();
                }
                catch (HDSException e) {
                    e.printStackTrace();
                    return BAD_CELL;
                }
            }

            public Class getContentClass() {
                return clazz2;
            }
        };
        return cg;
    }

    private static Class getWrapperClass(Type type) {
        return Array.get(type.newArray(1), 0).getClass();
    }

    private static interface CellGetter {
        public Object getValueAt(int var1);

        public Class getContentClass();
    }
}

