/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.datanode.viewers;

import java.awt.Component;
import java.awt.Dimension;
import java.io.Writer;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JTextPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;
import javax.swing.text.StyledDocument;

public class StyledTextArea
extends JTextPane {
    private StyledDocument doc = new DefaultStyledDocument();
    private boolean wrap;

    public StyledTextArea() {
        this.setDocument(this.doc);
        this.setEditable(false);
        Style defStyle = StyleContext.getDefaultStyleContext().getStyle("default");
        Style normalStyle = this.addStyle("normal", defStyle);
        StyleConstants.setFontFamily(normalStyle, "Bitstream Charter");
        Style titleStyle = this.addStyle("title", normalStyle);
        StyleConstants.setUnderline(titleStyle, true);
        StyleConstants.setFontSize(titleStyle, StyleConstants.getFontSize(titleStyle) + 2);
        Style screedStyle = this.addStyle("screed", normalStyle);
        StyleConstants.setFontFamily(screedStyle, "Monospaced");
        Style nameStyle = this.addStyle("itemname", normalStyle);
        StyleConstants.setBold(nameStyle, true);
        Style valueStyle = this.addStyle("itemvalue", normalStyle);
        Style headStyle = this.addStyle("heading", normalStyle);
        StyleConstants.setUnderline(headStyle, true);
        Style errorBodyStyle = this.addStyle("errorbody", normalStyle);
        StyleConstants.setItalic(errorBodyStyle, true);
        Style errorHeadStyle = this.addStyle("errorhead", errorBodyStyle);
        StyleConstants.setBold(errorHeadStyle, true);
        Style iconStyle = this.addStyle("icon", this.getStyle("title"));
        Style buttStyle = this.addStyle("component", this.getStyle("title"));
    }

    private void append(String sname, String text) {
        try {
            this.doc.insertString(this.doc.getLength(), text, this.getStyle(sname));
        }
        catch (BadLocationException e) {
            throw new IllegalStateException(e.toString());
        }
    }

    public void setWrap(boolean wrap) {
        this.wrap = wrap;
    }

    public void addTitle(String title) {
        this.append("title", title + "\n");
        this.addSeparator();
    }

    public void addSubHead(String text) {
        this.addSeparator();
        this.append("heading", text + "\n");
    }

    public void addKeyedItem(String name, String value) {
        this.append("itemname", name.replace(' ', '\u00a0') + ":\u00a0\u00a0");
        this.append("itemvalue", value + "\n");
    }

    public void addKeyedItem(String name, Object value) {
        this.addKeyedItem(name, value.toString());
    }

    public void addKeyedItem(String name, int value) {
        this.addKeyedItem(name, Integer.toString(value));
    }

    public void addKeyedItem(String name, long value) {
        this.addKeyedItem(name, Long.toString(value));
    }

    public void addKeyedItem(String name, double value) {
        this.addKeyedItem(name, Double.toString(value));
    }

    public void addKeyedItem(String name, float value) {
        this.addKeyedItem(name, Float.toString(value));
    }

    public void addKeyedItem(String name, boolean value) {
        this.addKeyedItem(name, value ? "yes" : "no");
    }

    public void logError(Throwable th) {
        this.append("normal", "\n");
        this.append("errorhead", "Error:  ");
        this.append("errorbody", th.getMessage());
        this.append("normal", "\n");
        th.printStackTrace();
    }

    public void addSeparator() {
        this.append("normal", "\n");
    }

    public void addText(String text) {
        this.append("screed", text + "\n");
    }

    public void addIcon(Icon icon) {
        Style iconStyle = this.doc.getStyle("icon");
        StyleConstants.setIcon(iconStyle, icon);
        this.append("icon", " ");
    }

    public void addAction(Action act) {
        this.addComponent(new JButton(act));
    }

    public void addComponent(Component comp) {
        Style compStyle = this.doc.getStyle("component");
        StyleConstants.setComponent(compStyle, comp);
        this.append("component", " ");
    }

    public void addSpace() {
        this.append("default", "  ");
    }

    public Writer lineAppender() {
        return this.limitedLineAppender(0);
    }

    public Writer limitedLineAppender(final int maxLines) {
        return new Writer(){
            private int nline = 0;
            private boolean truncate = false;

            public void write(char[] cbuf, int off, int len) {
                if (this.truncate) {
                    return;
                }
                String buf = new String(cbuf, off, len);
                int pos = 0;
                if (maxLines > 0) {
                    while ((pos = buf.indexOf(10, pos) + 1) > 0) {
                        ++this.nline;
                        if (this.nline < maxLines || pos >= buf.length()) continue;
                        buf = buf.substring(0, pos);
                        this.truncate = true;
                        break;
                    }
                }
                StyledTextArea.this.append("screed", buf);
                if (this.truncate) {
                    StyledTextArea.this.append("screed", "   ....");
                }
            }

            public void flush() {
            }

            public void close() {
            }
        };
    }

    public boolean getScrollableTracksViewportWidth() {
        return this.wrap || this.getSize().width < this.getParent().getSize().width;
    }

    public void setSize(Dimension d) {
        int pwidth = this.getParent().getSize().width;
        if (d.width < pwidth || this.wrap && d.width > pwidth) {
            d.width = pwidth;
        }
        super.setSize(d);
    }
}

