/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryQueryFactory;

public class KeywordServiceQueryFactory
implements RegistryQueryFactory {
    private final String baseQuery_;
    private final JComponent queryPanel_;
    private final JComboBox urlSelector_;
    private final JTextField keywordField_;
    private final JButton andButton_;
    private boolean or_;
    public static String[] KNOWN_REGISTRIES = new String[]{"http://registry.astrogrid.org/astrogrid-registry/services/RegistryQueryv1_0", "http://nvo.stsci.edu/vor10/ristandardservice.asmx"};
    public static final String[] MATCHED_FIELDS = new String[]{"identifier", "content/description", "title", "content/subject", "content/type"};

    public KeywordServiceQueryFactory(String standardId) {
        this.baseQuery_ = "( capability/@standardID = '" + standardId + "' )";
        this.queryPanel_ = new Box(1){

            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                KeywordServiceQueryFactory.this.urlSelector_.setEnabled(enabled);
                KeywordServiceQueryFactory.this.keywordField_.setEnabled(enabled);
                KeywordServiceQueryFactory.this.andButton_.setEnabled(enabled);
            }
        };
        Box urlLine = Box.createHorizontalBox();
        this.urlSelector_ = new JComboBox<String>(KNOWN_REGISTRIES);
        this.urlSelector_.setEditable(true);
        this.urlSelector_.setSelectedIndex(0);
        this.urlSelector_.setToolTipText("Endpoint of VOResource 1.0 registry service");
        urlLine.add(new JLabel("Registry: "));
        urlLine.add(this.urlSelector_);
        this.queryPanel_.add(urlLine);
        this.queryPanel_.add(Box.createVerticalStrut(5));
        this.andButton_ = new JButton(){
            private Dimension prefSize_ = new Dimension(0, 0);

            public String getText() {
                return KeywordServiceQueryFactory.this.or_ ? "Or" : "And";
            }

            public Dimension getPreferredSize() {
                Dimension psize = super.getPreferredSize();
                if (psize == null) {
                    return null;
                }
                this.prefSize_ = new Dimension(Math.max(this.prefSize_.width, psize.width), Math.max(this.prefSize_.height, psize.height));
                return this.prefSize_;
            }
        };
        this.andButton_.setToolTipText("Toggles whether keywords are combined using AND or OR for registry search");
        this.andButton_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                KeywordServiceQueryFactory.this.or_ = !KeywordServiceQueryFactory.this.or_;
            }
        });
        Box keywordLine = Box.createHorizontalBox();
        this.keywordField_ = new JTextField();
        this.keywordField_.setToolTipText("Space-separated list of keywords to match in resource title, description, IVORN, etc");
        keywordLine.add(new JLabel("Keywords: "));
        keywordLine.add(this.keywordField_);
        keywordLine.add(Box.createHorizontalStrut(5));
        keywordLine.add(this.andButton_);
        this.queryPanel_.add(keywordLine);
    }

    public RegistryQuery getQuery() throws MalformedURLException {
        String conjunction = this.or_ ? "or" : "and";
        String keyText = this.keywordField_.getText();
        String[] keywords = keyText == null || keyText.trim().length() == 0 ? new String[]{} : keyText.trim().split("\\s+");
        StringBuffer sbuf = new StringBuffer();
        sbuf.append(this.baseQuery_);
        if (keywords.length > 0) {
            sbuf.append(" and ( ");
            for (int iw = 0; iw < keywords.length; ++iw) {
                if (iw > 0) {
                    sbuf.append(conjunction);
                }
                sbuf.append("(");
                for (int ifi = 0; ifi < MATCHED_FIELDS.length; ++ifi) {
                    if (ifi > 0) {
                        sbuf.append(" or ");
                    }
                    sbuf.append(MATCHED_FIELDS[ifi]).append(" like ").append("'%").append(keywords[iw]).append("%'");
                }
                sbuf.append(")");
            }
            sbuf.append(" )");
        }
        String adql = sbuf.toString();
        String url = new URL((String)this.urlSelector_.getSelectedItem()).toString();
        return new RegistryQuery(url, adql);
    }

    public JComponent getComponent() {
        return this.queryPanel_;
    }
}

