/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.logging.Logger;
import net.ivoa.registry.RegistryAccessException;
import net.ivoa.registry.search.Records;
import net.ivoa.registry.search.RegistrySearchClient;
import net.ivoa.registry.search.VOResource;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryQueryException;
import uk.ac.starlink.vo.VORegResource;

public class RegistryQuery {
    private final RegistrySearchClient searchClient_;
    private final String text_;
    private URL endpoint_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.vo");
    public static final ValueInfo REGISTRY_INFO = new DefaultValueInfo("Registry Location", URL.class, "URL of registry queried");
    public static final ValueInfo TEXT_INFO = new DefaultValueInfo("Registry Query", String.class, "Text of query made to the registry");
    public static final String AG_REG = "http://registry.astrogrid.org/astrogrid-registry/services/RegistryQueryv1_0";
    public static final String NVO_REG = "http://nvo.stsci.edu/vor10/ristandardservice.asmx";

    public RegistryQuery(RegistrySearchClient searchClient, String text) {
        this.searchClient_ = searchClient;
        this.text_ = text;
        this.endpoint_ = null;
    }

    public RegistryQuery(String endpoint, String text) {
        this(new RegistrySearchClient(RegistryQuery.toUrl(endpoint)), text);
        this.searchClient_.setRecordBufferSize(100);
        this.endpoint_ = RegistryQuery.toUrl(endpoint);
    }

    public Records performQuery() throws RegistryAccessException {
        logger_.info("Making query \"" + this.text_ + "\" to " + this.getRegistry());
        return this.searchClient_.searchByADQL(this.text_);
    }

    public Iterator getQueryIterator() throws RegistryAccessException {
        final Records records = this.performQuery();
        return new Iterator(){
            private RegResource next_ = this.getNext();

            public boolean hasNext() {
                return this.next_ != null;
            }

            public Object next() {
                RegResource next = this.next_;
                if (next != null) {
                    try {
                        this.next_ = this.getNext();
                    }
                    catch (RegistryAccessException e) {
                        throw new RegistryQueryException(e);
                    }
                    return next;
                }
                throw new NoSuchElementException();
            }

            public void remove() {
                throw new UnsupportedOperationException();
            }

            private RegResource getNext() throws RegistryAccessException {
                VOResource next = null;
                while (records.hasNext() && next == null) {
                    next = records.next();
                }
                return next == null ? null : new VORegResource(next);
            }
        };
    }

    public RegResource[] getQueryResources() throws RegistryAccessException {
        ArrayList<VORegResource> resList = new ArrayList<VORegResource>();
        Records records = this.performQuery();
        while (records.hasNext()) {
            VOResource vores = records.next();
            if (vores == null) continue;
            resList.add(new VORegResource(vores));
        }
        return resList.toArray(new VORegResource[0]);
    }

    public String getText() {
        return this.text_;
    }

    public URL getRegistry() {
        return this.endpoint_;
    }

    public RegistrySearchClient getSearchClient() {
        return this.searchClient_;
    }

    public DescribedValue[] getMetadata() {
        return new DescribedValue[]{new DescribedValue(REGISTRY_INFO, (Object)this.getRegistry()), new DescribedValue(TEXT_INFO, (Object)this.getText())};
    }

    private static URL toUrl(String url) {
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            throw (IllegalArgumentException)new IllegalArgumentException("Not a URL: " + url).initCause(e);
        }
    }

    public String toString() {
        return this.text_;
    }
}

