/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import net.ivoa.registry.RegistryAccessException;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnStarTable;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;
import uk.ac.starlink.vo.RegistryQuery;
import uk.ac.starlink.vo.RegistryQueryException;

public class RegistryStarTable
extends ColumnStarTable {
    private final Record[] records_;
    private static final ValueInfo IDENTIFIER_INFO = new DefaultValueInfo("ID", String.class, "Registry identifier URI for resource");
    private static final ValueInfo SHORTNAME_INFO = new DefaultValueInfo("ShortName", String.class, "Short name for resource");
    private static final ValueInfo TITLE_INFO = new DefaultValueInfo("Title", String.class, "Title for resource");
    private static final ValueInfo PUBLISHER_INFO = new DefaultValueInfo("Publisher", String.class, "Person or organisation responsible for publishing the resource");
    private static final ValueInfo REFURL_INFO = new DefaultValueInfo("ReferenceURL", String.class, "URL describing the resource");
    private static final ValueInfo CONTACT_INFO = new DefaultValueInfo("Contact", String.class, "Person to contact concerning this resource");
    private static final ValueInfo CAP_DESCRIPTION_INFO = new DefaultValueInfo("CapDesc", String.class, "Description of the service capability");
    private static final ValueInfo CAP_STDID_INFO = new DefaultValueInfo("CapStdId", String.class, "Standard ID URI describing the type of service capability provided");
    private static final ValueInfo CAP_ACURL_INFO = new DefaultValueInfo("AccessURL", String.class, "Access URL for the service capability");
    private static final ValueInfo CAP_VERSION_INFO = new DefaultValueInfo("CapVersion", String.class, "Version of the service capability provided");
    private static final RegCapabilityInterface EMPTY_CAPABILITY = new RegCapabilityInterface(){

        public String getAccessUrl() {
            return null;
        }

        public String getDescription() {
            return null;
        }

        public String getStandardId() {
            return null;
        }

        public String getVersion() {
            return null;
        }
    };

    public RegistryStarTable(RegistryQuery query) throws RegistryAccessException {
        this.records_ = RegistryStarTable.getRecords(query);
        this.setParameters(new ArrayList<DescribedValue>(Arrays.asList(query.getMetadata())));
        this.addColumn(new ColumnData(IDENTIFIER_INFO){

            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getIdentifier();
            }
        });
        this.addColumn(new ColumnData(SHORTNAME_INFO){

            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getShortName();
            }
        });
        this.addColumn(new ColumnData(TITLE_INFO){

            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getTitle();
            }
        });
        this.addColumn(new ColumnData(PUBLISHER_INFO){

            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getPublisher();
            }
        });
        this.addColumn(new ColumnData(REFURL_INFO){

            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getReferenceUrl();
            }
        });
        this.addColumn(new ColumnData(CONTACT_INFO){

            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).resource_.getContact();
            }
        });
        this.addColumn(new ColumnData(CAP_DESCRIPTION_INFO){

            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).capability_.getDescription();
            }
        });
        this.addColumn(new ColumnData(CAP_STDID_INFO){

            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).capability_.getStandardId();
            }
        });
        this.addColumn(new ColumnData(CAP_ACURL_INFO){

            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).capability_.getAccessUrl();
            }
        });
        this.addColumn(new ColumnData(CAP_VERSION_INFO){

            public Object readValue(long irow) {
                return ((RegistryStarTable)RegistryStarTable.this).getRecord((long)irow).capability_.getVersion();
            }
        });
    }

    public long getRowCount() {
        return this.records_.length;
    }

    private Record getRecord(long irow) {
        return this.records_[Tables.checkedLongToInt((long)irow)];
    }

    private static Record[] getRecords(RegistryQuery query) throws RegistryAccessException {
        try {
            ArrayList<Record> recList = new ArrayList<Record>();
            Iterator it = query.getQueryIterator();
            while (it.hasNext()) {
                RegResource resource = (RegResource)it.next();
                RegCapabilityInterface[] caps = resource.getCapabilities();
                if (caps.length == 0) {
                    recList.add(new Record(resource, EMPTY_CAPABILITY));
                    continue;
                }
                for (int ic = 0; ic < caps.length; ++ic) {
                    recList.add(new Record(resource, caps[ic]));
                }
            }
            return recList.toArray(new Record[0]);
        }
        catch (RegistryQueryException e) {
            throw (RegistryQueryException)e.getCause();
        }
    }

    private static class Record {
        final RegResource resource_;
        final RegCapabilityInterface capability_;

        Record(RegResource resource, RegCapabilityInterface capability) {
            this.resource_ = resource;
            this.capability_ = capability;
        }
    }
}

