/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.vo;

import java.util.ArrayList;
import net.ivoa.registry.search.Metadata;
import net.ivoa.registry.search.VOResource;
import uk.ac.starlink.vo.RegCapabilityInterface;
import uk.ac.starlink.vo.RegResource;

public class VORegResource
implements RegResource {
    private final String shortName_;
    private final String title_;
    private final String identifier_;
    private final String publisher_;
    private final String contact_;
    private final String referenceUrl_;
    private final RegCapabilityInterface[] capabilities_;

    public VORegResource(VOResource resource) {
        this.shortName_ = resource.getParameter("shortName");
        this.title_ = resource.getParameter("title");
        this.identifier_ = resource.getParameter("identifier");
        this.publisher_ = resource.getParameter("curation/publisher");
        this.contact_ = resource.getParameter("curation/contact");
        this.referenceUrl_ = resource.getParameter("content/referenceURL");
        Metadata[] capBlocks = resource.getBlocks("capability");
        ArrayList<1> capList = new ArrayList<1>();
        for (int ic = 0; ic < capBlocks.length; ++ic) {
            Metadata capBlock = capBlocks[ic];
            final String standardId = capBlock.getParameter("@standardID");
            final String description = capBlock.getParameter("description");
            Metadata[] intfs = capBlock.getBlocks("interface");
            for (int ii = 0; ii < intfs.length; ++ii) {
                Metadata intf = intfs[ii];
                final String accessUrl = intf.getParameter("accessURL");
                final String version = intf.getParameter("@version");
                String role = intf.getParameter("@role");
                RegCapabilityInterface rci = new RegCapabilityInterface(){

                    public String getAccessUrl() {
                        return accessUrl;
                    }

                    public String getStandardId() {
                        return standardId;
                    }

                    public String getDescription() {
                        return description;
                    }

                    public String getVersion() {
                        return version;
                    }
                };
                capList.add("std".equals(role) ? 0 : capList.size(), rci);
            }
        }
        this.capabilities_ = capList.toArray(new RegCapabilityInterface[0]);
    }

    public String getShortName() {
        return this.shortName_;
    }

    public String getTitle() {
        return this.title_;
    }

    public String getIdentifier() {
        return this.identifier_;
    }

    public String getPublisher() {
        return this.publisher_;
    }

    public String getContact() {
        return this.contact_;
    }

    public String getReferenceUrl() {
        return this.referenceUrl_;
    }

    public RegCapabilityInterface[] getCapabilities() {
        return this.capabilities_;
    }
}

