/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.toolbar.toolbutton;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import javax.swing.ImageIcon;
import javax.swing.UIManager;

public abstract class DecoratedIcon
extends ImageIcon {
    public static final int ROLLOVER = 0;
    public static final int STANDARD = 1;
    protected int[][] _buffer;
    protected int _popupIconWidth = 11;
    protected int _popupIconHeight = 16;
    private int _popupIconOffset = 5;
    private ImageIcon _imageIcon;

    DecoratedIcon(ImageIcon imageIcon) {
        this._imageIcon = imageIcon;
    }

    protected void init(int[][] buffer) {
        this._buffer = buffer;
        this._popupIconWidth = this._buffer[0].length;
        this._popupIconHeight = this._buffer.length;
        int newWidth = this._imageIcon.getIconWidth() + this._popupIconOffset + this._popupIconWidth;
        int newHeight = this._imageIcon.getIconHeight();
        BufferedImage mergedImage = new BufferedImage(newWidth, newHeight, 2);
        Graphics2D g2 = mergedImage.createGraphics();
        g2.drawImage(this._imageIcon.getImage(), null, null);
        this.setImage(mergedImage);
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        super.paintIcon(c, g, x, y);
        int xOffset = x + this._imageIcon.getIconWidth() + this._popupIconOffset;
        Color[] colors = new Color[]{c.getBackground(), UIManager.getColor("controlDkShadow"), UIManager.getColor("controlText"), UIManager.getColor("controlHighlight")};
        int i = 0;
        while (i < this._popupIconWidth) {
            int j = 0;
            while (j < this._popupIconHeight) {
                if (this._buffer[j][i] != 0) {
                    g.setColor(colors[this._buffer[j][i]]);
                    g.drawLine(xOffset + i, y + j, xOffset + i, y + j);
                }
                ++j;
            }
            ++i;
        }
    }
}

