/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.AbstractMath;
import JSci.maths.SpecialMath;

public final class ExtraMath
extends AbstractMath {
    private ExtraMath() {
    }

    public static double hypot(double d, double d2) {
        double d3 = Math.abs(d);
        double d4 = Math.abs(d2);
        if (d3 == 0.0 && d4 == 0.0) {
            return 0.0;
        }
        if (d3 < d4) {
            return d4 * Math.sqrt(1.0 + d / d2 * (d / d2));
        }
        return d3 * Math.sqrt(1.0 + d2 / d * (d2 / d));
    }

    public static int pow(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            n *= n;
            ++n3;
        }
        return n;
    }

    public static double factorial(double d) {
        return SpecialMath.gamma(d + 1.0);
    }

    public static double logFactorial(double d) {
        return SpecialMath.logGamma(d + 1.0);
    }

    public static int binomial(int n, int n2) {
        if (n2 == n || n2 == 0) {
            return 1;
        }
        if (n == 0) {
            return 1;
        }
        return ExtraMath.binomial(n - 1, n2 - 1) + ExtraMath.binomial(n - 1, n2);
    }

    public static double binomial(double d, double d2) {
        return Math.exp(SpecialMath.logGamma(d + 1.0) - SpecialMath.logGamma(d2 + 1.0) - SpecialMath.logGamma(d - d2 + 1.0));
    }

    public static double sinh(double d) {
        return (Math.exp(d) - Math.exp(-d)) / 2.0;
    }

    public static double cosh(double d) {
        return (Math.exp(d) + Math.exp(-d)) / 2.0;
    }

    public static double tanh(double d) {
        return ExtraMath.sinh(d) / ExtraMath.cosh(d);
    }

    public static double asinh(double d) {
        return Math.log(d + Math.sqrt(d * d + 1.0));
    }

    public static double acosh(double d) {
        return Math.log(d + Math.sqrt(d * d - 1.0));
    }

    public static double atanh(double d) {
        return Math.log((1.0 + d) / (1.0 - d)) / 2.0;
    }
}

