/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths;

import JSci.maths.DimensionException;
import JSci.maths.DoubleSquareMatrix;
import JSci.maths.IntegerDiagonalMatrix;
import JSci.maths.IntegerMatrix;
import JSci.maths.IntegerVector;
import JSci.maths.Matrix;
import JSci.maths.MatrixDimensionException;

public class IntegerSquareMatrix
extends IntegerMatrix {
    protected transient DoubleSquareMatrix[] LU;
    protected transient int[] LUpivot;

    protected IntegerSquareMatrix(int n, int n2) {
        super(n, n, n2);
    }

    public IntegerSquareMatrix(int n) {
        super(n, n);
    }

    public IntegerSquareMatrix(int[][] nArray) {
        super(nArray);
        if (nArray.length != nArray[0].length) {
            this.matrix = null;
            throw new MatrixDimensionException("The array is not square.");
        }
    }

    public IntegerSquareMatrix(IntegerVector[] integerVectorArray) {
        super(integerVectorArray);
        if (integerVectorArray.length != integerVectorArray[0].dimension()) {
            this.matrix = null;
            throw new MatrixDimensionException("The array does not form a square matrix.");
        }
    }

    public boolean isSymmetric() {
        return this.equals(this.transpose());
    }

    public boolean isUnitary() {
        return this.multiply(this.transpose()).equals(IntegerDiagonalMatrix.identity(this.numRows));
    }

    public int det() {
        if (this.numRows == 2) {
            return this.matrix[0][0] * this.matrix[1][1] - this.matrix[0][1] * this.matrix[1][0];
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = this.luDecompose(null);
        double d = doubleSquareMatrixArray[1].matrix[0][0];
        int n = 1;
        while (n < this.numRows) {
            d *= doubleSquareMatrixArray[1].matrix[n][n];
            ++n;
        }
        return (int)d * this.LUpivot[this.numRows];
    }

    public int trace() {
        int n = this.matrix[0][0];
        int n2 = 1;
        while (n2 < this.numRows) {
            n += this.matrix[n2][n2];
            ++n2;
        }
        return n;
    }

    public IntegerMatrix add(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(integerMatrix);
            }
        }
        if (this.numRows == integerMatrix.rows() && this.numCols == integerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.matrix[n][0] + integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][n2] + integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawAdd(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows && this.numCols == integerMatrix.numCols) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.matrix[n][0] + integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][n2] + integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix add(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawAdd(integerSquareMatrix);
            }
        }
        if (this.numRows == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.matrix[n][0] + integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][n2] + integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix subtract(IntegerMatrix integerMatrix) {
        switch (integerMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(integerMatrix);
            }
        }
        if (this.numRows == integerMatrix.rows() && this.numCols == integerMatrix.columns()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.matrix[n][0] - integerMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][n2] - integerMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    private IntegerSquareMatrix rawSubtract(IntegerMatrix integerMatrix) {
        if (this.numRows == integerMatrix.numRows && this.numCols == integerMatrix.numCols) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.matrix[n][0] - integerMatrix.matrix[n][0];
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][n2] - integerMatrix.matrix[n][n2];
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerSquareMatrix subtract(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawSubtract(integerSquareMatrix);
            }
        }
        if (this.numRows == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                nArray[n][0] = this.matrix[n][0] - integerSquareMatrix.getElement(n, 0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][n2] - integerSquareMatrix.getElement(n, n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Matrices are different sizes.");
    }

    public IntegerMatrix scalarMultiply(int n) {
        int[][] nArray = new int[this.numRows][this.numCols];
        int n2 = 0;
        while (n2 < this.numRows) {
            nArray[n2][0] = n * this.matrix[n2][0];
            int n3 = 1;
            while (n3 < this.numCols) {
                nArray[n2][n3] = n * this.matrix[n2][n3];
                ++n3;
            }
            ++n2;
        }
        return new IntegerSquareMatrix(nArray);
    }

    public IntegerVector multiply(IntegerVector integerVector) {
        if (this.numCols == integerVector.dimension()) {
            int[] nArray = new int[this.numRows];
            int n = 0;
            while (n < this.numRows) {
                nArray[n] = this.matrix[n][0] * integerVector.getComponent(0);
                int n2 = 1;
                while (n2 < this.numCols) {
                    int n3 = n;
                    nArray[n3] = nArray[n3] + this.matrix[n][n2] * integerVector.getComponent(n2);
                    ++n2;
                }
                ++n;
            }
            return new IntegerVector(nArray);
        }
        throw new DimensionException("Matrix and vector are incompatible.");
    }

    public IntegerSquareMatrix multiply(IntegerSquareMatrix integerSquareMatrix) {
        switch (integerSquareMatrix.storageFormat) {
            case 1: {
                return this.rawMultiply(integerSquareMatrix);
            }
        }
        if (this.numRows == integerSquareMatrix.rows()) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][0] * integerSquareMatrix.getElement(0, n2);
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.matrix[n][n3] * integerSquareMatrix.getElement(n3, n2);
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    private IntegerSquareMatrix rawMultiply(IntegerSquareMatrix integerSquareMatrix) {
        if (this.numRows == integerSquareMatrix.numRows) {
            int[][] nArray = new int[this.numRows][this.numCols];
            int n = 0;
            while (n < this.numRows) {
                int n2 = 0;
                while (n2 < this.numCols) {
                    nArray[n][n2] = this.matrix[n][0] * integerSquareMatrix.matrix[0][n2];
                    int n3 = 1;
                    while (n3 < this.numCols) {
                        int[] nArray2 = nArray[n];
                        int n4 = n2;
                        nArray2[n4] = nArray2[n4] + this.matrix[n][n3] * integerSquareMatrix.matrix[n3][n2];
                        ++n3;
                    }
                    ++n2;
                }
                ++n;
            }
            return new IntegerSquareMatrix(nArray);
        }
        throw new MatrixDimensionException("Incompatible matrices.");
    }

    public Matrix transpose() {
        int[][] nArray = new int[this.numCols][this.numRows];
        int n = 0;
        while (n < this.numRows) {
            nArray[0][n] = this.matrix[n][0];
            int n2 = 1;
            while (n2 < this.numCols) {
                nArray[n2][n] = this.matrix[n][n2];
                ++n2;
            }
            ++n;
        }
        return new IntegerSquareMatrix(nArray);
    }

    public DoubleSquareMatrix[] luDecompose(int[] nArray) {
        if (this.LU != null) {
            if (nArray != null) {
                System.arraycopy(this.LUpivot, 0, nArray, 0, nArray.length);
            }
            return this.LU;
        }
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        if (nArray == null) {
            nArray = new int[n + 1];
        }
        int n2 = 0;
        while (n2 < n) {
            nArray[n2] = n2;
            ++n2;
        }
        nArray[n] = 1;
        int n3 = 0;
        while (n3 < n) {
            int n4;
            double d;
            n2 = 0;
            while (n2 < n3) {
                d = this.matrix[nArray[n2]][n3];
                n4 = 0;
                while (n4 < n2) {
                    d -= dArray2[n2][n4] * dArray2[n4][n3];
                    ++n4;
                }
                dArray2[n2][n3] = d;
                ++n2;
            }
            double d2 = 0.0;
            int n5 = n3;
            n2 = n3;
            while (n2 < n) {
                d = this.matrix[nArray[n2]][n3];
                n4 = 0;
                while (n4 < n3) {
                    d -= dArray2[n2][n4] * dArray2[n4][n3];
                    ++n4;
                }
                dArray2[n2][n3] = d;
                if ((d = Math.abs(d)) > d2) {
                    d2 = d;
                    n5 = n2;
                }
                ++n2;
            }
            if (n5 != n3) {
                n4 = 0;
                while (n4 < n3 + 1) {
                    d = dArray2[n3][n4];
                    dArray2[n3][n4] = dArray2[n5][n4];
                    dArray2[n5][n4] = d;
                    ++n4;
                }
                n4 = nArray[n3];
                nArray[n3] = nArray[n5];
                nArray[n5] = n4;
                nArray[n] = -nArray[n];
            }
            d = dArray2[n3][n3];
            n2 = n3 + 1;
            while (n2 < n) {
                double[] dArray3 = dArray2[n2];
                int n6 = n3;
                dArray3[n6] = dArray3[n6] / d;
                ++n2;
            }
            ++n3;
        }
        n3 = 0;
        while (n3 < n) {
            dArray[n3][n3] = 1.0;
            n2 = n3 + 1;
            while (n2 < n) {
                dArray[n2][n3] = dArray2[n2][n3];
                dArray2[n2][n3] = 0.0;
                ++n2;
            }
            ++n3;
        }
        this.LU = new DoubleSquareMatrix[2];
        this.LU[0] = new DoubleSquareMatrix(dArray);
        this.LU[1] = new DoubleSquareMatrix(dArray2);
        this.LUpivot = new int[nArray.length];
        System.arraycopy(nArray, 0, this.LUpivot, 0, nArray.length);
        return this.LU;
    }

    public DoubleSquareMatrix[] choleskyDecomposition() {
        int n = this.numRows;
        double[][] dArray = new double[n][n];
        double[][] dArray2 = new double[n][n];
        double d = Math.sqrt(this.matrix[0][0]);
        dArray2[0][0] = d;
        dArray[0][0] = d;
        int n2 = 1;
        while (n2 < n) {
            double d2 = (double)this.matrix[n2][0] / dArray[0][0];
            dArray2[0][n2] = d2;
            dArray[n2][0] = d2;
            ++n2;
        }
        int n3 = 1;
        while (n3 < n) {
            double d3 = this.matrix[n3][n3];
            n2 = 0;
            while (n2 < n3) {
                d3 -= dArray[n3][n2] * dArray[n3][n2];
                ++n2;
            }
            double d4 = Math.sqrt(d3);
            dArray2[n3][n3] = d4;
            dArray[n3][n3] = d4;
            n2 = n3 + 1;
            while (n2 < n) {
                d3 = this.matrix[n2][n3];
                int n4 = 0;
                while (n4 < n2) {
                    d3 -= dArray[n3][n4] * dArray2[n4][n2];
                    ++n4;
                }
                double d5 = d3 / dArray2[n3][n3];
                dArray2[n3][n2] = d5;
                dArray[n2][n3] = d5;
                ++n2;
            }
            ++n3;
        }
        DoubleSquareMatrix[] doubleSquareMatrixArray = new DoubleSquareMatrix[]{new DoubleSquareMatrix(dArray), new DoubleSquareMatrix(dArray2)};
        return doubleSquareMatrixArray;
    }
}

