/*
 * Decompiled with CFR 0.152.
 */
package JSci.maths.polynomials;

import JSci.maths.fields.Field;
import JSci.maths.polynomials.Polynomial;
import JSci.maths.polynomials.PolynomialBasis;
import JSci.maths.polynomials.RealPolynomial;
import JSci.maths.polynomials.RealPolynomialRing;

public class RealMonomialBasis
implements PolynomialBasis {
    private RealPolynomial[] _basis;
    private int _dim;

    public RealMonomialBasis(int n) {
        this._dim = n;
        this._basis = new RealPolynomial[n];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Polynomial getBasisVector(int n) {
        if (n >= this._dim) {
            throw new ArrayIndexOutOfBoundsException();
        }
        if (this._basis[n] == null) {
            RealMonomialBasis realMonomialBasis = this;
            synchronized (realMonomialBasis) {
                if (this._basis[n] == null) {
                    double[] dArray = new double[this._dim];
                    dArray[n] = 1.0;
                    this._basis[n] = new RealPolynomial(dArray);
                }
            }
        }
        return this._basis[n];
    }

    public int dimension() {
        return this._dim;
    }

    public Field.Member[] getSamplingPoints() {
        throw new UnsupportedOperationException();
    }

    public Polynomial superposition(Field.Member[] memberArray) {
        return this.superposition(RealPolynomialRing.toDouble(memberArray));
    }

    public RealPolynomial superposition(double[] dArray) {
        if (dArray == null) {
            throw new NullPointerException();
        }
        if (dArray.length != this._dim) {
            throw new IllegalArgumentException("Dimension of basis is " + this._dim + ". Got " + dArray.length + " coefficients");
        }
        return new RealPolynomial(dArray);
    }
}

