/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.xdoc;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.sax.SAXResult;
import javax.xml.transform.stream.StreamSource;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LinkChecker {
    private final URL context;
    private final boolean attemptExternal;
    private int localFailures;
    private int extFailures;
    private Map urlNames = new HashMap();
    private static Pattern namePattern1 = Pattern.compile("<a\\b[^>]*\\bname=['\"]([^'\"]*)['\"]", 2);
    private static Pattern namePattern2 = Pattern.compile("<a\\s+name=(\\w+)>", 2);
    private int networkTimeout = 5;

    public LinkChecker(URL context, boolean attemptExternal) {
        this.context = context;
        this.attemptExternal = attemptExternal;
    }

    private boolean checkURL(String href) {
        boolean ok;
        boolean isExternal;
        String frag;
        URL url;
        int hashPos = href.indexOf(35);
        try {
            if (hashPos < 0) {
                url = new URL(this.context, href);
                frag = null;
            } else {
                url = new URL(this.context, href.substring(0, hashPos));
                frag = href.substring(hashPos + 1);
            }
        }
        catch (MalformedURLException e) {
            this.logMessage("Badly formed URL: " + href);
            ++this.localFailures;
            return false;
        }
        boolean bl = isExternal = !"file".equals(url.getProtocol());
        if (isExternal && !this.attemptExternal) {
            return true;
        }
        try {
            ok = frag == null ? this.checkUrlExists(url) : this.checkUrlContains(url, frag);
        }
        catch (IOException e) {
            this.logMessage("Connection failed: " + e);
            ok = false;
        }
        if (!ok) {
            if (isExternal) {
                ++this.extFailures;
                this.logMessage("Bad remote link: " + href);
            } else {
                this.logMessage("Bad link: " + href);
                ++this.localFailures;
            }
        }
        return ok;
    }

    private boolean checkUrlExists(URL url) throws IOException {
        boolean ok;
        if (this.urlNames.containsKey(url)) {
            return true;
        }
        URLConnection conn = url.openConnection();
        if (conn instanceof HttpURLConnection) {
            HttpURLConnection hconn = (HttpURLConnection)conn;
            hconn.setRequestMethod("HEAD");
            this.connectWithTimeout(hconn);
            int response = hconn.getResponseCode();
            if (response == 200) {
                ok = true;
            } else {
                this.logMessage("Response " + response + ": " + url);
                ok = false;
            }
            hconn.disconnect();
        } else {
            this.connectWithTimeout(conn);
            conn.getInputStream().close();
            ok = true;
        }
        if (ok) {
            this.urlNames.put(url, null);
        }
        return ok;
    }

    private boolean checkUrlContains(URL url, String frag) throws IOException {
        if (this.urlNames.get(url) == null) {
            String line;
            HashSet<String> names = new HashSet<String>();
            URLConnection conn = url.openConnection();
            this.connectWithTimeout(conn);
            BufferedReader strm = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            while ((line = strm.readLine()) != null) {
                Matcher matcher = namePattern1.matcher(line);
                while (matcher.find()) {
                    names.add(matcher.group(1));
                }
                matcher = namePattern2.matcher(line);
                while (matcher.find()) {
                    names.add(matcher.group(1));
                }
            }
            strm.close();
            this.urlNames.put(url, names);
        }
        return ((Collection)this.urlNames.get(url)).contains(frag);
    }

    public boolean checkLinks(Source xsltSrc, Source xmlSrc) throws TransformerException, MalformedURLException {
        return this.checkLinks(xsltSrc, xmlSrc, null);
    }

    public boolean checkLinks(Source xsltSrc, Source xmlSrc, Map params) throws TransformerException, MalformedURLException {
        Transformer trans = TransformerFactory.newInstance().newTransformer(xsltSrc);
        if (params != null) {
            Iterator it = params.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry entry = it.next();
                String name = (String)entry.getKey();
                String value = (String)entry.getValue();
                trans.setParameter(name, value);
            }
        }
        trans.setOutputProperty("method", "xml");
        LinkCheckHandler handler = new LinkCheckHandler();
        trans.transform(xmlSrc, new SAXResult(handler));
        return handler.ok;
    }

    public void setTimeout(int timeoutSecs) {
        this.networkTimeout = timeoutSecs;
    }

    public int getTimeout() {
        return this.networkTimeout;
    }

    public int getLocalFailures() {
        return this.localFailures;
    }

    public int getExternalFailures() {
        return this.extFailures;
    }

    protected void logMessage(String msg) {
        System.out.println(msg);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void connectWithTimeout(URLConnection conn) throws IOException {
        URLConnector connector = new URLConnector(conn);
        connector.start();
        long endTime = System.currentTimeMillis() + (long)(this.networkTimeout * 1000);
        URLConnector uRLConnector = connector;
        synchronized (uRLConnector) {
            while (System.currentTimeMillis() < endTime && !connector.isConnected()) {
                try {
                    connector.wait(endTime - System.currentTimeMillis() + 1L);
                }
                catch (InterruptedException e) {
                    throw (IOException)new IOException("Connection interrupted: " + conn.getURL()).initCause(e);
                }
            }
            if (!connector.isConnected()) {
                throw new IOException("Connection timed out: " + conn.getURL());
            }
        }
    }

    public static void main(String[] args) throws MalformedURLException, TransformerException {
        File stylesheet;
        String usage = "Usage: LinkChecker [-noext] [-param name value ...] stylesheet [xmldoc]";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        HashMap params = new HashMap();
        boolean attemptExternal = true;
        while (argList.size() > 0 && ((String)argList.get(0)).startsWith("-")) {
            String flag = (String)argList.remove(0);
            if (flag.startsWith("-param") && argList.size() >= 2) {
                params.put(argList.remove(0), argList.remove(0));
                continue;
            }
            if (flag.startsWith("-noext")) {
                attemptExternal = false;
                continue;
            }
            System.err.println(usage);
            System.exit(1);
        }
        if (argList.size() < 1 || argList.size() > 2) {
            System.err.println(usage);
            System.exit(1);
        }
        if (!(stylesheet = new File((String)argList.get(0))).isFile()) {
            System.err.println("No stylesheet " + stylesheet);
            System.exit(1);
        }
        StreamSource styleSrc = new StreamSource(stylesheet);
        StreamSource docSrc = args.length > 1 ? new StreamSource((String)argList.get(1)) : new StreamSource(System.in);
        try {
            LinkChecker checker = new LinkChecker(new File(".").toURL(), attemptExternal);
            boolean ok = checker.checkLinks(styleSrc, docSrc, params);
            int localFailures = checker.getLocalFailures();
            int extFailures = checker.getExternalFailures();
            if (extFailures > 0) {
                System.out.println(extFailures + " external link resolution errors");
            }
            if (localFailures > 0) {
                System.out.println(localFailures + " local link resolution errors");
            }
            System.exit(localFailures == 0 ? 0 : 1);
        }
        catch (TransformerException e) {
            System.err.println(e);
            System.exit(1);
        }
        catch (MalformedURLException e) {
            System.err.println(e);
            System.exit(1);
        }
    }

    private class LinkCheckHandler
    extends DefaultHandler {
        boolean ok = true;
        private Set namesSeen = new HashSet();
        private List namesReferenced = new ArrayList();

        private LinkCheckHandler() {
        }

        public void startElement(String namespaceURI, String localName, String qName, Attributes atts) throws SAXException {
            String src;
            if (qName.equalsIgnoreCase("a")) {
                String href;
                String name = atts.getValue("name");
                if (name != null) {
                    this.namesSeen.add(name);
                }
                if ((href = atts.getValue("href")) != null) {
                    if (href.startsWith("#")) {
                        this.namesReferenced.add(href.substring(1));
                    } else if (!href.startsWith("mailto:") && !LinkChecker.this.checkURL(href)) {
                        this.ok = false;
                    }
                }
            } else if (qName.equalsIgnoreCase("img") && (src = atts.getValue("src")) != null && !LinkChecker.this.checkURL(src)) {
                this.ok = false;
            }
        }

        public void endDocument() throws SAXException {
            Iterator it = this.namesReferenced.iterator();
            while (it.hasNext()) {
                String name = (String)it.next();
                if (this.namesSeen.contains(name)) continue;
                LinkChecker.this.localFailures++;
                this.ok = false;
                LinkChecker.this.logMessage("Bad link: #" + name);
            }
        }
    }

    private final class URLConnector
    extends Thread {
        final URLConnection connection;
        boolean connected;
        IOException connectException;

        URLConnector(URLConnection connection) {
            this.connection = connection;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            try {
                Object hconn;
                this.connection.connect();
                if (this.connection instanceof HttpURLConnection) {
                    hconn = (HttpURLConnection)this.connection;
                    ((HttpURLConnection)hconn).getResponseCode();
                }
                hconn = this;
                synchronized (hconn) {
                    this.connected = true;
                    this.notifyAll();
                }
            }
            catch (IOException e) {
                URLConnector uRLConnector = this;
                synchronized (uRLConnector) {
                    this.connectException = e;
                    this.notifyAll();
                }
            }
        }

        public synchronized boolean isConnected() throws IOException {
            if (this.connectException != null) {
                throw this.connectException;
            }
            return this.connected;
        }
    }
}

