/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.xdoc;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;

public class XalanProc {
    public static void main(String[] args) throws TransformerException {
        File stylesheet;
        String usage = "Usage: XalanProc [-param name value ...] stylesheet [doc]";
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        HashMap params = new HashMap();
        while (argList.size() > 0 && ((String)argList.get(0)).startsWith("-")) {
            String flag = (String)argList.remove(0);
            if (flag.endsWith("-param") && argList.size() >= 2) {
                params.put(argList.remove(0), argList.remove(0));
                continue;
            }
            System.err.println(usage);
            System.exit(1);
        }
        if (argList.size() < 1 || argList.size() > 2) {
            System.err.println(usage);
            System.exit(1);
        }
        if (!(stylesheet = new File((String)argList.get(0))).isFile()) {
            System.err.println("No stylesheet " + stylesheet);
            System.exit(1);
        }
        StreamSource styleSrc = new StreamSource(stylesheet);
        StreamSource docSrc = args.length > 1 ? new StreamSource((String)argList.get(1)) : new StreamSource(System.in);
        Transformer trans = TransformerFactory.newInstance().newTransformer(styleSrc);
        Iterator it = params.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String name = (String)entry.getKey();
            String value = (String)entry.getValue();
            trans.setParameter(name, value);
        }
        StreamResult res = new StreamResult(System.out);
        trans.transform(docSrc, res);
    }
}

