/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.xdoc;

import [Ljava.lang.String;;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class XdocUtils {
    private XdocUtils() {
    }

    public static String classUsage(String clazzName) throws ClassNotFoundException, NoSuchMethodException, IllegalAccessException, InvocationTargetException {
        Class<?> clazz = Class.forName(clazzName);
        Method main = clazz.getMethod("main", String;.class);
        PrintStream origOut = System.out;
        ByteArrayOutputStream bufOut = new ByteArrayOutputStream();
        PrintStream pout = new PrintStream(bufOut);
        System.setOut(pout);
        main.invoke(null, new Object[]{new String[]{"-help"}});
        pout.flush();
        pout.close();
        System.setOut(origOut);
        return new String(bufOut.toByteArray());
    }

    public static String reportFileSize(String loc) {
        long size = XdocUtils.getFileSize(loc);
        if (size > 0x100000L) {
            long mb10 = Math.round((double)size * 10.0 / 1024.0 / 1024.0);
            float mb = (float)((double)mb10 / 10.0);
            return Float.toString(mb) + "M";
        }
        int kb = Math.round(size / 1024L);
        return Integer.toString(kb) + "k";
    }

    private static long getFileSize(String loc) {
        long leng;
        File f = new File(loc);
        if (!f.exists()) {
            System.err.println("File " + loc + " does not exist");
            System.exit(1);
        }
        if ((leng = f.length()) == 0L) {
            System.err.println("File " + loc + " has zero length");
            System.exit(1);
        }
        return leng;
    }
}

