/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.xdoc.fig;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;

public abstract class Anchor {
    public static final Color BG = Color.WHITE;
    public static final Anchor CENTRE = new FractionAnchor(0.5f, 0.5f);
    public static final Anchor WEST = new FractionAnchor(0.0f, 0.5f);
    public static final Anchor EAST = new FractionAnchor(1.0f, 0.5f);
    public static final Anchor NORTH = new FractionAnchor(0.5f, 0.0f);
    public static final Anchor SOUTH = new FractionAnchor(0.5f, 1.0f);
    public static final Anchor NORTH_WEST = new FractionAnchor(0.0f, 0.0f);
    public static final Anchor SOUTH_WEST = new FractionAnchor(0.0f, 1.0f);
    public static final Anchor NORTH_EAST = new FractionAnchor(1.0f, 0.0f);
    public static final Anchor SOUTH_EAST = new FractionAnchor(1.0f, 1.0f);

    public abstract Point getPoint(Rectangle var1);

    public Rectangle drawString(Graphics g, String text, int x, int y, boolean clearBg) {
        Rectangle bounds = Anchor.getBounds(g, text);
        Point p = this.getPoint(bounds);
        Rectangle transBounds = new Rectangle(bounds.x + x - p.x, bounds.y + y - p.y, bounds.width, bounds.height);
        if (clearBg) {
            Anchor.clearRect(g, transBounds);
        }
        g.drawString(text, transBounds.x - bounds.x, transBounds.y - bounds.y);
        return transBounds;
    }

    public static Anchor createFractionAnchor(float xfrac, float yfrac) {
        return new FractionAnchor(xfrac, yfrac);
    }

    private static void clearRect(Graphics g, Rectangle rect) {
        Color color = g.getColor();
        g.setColor(BG);
        g.fillRect(rect.x, rect.y, rect.width, rect.height);
        g.setColor(color);
    }

    private static Rectangle getBounds(Graphics g, String text) {
        return g.getFontMetrics().getStringBounds(text, g).getBounds();
    }

    private static class FractionAnchor
    extends Anchor {
        private final float xfrac_;
        private final float yfrac_;

        FractionAnchor(float xfrac, float yfrac) {
            this.xfrac_ = xfrac;
            this.yfrac_ = yfrac;
        }

        public Point getPoint(Rectangle box) {
            return new Point(box.x + (int)((float)box.width * this.xfrac_), box.y + (int)((float)box.height * this.yfrac_));
        }
    }
}

