/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.xdoc.fig;

import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;

public abstract class Arrow {
    private int headPad_;
    private int tailPad_;

    public void drawArrow(Graphics2D g2, int x1, int y1, int x2, int y2) {
        AffineTransform trans = g2.getTransform();
        g2.translate(x2, y2);
        g2.rotate(Math.atan2(y1 - y2, x1 - x2));
        g2.translate(this.headPad_, 0);
        double r1 = Math.sqrt((x2 - x1) * (x2 - x1) + (y2 - y1) * (y2 - y1));
        this.drawArrow(g2, (int)Math.round(r1 - (double)this.tailPad_ - (double)this.headPad_));
        g2.setTransform(trans);
    }

    protected abstract void drawArrow(Graphics2D var1, int var2);

    public void setPad(int pad) {
        this.headPad_ = pad;
        this.tailPad_ = pad;
    }

    public static Arrow createFilledArrow(int lpar, int lperp) {
        return new FilledArrow(lpar, lperp);
    }

    public static class FilledArrow
    extends Arrow {
        private final int lpar_;
        private final int lperp_;

        public FilledArrow(int lpar, int lperp) {
            this.lpar_ = lpar;
            this.lperp_ = lperp;
        }

        protected void drawArrow(Graphics2D g2, int x1) {
            g2.drawLine(x1, 0, this.lpar_ / 2, 0);
            g2.fillPolygon(new int[]{0, this.lpar_, this.lpar_}, new int[]{0, -this.lperp_, this.lperp_}, 3);
        }
    }
}

