/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.xdoc.fig;

import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.BufferedOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.Icon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.KeyStroke;
import uk.ac.starlink.xdoc.fig.FixedEpsGraphics2D;

public abstract class FigureIcon
implements Icon {
    private final Rectangle bounds_;

    protected FigureIcon(Rectangle bounds) {
        this.bounds_ = new Rectangle(bounds);
    }

    protected abstract void doDrawing(Graphics2D var1);

    public int getIconWidth() {
        return this.bounds_.width;
    }

    public int getIconHeight() {
        return this.bounds_.height;
    }

    public void paintIcon(Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create();
        g2.translate(x - this.bounds_.x, y - this.bounds_.y);
        this.doDrawing(g2);
    }

    public void display() {
        Icon icon;
        final JFrame frame = new JFrame();
        frame.setDefaultCloseOperation(3);
        JPanel container = new JPanel();
        container.setBackground(Color.WHITE);
        container.setOpaque(true);
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        int xfact = this.getIconWidth() / screen.width;
        int yfact = this.getIconHeight() / screen.height;
        if (xfact == 0 && yfact == 0) {
            icon = this;
        } else {
            final int fact = Math.max(xfact + 1, yfact + 1);
            icon = new Icon(){

                public int getIconWidth() {
                    return (int)Math.ceil(FigureIcon.this.getIconWidth() / fact);
                }

                public int getIconHeight() {
                    return (int)Math.ceil(FigureIcon.this.getIconHeight() / fact);
                }

                public void paintIcon(Component c, Graphics g, int x, int y) {
                    Graphics2D g2 = (Graphics2D)g;
                    AffineTransform trans = g2.getTransform();
                    g2.scale(1.0 / (double)fact, 1.0 / (double)fact);
                    FigureIcon.this.paintIcon(c, g2, Math.round(x * fact), Math.round(y * fact));
                    g2.setTransform(trans);
                }
            };
        }
        container.add(new JLabel(icon));
        String quitKey = "quit";
        container.getInputMap().put(KeyStroke.getKeyStroke('q'), quitKey);
        container.getActionMap().put(quitKey, new AbstractAction(){

            public void actionPerformed(ActionEvent evt) {
                frame.dispose();
            }
        });
        frame.getContentPane().add(container);
        frame.pack();
        frame.setVisible(true);
    }

    public void exportEps(OutputStream out) throws IOException {
        int pad;
        double scale;
        double padfrac = 0.05;
        double xdpi = (double)this.bounds_.width / 6.0;
        double ydpi = (double)this.bounds_.height / 9.0;
        if (xdpi > ydpi) {
            scale = 72.0 / xdpi;
            pad = (int)Math.ceil((double)this.bounds_.width * padfrac * scale);
        } else {
            scale = 72.0 / ydpi;
            pad = (int)Math.ceil((double)this.bounds_.height * padfrac * scale);
        }
        int xlo = (int)Math.floor(scale * (double)this.bounds_.x) - pad;
        int ylo = (int)Math.floor(scale * (double)this.bounds_.y) - pad;
        int xhi = (int)Math.ceil(scale * (double)(this.bounds_.x + this.bounds_.width)) + pad;
        int yhi = (int)Math.ceil(scale * (double)(this.bounds_.y + this.bounds_.height)) + pad;
        FixedEpsGraphics2D g2 = new FixedEpsGraphics2D("Figure", out, xlo, ylo, xhi, yhi);
        g2.scale(scale, scale);
        this.doDrawing(g2);
        g2.close();
    }

    public void exportImageIO(String formatName, boolean transparent, OutputStream out) throws IOException {
        BufferedImage image = new BufferedImage(this.bounds_.width, this.bounds_.height, transparent ? 2 : 1);
        Graphics2D g2 = image.createGraphics();
        Color color = g2.getColor();
        Composite compos = g2.getComposite();
        g2.setComposite(AlphaComposite.getInstance(2));
        g2.setColor(new Color(1.0f, 1.0f, 1.0f, 0.0f));
        g2.fillRect(0, 0, this.bounds_.width, this.bounds_.height);
        g2.setColor(color);
        g2.setComposite(compos);
        g2.translate(-this.bounds_.x, -this.bounds_.y);
        this.doDrawing(g2);
        g2.translate(this.bounds_.x, this.bounds_.y);
        g2.dispose();
        boolean done = ImageIO.write((RenderedImage)image, formatName, out);
        out.flush();
        if (!done) {
            throw new IOException("No handler for format " + formatName);
        }
    }

    public static int runMain(String[] args, FigureIcon fig) throws IOException {
        StringBuffer ubuf = new StringBuffer("Usage:").append(" FigureIcon").append(" [");
        Mode[] modes = Mode.getModes();
        for (int i = 0; i < modes.length; ++i) {
            if (i > 0) {
                ubuf.append('|');
            }
            ubuf.append(modes[i].getFlag());
        }
        ubuf.append(']');
        if (fig == null) {
            ubuf.append(" <fig-class>");
        }
        String usage = ubuf.toString();
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        String destination = null;
        Mode mode = null;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            Class<?> clazz;
            String arg = (String)it.next();
            if (arg.equals("-o") && it.hasNext()) {
                it.remove();
                destination = (String)it.next();
                it.remove();
                continue;
            }
            if (arg.startsWith("-h")) {
                it.remove();
                System.out.println(usage);
                return 0;
            }
            if (arg.startsWith("-")) {
                Mode m = null;
                for (int i = 0; m == null && i < modes.length; ++i) {
                    if (!modes[i].getFlag().equals(arg)) continue;
                    it.remove();
                    mode = m = modes[i];
                }
                if (m != null) continue;
                System.err.println(usage);
                return 1;
            }
            if (fig != null) continue;
            it.remove();
            try {
                clazz = Class.forName(arg);
            }
            catch (Throwable e) {
                System.err.println("No class " + arg + ": " + e);
                return 1;
            }
            try {
                fig = (FigureIcon)clazz.newInstance();
            }
            catch (Throwable e) {
                System.err.println("Error instantiating " + clazz.getName() + ": " + e);
                return 1;
            }
        }
        if (!argList.isEmpty() || fig == null || mode == null) {
            System.err.println(usage);
            return 1;
        }
        mode.process(fig, destination);
        return 0;
    }

    public static void main(String[] args) throws IOException {
        int status = FigureIcon.runMain(args, null);
        if (status != 0) {
            System.exit(status);
        }
    }

    private static abstract class Mode {
        private final String name_;
        private static final Mode SWING = new Mode("swing"){

            void process(FigureIcon fig, String dest) {
                fig.display();
            }
        };
        private static final Mode EPS = new Mode("eps"){

            void process(FigureIcon fig, String dest) throws IOException {
                fig.exportEps(Mode.access$000(dest));
            }
        };

        public Mode(String name) {
            this.name_ = name;
        }

        abstract void process(FigureIcon var1, String var2) throws IOException;

        public String getFlag() {
            return "-" + this.name_;
        }

        public String toString() {
            return this.name_;
        }

        private static OutputStream getOutputStream(String dest) throws IOException {
            return dest == null || "-".equals(dest) ? System.out : new BufferedOutputStream(new FileOutputStream(dest));
        }

        public static Mode[] getModes() {
            return new Mode[]{SWING, EPS, new ImageIOMode("png", "png", false), new ImageIOMode("jpeg", "jpeg", false)};
        }

        private static class ImageIOMode
        extends Mode {
            private final String formatName_;
            private final boolean transparent_;

            ImageIOMode(String name, String formatName, boolean transparent) {
                super(name);
                this.formatName_ = formatName;
                this.transparent_ = transparent;
            }

            void process(FigureIcon fig, String dest) throws IOException {
                fig.exportImageIO(this.formatName_, this.transparent_, Mode.getOutputStream(dest));
            }
        }
    }
}

