/*
 * Decompiled with CFR 0.152.
 */
package net.ivoa.adql.convert.parser.v1_0;

import java.io.DataInputStream;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.transform.TransformerException;
import net.ivoa.adql.convert.ADQLs2DOMParser;
import net.ivoa.adql.convert.parser.v1_0.ADQLParserConstants;
import net.ivoa.adql.convert.parser.v1_0.ADQLParserTokenManager;
import net.ivoa.adql.convert.parser.v1_0.ParseException;
import net.ivoa.adql.convert.parser.v1_0.SimpleCharStream;
import net.ivoa.adql.convert.parser.v1_0.Token;
import org.w3c.dom.Attr;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ADQLParser
extends ADQLs2DOMParser
implements ADQLParserConstants {
    private boolean defineSTCR = false;
    private boolean defineSTCC = false;
    public static final String ADQL_NS = "http://www.ivoa.net/xml/ADQL/v1.0";
    public static final String ADQL_PREFIX = "ad";
    public static final String STCR_NS = "http://www.ivoa.net/xml/STC/STCregion/v1.10";
    public static final String STCR_PREFIX = "reg";
    public static final String STCC_NS = "http://www.ivoa.net/xml/STC/STCcoords/v1.10";
    public static final String STCC_PREFIX = "stc";
    public ADQLParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[48];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[10];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public static void main(String[] args) throws TransformerException {
        ADQLParser p = null;
        if (args.length < 1) {
            p = new ADQLParser(System.in);
        } else {
            try {
                p = new ADQLParser(new DataInputStream(new FileInputStream(args[0])));
            }
            catch (FileNotFoundException e) {
                p = new ADQLParser(System.in);
            }
        }
        p.parseSelect();
        System.out.println("Parse Successful");
    }

    public ADQLParser() {
    }

    protected Element createADQLElement(String name) {
        if (this.nsmode == 0) {
            name = "ad:" + name;
        }
        return this.doc.createElementNS(ADQL_NS, name);
    }

    private Element createSTCRElement(String name) {
        this.defineSTCR = true;
        name = "reg:" + name;
        return this.doc.createElementNS(STCR_NS, name);
    }

    private Element createSTCCElement(String name) {
        this.defineSTCC = true;
        if (this.nsmode == 0) {
            name = "stc:" + name;
        }
        return this.doc.createElementNS(STCC_NS, name);
    }

    private Element createRootElement(String name) {
        Element root = this.createADQLElement(name);
        root.setAttribute("xmlns:ad", ADQL_NS);
        if (this.defineSTCR) {
            root.setAttribute("xmlns:reg", STCR_NS);
        }
        if (this.defineSTCC) {
            root.setAttribute("xmlns:stc", STCC_NS);
        }
        root.setAttribute("xmlns:xsi", "http://www.w3.org/2001/XMLSchema-instance");
        if (this.nsmode == 1) {
            root.setAttribute("xmlns", ADQL_NS);
        }
        this.parent.appendChild(root);
        return root;
    }

    private Element getBinaryExpr(String name, boolean setXSIType, Element arg1, Element arg2, String op) {
        Element out = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(out, "binaryExprType");
        }
        out.setAttribute("Oper", op);
        out.appendChild(arg1);
        out.appendChild(arg2);
        return out;
    }

    private static void setXSITypeAttr(Element on, String type) {
        on.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "ad:" + type);
    }

    public Element parseSelect() throws TransformerException {
        try {
            return this.Select(null);
        }
        catch (ParseException ex) {
            throw new TransformerException(ex);
        }
    }

    public Element parseWhere() throws TransformerException {
        try {
            return this.Where("Where");
        }
        catch (ParseException ex) {
            throw new TransformerException(ex);
        }
    }

    public final String MathFunctionName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: {
                this.jj_consume_token(42);
                break;
            }
            case 43: {
                this.jj_consume_token(43);
                break;
            }
            case 44: {
                this.jj_consume_token(44);
                break;
            }
            case 45: {
                this.jj_consume_token(45);
                break;
            }
            case 46: {
                this.jj_consume_token(46);
                break;
            }
            case 48: {
                this.jj_consume_token(48);
                break;
            }
            case 47: {
                this.jj_consume_token(47);
                break;
            }
            case 49: {
                this.jj_consume_token(49);
                break;
            }
            case 52: {
                this.jj_consume_token(52);
                break;
            }
            case 53: {
                this.jj_consume_token(53);
                break;
            }
            case 54: {
                this.jj_consume_token(54);
                break;
            }
            case 55: {
                this.jj_consume_token(55);
                break;
            }
            case 56: {
                this.jj_consume_token(56);
                break;
            }
            default: {
                this.jj_la1[0] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.toUpperCase();
    }

    public final String AggregateFunctionName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: {
                this.jj_consume_token(30);
                break;
            }
            case 31: {
                this.jj_consume_token(31);
                break;
            }
            case 32: {
                this.jj_consume_token(32);
                break;
            }
            case 33: {
                this.jj_consume_token(33);
                break;
            }
            case 34: {
                this.jj_consume_token(34);
                break;
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.toUpperCase();
    }

    public final String TrigonometricFunctionName() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 35: {
                this.jj_consume_token(35);
                break;
            }
            case 36: {
                this.jj_consume_token(36);
                break;
            }
            case 37: {
                this.jj_consume_token(37);
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                break;
            }
            case 39: {
                this.jj_consume_token(39);
                break;
            }
            case 40: {
                this.jj_consume_token(40);
                break;
            }
            case 41: {
                this.jj_consume_token(41);
                break;
            }
            default: {
                this.jj_la1[2] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image.toUpperCase();
    }

    /*
     * WARNING - void declaration
     */
    public final Element FunctionOfOneVar(String name, boolean setXSIType) throws ParseException {
        void var7_6;
        boolean isMath = false;
        boolean isAgg = false;
        boolean isTrig = false;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                String fname = this.MathFunctionName();
                isMath = true;
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: {
                String fname = this.AggregateFunctionName();
                isAgg = true;
                break;
            }
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: {
                String fname = this.TrigonometricFunctionName();
                isTrig = true;
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(73);
        Element arg = this.ScalarExpression("Arg");
        this.jj_consume_token(74);
        Element f = null;
        f = this.createADQLElement(name);
        if (setXSIType) {
            if (isMath) {
                ADQLParser.setXSITypeAttr(f, "mathFunctionType");
            } else if (isAgg) {
                ADQLParser.setXSITypeAttr(f, "aggregateFunctionType");
            } else if (isTrig) {
                ADQLParser.setXSITypeAttr(f, "trigonometricFunctionType");
            }
        }
        f.setAttribute("Name", (String)var7_6);
        f.appendChild(arg);
        return f;
    }

    public final Element AliasSelectionItem(String name, boolean setXSIType) throws ParseException {
        String as = null;
        Element exp = this.ScalarExpression(name);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 8: {
                this.jj_consume_token(8);
                this.jj_consume_token(67);
                as = this.token.image;
                break;
            }
            default: {
                this.jj_la1[4] = this.jj_gen;
            }
        }
        if (as != null) {
            Element a = this.createADQLElement(name);
            if (setXSIType) {
                ADQLParser.setXSITypeAttr(a, "aliasSelectionItemType");
            }
            exp = this.renameADQLElement(exp, "Expression", null);
            a.appendChild(exp);
            a.setAttribute("As", as);
            exp = a;
        }
        return exp;
    }

    public final Attr AllOrDistinct(String name) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: {
                this.jj_consume_token(5);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Attr out = this.doc.createAttribute(name);
        if (this.token.image.toUpperCase().equals("ALL")) {
            out.setValue("All");
        } else {
            out.setValue("DISTINCT");
        }
        return out;
    }

    public final Element AllSelectionItem(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(75);
        Element all = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(all, "allSelectionItemType");
        }
        return all;
    }

    public final Element ArchiveTable(String name, boolean setXSIType) throws ParseException {
        String archive = null;
        String table = null;
        String alias = null;
        this.jj_consume_token(67);
        archive = this.token.image;
        this.jj_consume_token(76);
        this.jj_consume_token(67);
        table = this.token.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                alias = this.token.image;
                break;
            }
            default: {
                this.jj_la1[6] = this.jj_gen;
            }
        }
        Element a = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(a, "archiveTableType");
        }
        a.setAttribute("Archive", archive);
        a.setAttribute("Name", table);
        if (alias != null) {
            a.setAttribute("Alias", alias);
        }
        return a;
    }

    public final Element Atom(String name, boolean setXSIType) throws ParseException {
        Element u = null;
        Element l = this.Literal("Literal", true);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: 
            case 68: {
                u = this.Unit("Unit");
                break;
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        Element a = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(a, "atomType");
        }
        a.appendChild(l);
        if (u != null) {
            a.appendChild(u);
        }
        return a;
    }

    public final Element Unit(String name) throws ParseException {
        String unit = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                unit = this.token.image;
                break;
            }
            case 68: {
                this.jj_consume_token(68);
                unit = this.token.image.substring(1, this.token.image.length() - 1).trim();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Element u = this.createADQLElement(name);
        Text txt = this.doc.createTextNode(unit);
        u.appendChild(txt);
        return u;
    }

    public final Element BetweenPred(String name, boolean setXSIType) throws ParseException {
        boolean not = false;
        Element arg0 = this.ScalarExpression("Arg");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                not = true;
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
            }
        }
        this.jj_consume_token(10);
        Element arg1 = this.ScalarExpression("Arg");
        this.jj_consume_token(6);
        Element arg2 = this.ScalarExpression("Arg");
        Element b = this.createADQLElement(name);
        if (not) {
            if (setXSIType) {
                ADQLParser.setXSITypeAttr(b, "notBetweenPredType");
            }
        } else if (setXSIType) {
            ADQLParser.setXSITypeAttr(b, "betweenPredType");
        }
        b.appendChild(arg0);
        b.appendChild(arg1);
        b.appendChild(arg2);
        return b;
    }

    public final Element ClosedExpr(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(73);
        Element arg = this.ScalarExpression("Arg");
        this.jj_consume_token(74);
        Element c = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(c, "closedExprType");
        }
        c.appendChild(arg);
        return c;
    }

    public final Element ClosedSearch(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(73);
        Element s = this.Search(name);
        this.jj_consume_token(74);
        Element c = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(c, "closedSearchType");
        }
        c.appendChild(s);
        return c;
    }

    /*
     * WARNING - void declaration
     */
    public final Element ColumnReference(String name, boolean setXSIType) throws ParseException {
        void var3_3;
        Element col;
        if (this.jj_2_1(Integer.MAX_VALUE)) {
            col = this.ActualColumnReference(name, setXSIType);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: 
                case 78: 
                case 79: {
                    col = this.XPathReference(name, setXSIType);
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return var3_3;
    }

    public final Element ActualColumnReference(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(67);
        String table = this.token.image;
        this.jj_consume_token(77);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                break;
            }
            case 75: {
                this.jj_consume_token(75);
                break;
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String cname = this.token.image;
        Element c = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(c, "columnReferenceType");
        }
        c.setAttribute("Table", table);
        c.setAttribute("Name", cname);
        return c;
    }

    public final Element XPathReference(String name, boolean setXSIType) throws ParseException {
        StringBuffer sb = new StringBuffer();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 78: {
                this.jj_consume_token(78);
                sb.append(this.token.image);
                break;
            }
            default: {
                this.jj_la1[12] = this.jj_gen;
            }
        }
        this.RelativeXPath(sb);
        String cname = sb.toString();
        Element c = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(c, "columnReferenceType");
        }
        c.setAttribute("Table", "");
        c.setAttribute("xpathName", cname);
        int s = cname.lastIndexOf("/");
        if (s < 0) {
            c.setAttribute("name", cname);
        } else {
            c.setAttribute("name", cname.substring(s + 1));
        }
        return c;
    }

    public final void RelativeXPath(StringBuffer sb) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 79: {
                this.jj_consume_token(79);
                sb.append(this.token.image);
                break;
            }
            default: {
                this.jj_la1[13] = this.jj_gen;
            }
        }
        this.jj_consume_token(67);
        sb.append(this.token.image);
        if (!this.jj_2_2(2)) {
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 78: {
                this.jj_consume_token(78);
                sb.append(this.token.image);
                this.RelativeXPath(sb);
                break;
            }
            default: {
                this.jj_la1[14] = this.jj_gen;
            }
        }
    }

    public final Element ComparisonPred(String name, boolean setXSIType) throws ParseException {
        Element arg1 = this.ScalarExpression("Arg");
        String divider = this.ComparisonDivider();
        Element arg2 = this.ScalarExpression("Arg");
        Element c = this.createADQLElement(name);
        Matcher like = Pattern.compile(".*LIKE", 2).matcher(divider);
        Matcher not = Pattern.compile("NOT.*", 2).matcher(divider);
        if (like.matches()) {
            arg2 = this.renameADQLElement(arg2, "Pattern", null);
            if (setXSIType) {
                if (not.matches()) {
                    ADQLParser.setXSITypeAttr(c, "notLikePredType");
                } else {
                    ADQLParser.setXSITypeAttr(c, "likePredType");
                }
            }
        } else {
            if (setXSIType) {
                ADQLParser.setXSITypeAttr(c, "comparisonPredType");
            }
            c.setAttribute("Comparison", divider);
        }
        c.appendChild(arg1);
        c.appendChild(arg2);
        return c;
    }

    public final String ComparisonDivider() throws ParseException {
        String value = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 80: 
            case 81: 
            case 82: 
            case 83: 
            case 84: 
            case 85: 
            case 86: {
                value = this.Comparison();
                break;
            }
            case 21: 
            case 22: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 22: {
                        this.jj_consume_token(22);
                        value = "NOT ";
                        break;
                    }
                    default: {
                        this.jj_la1[15] = this.jj_gen;
                    }
                }
                this.jj_consume_token(21);
                value = value + this.token.image;
                break;
            }
            default: {
                this.jj_la1[16] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return value;
    }

    public final String Comparison() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 80: {
                this.jj_consume_token(80);
                break;
            }
            case 81: {
                this.jj_consume_token(81);
                break;
            }
            case 82: {
                this.jj_consume_token(82);
                break;
            }
            case 83: {
                this.jj_consume_token(83);
                break;
            }
            case 84: {
                this.jj_consume_token(84);
                break;
            }
            case 85: {
                this.jj_consume_token(85);
                break;
            }
            case 86: {
                this.jj_consume_token(86);
                break;
            }
            default: {
                this.jj_la1[17] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final Element DropTable(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(67);
        Element dt = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(dt, "dropTableType");
        }
        dt.setAttribute("Name", this.token.image);
        return dt;
    }

    public final Element From(String name) throws ParseException {
        ArrayList<Element> list = new ArrayList<Element>();
        this.jj_consume_token(15);
        Element got = this.FromTable("Table", true);
        list.add(got);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    break;
                }
                default: {
                    this.jj_la1[18] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(87);
            got = this.FromTable("Table", true);
            list.add(got);
        }
        Element f = this.createADQLElement(name);
        for (int i = 0; i < list.size(); ++i) {
            f.appendChild((Element)list.get(i));
        }
        return f;
    }

    /*
     * WARNING - void declaration
     */
    public final Element FromTable(String name, boolean setXSIType) throws ParseException {
        void var3_3;
        Element ft;
        if (this.jj_2_3(2)) {
            ft = this.ArchiveTable(name, setXSIType);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 67: 
                case 91: {
                    ft = this.Table(name, setXSIType);
                    break;
                }
                default: {
                    this.jj_la1[19] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return var3_3;
    }

    public final Element GroupBy(String name) throws ParseException {
        ArrayList<Element> list = new ArrayList<Element>();
        this.jj_consume_token(16);
        this.jj_consume_token(11);
        Element cr = this.ColumnReference("Column", false);
        list.add(cr);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    break;
                }
                default: {
                    this.jj_la1[20] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(87);
            cr = this.ColumnReference("Column", false);
            list.add(cr);
        }
        Element gb = this.createADQLElement(name);
        for (int i = 0; i < list.size(); ++i) {
            gb.appendChild((Element)list.get(i));
        }
        return gb;
    }

    public final Element Having(String name) throws ParseException {
        this.jj_consume_token(17);
        Element st = this.Search("Condition");
        Element h = this.createADQLElement(name);
        h.appendChild(st);
        return h;
    }

    public final Element IncludeTable(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(67);
        Element it = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(it, "includeTableType");
        }
        it.setAttribute("Name", this.token.image);
        return it;
    }

    public final Element IntersectionSearch(String name, boolean setXSIType) throws ParseException {
        Element arg1 = this.IntersectionElement(name, true);
        while (this.jj_2_4(2)) {
            this.jj_consume_token(6);
            Element arg2 = this.IntersectionElement("Condition", true);
            arg1 = this.renameADQLElement(arg1, "Condition", null);
            Element is = this.createADQLElement(name);
            if (setXSIType) {
                ADQLParser.setXSITypeAttr(is, "intersectionSearchType");
            }
            is.appendChild(arg1);
            is.appendChild(arg2);
            arg1 = is;
        }
        return arg1;
    }

    /*
     * WARNING - void declaration
     */
    public final Element IntersectionElement(String name, boolean setXSIType) throws ParseException {
        void var3_3;
        Element s;
        if (this.jj_2_5(Integer.MAX_VALUE)) {
            s = this.ClosedSearch(name, true);
        } else if (this.jj_2_6(Integer.MAX_VALUE)) {
            s = this.BetweenPred(name, true);
        } else {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 22: {
                    s = this.InverseSearch(name, true);
                    break;
                }
                case 30: 
                case 31: 
                case 32: 
                case 33: 
                case 34: 
                case 35: 
                case 36: 
                case 37: 
                case 38: 
                case 39: 
                case 40: 
                case 41: 
                case 42: 
                case 43: 
                case 44: 
                case 45: 
                case 46: 
                case 47: 
                case 48: 
                case 49: 
                case 52: 
                case 53: 
                case 54: 
                case 55: 
                case 56: 
                case 59: 
                case 60: 
                case 67: 
                case 71: 
                case 73: 
                case 78: 
                case 79: 
                case 89: 
                case 90: {
                    s = this.ComparisonPred(name, true);
                    break;
                }
                case 57: {
                    s = this.RegionSearch(name, true);
                    break;
                }
                case 58: {
                    s = this.XMatch(name, true);
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
        }
        return var3_3;
    }

    public final Element InverseSearch(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(22);
        Element s = this.Search("Condition");
        Element is = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(is, "inverseSearchType");
        }
        is.appendChild(s);
        return is;
    }

    /*
     * WARNING - void declaration
     */
    public final Element Literal(String name, boolean setXSIType) throws ParseException {
        void var3_3;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: 
            case 60: {
                Element l = this.Number(name, true);
                break;
            }
            case 71: {
                Element l = this.XString(name, true);
                break;
            }
            default: {
                this.jj_la1[22] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var3_3;
    }

    public final Element Number(String name, boolean setXSIType) throws ParseException {
        Element num = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: {
                this.jj_consume_token(59);
                num = this.createADQLElement(name);
                if (setXSIType) {
                    ADQLParser.setXSITypeAttr(num, "realType");
                }
                num.setAttribute("Value", this.token.image);
                return num;
            }
            case 60: {
                this.jj_consume_token(60);
                num = this.createADQLElement(name);
                if (setXSIType) {
                    ADQLParser.setXSITypeAttr(num, "integerType");
                }
                num.setAttribute("Value", this.token.image);
                return num;
            }
        }
        this.jj_la1[23] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final String OrderDirection() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 12: {
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[24] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.token.image;
    }

    public final Element OrderExpression(String name) throws ParseException {
        ArrayList<Element> list = new ArrayList<Element>();
        this.jj_consume_token(25);
        this.jj_consume_token(11);
        Element o = this.Order("Item");
        list.add(o);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    break;
                }
                default: {
                    this.jj_la1[25] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(87);
            o = this.Order("Item");
            list.add(o);
        }
        Element oe = this.createADQLElement(name);
        for (int i = 0; i < list.size(); ++i) {
            oe.appendChild((Element)list.get(i));
        }
        return oe;
    }

    public final Element Order(String name) throws ParseException {
        Element s = null;
        Element oo = null;
        s = this.ScalarExpression("Expression");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: 
            case 12: {
                oo = this.OrderOption("Order");
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
            }
        }
        Element o = this.createADQLElement(name);
        o.appendChild(s);
        if (oo != null) {
            o.appendChild(oo);
        }
        return o;
    }

    public final Element OrderOption(String name) throws ParseException {
        String od = this.OrderDirection();
        Element oo = this.createADQLElement(name);
        oo.setAttribute("Direction", od);
        return oo;
    }

    public final Element RegionSearch(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(57);
        this.jj_consume_token(73);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 71: {
                this.jj_consume_token(71);
                break;
            }
            case 72: {
                this.jj_consume_token(72);
                break;
            }
            default: {
                this.jj_la1[27] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        String literal = this.token.image;
        this.jj_consume_token(74);
        literal = literal.substring(1, literal.length() - 1);
        Pattern p = Pattern.compile(" ");
        String[] flds = p.split(literal);
        if (flds.length != 5) {
            throw new ParseException("Error parsing region literal:" + literal);
        }
        if (!flds[0].toUpperCase().equals("CIRCLE") || !flds[1].toUpperCase().equals("J2000")) {
            throw new ParseException("Unsupported region type, or coordinate system.  Only CIRCLE J2000 supported. " + flds[0] + ":" + flds[1]);
        }
        Element rs = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(rs, "regionSearchType");
        }
        Element ct = this.createADQLElement("Region");
        ct.setAttribute("unit", "deg");
        ct.setAttributeNS("http://www.w3.org/2001/XMLSchema-instance", "xsi:type", "reg:circleType");
        rs.appendChild(ct);
        Element cen = this.createSTCRElement("Center");
        Text txt = this.doc.createTextNode(flds[2] + " " + flds[3]);
        cen.appendChild(txt);
        ct.appendChild(cen);
        if (flds[4].endsWith("\"")) {
            double radius = Double.parseDouble(flds[4].substring(0, flds[4].length() - 1)) / 3660.0;
            flds[4] = Double.toString(radius);
        } else if (flds[4].endsWith("'")) {
            double radius = Double.parseDouble(flds[4].substring(0, flds[4].length() - 1)) / 60.0;
            flds[4] = Double.toString(radius);
        } else {
            double radius = Double.parseDouble(flds[4]);
        }
        Element rad = this.createSTCRElement("Radius");
        txt = this.doc.createTextNode(flds[4]);
        rad.appendChild(txt);
        ct.appendChild(rad);
        return rs;
    }

    /*
     * WARNING - void declaration
     */
    public final Element SelectionItem(String name) throws ParseException {
        void var2_2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 67: 
            case 71: 
            case 73: 
            case 78: 
            case 79: 
            case 89: 
            case 90: {
                Element s = this.AliasSelectionItem(name, true);
                break;
            }
            case 75: {
                Element s = this.AllSelectionItem(name, true);
                break;
            }
            default: {
                this.jj_la1[28] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var2_2;
    }

    public final Element SelectionLimit(String name) throws ParseException {
        this.jj_consume_token(27);
        this.jj_consume_token(60);
        int x = Integer.parseInt(this.token.image);
        if (x < 0) {
            throw new ParseException("Requested row limit is negative");
        }
        Element sl = this.createADQLElement(name);
        sl.setAttribute("Top", Integer.toString(x));
        return sl;
    }

    public final Element SelectionList(String name) throws ParseException {
        ArrayList<Element> list = new ArrayList<Element>();
        Element si = this.SelectionItem("Item");
        list.add(si);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    break;
                }
                default: {
                    this.jj_la1[29] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(87);
            si = this.SelectionItem("Item");
            list.add(si);
        }
        Element sl = this.createADQLElement(name);
        for (int i = 0; i < list.size(); ++i) {
            sl.appendChild((Element)list.get(i));
        }
        return sl;
    }

    public final Element SelectionOption(String name) throws ParseException {
        Attr allordistinct = this.AllOrDistinct("Option");
        Element so = this.createADQLElement(name);
        so.setAttributeNode(allordistinct);
        return so;
    }

    public final Element Into(String name) throws ParseException {
        Text s = null;
        Element t = null;
        Element e = null;
        String i = null;
        this.jj_consume_token(19);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 67: {
                this.jj_consume_token(67);
                i = this.token.image;
                break;
            }
            case 66: {
                this.jj_consume_token(66);
                i = this.token.image;
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        e = this.createADQLElement("InTo");
        t = this.createADQLElement("TableName");
        s = this.doc.createTextNode(i);
        t.appendChild(s);
        e.appendChild(t);
        return e;
    }

    public final Element Select(String name) throws ParseException {
        Element s;
        Element allow = null;
        Element restrict = null;
        Element sel = null;
        Element into = null;
        Element from = null;
        Element where = null;
        Element group = null;
        Element having = null;
        Element order = null;
        this.jj_consume_token(26);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 5: 
            case 13: {
                allow = this.SelectionOption("Allow");
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 27: {
                restrict = this.SelectionLimit("Restrict");
                break;
            }
            default: {
                this.jj_la1[32] = this.jj_gen;
            }
        }
        sel = this.SelectionList("SelectionList");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 19: {
                into = this.Into("Into");
                break;
            }
            default: {
                this.jj_la1[33] = this.jj_gen;
            }
        }
        from = this.From("From");
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 29: {
                where = this.Where("Where");
                break;
            }
            default: {
                this.jj_la1[34] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 16: {
                group = this.GroupBy("GroupBy");
                break;
            }
            default: {
                this.jj_la1[35] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 17: {
                having = this.Having("Having");
                break;
            }
            default: {
                this.jj_la1[36] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                order = this.OrderExpression("OrderBy");
                break;
            }
            default: {
                this.jj_la1[37] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 88: {
                this.jj_consume_token(88);
                break;
            }
            case 0: {
                this.jj_consume_token(0);
                break;
            }
            default: {
                this.jj_la1[38] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        Element element = s = name == null ? this.createRootElement("Select") : this.createADQLElement(name);
        if (allow != null) {
            s.appendChild(allow);
        }
        if (restrict != null) {
            s.appendChild(restrict);
        }
        if (sel != null) {
            s.appendChild(sel);
        }
        if (into != null) {
            s.appendChild(into);
        }
        if (from != null) {
            s.appendChild(from);
        }
        if (where != null) {
            s.appendChild(where);
        }
        if (group != null) {
            s.appendChild(group);
        }
        if (having != null) {
            s.appendChild(having);
        }
        if (order != null) {
            s.appendChild(order);
        }
        return s;
    }

    public final Element ScalarExpression(String name) throws ParseException {
        Element s = this.PlusExpr(name);
        return s;
    }

    public final Element PlusExpr(String name) throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: 
            case 59: 
            case 60: 
            case 67: 
            case 71: 
            case 73: 
            case 78: 
            case 79: {
                Element arg1 = this.MultExpr(name, true);
                while (this.jj_2_7(2)) {
                    Element be;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 89: {
                            this.jj_consume_token(89);
                            break;
                        }
                        case 90: {
                            this.jj_consume_token(90);
                            break;
                        }
                        default: {
                            this.jj_la1[39] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    String op = this.token.image;
                    Element arg2 = this.MultExpr("Arg", true);
                    arg1 = this.renameADQLElement(arg1, "Arg", null);
                    arg1 = be = this.getBinaryExpr(name, true, arg1, arg2, op);
                }
                return arg1;
            }
            case 89: 
            case 90: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 89: {
                        this.jj_consume_token(89);
                        break;
                    }
                    case 90: {
                        this.jj_consume_token(90);
                        break;
                    }
                    default: {
                        this.jj_la1[40] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
                String op = this.token.image;
                Element arg1 = this.MultExpr(name, true);
                if (this.matchesXSIType(arg1, "ad:AtomType")) {
                    String val;
                    Element lit = this.getChildByTag(arg1, "Literal");
                    if (lit != null && (this.matchesXSIType(lit, "ad:IntegerType") || this.matchesXSIType(lit, "ad:RealType")) && op.equals("-") && (val = arg1.getAttribute("Value")) != null) {
                        val = val.trim().startsWith("-") ? val.trim().substring(1) : (val.trim().startsWith("+") ? "-" + val.trim().substring(1) : "-" + val.trim());
                        arg1.setAttribute("Value", val);
                    }
                } else {
                    Element un = this.createADQLElement(name);
                    ADQLParser.setXSITypeAttr(un, "unaryType");
                    un.setAttribute("Oper", op);
                    un.appendChild(arg1);
                    arg1 = un;
                }
                while (this.jj_2_8(2)) {
                    Element be;
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 89: {
                            this.jj_consume_token(89);
                            break;
                        }
                        case 90: {
                            this.jj_consume_token(90);
                            break;
                        }
                        default: {
                            this.jj_la1[41] = this.jj_gen;
                            this.jj_consume_token(-1);
                            throw new ParseException();
                        }
                    }
                    op = this.token.image;
                    Element arg2 = this.MultExpr("Arg", true);
                    arg1 = this.renameADQLElement(arg1, "Arg", null);
                    arg1 = be = this.getBinaryExpr(name, true, arg1, arg2, op);
                }
                return arg1;
            }
        }
        this.jj_la1[42] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Element MultExpr(String name, boolean setXSIType) throws ParseException {
        Element arg1 = this.UnitExpr(name, true);
        while (this.jj_2_9(2)) {
            Element be;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 75: {
                    this.jj_consume_token(75);
                    break;
                }
                case 78: {
                    this.jj_consume_token(78);
                    break;
                }
                default: {
                    this.jj_la1[43] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            String op = this.token.image;
            Element arg2 = this.UnitExpr("Arg", true);
            arg1 = this.renameADQLElement(arg1, "Arg", null);
            arg1 = be = this.getBinaryExpr(name, true, arg1, arg2, op);
        }
        return arg1;
    }

    /*
     * WARNING - void declaration
     */
    public final Element UnitExpr(String name, boolean setXSIType) throws ParseException {
        void var3_3;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 59: 
            case 60: 
            case 71: {
                Element s = this.Atom(name, true);
                break;
            }
            case 73: {
                Element s = this.ClosedExpr(name, true);
                break;
            }
            case 67: 
            case 78: 
            case 79: {
                Element s = this.ColumnReference(name, true);
                break;
            }
            case 30: 
            case 31: 
            case 32: 
            case 33: 
            case 34: 
            case 35: 
            case 36: 
            case 37: 
            case 38: 
            case 39: 
            case 40: 
            case 41: 
            case 42: 
            case 43: 
            case 44: 
            case 45: 
            case 46: 
            case 47: 
            case 48: 
            case 49: 
            case 52: 
            case 53: 
            case 54: 
            case 55: 
            case 56: {
                Element s = this.FunctionOfOneVar(name, true);
                break;
            }
            default: {
                this.jj_la1[44] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var3_3;
    }

    public final Element Search(String name) throws ParseException {
        Element s = this.UnionSearch(name, true);
        return s;
    }

    public final Element XString(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(71);
        Element lit = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(lit, "stringType");
        }
        String val = this.token.image;
        val = val.substring(1, val.length() - 1);
        Matcher m = Pattern.compile("''").matcher(val);
        val = m.replaceAll("'");
        lit.setAttribute("Value", val);
        return lit;
    }

    public final Element Table(String name, boolean setXSIType) throws ParseException {
        String temp = "";
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 91: {
                this.jj_consume_token(91);
                temp = "#";
                break;
            }
            default: {
                this.jj_la1[45] = this.jj_gen;
            }
        }
        this.jj_consume_token(67);
        String table = this.token.image;
        this.jj_consume_token(67);
        String alias = this.token.image;
        Element t = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(t, "tableType");
        }
        t.setAttribute("Name", table);
        t.setAttribute("Alias", alias);
        return t;
    }

    public final Element UnionSearch(String name, boolean setXSIType) throws ParseException {
        Element arg1 = this.IntersectionSearch(name, true);
        while (this.jj_2_10(2)) {
            this.jj_consume_token(24);
            Element arg2 = this.IntersectionSearch("Condition", true);
            arg1 = this.renameADQLElement(arg1, "Condition", null);
            Element us = this.createADQLElement(name);
            if (setXSIType) {
                ADQLParser.setXSITypeAttr(us, "unionSearchType");
            }
            us.appendChild(arg1);
            us.appendChild(arg2);
            arg1 = us;
        }
        return arg1;
    }

    public final Element Where(String name) throws ParseException {
        this.jj_consume_token(29);
        Element cond = this.Search("Condition");
        Element w = name == null ? this.createRootElement("Where") : this.createADQLElement(name);
        w.appendChild(cond);
        return w;
    }

    public final Element XMatch(String name, boolean setXSIType) throws ParseException {
        this.jj_consume_token(58);
        this.jj_consume_token(73);
        ArrayList list = this.XMatchList("Table");
        this.jj_consume_token(74);
        String c = this.Comparison();
        Element n = this.Number("Sigma", true);
        Element x = this.createADQLElement(name);
        if (setXSIType) {
            ADQLParser.setXSITypeAttr(x, "XMatchType");
        }
        for (int i = 0; i < list.size(); ++i) {
            x.appendChild((Element)list.get(i));
        }
        Text txt = this.doc.createTextNode(c);
        Element nature = this.createADQLElement("Nature");
        nature.appendChild(txt);
        x.appendChild(nature);
        x.appendChild(n);
        return x;
    }

    public final ArrayList XMatchList(String name) throws ParseException {
        ArrayList<Element> list = new ArrayList<Element>();
        Element x = this.XMatchTableAlias(name);
        list.add(x);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 87: {
                    break;
                }
                default: {
                    this.jj_la1[46] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(87);
            x = this.XMatchTableAlias(name);
            list.add(x);
        }
        return list;
    }

    /*
     * WARNING - void declaration
     */
    public final Element XMatchTableAlias(String name) throws ParseException {
        void var2_2;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 92: {
                this.jj_consume_token(92);
                Element x = this.DropTable(name, true);
                break;
            }
            case 67: {
                Element x = this.IncludeTable(name, true);
                break;
            }
            default: {
                this.jj_la1[47] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return var2_2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_6(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_6();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(5, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_7(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_7();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(6, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_8(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_8();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(7, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_9(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_9();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(8, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_10(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_10();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(9, xla);
        }
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_50() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_44() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_50()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_51()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_57() {
        return this.jj_scan_token(71);
    }

    private final boolean jj_3R_25() {
        return this.jj_3R_36();
    }

    private final boolean jj_3R_79() {
        return false;
    }

    private final boolean jj_3R_33() {
        if (this.jj_3R_26()) {
            return true;
        }
        if (this.jj_3R_63()) {
            return true;
        }
        return this.jj_3R_26();
    }

    private final boolean jj_3R_32() {
        if (this.jj_scan_token(22)) {
            return true;
        }
        return this.jj_3R_25();
    }

    private final boolean jj_3R_80() {
        if (this.jj_scan_token(78)) {
            return true;
        }
        return this.jj_3R_59();
    }

    private final boolean jj_3_6() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_31() {
        return this.jj_3R_41();
    }

    private final boolean jj_3R_30() {
        return this.jj_3R_40();
    }

    private final boolean jj_3_5() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_29() {
        return this.jj_3R_39();
    }

    private final boolean jj_3R_62() {
        return this.jj_scan_token(79);
    }

    private final boolean jj_3R_24() {
        return this.jj_3R_35();
    }

    private final boolean jj_3R_28() {
        return this.jj_3R_38();
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_34();
    }

    private final boolean jj_3R_59() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_62()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(67)) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_79()) {
            return true;
        }
        xsp = this.jj_scanpos;
        if (this.jj_3R_80()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_22() {
        return this.jj_3R_33();
    }

    private final boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_28()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_29()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_30()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_31()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_21() {
        return this.jj_3R_32();
    }

    private final boolean jj_3R_20() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_19() {
        return this.jj_3R_14();
    }

    private final boolean jj_3_9() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(75)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(78)) {
                return true;
            }
        }
        return this.jj_3R_17();
    }

    private final boolean jj_3R_13() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_19()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_20()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_21()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_22()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_23()) {
                            this.jj_scanpos = xsp;
                            if (this.jj_3R_24()) {
                                return true;
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_16() {
        Token xsp;
        if (this.jj_3R_17()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_9());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_58() {
        return this.jj_scan_token(78);
    }

    private final boolean jj_3R_52() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_58()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_3R_59();
    }

    private final boolean jj_3_4() {
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_18() {
        Token xsp;
        if (this.jj_3R_13()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_4());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_49() {
        return this.jj_3R_55();
    }

    private final boolean jj_3R_48() {
        return this.jj_3R_54();
    }

    private final boolean jj_3_8() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(89)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(90)) {
                return true;
            }
        }
        return this.jj_3R_16();
    }

    private final boolean jj_3R_47() {
        return this.jj_3R_53();
    }

    private final boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_47()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_48()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_49()) {
                    return true;
                }
            }
        }
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_26()) {
            return true;
        }
        return this.jj_scan_token(74);
    }

    private final boolean jj_3R_11() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        if (this.jj_scan_token(77)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(67)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(75)) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_1() {
        return this.jj_3R_11();
    }

    private final boolean jj_3R_76() {
        return this.jj_scan_token(67);
    }

    private final boolean jj_3R_46() {
        return this.jj_3R_52();
    }

    private final boolean jj_3R_45() {
        return this.jj_3R_11();
    }

    private final boolean jj_3R_40() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_46()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_73() {
        return this.jj_3R_76();
    }

    private final boolean jj_3R_55() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(35)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(36)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(37)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(38)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(39)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(40)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(41)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_72() {
        if (this.jj_scan_token(92)) {
            return true;
        }
        return this.jj_3R_75();
    }

    private final boolean jj_3R_68() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_72()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_73()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_54() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(30)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(31)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(32)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(33)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(34)) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_14() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_25()) {
            return true;
        }
        return this.jj_scan_token(74);
    }

    private final boolean jj_3R_69() {
        if (this.jj_scan_token(87)) {
            return true;
        }
        return this.jj_3R_68();
    }

    private final boolean jj_3R_64() {
        Token xsp;
        if (this.jj_3R_68()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_69());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_43() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(89)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(90)) {
                return true;
            }
        }
        if (this.jj_3R_16()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_8());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_53() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(42)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(43)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(44)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(45)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(46)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(48)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(47)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(49)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(52)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(53)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(54)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(55)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(56)) {
                                                            return true;
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_39() {
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_26()) {
            return true;
        }
        return this.jj_scan_token(74);
    }

    private final boolean jj_3_7() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(89)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(90)) {
                return true;
            }
        }
        return this.jj_3R_16();
    }

    private final boolean jj_3R_34() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        if (this.jj_scan_token(73)) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(71)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(72)) {
                return true;
            }
        }
        return this.jj_scan_token(74);
    }

    private final boolean jj_3R_42() {
        Token xsp;
        if (this.jj_3R_16()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_7());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_37() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_42()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_43()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3_3() {
        return this.jj_3R_12();
    }

    private final boolean jj_3R_35() {
        if (this.jj_scan_token(58)) {
            return true;
        }
        if (this.jj_scan_token(73)) {
            return true;
        }
        if (this.jj_3R_64()) {
            return true;
        }
        if (this.jj_scan_token(74)) {
            return true;
        }
        if (this.jj_3R_65()) {
            return true;
        }
        return this.jj_3R_56();
    }

    private final boolean jj_3R_26() {
        return this.jj_3R_37();
    }

    private final boolean jj_3R_27() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_15() {
        if (this.jj_3R_26()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_27()) {
            this.jj_scanpos = xsp;
        }
        if (this.jj_scan_token(10)) {
            return true;
        }
        if (this.jj_3R_26()) {
            return true;
        }
        if (this.jj_scan_token(6)) {
            return true;
        }
        return this.jj_3R_26();
    }

    private final boolean jj_3R_78() {
        return this.jj_scan_token(68);
    }

    private final boolean jj_3R_77() {
        return this.jj_scan_token(67);
    }

    private final boolean jj_3R_74() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_77()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_78()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_75() {
        return this.jj_scan_token(67);
    }

    private final boolean jj_3R_70() {
        return this.jj_3R_74();
    }

    private final boolean jj_3_10() {
        if (this.jj_scan_token(24)) {
            return true;
        }
        return this.jj_3R_18();
    }

    private final boolean jj_3R_38() {
        if (this.jj_3R_44()) {
            return true;
        }
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_70()) {
            this.jj_scanpos = xsp;
        }
        return false;
    }

    private final boolean jj_3R_36() {
        Token xsp;
        if (this.jj_3R_18()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3_10());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_65() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(80)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(81)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(82)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(83)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(84)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(85)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(86)) {
                                    return true;
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_61() {
        return this.jj_scan_token(60);
    }

    private final boolean jj_3R_71() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_67() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_71()) {
            this.jj_scanpos = xsp;
        }
        return this.jj_scan_token(21);
    }

    private final boolean jj_3R_66() {
        return this.jj_3R_65();
    }

    private final boolean jj_3R_63() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_66()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_67()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_12() {
        if (this.jj_scan_token(67)) {
            return true;
        }
        return this.jj_scan_token(76);
    }

    private final boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_60()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_61()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_60() {
        return this.jj_scan_token(59);
    }

    private final boolean jj_3_2() {
        return this.jj_scan_token(0);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{0, -1073741824, 0, -1073741824, 256, 8224, 0, 0, 0, 0x400000, 0, 0, 0, 0, 0, 0x400000, 0x600000, 0, 0, 0, 0, -1069547520, 0, 0, 4608, 0, 4608, 0, -1073741824, 0, 0, 8224, 0x8000000, 524288, 0x20000000, 65536, 131072, 0x2000000, 1, 0, 0, 0, -1073741824, 0, -1073741824, 0, 0, 0};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{32766976, 7, 1016, 0x1F3FFFF, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0x1FF3FFFF, 0x18000000, 0x18000000, 0, 0, 0, 0, 435421183, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 435421183, 0, 435421183, 0, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{0, 0, 0, 0, 0, 0, 8, 24, 24, 0, 49160, 2056, 16384, 32768, 16384, 0, 0x7F0000, 0x7F0000, 0x800000, 0x8000008, 0x800000, 100713096, 128, 0, 0, 0x800000, 0, 384, 100715144, 0x800000, 12, 0, 0, 0, 0, 0, 0, 0, 0x1000000, 0x6000000, 0x6000000, 0x6000000, 100713096, 18432, 49800, 0x8000000, 0x800000, 0x10000008};
    }

    public ADQLParser(InputStream stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ADQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ADQLParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ADQLParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public ADQLParser(ADQLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(ADQLParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 48; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[93];
        for (i = 0; i < 93; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 48; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 93; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, ADQLParserConstants.tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 10; ++i) {
            JJCalls p = this.jj_2_rtns[i];
            do {
                if (p.gen <= this.jj_gen) continue;
                this.jj_la = p.arg;
                this.jj_lastpos = this.jj_scanpos = p.first;
                switch (i) {
                    case 0: {
                        this.jj_3_1();
                        break;
                    }
                    case 1: {
                        this.jj_3_2();
                        break;
                    }
                    case 2: {
                        this.jj_3_3();
                        break;
                    }
                    case 3: {
                        this.jj_3_4();
                        break;
                    }
                    case 4: {
                        this.jj_3_5();
                        break;
                    }
                    case 5: {
                        this.jj_3_6();
                        break;
                    }
                    case 6: {
                        this.jj_3_7();
                        break;
                    }
                    case 7: {
                        this.jj_3_8();
                        break;
                    }
                    case 8: {
                        this.jj_3_9();
                        break;
                    }
                    case 9: {
                        this.jj_3_10();
                    }
                }
            } while ((p = p.next) != null);
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        ADQLParser.jj_la1_0();
        ADQLParser.jj_la1_1();
        ADQLParser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

