/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.eag.healpix;

import gov.fnal.eag.healpix.BitManipulation;
import gov.fnal.eag.healpix.HealpixException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Vector;
import javax.vecmath.Tuple3d;
import javax.vecmath.Vector3d;

public class PixTools {
    private static double twothird = 0.6666666666666666;
    private static double PI = Math.PI;
    private static double TWOPI = 2.0 * PI;
    private static double HALFPI = PI / 2.0;
    private static int ns_max = 0x100000;
    private static int xmax = 4096;
    private static int pixmax = 262144;
    private static int xmid = 512;
    private static long[] x2pix = new long[xmax + 1];
    private static long[] y2pix = new long[xmax + 1];
    private static long[] pix2x = new long[pixmax + 1];
    private static long[] pix2y = new long[pixmax + 1];
    private Vector3d pixVect = new Vector3d(0.0, 0.0, 0.0);
    private double[][] pixVertex = new double[3][4];
    private BitManipulation bm = new BitManipulation();
    static /* synthetic */ Class class$java$lang$Number;

    public PixTools() {
        int n;
        for (n = 0; n <= xmax; ++n) {
            PixTools.x2pix[n] = 0L;
            PixTools.y2pix[n] = 0L;
        }
        for (n = 0; n <= pixmax; ++n) {
            PixTools.pix2x[n] = 0L;
            PixTools.pix2y[n] = 0L;
        }
    }

    public ArrayList query_strip(long l, double d, double d2, long l2) throws Exception {
        long l3;
        ArrayList arrayList = new ArrayList();
        ArrayList arrayList2 = new ArrayList();
        double[] dArray = new double[4];
        boolean bl = false;
        String string = " QUERY_STRIP";
        long l4 = this.Nside2Npix(l);
        if (l2 == 1L) {
            bl = true;
        }
        if (l4 < 0L) {
            throw new IllegalArgumentException(string + " Nside should be power of 2");
        }
        if (d < 0.0 || d > PI || d2 < 0.0 || d2 > PI) {
            throw new IllegalArgumentException(string + " Illegal value of theta1, theta2");
        }
        if (d <= d2) {
            l3 = 1L;
            dArray[0] = d;
            dArray[1] = d2;
        } else {
            l3 = 2L;
            dArray[0] = 0.0;
            dArray[1] = d2;
            dArray[2] = d;
            dArray[3] = PI;
        }
        int n = 0;
        while ((long)n < l3) {
            long l5 = this.RingNum(l, Math.cos(dArray[2 * n]));
            long l6 = this.RingNum(l, Math.cos(dArray[2 * n + 1]));
            for (long i = l5; i <= l6; ++i) {
                double d3 = 0.0;
                double d4 = PI;
                arrayList2 = this.InRing(l, i, d3, d4, bl);
                arrayList.addAll(arrayList2);
            }
            ++n;
        }
        return arrayList;
    }

    public ArrayList query_polygon(long l, ArrayList arrayList, long l2, long l3) throws Exception {
        int n;
        int n2;
        Vector3d vector3d;
        Vector3d vector3d2;
        Vector3d vector3d3;
        int n3;
        ArrayList<Long> arrayList2 = new ArrayList<Long>();
        int n4 = arrayList.size();
        ArrayList arrayList3 = new ArrayList();
        double[] dArray = new double[n4];
        int n5 = 0;
        String string = "QUERY_POLYGON";
        for (n3 = 0; n3 < n4; ++n3) {
            dArray[n3] = 0.0;
        }
        int n6 = n4;
        if (n6 < 3) {
            throw new IllegalArgumentException(string + " Number of vertices should be >= 3");
        }
        n3 = 0;
        int n7 = 0;
        if (n6 > 3) {
            int n8;
            for (n8 = 1; n8 <= n6 - 1; ++n8) {
                n3 = (int)this.bm.MODULO(n8 - 1, n6);
                n7 = (int)this.bm.MODULO(n8 + 1, n6);
                vector3d3 = (Vector3d)arrayList.get(n3);
                vector3d2 = (Vector3d)arrayList.get(n8);
                vector3d = (Vector3d)arrayList.get(n7);
                Vector3d vector3d4 = new Vector3d(this.crossProduct(vector3d3, vector3d));
                double d = this.dotProduct(vector3d4, vector3d2);
                dArray[n8] = d >= 0.0 ? 1.0 : -1.0;
            }
            int n9 = 0;
            for (n8 = 0; n8 < n4; ++n8) {
                if (!(dArray[n8] > 0.0)) continue;
                ++n9;
            }
            int n10 = n6 - n9;
            int n11 = Math.min(n9, n10);
            if (n11 != 0) {
                if (n11 == 1) {
                    if (n9 == 1) {
                        for (n8 = 0; n8 < n4 - 1; ++n8) {
                            if (!(Math.abs(dArray[n8] - 1.0) <= 1.0E-12)) continue;
                            n5 = n8;
                            break;
                        }
                    } else {
                        for (n8 = 0; n8 < n4 - 1; ++n8) {
                            if (!(Math.abs(dArray[n8] + 1.0) <= 1.0E-12)) continue;
                            n5 = n8;
                            break;
                        }
                    }
                    n8 = arrayList.size() - n5;
                    n2 = arrayList.size() - 1;
                    for (n = 0; n < n8; ++n) {
                        Vector3d vector3d5 = new Vector3d((Vector3d)arrayList.get(n2));
                        arrayList.remove(n2);
                        arrayList.add(0, vector3d5);
                    }
                }
                if (n11 > 1) {
                    System.out.println(" The polygon has more than one concave vertex");
                    System.out.println(" The result is unpredictable");
                }
            }
        }
        long l4 = this.Nside2Npix(l);
        while (n6 >= 3) {
            vector3d3 = (Vector3d)arrayList.get(0);
            vector3d2 = (Vector3d)arrayList.get(n6 - 2);
            vector3d = (Vector3d)arrayList.get(n6 - 1);
            ArrayList arrayList4 = new ArrayList();
            arrayList4 = this.query_triangle(l, vector3d3, vector3d2, vector3d, l2, l3);
            arrayList3.addAll(arrayList4);
            --n6;
        }
        l4 = arrayList3.size();
        long[] lArray = new long[(int)l4];
        n2 = 0;
        while ((long)n2 < l4) {
            lArray[n2] = (Long)arrayList3.get(n2);
            ++n2;
        }
        Arrays.sort(lArray);
        n2 = 0;
        arrayList2.add(n2, new Long(lArray[0]));
        for (n = 1; n < lArray.length; ++n) {
            if (lArray[n] <= lArray[n - 1]) continue;
            arrayList2.add(++n2, new Long(lArray[n]));
        }
        return arrayList2;
    }

    public ArrayList query_triangle(long l, Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3, long l2, long l3) throws Exception {
        int n;
        boolean bl;
        ArrayList arrayList = new ArrayList();
        long l4 = 0L;
        Vector3d[] vector3dArray = new Vector3d[3];
        Vector3d[] vector3dArray2 = new Vector3d[3];
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        double[] dArray3 = new double[3];
        double[] dArray4 = new double[3];
        double[] dArray5 = new double[3];
        double[][] dArray6 = new double[3][2];
        double[] dArray7 = new double[4];
        double[] dArray8 = new double[4];
        double[] dArray9 = new double[4];
        double[] dArray10 = new double[6];
        boolean bl2 = false;
        boolean bl3 = false;
        String string = "QUERY_TRIANGLE";
        long l5 = l * l;
        long l6 = this.Nside2Npix(l);
        if (l6 < 0L) {
            throw new IllegalArgumentException(string + " Nside should be power of 2 >0 and < " + ns_max);
        }
        if (l3 == 1L) {
            bl2 = true;
        }
        if (l2 == 1L) {
            bl3 = true;
        }
        vector3dArray[0] = new Vector3d(vector3d);
        vector3dArray[0].normalize();
        vector3dArray[1] = new Vector3d(vector3d2);
        vector3dArray[1].normalize();
        vector3dArray[2] = new Vector3d(vector3d3);
        vector3dArray[2].normalize();
        double d = 1.0 / (3.0 * (double)l5);
        double d2 = 2.0 / (3.0 * (double)l);
        Vector3d vector3d4 = new Vector3d(0.0, 0.0, 0.0);
        vector3d4 = this.crossProduct(vector3dArray[0], vector3dArray[1]);
        double d3 = this.dotProduct(vector3d4, vector3dArray[2]);
        if (Math.abs(d3) < 1.0E-20) {
            throw new HealpixException(string + ": the triangle is degenerated - query cannot be performed");
        }
        double d4 = d3 >= 0.0 ? 1.0 : -1.0;
        dArray[0] = this.dotProduct(vector3dArray[1], vector3dArray[2]);
        dArray[1] = this.dotProduct(vector3dArray[2], vector3dArray[0]);
        dArray[2] = this.dotProduct(vector3dArray[0], vector3dArray[1]);
        vector3dArray2[0] = this.crossProduct(vector3dArray[1], vector3dArray[2]);
        vector3dArray2[1] = this.crossProduct(vector3dArray[2], vector3dArray[0]);
        vector3dArray2[2] = this.crossProduct(vector3dArray[0], vector3dArray[1]);
        vector3dArray2[0].normalize();
        vector3dArray2[1].normalize();
        vector3dArray2[2].normalize();
        double d5 = -1.0;
        double d6 = 1.0;
        boolean bl4 = vector3dArray2[0].z * d4 >= 0.0;
        boolean bl5 = vector3dArray2[1].z * d4 >= 0.0;
        boolean bl6 = bl = vector3dArray2[2].z * d4 >= 0.0;
        if (bl4 && bl5 && bl) {
            d5 = 1.0;
        }
        if (!(bl4 || bl5 || bl)) {
            d6 = -1.0;
        }
        boolean bl7 = vector3dArray[2].z - dArray[0] * vector3dArray[1].z >= 0.0;
        boolean bl8 = vector3dArray[1].z - dArray[0] * vector3dArray[2].z >= 0.0;
        boolean bl9 = vector3dArray[2].z - dArray[1] * vector3dArray[0].z >= 0.0;
        boolean bl10 = vector3dArray[0].z - dArray[1] * vector3dArray[2].z >= 0.0;
        boolean bl11 = vector3dArray[1].z - dArray[2] * vector3dArray[0].z >= 0.0;
        boolean bl12 = vector3dArray[0].z - dArray[2] * vector3dArray[1].z >= 0.0;
        for (n = 0; n < 3; ++n) {
            dArray2[n] = Math.sqrt((1.0 - vector3dArray2[n].z) * (1.0 + vector3dArray2[n].z));
        }
        double d7 = vector3dArray[1].z;
        double d8 = vector3dArray[2].z;
        double d9 = vector3dArray[2].z;
        double d10 = vector3dArray[0].z;
        double d11 = vector3dArray[0].z;
        double d12 = vector3dArray[1].z;
        d5 = Math.max(Math.max(d7, d9), Math.max(d11, d5));
        d6 = Math.min(Math.min(d8, d10), Math.min(d12, d6));
        double d13 = 0.0;
        double d14 = 0.0;
        if (bl2) {
            d13 = PI / (4.0 * (double)l);
            d14 = Math.sin(d13);
            d5 = Math.min(1.0, Math.cos(Math.acos(d5) - d13));
            d6 = Math.max(-1.0, Math.cos(Math.acos(d6) + d13));
        }
        long l7 = this.RingNum(l, d5);
        long l8 = this.RingNum(l, d6);
        for (n = 0; n < 3; ++n) {
            dArray4[n] = -1.0E30 * vector3dArray2[n].z;
            dArray3[n] = 0.0;
        }
        for (n = 0; n < 3; ++n) {
            if (!(dArray2[n] > 1.0E-10)) continue;
            dArray4[n] = -vector3dArray2[n].z / dArray2[n];
            dArray3[n] = Math.atan2(vector3dArray2[n].y, vector3dArray2[n].x);
            if (!(dArray3[n] < 0.0)) continue;
            dArray3[n] = this.bm.MODULO(Math.atan2(vector3dArray2[n].y, vector3dArray2[n].x) + TWOPI, TWOPI);
        }
        n = 0;
        for (long i = l7; i <= l8; ++i) {
            long l9;
            int n2;
            n = 0;
            double d15 = i <= l - 1L ? 1.0 - (double)(i * i) * d : (i <= 3L * l ? (2.0 * (double)l - (double)i) * d2 : -1.0 + (4.0 * (double)l - (double)i) * (4.0 * (double)l - (double)i) * d);
            double d16 = Math.sqrt((1.0 - d15) * (1.0 + d15));
            double d17 = d15 / d16;
            for (n2 = 0; n2 < 3; ++n2) {
                dArray5[n2] = dArray4[n2] * d17 - d4 * d14 / ((dArray2[n2] + 1.0E-30) * d16);
            }
            for (n2 = 0; n2 < 3; ++n2) {
                if (dArray5[n2] * d4 <= -1.0) {
                    dArray6[n2][0] = 0.0;
                    dArray6[n2][1] = TWOPI;
                    continue;
                }
                if (dArray5[n2] * d4 >= 1.0) {
                    dArray6[n2][0] = -1.000001 * (double)(n2 + 1);
                    dArray6[n2][1] = -1.0 * (double)(n2 + 1);
                    continue;
                }
                double d18 = dArray3[n2] - Math.acos(dArray5[n2]) * d4;
                double d19 = dArray3[n2] + Math.acos(dArray5[n2]) * d4;
                if (d19 < 0.0) {
                    d19 += TWOPI;
                }
                if (d18 < 0.0) {
                    d18 += TWOPI;
                }
                dArray6[n2][0] = this.bm.MODULO(d18, TWOPI);
                dArray6[n2][1] = this.bm.MODULO(d19, TWOPI);
            }
            dArray7 = this.intrs_intrv(dArray6[0], dArray6[1]);
            long l10 = dArray7.length / 2;
            if (l10 == 0L) continue;
            if (l10 == 1L) {
                dArray8 = this.intrs_intrv(dArray6[2], dArray7);
                l9 = dArray8.length / 2;
                if (l9 == 0L) {
                    n = 1;
                }
                if (n == 0) {
                    for (n2 = 0; n2 < dArray8.length; ++n2) {
                        dArray10[n2] = dArray8[n2];
                    }
                    l4 = l9;
                }
            }
            if (n == 0 && l10 == 2L) {
                double[] dArray11;
                long l11;
                double[] dArray12 = new double[]{dArray7[0], dArray7[1]};
                dArray8 = this.intrs_intrv(dArray6[2], dArray12);
                l9 = dArray8.length / 2;
                l4 = l9 + (l11 = (long)((dArray9 = this.intrs_intrv(dArray6[2], dArray11 = new double[]{dArray7[2], dArray7[3]})).length / 2));
                if (l4 == 0L) {
                    n = 1;
                }
                if (n == 0) {
                    int n3;
                    if (l9 != 0L) {
                        n3 = 0;
                        while ((long)n3 < 2L * l9) {
                            dArray10[n3] = dArray8[n3];
                            ++n3;
                        }
                    }
                    if (l11 != 0L) {
                        n3 = 0;
                        while ((long)n3 < 2L * l11) {
                            dArray10[(int)((long)n3 + 2L * l9)] = dArray9[n3];
                            ++n3;
                        }
                    }
                    if (l4 > 3L) {
                        throw new HealpixException(string + ": too many intervals found");
                    }
                }
            }
            if (n != 0) continue;
            for (long j = 0L; j < l4; ++j) {
                double d20 = dArray10[(int)(2L * j)];
                double d21 = dArray10[(int)(2L * j + 1L)];
                double d22 = (d20 + d21) / 2.0;
                double d23 = Math.abs(d21 - d20) / 2.0;
                if (d23 < 0.0) {
                    d22 += PI;
                    d23 += PI;
                }
                ArrayList arrayList2 = this.InRing(l, i, d22, d23, bl3);
                arrayList.addAll(arrayList2);
            }
        }
        return arrayList;
    }

    public double[] intrs_intrv(double[] dArray, double[] dArray2) {
        double d = 1.0E-10;
        double[] dArray3 = new double[]{0.0};
        int n = 0;
        boolean bl = dArray[0] < dArray[1] + d;
        boolean bl2 = !bl;
        boolean bl3 = dArray2[0] < dArray2[1] + d;
        boolean bl4 = !bl3;
        boolean bl5 = dArray[0] < dArray2[0] + d;
        boolean bl6 = !bl5;
        boolean bl7 = dArray[1] < dArray2[1] + d;
        boolean bl8 = !bl7;
        boolean bl9 = dArray[0] < dArray2[1] + d;
        boolean bl10 = dArray2[0] < dArray[1] + d;
        n = 0;
        double[] dArray4 = new double[]{-1.0E9, -1.0E9, -1.0E9, -1.0E9};
        if (bl3 && bl6 && bl9 || bl4 && (bl6 || bl9)) {
            dArray4[++n - 1] = dArray[0];
        }
        if (bl && bl5 && bl10 || bl2 && (bl5 || bl10)) {
            dArray4[++n - 1] = dArray2[0];
        }
        if (bl3 && bl10 && bl7 || bl4 && (bl10 || bl7)) {
            dArray4[++n - 1] = dArray[1];
        }
        if (bl && bl9 && bl8 || bl2 && (bl9 || bl8)) {
            dArray4[++n - 1] = dArray2[1];
        }
        dArray3 = new double[]{0.0};
        switch (n) {
            case 2: {
                dArray3 = new double[]{dArray4[0] - d, dArray4[1] + d};
                break;
            }
            case 4: {
                dArray3 = new double[]{dArray4[0] - d, dArray4[3] + d, dArray4[1] - d, dArray4[2] + d};
            }
        }
        double[] dArray5 = dArray3;
        return dArray5;
    }

    public ArrayList getDisc_ring(long l, Vector3d vector3d, double d) {
        int n = 0;
        int n2 = 0;
        ArrayList arrayList = this.query_disc(l, vector3d, d, n, n2);
        return arrayList;
    }

    public ArrayList query_disc(long l, Vector3d vector3d, double d, int n, int n2) {
        long l2;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        boolean bl = false;
        boolean bl2 = false;
        String string = "QUERY_DISC";
        long l3 = l * l;
        long l4 = 12L * l3;
        double d2 = this.PixRes(l);
        if (d < 0.0 || d > PI) {
            throw new IllegalArgumentException(string + ": angular radius is in RADIAN and should be in [0,pi]");
        }
        if (n2 == 1) {
            bl = true;
        }
        if (n == 1) {
            bl2 = true;
        }
        double d3 = 1.0 / (3.0 * (double)l * (double)l);
        double d4 = 2.0 / (3.0 * (double)l);
        double d5 = d;
        if (bl) {
            d5 += PI / (4.0 * (double)l);
        }
        double d6 = Math.cos(d5);
        vector3d.normalize();
        double d7 = vector3d.x;
        double d8 = vector3d.y;
        double d9 = vector3d.z;
        double d10 = 0.0;
        double d11 = 0.0;
        if (d7 != 0.0 || d8 != 0.0) {
            d10 = this.bm.MODULO(Math.atan2(d8, d7) + TWOPI, TWOPI);
        }
        double d12 = Math.cos(d10);
        double d13 = d7 * d7 + d8 * d8;
        double d14 = Math.asin(d9);
        double d15 = d14 + d5;
        double d16 = d14 - d5;
        double d17 = d15 >= HALFPI ? 1.0 : Math.sin(d15);
        long l5 = this.RingNum(l, d17);
        l5 = Math.max(1L, l5 - 1L);
        double d18 = d16 <= -HALFPI ? -1.0 : Math.sin(d16);
        long l6 = this.RingNum(l, d18);
        l6 = Math.min(4L * l - 1L, l6 + 1L);
        long l7 = -1L;
        for (long i = l5; i <= l6; ++i) {
            double d19 = i <= l - 1L ? 1.0 - (double)(i * i) * d3 : (i <= 3L * l ? (2.0 * (double)l - (double)i) * d4 : -1.0 + (4.0 * (double)l - (double)i) * (4.0 * (double)l - (double)i) * d3);
            double d20 = d6 - d19 * d9;
            double d21 = 1.0 - d19 * d19;
            double d22 = d20 / Math.sqrt(d13 * d21);
            l2 = 0L;
            if (Math.abs(d7) <= 1.0E-12 && Math.abs(d8) <= 1.0E-12) {
                d22 = -1.0;
                d11 = PI;
                l2 = 1L;
            }
            if (l2 == 0L) {
                if (Math.abs(d22) <= 1.0) {
                    d11 = Math.acos(d22);
                } else if (d12 >= d22) {
                    d11 = PI;
                } else {
                    l2 = 2L;
                }
            }
            if (l2 >= 2L) continue;
            ArrayList arrayList2 = this.InRing(l, i, d10, d11, bl2);
            arrayList.addAll(arrayList2);
        }
        l2 = 0L;
        if (arrayList.size() == 0 && d2 > Math.toDegrees(d) / 3600.0) {
            l2 = bl2 ? this.vect2pix_nest(l, vector3d) : this.vect2pix_ring(l, vector3d);
            arrayList.add(new Long(l2));
        }
        return arrayList;
    }

    public double[] pix2ang_ring(long l, long l2) {
        double d;
        double d2;
        double[] dArray = new double[]{0.0, 0.0};
        String string = "pix2ang_ring:";
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " Nside should be power of 2 >0 and < " + ns_max);
        }
        long l3 = l * l;
        long l4 = 12L * l3;
        if (l2 < 0L || l2 > l4 - 1L) {
            throw new IllegalArgumentException(string + " ipix out of range calculated from nside");
        }
        long l5 = l2 + 1L;
        long l6 = 2L * l;
        long l7 = 4L * l;
        long l8 = 2L * l * (l - 1L);
        if (l5 <= l8) {
            double d3 = (double)l5 / 2.0;
            double d4 = (long)d3;
            long l9 = (long)Math.sqrt(d3 - Math.sqrt(d4)) + 1L;
            long l10 = l5 - 2L * l9 * (l9 - 1L);
            d2 = Math.acos(1.0 - (double)(l9 * l9) / (3.0 * (double)l3));
            d = ((double)l10 - 0.5) * PI / (2.0 * (double)l9);
        } else if (l5 <= l6 * (5L * l + 1L)) {
            long l11 = l5 - l8 - 1L;
            long l12 = l11 / l7 + l;
            long l13 = (long)this.bm.MODULO(l11, l7) + 1L;
            double d5 = 0.5 * (1.0 + this.bm.MODULO(l12 + l, 2.0));
            d2 = Math.acos((double)(l6 - l12) / (1.5 * (double)l));
            d = ((double)l13 - d5) * PI / (2.0 * (double)l);
        } else {
            long l14 = l4 - l5 + 1L;
            double d6 = (double)l14 / 2.0;
            double d7 = (long)d6;
            long l15 = (long)Math.sqrt(d6 - Math.sqrt(d7)) + 1L;
            long l16 = 4L * l15 + 1L - (l14 - 2L * l15 * (l15 - 1L));
            d2 = Math.acos(-1.0 + (double)(l15 * l15) / (3.0 * (double)l3));
            d = ((double)l16 - 0.5) * PI / (2.0 * (double)l15);
        }
        dArray[0] = d2;
        dArray[1] = d;
        return dArray;
    }

    public Vector3d pix2vect_ring(long l, long l2) {
        this.makePix2Vect_ring(l, l2);
        Vector3d vector3d = new Vector3d(this.pixVect);
        return vector3d;
    }

    public double[][] pix2vertex_ring(long l, long l2) {
        this.makePix2Vect_ring(l, l2);
        double[][] dArray = this.pixVertex;
        return dArray;
    }

    private void makePix2Vect_ring(long l, long l2) {
        double d;
        double d2;
        double d3;
        double d4;
        double d5;
        long l3 = l * l;
        String string = " Pix2Vect_ring:";
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " Nside should be power of 2 >0 and < " + ns_max);
        }
        long l4 = 12L * l3;
        if (l2 < 0L || l2 > l4 - 1L) {
            throw new IllegalArgumentException(string + " ipix out of range calculated from nside");
        }
        long l5 = l2 + 1L;
        long l6 = 2L * l;
        long l7 = 4L * l;
        long l8 = 2L * l * (l - 1L);
        double d6 = 1.5 * (double)l;
        double d7 = 3.0 * (double)l3;
        double d8 = 0.0;
        double d9 = 0.0;
        if (l5 <= l8) {
            double d10 = (double)l5 / 2.0;
            double d11 = (long)d10;
            long l9 = (long)Math.sqrt(d10 - Math.sqrt(d11)) + 1L;
            long l10 = l5 - 2L * l9 * (l9 - 1L);
            d5 = 1.0 - (double)(l9 * l9) / d7;
            d4 = ((double)l10 - 0.5) * PI / (2.0 * (double)l9);
            d3 = PI / (4.0 * (double)l9);
            d2 = 1.0 - (double)((l9 - 1L) * (l9 - 1L)) / d7;
            d = 1.0 - (double)((l9 + 1L) * (l9 + 1L)) / d7;
            long l11 = (long)this.bm.MODULO(l10 - 1L, l9);
            long l12 = (l10 - 1L) / l9;
            if (l9 > 1L) {
                d8 = HALFPI * ((double)l12 + (double)l11 / ((double)l9 - 1.0));
            }
            d9 = HALFPI * ((double)l12 + ((double)l11 + 1.0) / ((double)l9 + 1.0));
        } else if (l5 <= l6 * (5L * l + 1L)) {
            long l13 = l5 - l8 - 1L;
            long l14 = l13 / l7 + l;
            long l15 = (long)this.bm.MODULO(l13, l7) + 1L;
            double d12 = 0.5 * (1.0 + this.bm.MODULO(l14 + l, 2.0));
            d5 = (double)(l6 - l14) / d6;
            d4 = ((double)l15 - d12) * PI / (2.0 * (double)l);
            d3 = PI / (4.0 * (double)l);
            d8 = d4;
            d9 = d4;
            d2 = (double)(l6 - l14 + 1L) / d6;
            d = (double)(l6 - l14 - 1L) / d6;
            if (l14 == l) {
                d2 = 1.0 - (double)((l - 1L) * (l - 1L)) / d7;
                long l16 = (long)this.bm.MODULO(l15 - 1L, l);
                long l17 = (l15 - 1L) / l;
                if (l > 1L) {
                    d8 = HALFPI * ((double)l17 + (double)l16 / ((double)l - 1.0));
                }
            } else if (l14 == 3L * l) {
                d = -1.0 + (double)((l - 1L) * (l - 1L)) / d7;
                long l18 = (long)this.bm.MODULO(l15 - 1L, l);
                long l19 = (l15 - 1L) / l;
                if (l > 1L) {
                    d9 = HALFPI * ((double)l19 + (double)l18 / ((double)l - 1.0));
                }
            }
        } else {
            long l20 = l4 - l5 + 1L;
            double d13 = (double)l20 / 2.0;
            double d14 = (long)d13;
            long l21 = (long)Math.sqrt(d13 - Math.sqrt(d14)) + 1L;
            long l22 = 4L * l21 + 1L - (l20 - 2L * l21 * (l21 - 1L));
            d5 = -1.0 + (double)(l21 * l21) / d7;
            d4 = ((double)l22 - 0.5) * PI / (2.0 * (double)l21);
            d3 = PI / (4.0 * (double)l21);
            d2 = -1.0 + (double)((l21 + 1L) * (l21 + 1L)) / d7;
            d = -1.0 + (double)((l21 - 1L) * (l21 - 1L)) / d7;
            long l23 = (long)this.bm.MODULO(l22 - 1L, l21);
            long l24 = (l22 - 1L) / l21;
            d8 = HALFPI * ((double)l24 + (double)(l23 + 1L) / ((double)l21 + 1.0));
            if (l21 > 1L) {
                d9 = HALFPI * ((double)l24 + (double)l23 / ((double)l21 - 1.0));
            }
        }
        double d15 = Math.sqrt((1.0 - d5) * (1.0 + d5));
        this.pixVect.x = d15 * Math.cos(d4);
        this.pixVect.y = d15 * Math.sin(d4);
        this.pixVect.z = d5;
        this.pixVect = new Vector3d(d15 * Math.cos(d4), d15 * Math.sin(d4), d5);
        double d16 = d4 - d3;
        this.pixVertex[0][1] = d15 * Math.cos(d16);
        this.pixVertex[1][1] = d15 * Math.sin(d16);
        this.pixVertex[2][1] = d5;
        double d17 = d4 + d3;
        this.pixVertex[0][3] = d15 * Math.cos(d17);
        this.pixVertex[1][3] = d15 * Math.sin(d17);
        this.pixVertex[2][3] = d5;
        double d18 = Math.sqrt((1.0 - d2) * (1.0 + d2));
        this.pixVertex[0][0] = d18 * Math.cos(d8);
        this.pixVertex[1][0] = d18 * Math.sin(d8);
        this.pixVertex[2][0] = d2;
        double d19 = Math.sqrt((1.0 - d) * (1.0 + d));
        this.pixVertex[0][2] = d19 * Math.cos(d9);
        this.pixVertex[1][2] = d19 * Math.sin(d9);
        this.pixVertex[2][2] = d;
    }

    public long ang2pix_ring(long l, double d, double d2) {
        long l2;
        long l3 = 0L;
        String string = "ang2pix_ring:";
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " Nside should be power of 2 >0 and < " + ns_max);
        }
        if (d < 0.0 || d > PI) {
            throw new IllegalArgumentException(string + " Theta out of range [0,pi]");
        }
        double d3 = Math.cos(d);
        double d4 = Math.abs(d3);
        if (d2 >= TWOPI) {
            d2 -= TWOPI;
        }
        if (d2 < 0.0) {
            d2 += TWOPI;
        }
        double d5 = d2 / HALFPI;
        long l4 = 2L * l;
        long l5 = 4L * l;
        long l6 = l4 * (l - 1L);
        long l7 = 12L * l * l;
        if (d4 < twothird) {
            long l8;
            long l9 = (long)((double)l * (0.5 + d5 - 0.75 * d3));
            long l10 = (long)((double)l * (0.5 + d5 + 0.75 * d3));
            long l11 = l + 1L + l9 - l10;
            long l12 = 0L;
            if ((long)this.bm.MODULO(l11, 2.0) == 0L) {
                l12 = 1L;
            }
            if ((l8 = (l9 + l10 - l + l12 + 1L) / 2L + 1L) > l5) {
                l8 -= l5;
            }
            l2 = l6 + l5 * (l11 - 1L) + l8;
        } else {
            long l13;
            double d6 = d5 - (double)((long)d5);
            double d7 = Math.sqrt(3.0 * (1.0 - d4));
            long l14 = (long)((double)l * d6 * d7);
            long l15 = l14 + (l13 = (long)((double)l * (1.0 - d6) * d7)) + 1L;
            long l16 = (long)(d5 * (double)l15) + 1L;
            if (l16 > 4L * l15) {
                l16 -= 4L * l15;
            }
            l2 = 2L * l15 * (l15 - 1L) + l16;
            if (d3 <= 0.0) {
                l2 = l7 - 2L * l15 * (l15 + 1L) + l16;
            }
        }
        l3 = l2 - 1L;
        return l3;
    }

    public long vect2pix_ring(long l, Vector3d vector3d) {
        long l2;
        long l3 = 0L;
        String string = " vect2pix_ring:";
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " Nside should be power of 2 >0 and < " + ns_max);
        }
        double d = vector3d.length();
        double d2 = vector3d.z / d;
        double d3 = 0.0;
        if (vector3d.x != 0.0 || vector3d.y != 0.0) {
            d3 = Math.atan2(vector3d.y, vector3d.x);
        }
        double d4 = Math.abs(d2);
        if (d3 < 0.0) {
            d3 += TWOPI;
        }
        double d5 = d3 / HALFPI;
        long l4 = 2L * l;
        long l5 = 4L * l;
        long l6 = l4 * (l - 1L);
        long l7 = 12L * l * l;
        if (d4 < twothird) {
            long l8 = (long)((double)l * (0.5 + d5 - 0.75 * d2));
            long l9 = (long)((double)l * (0.5 + d5 + 0.75 * d2));
            long l10 = l + 1L + l8 - l9;
            long l11 = 0L;
            if ((long)this.bm.MODULO(l10, 2.0) == 0L) {
                l11 = 1L;
            }
            long l12 = (l8 + l9 - l + l11 + 1L) / 2L + 1L;
            l2 = l6 + l5 * (l10 - 1L) + l12;
        } else {
            long l13;
            double d6 = d5 - (double)((long)d5);
            double d7 = Math.sqrt(3.0 * (1.0 - d4));
            long l14 = (long)((double)l * d6 * d7);
            long l15 = l14 + (l13 = (long)((double)l * (1.0 - d6) * d7)) + 1L;
            long l16 = (long)(d5 * (double)l15) + 1L;
            if (l16 > 4L * l15) {
                l16 -= 4L * l15;
            }
            l2 = 2L * l15 * (l15 - 1L) + l16;
            if (d2 <= 0.0) {
                l2 = l7 - 2L * l15 * (l15 + 1L) + l16;
            }
        }
        l3 = l2 - 1L;
        return l3;
    }

    public double[] pix2ang_nest(long l, long l2) {
        double[] dArray = new double[2];
        double d = 0.0;
        double d2 = 0.0;
        String string = "pix2ang_nest:";
        long[] lArray = new long[]{0L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L};
        long[] lArray2 = new long[]{0L, 1L, 3L, 5L, 7L, 0L, 2L, 4L, 6L, 1L, 3L, 5L, 7L};
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " Nside should be power of 2 >0 and < " + ns_max);
        }
        long l3 = l * l;
        long l4 = 12L * l3;
        if (l2 < 0L || l2 > l4 - 1L) {
            throw new IllegalArgumentException(string + " ipix out of range calculated from nside");
        }
        if (pix2x[xmax - 1] <= 0L) {
            this.mk_pix2xy();
        }
        double d3 = 1.0 * (double)l;
        double d4 = 1.0 / (3.0 * d3 * d3);
        double d5 = 2.0 / (3.0 * d3);
        long l5 = 4L * l;
        long l6 = l * l;
        long l7 = l2 / l6;
        long l8 = (long)this.bm.MODULO(l2, l6);
        long l9 = (long)this.bm.MODULO(l8, pixmax);
        long l10 = l8 / (long)pixmax;
        long l11 = (long)this.bm.MODULO(l10, pixmax);
        long l12 = l10 / (long)pixmax;
        long l13 = (long)pixmax * pix2x[(int)l12] + (long)xmid * pix2x[(int)l11] + pix2x[(int)l9];
        long l14 = (long)pixmax * pix2y[(int)l12] + (long)xmid * pix2y[(int)l11] + pix2y[(int)l9];
        long l15 = l13 + l14;
        long l16 = l13 - l14;
        long l17 = lArray[(int)(l7 + 1L)] * l - l15 - 1L;
        long l18 = l;
        double d6 = (double)(2L * l - l17) * d5;
        long l19 = (long)this.bm.MODULO(l17 - l, 2.0);
        if (l17 < l) {
            l18 = l17;
            d6 = 1.0 - (double)(l18 * l18) * d4;
            l19 = 0L;
        } else if (l17 > 3L * l) {
            l18 = l5 - l17;
            d6 = -1.0 + (double)(l18 * l18) * d4;
            l19 = 0L;
        }
        d = Math.acos(d6);
        long l20 = (lArray2[(int)(l7 + 1L)] * l18 + l16 + 1L + l19) / 2L;
        if (l20 > l5) {
            l20 -= l5;
        }
        if (l20 < 1L) {
            l20 += l5;
        }
        d2 = ((double)l20 - (double)(l19 + 1L) * 0.5) * (HALFPI / (double)l18);
        dArray[0] = d;
        dArray[1] = d2;
        return dArray;
    }

    public Vector3d pix2vect_nest(long l, long l2) {
        this.makePix2Vect_Nest(l, l2);
        Vector3d vector3d = new Vector3d(this.pixVect);
        return vector3d;
    }

    public double[][] pix2vertex_nest(long l, long l2) {
        double[][] dArray = new double[3][4];
        this.makePix2Vect_Nest(l, l2);
        for (int i = 0; i < 3; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray[i][j] = this.pixVertex[i][j];
            }
        }
        return dArray;
    }

    private void makePix2Vect_Nest(long l, long l2) {
        int[] nArray = new int[]{0, 2, 2, 2, 2, 3, 3, 3, 3, 4, 4, 4, 4};
        int[] nArray2 = new int[]{0, 1, 3, 5, 7, 0, 2, 4, 6, 1, 3, 5, 7};
        String string = "Pix2Vect_Nest:";
        double d = 0.0;
        double d2 = 0.0;
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " Nside should be power of 2 >0 and < " + ns_max);
        }
        long l3 = l * l;
        long l4 = 12L * l3;
        if (l2 < 0L || l2 > l4 - 1L) {
            throw new IllegalArgumentException(string + " ipix out of range calculated from nside");
        }
        if (pix2x[pixmax - 1] <= 0L) {
            this.mk_pix2xy();
        }
        double d3 = l;
        double d4 = 1.0 / (3.0 * d3 * d3);
        double d5 = 2.0 / (3.0 * d3);
        long l5 = 4L * l;
        long l6 = l3;
        long l7 = l2 / l6;
        long l8 = (long)this.bm.MODULO(l2, l6);
        long l9 = (long)this.bm.MODULO(l8, pixmax);
        long l10 = l8 / (long)pixmax;
        long l11 = (long)this.bm.MODULO(l10, pixmax);
        long l12 = l10 / (long)pixmax;
        long l13 = (long)pixmax * pix2x[(int)l12] + (long)xmid * pix2x[(int)l11] + pix2x[(int)l9];
        long l14 = (long)pixmax * pix2y[(int)l12] + (long)xmid * pix2y[(int)l11] + pix2y[(int)l9];
        long l15 = l13 + l14;
        long l16 = l13 - l14;
        long l17 = (long)nArray[(int)(l7 + 1L)] * l - l15 - 1L;
        long l18 = l;
        double d6 = (2.0 * (double)l - (double)l17) * d5;
        long l19 = (long)this.bm.MODULO(l17 - l, 2.0);
        d = (2.0 * (double)l - (double)l17 + 1.0) * d5;
        d2 = (2.0 * (double)l - (double)l17 - 1.0) * d5;
        if (l17 == l) {
            d = 1.0 - ((double)l - 1.0) * ((double)l - 1.0) * d4;
        } else if (l17 == 3L * l) {
            d2 = -1.0 + ((double)l - 1.0) * ((double)l - 1.0) * d4;
        }
        if (l17 < l) {
            l18 = l17;
            d6 = 1.0 - (double)(l18 * l18) * d4;
            l19 = 0L;
            d = 1.0 - (double)((l18 - 1L) * (l18 - 1L)) * d4;
            d2 = 1.0 - (double)((l18 + 1L) * (l18 + 1L)) * d4;
        } else if (l17 > 3L * l) {
            l18 = l5 - l17;
            d6 = -1.0 + (double)(l18 * l18) * d4;
            l19 = 0L;
            d = -1.0 + (double)((l18 + 1L) * (l18 + 1L)) * d4;
            d2 = -1.0 + (double)((l18 - 1L) * (l18 - 1L)) * d4;
        }
        long l20 = ((long)nArray2[(int)(l7 + 1L)] * l18 + l16 + 1L + l19) / 2L;
        if (l20 > l5) {
            l20 -= l5;
        }
        if (l20 < 1L) {
            l20 += l5;
        }
        double d7 = ((double)l20 - (double)(l19 + 1L) / 2.0) * (HALFPI / (double)l18);
        double d8 = Math.sqrt((1.0 - d6) * (1.0 + d6));
        this.pixVect.x = d8 * Math.cos(d7);
        this.pixVect.y = d8 * Math.sin(d7);
        this.pixVect.z = d6;
        double d9 = d7;
        double d10 = d7;
        double d11 = 0.0;
        long l21 = (long)this.bm.MODULO(l20 - 1L, l18);
        long l22 = (l20 - 1L) / l18;
        if (l18 > 1L) {
            d11 = HALFPI * ((double)l22 + (double)l21 / ((double)l18 - 1.0));
        }
        double d12 = HALFPI * ((double)l22 + (double)(l21 + 1L) / ((double)l18 + 1.0));
        if (l17 < l) {
            d9 = d11;
            d10 = d12;
        } else if (l17 > 3L * l) {
            d9 = d12;
            d10 = d11;
        } else if (l17 == l) {
            d9 = d11;
        } else if (l17 == 3L * l) {
            d10 = d11;
        }
        double d13 = PI / (4.0 * (double)l18);
        double d14 = d7 - d13;
        this.pixVertex[0][1] = d8 * Math.cos(d14);
        this.pixVertex[1][1] = d8 * Math.sin(d14);
        this.pixVertex[2][1] = d6;
        double d15 = d7 + d13;
        this.pixVertex[0][3] = d8 * Math.cos(d15);
        this.pixVertex[1][3] = d8 * Math.sin(d15);
        this.pixVertex[2][3] = d6;
        double d16 = Math.sqrt((1.0 - d) * (1.0 + d));
        this.pixVertex[0][0] = d16 * Math.cos(d9);
        this.pixVertex[1][0] = d16 * Math.sin(d9);
        this.pixVertex[2][0] = d;
        double d17 = Math.sqrt((1.0 - d2) * (1.0 + d2));
        this.pixVertex[0][2] = d17 * Math.cos(d10);
        this.pixVertex[1][2] = d17 * Math.sin(d10);
        this.pixVertex[2][2] = d2;
    }

    public long ang2pix_nest(long l, double d, double d2) {
        long l2;
        long l3;
        long l4;
        long l5 = 0L;
        String string = "ang2pix_nest:";
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " Nside should be power of 2 >0 and < " + ns_max);
        }
        if (d < 0.0 || d > PI) {
            throw new IllegalArgumentException(string + " theta is out of range [0.,PI]");
        }
        if (x2pix[xmax - 1] <= 0L) {
            this.mk_xy2pix();
        }
        double d3 = Math.cos(d);
        double d4 = Math.abs(d3);
        if (d2 < 0.0) {
            d2 += TWOPI;
        }
        if (d2 >= TWOPI) {
            d2 -= TWOPI;
        }
        double d5 = this.bm.MODULO(d2, TWOPI) / HALFPI;
        if (d4 <= twothird) {
            long l6 = (long)((double)ns_max * (0.5 + d5 - d3 * 0.75));
            long l7 = l6 / (long)ns_max;
            long l8 = (long)((double)ns_max * (0.5 + d5 + d3 * 0.75));
            long l9 = l8 / (long)ns_max;
            l4 = l7 == l9 ? (long)this.bm.MODULO(l7, 4.0) + 4L : (l7 < l9 ? (long)this.bm.MODULO(l7, 4.0) : (long)this.bm.MODULO(l9, 4.0) + 8L);
            l3 = (long)this.bm.MODULO(l8, ns_max);
            l2 = (long)ns_max - (long)this.bm.MODULO(l6, ns_max) - 1L;
        } else {
            long l10 = (long)d5;
            if (l10 >= 4L) {
                l10 = 3L;
            }
            double d6 = d5 - (double)l10;
            double d7 = Math.sqrt(3.0 * (1.0 - d4));
            long l11 = (long)((double)ns_max * d6 * d7);
            long l12 = (long)((double)ns_max * (1.0 - d6) * d7);
            l11 = Math.min((long)(ns_max - 1), l11);
            l12 = Math.min((long)(ns_max - 1), l12);
            if (d3 >= 0.0) {
                l4 = l10;
                l3 = (long)ns_max - l12 - 1L;
                l2 = (long)ns_max - l11 - 1L;
            } else {
                l4 = l10 + 8L;
                l3 = l11;
                l2 = l12;
            }
        }
        long l13 = (long)this.bm.MODULO(l3, xmax);
        long l14 = l3 / (long)xmax;
        long l15 = (long)this.bm.MODULO(l2, xmax);
        long l16 = l2 / (long)xmax;
        long l17 = (x2pix[(int)(l14 + 1L)] + y2pix[(int)(l16 + 1L)]) * (long)(xmax * xmax) + (x2pix[(int)(l13 + 1L)] + y2pix[(int)(l15 + 1L)]);
        l5 = (l17 /= (long)ns_max / l * ((long)ns_max / l)) + l4 * l * l;
        return l5;
    }

    public Object[] convert_nest2ring(long l, Object[] objectArray) {
        long l2 = 12L * l * l;
        Object[] objectArray2 = new Object[(int)l2];
        for (long i = 0L; i < l2; ++i) {
            int n = (int)this.nest2ring(l, i);
            objectArray2[n] = objectArray[(int)i];
        }
        return objectArray2;
    }

    public Object[] convert_ring2nest(long l, Object[] objectArray) {
        long l2 = 12L * l * l;
        Object[] objectArray2 = new Object[(int)l2];
        for (long i = 0L; i < l2; ++i) {
            long l3 = this.ring2nest(l, i);
            objectArray2[(int)l3] = objectArray[(int)i];
        }
        return objectArray2;
    }

    public Object[] convert_inplace_long(String string, Object[] objectArray) {
        String string2 = "convert_in_place:";
        long l = objectArray.length;
        long l2 = (long)Math.sqrt((double)l / 12.0);
        if (l2 > (long)ns_max) {
            throw new IllegalArgumentException(string2 + " Map is too big");
        }
        boolean[] blArray = new boolean[(int)l];
        int n = 0;
        while ((long)n < l) {
            blArray[n] = false;
            ++n;
        }
        long l3 = 0L;
        n = 0;
        while ((long)n < l) {
            Object object = objectArray[(int)l3];
            long l4 = l3;
            long l5 = string.equalsIgnoreCase("ring2nest") ? this.ring2nest(l2, l4) : this.nest2ring(l2, l4);
            while (!blArray[(int)l5]) {
                Object object2 = objectArray[(int)l5];
                objectArray[(int)l5] = object;
                object = object2;
                l4 = l5;
                if (string.equalsIgnoreCase("ring2nest")) {
                    l5 = this.ring2nest(l2, l4);
                    continue;
                }
                l5 = this.nest2ring(l2, l4);
            }
            while (!blArray[(int)l3] || l3 >= l - 1L) {
                ++l3;
            }
            ++n;
        }
        Object[] objectArray2 = objectArray;
        return objectArray2;
    }

    public ArrayList neighbours_nest(long l, long l2) {
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l3 = 0L;
        long[] lArray = new long[2];
        long[] lArray2 = new long[2];
        String string = "neighbours_nest:";
        arrayList.add(0, new Long(0L));
        arrayList.add(1, new Long(0L));
        arrayList.add(2, new Long(0L));
        arrayList.add(3, new Long(0L));
        arrayList.add(4, new Long(0L));
        arrayList.add(5, new Long(0L));
        arrayList.add(6, new Long(0L));
        arrayList.add(7, new Long(0L));
        int n = 0;
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " Nside should be power of 2 >0 and < " + ns_max);
        }
        long l4 = l * l;
        long l5 = 12L * l4;
        if (l2 < 0L || l2 > l5 - 1L) {
            throw new IllegalArgumentException(string + " ipix out of range ");
        }
        if (x2pix[xmax - 1] <= 0L) {
            this.mk_xy2pix();
        }
        long l6 = (l4 - 1L) / 3L;
        long l7 = 2L * l6;
        long l8 = l2 / l4;
        long l9 = (long)this.bm.MODULO(l2, l4);
        lArray = this.pix2xy_nest(l, l9);
        long l10 = lArray[0];
        long l11 = lArray[1];
        long l12 = lArray[0] - 1L;
        long l13 = lArray[0] + 1L;
        long l14 = lArray[1] - 1L;
        long l15 = lArray[1] + 1L;
        n = 0;
        if (l9 == l7 && n == 0) {
            n = 5;
        }
        if (l9 == l4 - 1L && n == 0) {
            n = 6;
        }
        if (l9 == 0L && n == 0) {
            n = 7;
        }
        if (l9 == l6 && n == 0) {
            n = 8;
        }
        if ((l9 & l6) == l6 && n == 0) {
            n = 1;
        }
        if ((l9 & l6) == 0L && n == 0) {
            n = 2;
        }
        if ((l9 & l7) == l7 && n == 0) {
            n = 3;
        }
        if ((l9 & l7) == 0L && n == 0) {
            n = 4;
        }
        if (n == 0) {
            arrayList.add(0, new Long(this.xy2pix_nest(l, l12, l14, l8)));
            arrayList.add(1, new Long(this.xy2pix_nest(l, l12, l11, l8)));
            arrayList.add(2, new Long(this.xy2pix_nest(l, l12, l15, l8)));
            arrayList.add(3, new Long(this.xy2pix_nest(l, l10, l15, l8)));
            arrayList.add(4, new Long(this.xy2pix_nest(l, l13, l15, l8)));
            arrayList.add(5, new Long(this.xy2pix_nest(l, l13, l11, l8)));
            arrayList.add(6, new Long(this.xy2pix_nest(l, l13, l14, l8)));
            arrayList.add(7, new Long(this.xy2pix_nest(l, l10, l14, l8)));
        }
        long l16 = l8 / 4L;
        long l17 = (long)this.bm.MODULO(l8, 4.0);
        long l18 = (long)this.bm.MODULO(l17 + 1L, 4.0);
        long l19 = (long)this.bm.MODULO(l17 + 4L - 1L, 4.0);
        long l20 = (long)this.bm.MODULO(l17 + 2L, 4.0);
        if (l16 == 0L) {
            switch (n) {
                case 1: {
                    long l21 = 0L + l18;
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l12, l14, l8)));
                    arrayList.set(1, new Long(this.xy2pix_nest(l, l12, l11, l8)));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l12, l15, l8)));
                    arrayList.set(3, new Long(this.xy2pix_nest(l, l10, l15, l8)));
                    arrayList.set(7, new Long(this.xy2pix_nest(l, l10, l14, l8)));
                    long l22 = (long)this.bm.MODULO(this.bm.swapLSBMSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l22);
                    long l23 = lArray2[0];
                    long l24 = lArray2[1];
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l23 + 1L, l24, l21)));
                    arrayList.set(5, new Long(l21 * l4 + l22));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l23 - 1L, l24, l21)));
                    break;
                }
                case 2: {
                    long l25 = 4L + l17;
                    long l26 = (long)this.bm.MODULO(this.bm.invLSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l26);
                    long l27 = lArray2[0];
                    long l28 = lArray2[1];
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l27, l28 - 1L, l25)));
                    arrayList.set(1, new Long(l25 * l4 + l26));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l27, l28 + 1L, l25)));
                    arrayList.set(3, new Long(this.xy2pix_nest(l, l10, l15, l8)));
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l13, l15, l8)));
                    arrayList.set(5, new Long(this.xy2pix_nest(l, l13, l11, l8)));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l13, l14, l8)));
                    arrayList.set(7, new Long(this.xy2pix_nest(l, l10, l14, l8)));
                    break;
                }
                case 3: {
                    long l29 = 0L + l19;
                    long l30 = (long)this.bm.MODULO(this.bm.swapLSBMSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l30);
                    long l31 = lArray2[0];
                    long l32 = lArray2[1];
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l12, l14, l8)));
                    arrayList.set(1, new Long(this.xy2pix_nest(l, l12, l11, l8)));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l31, l32 - 1L, l29)));
                    arrayList.set(3, new Long(l29 * l4 + l30));
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l31, l32 + 1L, l29)));
                    arrayList.set(5, new Long(this.xy2pix_nest(l, l13, l11, l8)));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l13, l14, l8)));
                    arrayList.set(7, new Long(this.xy2pix_nest(l, l10, l14, l8)));
                    break;
                }
                case 4: {
                    long l33 = 4L + l18;
                    long l34 = (long)this.bm.MODULO(this.bm.invMSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l34);
                    long l35 = lArray2[0];
                    long l36 = lArray2[1];
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l35 - 1L, l36, l33)));
                    arrayList.set(1, new Long(this.xy2pix_nest(l, l12, l11, l8)));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l12, l15, l8)));
                    arrayList.set(3, new Long(this.xy2pix_nest(l, l10, l15, l8)));
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l13, l15, l8)));
                    arrayList.set(5, new Long(this.xy2pix_nest(l, l13, l11, l8)));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l35 + 1L, l36, l33)));
                    arrayList.set(7, new Long(l33 * l4 + l34));
                    break;
                }
                case 5: {
                    long l37 = 4L + l17;
                    l3 = l37 * l4 + l4 - 1L;
                    arrayList.set(0, new Long(l3 - 2L));
                    arrayList.set(1, new Long(l3));
                    l37 = 0L + l19;
                    l3 = l37 * l4 + l6;
                    arrayList.set(2, new Long(l3));
                    arrayList.set(3, new Long(l3 + 2L));
                    arrayList.set(4, new Long(l2 + 1L));
                    arrayList.set(5, new Long(l2 - 1L));
                    arrayList.set(6, new Long(l2 - 2L));
                    arrayList.remove(7);
                    break;
                }
                case 6: {
                    long l38 = 0L + l19;
                    arrayList.set(0, new Long(l2 - 3L));
                    arrayList.set(1, new Long(l2 - 1L));
                    l3 = l38 * l4 + l4 - 1L;
                    arrayList.set(2, new Long(l3 - 2L));
                    arrayList.set(3, new Long(l3));
                    l38 = 0L + l20;
                    arrayList.set(4, new Long(l38 * l4 + l4 - 1L));
                    l38 = 0L + l18;
                    l3 = l38 * l4 + l4 - 1L;
                    arrayList.set(5, new Long(l3));
                    arrayList.set(6, new Long(l3 - 1L));
                    arrayList.set(7, new Long(l2 - 2L));
                    break;
                }
                case 7: {
                    long l39 = 8L + l17;
                    arrayList.set(0, new Long(l39 * l4 + l4 - 1L));
                    l39 = 4L + l17;
                    l3 = l39 * l4 + l6;
                    arrayList.set(1, new Long(l3));
                    arrayList.set(2, new Long(l3 + 2L));
                    arrayList.set(3, new Long(l2 + 2L));
                    arrayList.set(4, new Long(l2 + 3L));
                    arrayList.set(5, new Long(l2 + 1L));
                    l39 = 4L + l18;
                    l3 = l39 * l4 + l7;
                    arrayList.set(6, new Long(l3 + 1L));
                    arrayList.set(7, new Long(l3));
                    break;
                }
                case 8: {
                    long l40 = 0L + l18;
                    arrayList.set(1, new Long(l2 - 1L));
                    arrayList.set(2, new Long(l2 + 1L));
                    arrayList.set(3, new Long(l2 + 2L));
                    l3 = l40 * l4 + l7;
                    arrayList.set(4, new Long(l3 + 1L));
                    arrayList.set(5, new Long(l3));
                    l40 = 4L + l18;
                    l3 = l40 * l4 + l4 - 1L;
                    arrayList.set(0, new Long(l3 - 1L));
                    arrayList.set(6, new Long(l3));
                    arrayList.remove(7);
                }
            }
        } else if (l16 == 1L) {
            switch (n) {
                case 1: {
                    long l41 = 0L + l18;
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l12, l14, l8)));
                    arrayList.set(1, new Long(this.xy2pix_nest(l, l12, l11, l8)));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l12, l15, l8)));
                    arrayList.set(3, new Long(this.xy2pix_nest(l, l10, l15, l8)));
                    arrayList.set(7, new Long(this.xy2pix_nest(l, l10, l14, l8)));
                    long l42 = (long)this.bm.MODULO(this.bm.invLSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l42);
                    long l43 = lArray2[0];
                    long l44 = lArray2[1];
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l43, l44 + 1L, l41)));
                    arrayList.set(5, new Long(l41 * l4 + l42));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l43, l44 - 1L, l41)));
                    break;
                }
                case 2: {
                    long l45 = 8L + l19;
                    long l46 = (long)this.bm.MODULO(this.bm.invLSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l46);
                    long l47 = lArray2[0];
                    long l48 = lArray2[1];
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l47, l48 - 1L, l45)));
                    arrayList.set(1, new Long(l45 * l4 + l46));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l47, l48 + 1L, l45)));
                    arrayList.set(3, new Long(this.xy2pix_nest(l, l10, l15, l8)));
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l13, l15, l8)));
                    arrayList.set(5, new Long(this.xy2pix_nest(l, l13, l11, l8)));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l13, l14, l8)));
                    arrayList.set(7, new Long(this.xy2pix_nest(l, l10, l14, l8)));
                    break;
                }
                case 3: {
                    long l49 = 0L + l19;
                    long l50 = (long)this.bm.MODULO(this.bm.invMSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l50);
                    long l51 = lArray2[0];
                    long l52 = lArray2[1];
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l51 - 1L, l52, l49)));
                    arrayList.set(3, new Long(l49 * l4 + l50));
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l51 + 1L, l52, l49)));
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l12, l14, l8)));
                    arrayList.set(1, new Long(this.xy2pix_nest(l, l12, l11, l8)));
                    arrayList.set(5, new Long(this.xy2pix_nest(l, l13, l11, l8)));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l13, l14, l8)));
                    arrayList.set(7, new Long(this.xy2pix_nest(l, l10, l14, l8)));
                    break;
                }
                case 4: {
                    long l53 = 8L + l17;
                    long l54 = (long)this.bm.MODULO(this.bm.invMSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l54);
                    long l55 = lArray2[0];
                    long l56 = lArray2[1];
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l55 - 1L, l56, l53)));
                    arrayList.set(1, new Long(this.xy2pix_nest(l, l12, l11, l8)));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l12, l15, l8)));
                    arrayList.set(3, new Long(this.xy2pix_nest(l, l10, l15, l8)));
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l13, l15, l8)));
                    arrayList.set(5, new Long(this.xy2pix_nest(l, l13, l11, l8)));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l55 + 1L, l56, l53)));
                    arrayList.set(7, new Long(l53 * l4 + l54));
                    break;
                }
                case 5: {
                    long l57 = 8L + l19;
                    l3 = l57 * l4 + l4 - 1L;
                    arrayList.set(0, new Long(l3 - 2L));
                    arrayList.set(1, new Long(l3));
                    l57 = 4L + l19;
                    arrayList.set(2, new Long(l57 * l4 + l6));
                    l57 = 0L + l19;
                    l3 = l57 * l4;
                    arrayList.set(3, new Long(l3));
                    arrayList.set(4, new Long(l3 + 1L));
                    arrayList.set(5, new Long(l2 + 1L));
                    arrayList.set(6, new Long(l2 - 1L));
                    arrayList.set(7, new Long(l2 - 2L));
                    break;
                }
                case 6: {
                    long l58 = 0L + l19;
                    arrayList.set(0, new Long(l2 - 3L));
                    arrayList.set(1, new Long(l2 - 1L));
                    l3 = l58 * l4 + l6;
                    arrayList.set(2, new Long(l3 - 1L));
                    arrayList.set(3, new Long(l3));
                    l58 = 0L + l17;
                    l3 = l58 * l4 + l7;
                    arrayList.set(4, new Long(l3));
                    arrayList.set(5, new Long(l3 - 2L));
                    arrayList.set(6, new Long(l2 - 2L));
                    arrayList.remove(7);
                    break;
                }
                case 7: {
                    long l59 = 8L + l19;
                    l3 = l59 * l4 + l6;
                    arrayList.set(0, new Long(l3));
                    arrayList.set(1, new Long(l3 + 2L));
                    arrayList.set(2, new Long(l2 + 2L));
                    arrayList.set(3, new Long(l2 + 3L));
                    arrayList.set(4, new Long(l2 + 1L));
                    l59 = 8L + l17;
                    l3 = l59 * l4 + l7;
                    arrayList.set(5, new Long(l3 + 1L));
                    arrayList.set(6, new Long(l3));
                    arrayList.remove(7);
                    break;
                }
                case 8: {
                    long l60 = 8L + l17;
                    l3 = l60 * l4 + l4 - 1L;
                    arrayList.set(0, new Long(l3 - 1L));
                    arrayList.set(1, new Long(l2 - 1L));
                    arrayList.set(2, new Long(l2 + 1L));
                    arrayList.set(3, new Long(l2 + 2L));
                    arrayList.set(7, new Long(l3));
                    l60 = 0L + l17;
                    l3 = l60 * l4;
                    arrayList.set(4, new Long(l3 + 2L));
                    arrayList.set(5, new Long(l3));
                    l60 = 4L + l18;
                    arrayList.set(6, new Long(l60 * l4 + l7));
                }
            }
        } else {
            switch (n) {
                case 1: {
                    long l61 = 4L + l18;
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l12, l14, l8)));
                    arrayList.set(1, new Long(this.xy2pix_nest(l, l12, l11, l8)));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l12, l15, l8)));
                    arrayList.set(3, new Long(this.xy2pix_nest(l, l10, l15, l8)));
                    arrayList.set(7, new Long(this.xy2pix_nest(l, l10, l14, l8)));
                    long l62 = (long)this.bm.MODULO(this.bm.invLSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l62);
                    long l63 = lArray2[0];
                    long l64 = lArray2[1];
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l63, l64 + 1L, l61)));
                    arrayList.set(5, new Long(l61 * l4 + l62));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l63, l64 - 1L, l61)));
                    break;
                }
                case 2: {
                    long l65 = 8L + l19;
                    long l66 = (long)this.bm.MODULO(this.bm.swapLSBMSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l66);
                    long l67 = lArray2[0];
                    long l68 = lArray2[1];
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l67 - 1L, l68, l65)));
                    arrayList.set(1, new Long(l65 * l4 + l66));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l67 + 1L, l68, l65)));
                    arrayList.set(3, new Long(this.xy2pix_nest(l, l10, l15, l8)));
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l13, l15, l8)));
                    arrayList.set(5, new Long(this.xy2pix_nest(l, l13, l11, l8)));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l13, l14, l8)));
                    arrayList.set(7, new Long(this.xy2pix_nest(l, l10, l14, l8)));
                    break;
                }
                case 3: {
                    long l69 = 4L + l17;
                    long l70 = (long)this.bm.MODULO(this.bm.invMSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l70);
                    long l71 = lArray2[0];
                    long l72 = lArray2[1];
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l12, l14, l8)));
                    arrayList.set(1, new Long(this.xy2pix_nest(l, l12, l11, l8)));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l71 - 1L, l72, l69)));
                    arrayList.set(3, new Long(l69 * l4 + l70));
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l71 + 1L, l72, l69)));
                    arrayList.set(5, new Long(this.xy2pix_nest(l, l13, l11, l8)));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l13, l14, l8)));
                    arrayList.set(7, new Long(this.xy2pix_nest(l, l10, l14, l8)));
                    break;
                }
                case 4: {
                    long l73 = 8L + l18;
                    long l74 = (long)this.bm.MODULO(this.bm.swapLSBMSB(l9), l4);
                    lArray2 = this.pix2xy_nest(l, l74);
                    long l75 = lArray2[0];
                    long l76 = lArray2[1];
                    arrayList.set(0, new Long(this.xy2pix_nest(l, l75, l76 - 1L, l73)));
                    arrayList.set(1, new Long(this.xy2pix_nest(l, l12, l11, l8)));
                    arrayList.set(2, new Long(this.xy2pix_nest(l, l12, l15, l8)));
                    arrayList.set(3, new Long(this.xy2pix_nest(l, l10, l15, l8)));
                    arrayList.set(4, new Long(this.xy2pix_nest(l, l13, l15, l8)));
                    arrayList.set(5, new Long(this.xy2pix_nest(l, l13, l11, l8)));
                    arrayList.set(6, new Long(this.xy2pix_nest(l, l75, l76 + 1L, l73)));
                    arrayList.set(7, new Long(l73 * l4 + l74));
                    break;
                }
                case 5: {
                    long l77 = 8L + l19;
                    l3 = l77 * l4 + l6;
                    arrayList.set(0, new Long(l3 - 2L));
                    arrayList.set(1, new Long(l3));
                    l77 = 4L + l17;
                    arrayList.set(2, new Long(l77 * l4));
                    arrayList.set(3, new Long(l77 * l4 + 1L));
                    arrayList.set(4, new Long(l2 + 1L));
                    arrayList.set(5, new Long(l2 - 1L));
                    arrayList.set(6, new Long(l2 - 2L));
                    arrayList.remove(7);
                    break;
                }
                case 6: {
                    long l78 = 4L + l17;
                    arrayList.set(0, new Long(l2 - 3L));
                    arrayList.set(1, new Long(l2 - 1L));
                    l3 = l78 * l4 + l6;
                    arrayList.set(2, new Long(l3 - 1L));
                    arrayList.set(3, new Long(l3));
                    l78 = 0L + l17;
                    arrayList.set(4, new Long(l78 * l4));
                    l78 = 4L + l18;
                    l3 = l78 * l4 + l7;
                    arrayList.set(5, new Long(l3));
                    arrayList.set(6, new Long(l3 - 2L));
                    arrayList.set(7, new Long(l2 - 2L));
                    break;
                }
                case 7: {
                    long l79 = 8L + l20;
                    arrayList.set(0, new Long(l79 * l4));
                    l79 = 8L + l19;
                    l3 = l79 * l4;
                    arrayList.set(1, new Long(l3));
                    arrayList.set(2, new Long(l3 + 1L));
                    arrayList.set(3, new Long(l2 + 2L));
                    arrayList.set(4, new Long(l2 + 3L));
                    arrayList.set(5, new Long(l2 + 1L));
                    l79 = 8L + l18;
                    l3 = l79 * l4;
                    arrayList.set(6, new Long(l3 + 2L));
                    arrayList.set(7, new Long(l3));
                    break;
                }
                case 8: {
                    long l80 = 8L + l18;
                    arrayList.set(1, new Long(l2 - 1L));
                    arrayList.set(2, new Long(l2 + 1L));
                    arrayList.set(3, new Long(l2 + 2L));
                    l3 = l80 * l4 + l7;
                    arrayList.set(6, new Long(l3));
                    arrayList.set(0, new Long(l3 - 2L));
                    l80 = 4L + l18;
                    l3 = l80 * l4;
                    arrayList.set(4, new Long(l3 + 2L));
                    arrayList.set(5, new Long(l3));
                    arrayList.remove(7);
                }
            }
        }
        return arrayList;
    }

    public ArrayList InRing(long l, long l2, double d, double d2, boolean bl) {
        long l3;
        long l4;
        long l5;
        long l6;
        boolean bl2 = false;
        boolean bl3 = false;
        boolean bl4 = true;
        boolean bl5 = false;
        double d3 = Double.MIN_VALUE;
        if (bl) {
            bl4 = false;
        }
        double d4 = 0.0;
        long l7 = 0L;
        long l8 = 0L;
        long l9 = 0L;
        ArrayList<Long> arrayList = new ArrayList<Long>();
        long l10 = 12L * l * l;
        long l11 = 2L * l * (l - 1L);
        double d5 = this.bm.MODULO(d - d2, TWOPI) - d3;
        double d6 = this.bm.MODULO(d + d2, TWOPI) + d3;
        if (Math.abs(d2 - PI) < d3) {
            bl2 = true;
        }
        if (l2 >= l && l2 <= 3L * l) {
            l7 = l2 - l + 1L;
            l6 = l11 + 4L * l * (l7 - 1L);
            l5 = l6 + 4L * l - 1L;
            l4 = (long)this.bm.MODULO(l7, 2.0);
            l3 = l * 4L;
        } else {
            if (l2 < l) {
                l7 = l2;
                l6 = 2L * l7 * (l7 - 1L);
                l5 = l6 + 4L * l7 - 1L;
            } else {
                l7 = 4L * l - l2;
                l6 = l10 - 2L * l7 * (l7 + 1L);
                l5 = l6 + 4L * l7 - 1L;
            }
            l3 = l7 * 4L;
            l4 = 1L;
        }
        if (bl2) {
            long l12 = l5 - l6 + 1L;
            if (bl4) {
                long l13 = 0L;
                for (long i = l6; i <= l5; ++i) {
                    arrayList.add((int)l13, new Long(i));
                    ++l13;
                }
            } else {
                boolean bl6 = false;
                int n = 0;
                while ((long)n < l12) {
                    long l14 = this.ring2nest(l, l6 + (long)n);
                    arrayList.add(n, new Long(l14));
                    ++n;
                }
            }
            return arrayList;
        }
        d4 = (double)l4 / 2.0;
        if (bl5) {
            l8 = Math.round((double)l3 * d5 / TWOPI - d4);
            l9 = Math.round((double)l3 * d6 / TWOPI - d4);
            l8 = (long)this.bm.MODULO(l8, l3);
            l9 = (long)this.bm.MODULO(l9, l3);
        } else {
            l8 = (long)Math.ceil((double)l3 * d5 / TWOPI - d4);
            if (l8 == (l9 = (long)Math.floor((double)l3 * d6 / TWOPI - d4)) + 1L) {
                l8 = l9;
            }
            if (l8 - l9 == 1L && d2 * (double)l3 < PI) {
                System.out.println("the interval is too small and avay from center");
                return arrayList;
            }
            l8 = Math.min(l8, l3 - 1L);
            l9 = Math.max(l9, 0L);
        }
        if (l8 > l9) {
            bl3 = true;
        }
        if (bl3) {
            long l15 = l5 - (l8 += l6) + 1L;
            long l16 = (l9 += l6) + 1L;
            long l17 = l15 + l16;
            if (bl4) {
                long l18;
                int n = 0;
                for (l18 = l8; l18 <= l5; ++l18) {
                    arrayList.add(n, new Long(l18));
                    ++n;
                }
                for (l18 = l6; l18 <= l9; ++l18) {
                    arrayList.add(n, new Long(l18));
                    ++n;
                }
            } else {
                long l19;
                long l20;
                int n = 0;
                for (l20 = l8; l20 <= l5; ++l20) {
                    l19 = this.ring2nest(l, l20);
                    arrayList.add(n, new Long(l19));
                    ++n;
                }
                for (l20 = l6; l20 <= l9; ++l20) {
                    l19 = this.ring2nest(l, l20);
                    arrayList.add(n, new Long(l19));
                    ++n;
                }
            }
        } else {
            long l21 = l9 - l8 + 1L;
            if (l8 < 0L) {
                long l22 = l8 = Math.abs(l8);
                long l23 = l9 + 1L;
                l21 = l22 + l23;
                if (bl4) {
                    long l24;
                    int n = 0;
                    for (l24 = 0L; l24 < l8; ++l24) {
                        arrayList.add(n, new Long(l5 - l24));
                        ++n;
                    }
                    for (l24 = 0L; l24 <= l9; ++l24) {
                        arrayList.add(n, new Long(l6 + l24));
                        ++n;
                    }
                } else {
                    long l25;
                    int n = 0;
                    int n2 = 0;
                    while ((long)n2 < l8) {
                        l25 = this.ring2nest(l, l5 - (long)n2);
                        arrayList.add(n, new Long(l25));
                        ++n;
                        ++n2;
                    }
                    for (long i = 0L; i <= l9; ++i) {
                        l25 = this.ring2nest(l, l6 + i);
                        arrayList.add(n, new Long(l25));
                        ++n;
                    }
                }
                return arrayList;
            }
            l8 += l6;
            l9 += l6;
            if (bl4) {
                int n = 0;
                for (long i = l8; i <= l9; ++i) {
                    arrayList.add(n, new Long(i));
                    ++n;
                }
            } else {
                int n = 0;
                for (long i = l8; i <= l9; ++i) {
                    long l26 = this.ring2nest(l, i);
                    arrayList.add(n, new Long(l26));
                    ++n;
                }
            }
        }
        return arrayList;
    }

    public long next_in_line_nest(long l, long l2) {
        long[] lArray = new long[2];
        long l3 = 0L;
        String string = "next_in_line:";
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " nside should be power of 2 >0 and < " + ns_max);
        }
        long l4 = l * l;
        long l5 = 12L * l4;
        if (l2 < 0L || l2 > l5 - 1L) {
            throw new IllegalArgumentException(string + " ipix out of range defined by nside");
        }
        if (x2pix[xmax - 1] <= 0L) {
            this.mk_xy2pix();
        }
        long l6 = (l4 - 1L) / 3L;
        long l7 = 2L * l6;
        long l8 = l2 / l4;
        long l9 = (long)this.bm.MODULO(l2, l4);
        lArray = this.pix2xy_nest(l, l9);
        long l10 = lArray[0];
        long l11 = lArray[1];
        long l12 = l10 + 1L;
        long l13 = l11 - 1L;
        boolean bl = false;
        int n = -1;
        if (l9 == l7) {
            l3 = l2 - 1L;
            return l3;
        }
        if (l9 == l4 - 1L && !bl) {
            n = 6;
            bl = true;
        }
        if (l9 == 0L && !bl) {
            n = 7;
            bl = true;
        }
        if (l9 == l6 && !bl) {
            n = 8;
            bl = true;
        }
        if ((l9 & l6) == l6 && !bl) {
            n = 1;
            bl = true;
        }
        if ((l9 & l7) == 0L && !bl) {
            n = 4;
            bl = true;
        }
        if (!bl) {
            l3 = this.xy2pix_nest(l, l12, l13, l8);
            return l3;
        }
        long l14 = l8 / 4L;
        long l15 = (long)this.bm.MODULO(l8, 4.0);
        long l16 = (long)this.bm.MODULO(l15 + 1L, 4.0);
        long l17 = (long)this.bm.MODULO(l15 + 4L - 1L, 4.0);
        long l18 = (long)this.bm.MODULO(l15 + 2L, 4.0);
        if (l14 == 0L) {
            switch (n) {
                case 1: {
                    long l19 = 0L + l16;
                    long l20 = (long)this.bm.MODULO(this.bm.swapLSBMSB(l9), l4);
                    l3 = l19 * l4 + l20;
                    break;
                }
                case 4: {
                    long l21 = 4L + l16;
                    long l22 = (long)this.bm.MODULO(this.bm.invMSB(l9), l4);
                    lArray = this.pix2xy_nest(l, l22);
                    long l23 = lArray[0];
                    long l24 = lArray[1];
                    l3 = this.xy2pix_nest(l, l23 + 1L, l24, l21);
                    break;
                }
                case 6: {
                    long l25 = 0L + l16;
                    l3 = l25 * l4 + l4 - 1L;
                    break;
                }
                case 7: {
                    long l26 = 4L + l16;
                    l3 = l26 * l4 + l7 + 1L;
                    break;
                }
                case 8: {
                    long l27 = 0L + l16;
                    l3 = l27 * l4 + l7;
                }
            }
        } else if (l14 == 1L) {
            switch (n) {
                case 1: {
                    long l28 = 0L + l15;
                    long l29 = (long)this.bm.MODULO(this.bm.invLSB(l9), l4);
                    lArray = this.pix2xy_nest(l, l29);
                    long l30 = lArray[0];
                    long l31 = lArray[1];
                    l3 = this.xy2pix_nest(l, l30, l31 - 1L, l28);
                    break;
                }
                case 4: {
                    long l32 = 8L + l15;
                    long l33 = (long)this.bm.MODULO(this.bm.invMSB(l9), l4);
                    lArray = this.pix2xy_nest(l, l33);
                    l3 = this.xy2pix_nest(l, lArray[0] + 1L, lArray[1], l32);
                    break;
                }
                case 6: {
                    long l34 = 0L + l15;
                    l3 = l34 * l4 + l7 - 2L;
                    break;
                }
                case 7: {
                    long l35 = 8L + l15;
                    l3 = l35 * l4 + l7 + 1L;
                    break;
                }
                case 8: {
                    long l36 = 4L + l16;
                    l3 = l36 * l4 + l7;
                }
            }
        } else {
            switch (n) {
                case 1: {
                    long l37 = 4L + l16;
                    long l38 = (long)this.bm.MODULO(this.bm.invLSB(l9), l4);
                    lArray = this.pix2xy_nest(l, l38);
                    l3 = this.xy2pix_nest(l, lArray[0], lArray[1] - 1L, l37);
                    break;
                }
                case 4: {
                    long l39 = 8L + l16;
                    long l40 = (long)this.bm.MODULO(this.bm.swapLSBMSB(l9), l4);
                    l3 = l39 * l4 + l40;
                    break;
                }
                case 6: {
                    long l41 = 4L + l16;
                    l3 = l41 * l4 + l7 - 2L;
                    break;
                }
                case 7: {
                    long l42 = 8L + l16;
                    l3 = l42 * l4;
                    break;
                }
                case 8: {
                    long l43 = 8L + l16;
                    l3 = l43 * l4 + l7;
                }
            }
        }
        return l3;
    }

    public long vect2pix_nest(long l, Vector3d vector3d) {
        long l2;
        long l3;
        long l4;
        long l5 = 0L;
        String string = " vect2pix_nest:";
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " nside should be power of 2 >0 and < ns_max");
        }
        if (x2pix[xmax - 1] <= 0L) {
            this.mk_xy2pix();
        }
        double d = vector3d.length();
        double d2 = vector3d.z / d;
        double d3 = 0.0;
        if (vector3d.x != 0.0 || vector3d.y != 0.0) {
            d3 = Math.atan2(vector3d.y, vector3d.x);
        }
        double d4 = Math.abs(d2);
        if (d3 < 0.0) {
            d3 += TWOPI;
        }
        double d5 = 2.0 * d3 / PI;
        if (d4 <= twothird) {
            long l6 = (long)((double)ns_max * (0.5 + d5 - d2 * 0.75));
            long l7 = l6 / (long)ns_max;
            long l8 = (long)((double)ns_max * (0.5 + d5 + d2 * 0.75));
            long l9 = l8 / (long)ns_max;
            l4 = l7 == l9 ? (long)this.bm.MODULO(l7, 4.0) + 4L : (l7 < l9 ? (long)this.bm.MODULO(l7, 4.0) : (long)this.bm.MODULO(l9, 4.0) + 8L);
            l3 = (long)this.bm.MODULO(l8, ns_max);
            l2 = (long)ns_max - (long)this.bm.MODULO(l6, ns_max) - 1L;
        } else {
            long l10 = (long)d5;
            if (l10 >= 4L) {
                l10 = 3L;
            }
            double d6 = d5 - (double)l10;
            double d7 = Math.sqrt(3.0 * (1.0 - d4));
            long l11 = (long)((double)ns_max * d6 * d7);
            long l12 = (long)((double)ns_max * (1.0 - d6) * d7);
            l11 = Math.min((long)(ns_max - 1), l11);
            l12 = Math.min((long)(ns_max - 1), l12);
            if (d2 >= 0.0) {
                l4 = l10;
                l3 = (long)ns_max - l12 - 1L;
                l2 = (long)ns_max - l11 - 1L;
            } else {
                l4 = l10 + 8L;
                l3 = l11;
                l2 = l12;
            }
        }
        long l13 = (long)this.bm.MODULO(l3, xmax);
        long l14 = l3 / (long)xmax;
        long l15 = (long)this.bm.MODULO(l2, xmax);
        long l16 = l2 / (long)xmax;
        long l17 = (x2pix[(int)(l14 + 1L)] + y2pix[(int)(l16 + 1L)]) * (long)(xmax * xmax) + (x2pix[(int)(l13 + 1L)] + y2pix[(int)(l15 + 1L)]);
        l5 = (l17 /= (long)ns_max / l * ((long)ns_max / l)) + l4 * l * l;
        return l5;
    }

    private long xy2pix_nest(long l, long l2, long l3, long l4) {
        long l5 = 0L;
        String string = "xy2pix_nest:";
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " nside should be power of 2 >0 and < " + ns_max);
        }
        if (x2pix[xmax - 1] <= 0L) {
            this.mk_xy2pix();
        }
        long l6 = (long)this.bm.MODULO(l2, xmax);
        long l7 = l2 / (long)xmax;
        long l8 = (long)this.bm.MODULO(l3, xmax);
        long l9 = l3 / (long)xmax;
        long l10 = (x2pix[(int)(l7 + 1L)] + y2pix[(int)(l9 + 1L)]) * (long)xmax * (long)xmax + (x2pix[(int)(l6 + 1L)] + y2pix[(int)(l8 + 1L)]);
        l5 = l10 + l4 * l * l;
        return l5;
    }

    private long[] pix2xy_nest(long l, long l2) {
        long[] lArray = new long[]{0L, 0L};
        String string = "pix2xy_nest:";
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " nside should be power of 2 >0 and < " + ns_max);
        }
        if (l2 < 0L || l2 > l * l - 1L) {
            throw new IllegalArgumentException(string + " ipix out of range defined by nside");
        }
        if (pix2x[pixmax] <= 0L) {
            this.mk_pix2xy();
        }
        long l3 = (long)this.bm.MODULO(l2, pixmax);
        long l4 = l2 / (long)pixmax;
        long l5 = (long)this.bm.MODULO(l4, pixmax);
        long l6 = l4 / (long)pixmax;
        long l7 = (long)pixmax * pix2x[(int)l6] + (long)xmid * pix2x[(int)l5] + pix2x[(int)l3];
        long l8 = (long)pixmax * pix2y[(int)l6] + (long)xmid * pix2y[(int)l5] + pix2y[(int)l3];
        lArray[0] = l7;
        lArray[1] = l8;
        return lArray;
    }

    private void mk_pix2xy() {
        boolean bl = true;
        for (long i = 0L; i <= (long)pixmax; ++i) {
            long l = i;
            long l2 = 0L;
            long l3 = 0L;
            long l4 = 1L;
            while (l != 0L) {
                long l5 = (long)this.bm.MODULO(l, 2.0);
                l2 += l5 * l4;
                l5 = (long)this.bm.MODULO(l /= 2L, 2.0);
                l /= 2L;
                l3 += l5 * l4;
                l4 *= 2L;
            }
            PixTools.pix2x[(int)i] = l2;
            PixTools.pix2y[(int)i] = l3;
        }
    }

    public long ring2nest(long l, long l2) {
        long l3;
        long l4;
        long l5;
        long l6;
        long l7 = 0L;
        long[] lArray = new long[]{0L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L};
        long[] lArray2 = new long[]{0L, 1L, 3L, 5L, 7L, 0L, 2L, 4L, 6L, 1L, 3L, 5L, 7L};
        String string = "ring2nest:";
        long l8 = 0L;
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " nside should be power of 2 >0 and < " + ns_max);
        }
        long l9 = 12L * l * l;
        if (l2 < 0L || l2 > l9 - 1L) {
            throw new IllegalArgumentException(string + " ipring out of range [0,npix-1]");
        }
        if (x2pix[xmax - 1] <= 0L) {
            this.mk_xy2pix();
        }
        long l10 = 2L * l;
        long l11 = 4L * l;
        long l12 = l2 + 1L;
        long l13 = l10 * (l - 1L);
        if (l12 <= l13) {
            double d = (double)l12 / 2.0;
            double d2 = Math.floor(d);
            l6 = (long)Math.floor(Math.sqrt(d - Math.sqrt(d2))) + 1L;
            l5 = l12 - 2L * l6 * (l6 - 1L);
            l4 = 0L;
            l3 = l6;
            l8 = (l5 - 1L) / l6;
        } else if (l12 <= l10 * (5L * l + 1L)) {
            long l14 = l12 - l13 - 1L;
            l6 = (long)Math.floor(l14 / l11) + l;
            l5 = (long)this.bm.MODULO(l14, l11) + 1L;
            l4 = (long)this.bm.MODULO(l6 + l, 2.0);
            l3 = l;
            long l15 = l6 - l + 1L;
            long l16 = l10 + 2L - l15;
            long l17 = (l5 - l16 / 2L + l - 1L) / l;
            long l18 = (l5 - l15 / 2L + l - 1L) / l;
            if (l17 == l18) {
                l8 = (long)this.bm.MODULO(l17, 4.0) + 4L;
            } else if (l17 + 1L == l18) {
                l8 = l17;
            } else if (l17 - 1L == l18) {
                l8 = l17 + 7L;
            }
        } else {
            long l19 = l9 - l12 + 1L;
            double d = (double)l19 / 2.0;
            double d3 = Math.floor(d);
            long l20 = (long)Math.floor(Math.sqrt(d - Math.sqrt(d3))) + 1L;
            l5 = 4L * l20 + 1L - (l19 - 2L * l20 * (l20 - 1L));
            l4 = 0L;
            l3 = l20;
            l6 = l11 - l20;
            l8 = (l5 - 1L) / l20 + 8L;
        }
        long l21 = l6 - lArray[(int)(l8 + 1L)] * l + 1L;
        long l22 = 2L * l5 - lArray2[(int)(l8 + 1L)] * l3 - l4 - 1L;
        if (l22 >= l10) {
            l22 -= 8L * l;
        }
        long l23 = (l22 - l21) / 2L;
        long l24 = -(l22 + l21) / 2L;
        long l25 = (long)this.bm.MODULO(l23, xmax);
        long l26 = l23 / (long)xmax;
        long l27 = (long)this.bm.MODULO(l24, xmax);
        long l28 = l24 / (long)xmax;
        long l29 = (x2pix[(int)(l26 + 1L)] + y2pix[(int)(l28 + 1L)]) * (long)xmax * (long)xmax + (x2pix[(int)(l25 + 1L)] + y2pix[(int)(l27 + 1L)]);
        l7 = l29 + l8 * l * l;
        return l7;
    }

    public long nest2ring(long l, long l2) {
        long l3;
        long l4;
        long l5 = 0L;
        long[] lArray = new long[]{0L, 2L, 2L, 2L, 2L, 3L, 3L, 3L, 3L, 4L, 4L, 4L, 4L};
        long[] lArray2 = new long[]{0L, 1L, 3L, 5L, 7L, 0L, 2L, 4L, 6L, 1L, 3L, 5L, 7L};
        String string = "nest2ring:";
        if (l < 1L || l > (long)ns_max) {
            throw new IllegalArgumentException(string + " nside should be power of 2 >0 and < ns_max");
        }
        long l6 = 12L * l * l;
        if (l2 < 0L || l2 > l6 - 1L) {
            throw new IllegalArgumentException(string + " ipnest out of range [0,npix-1]");
        }
        if (pix2x[pixmax - 1] <= 0L) {
            this.mk_pix2xy();
        }
        long l7 = 2L * l * (l - 1L);
        long l8 = 4L * l;
        long l9 = l * l;
        long l10 = l2 / l9;
        long l11 = l2 >= l9 ? (long)this.bm.MODULO(l2, l9) : l2;
        long l12 = (long)this.bm.MODULO(l11, pixmax);
        if (l12 < 0L) {
            l12 = -l12;
        }
        if ((l4 = (long)this.bm.MODULO(l3 = l11 / (long)pixmax, pixmax)) < 0L) {
            l4 = -l4;
        }
        long l13 = l3 / (long)pixmax;
        long l14 = (long)pixmax * pix2x[(int)l13] + (long)xmid * pix2x[(int)l4] + pix2x[(int)l12];
        long l15 = (long)pixmax * pix2y[(int)l13] + (long)xmid * pix2y[(int)l4] + pix2y[(int)l12];
        long l16 = l14 + l15;
        long l17 = l14 - l15;
        long l18 = lArray[(int)(l10 + 1L)] * l - l16 - 1L;
        long l19 = l;
        long l20 = l7 + l8 * (l18 - l);
        long l21 = (long)this.bm.MODULO(l18 - l, 2.0);
        if (l18 < l) {
            l19 = l18;
            l20 = 2L * l19 * (l19 - 1L);
            l21 = 0L;
        } else if (l18 > 3L * l) {
            l19 = l8 - l18;
            l20 = l6 - 2L * (l19 + 1L) * l19;
            l21 = 0L;
        }
        long l22 = (lArray2[(int)(l10 + 1L)] * l19 + l17 + 1L + l21) / 2L;
        if (l22 > l8) {
            l22 -= l8;
        }
        if (l22 < 1L) {
            l22 += l8;
        }
        l5 = l20 + l22 - 1L;
        return l5;
    }

    private void mk_xy2pix() {
        for (int i = 1; i <= xmax; ++i) {
            long l = i - 1;
            long l2 = 0L;
            long l3 = 1L;
            while (l != 0L) {
                long l4 = (long)this.bm.MODULO(l, 2.0);
                l /= 2L;
                l2 += l3 * l4;
                l3 *= 4L;
            }
            PixTools.x2pix[i] = l2;
            PixTools.y2pix[i] = 2L * l2;
        }
    }

    public long RingNum(long l, double d) {
        long l2 = 0L;
        l2 = Math.round((double)l * (2.0 - 1.5 * d));
        if (d > twothird && (l2 = Math.round((double)l * Math.sqrt(3.0 * (1.0 - d)))) == 0L) {
            l2 = 1L;
        }
        if (d < -twothird) {
            l2 = Math.round((double)l * Math.sqrt(3.0 * (1.0 + d)));
            if (l2 == 0L) {
                l2 = 1L;
            }
            l2 = 4L * l - l2;
        }
        return l2;
    }

    public Vector3d Ang2Vec(double d, double d2) {
        double d3 = Math.PI;
        String string = "Ang2Vec:";
        if (d < 0.0 || d > d3) {
            throw new IllegalArgumentException(string + " theta out of range [0.,PI]");
        }
        double d4 = Math.sin(d);
        double d5 = d4 * Math.cos(d2);
        double d6 = d4 * Math.sin(d2);
        double d7 = Math.cos(d);
        Vector3d vector3d = new Vector3d(d5, d6, d7);
        return vector3d;
    }

    public double[] Vect2Ang(Vector3d vector3d) {
        double[] dArray = new double[2];
        double d = vector3d.length();
        double d2 = vector3d.z / d;
        double d3 = Math.acos(d2);
        double d4 = 0.0;
        if (vector3d.x != 0.0 || vector3d.y != 0.0) {
            d4 = Math.atan2(vector3d.y, vector3d.x);
        }
        if (d4 < 0.0) {
            d4 += Math.PI * 2;
        }
        dArray[0] = d3;
        dArray[1] = d4;
        return dArray;
    }

    public long Npix2Nside(long l) {
        double d;
        long l2 = 0L;
        long l3 = 12L * (long)ns_max * (long)ns_max;
        String string = "Npix2Nside:";
        l2 = (long)Math.rint(Math.sqrt(l / 12L));
        if (l < 12L) {
            throw new IllegalArgumentException(string + " npix is too small should be > 12");
        }
        if (l > l3) {
            throw new IllegalArgumentException(string + " npix is too large > 12 * ns_max^2");
        }
        double d2 = 12.0 * (double)l2 * (double)l2;
        if (Math.abs(d2 - (double)l) > 0.01) {
            throw new IllegalArgumentException(string + "  npix is not 12*nside*nside");
        }
        double d3 = Math.log(l2) / Math.log(2.0);
        if (Math.abs(d3 - (d = Math.rint(d3))) > 1.0E-6) {
            throw new IllegalArgumentException(string + "  nside is not power of 2");
        }
        return l2;
    }

    public long Nside2Npix(long l) {
        long[] lArray = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L, 0x200000L, 0x400000L};
        long l2 = 0L;
        String string = "Nside2Npix:";
        if (Arrays.binarySearch(lArray, l) < 0) {
            throw new IllegalArgumentException(string + " nside should be >0, power of 2, <" + ns_max);
        }
        l2 = 12L * l * l;
        return l2;
    }

    public double SurfaceTriangle(Vector3d vector3d, Vector3d vector3d2, Vector3d vector3d3) throws Exception {
        double d = 0.0;
        double d2 = this.AngDist(vector3d2, vector3d3) / 4.0;
        double d3 = this.AngDist(vector3d3, vector3d) / 4.0;
        double d4 = this.AngDist(vector3d, vector3d2) / 4.0;
        double d5 = Math.tan(d2 + d3 + d4);
        double d6 = Math.tan(d3 + d4 - d2);
        double d7 = Math.tan(d2 + d4 - d3);
        double d8 = Math.tan(d2 + d3 - d4);
        d = 4.0 * Math.atan(Math.sqrt(d5 * d6 * d7 * d8));
        return d;
    }

    public double AngDist(Vector3d vector3d, Vector3d vector3d2) throws Exception {
        double d = 0.0;
        double d2 = 0.999;
        Vector3d vector3d3 = vector3d;
        Vector3d vector3d4 = vector3d2;
        vector3d3.normalize();
        vector3d4.normalize();
        double d3 = vector3d3.dot(vector3d4);
        if (d3 > d2) {
            vector3d3.sub((Tuple3d)vector3d4);
            double d4 = vector3d3.length();
            d = 2.0 * Math.asin(d4 / 2.0);
        } else if (d3 < -d2) {
            vector3d3.add((Tuple3d)vector3d4);
            double d5 = vector3d3.length();
            d = Math.PI - 2.0 * Math.asin(d5 / 2.0);
        } else {
            d = vector3d3.angle(vector3d4);
        }
        return d;
    }

    public Vector VectProd(Vector vector, Vector vector2) throws Exception {
        Vector<Double> vector3 = new Vector<Double>();
        double[] dArray = new double[3];
        double[] dArray2 = new double[3];
        for (int i = 0; i < 3; ++i) {
            if (!vector.get(i).getClass().isInstance(class$java$lang$Number == null ? PixTools.class$("java.lang.Number") : class$java$lang$Number)) {
                throw new Exception();
            }
            dArray[i] = ((Number)vector.get(i)).doubleValue();
            if (!vector2.get(i).getClass().isInstance(class$java$lang$Number == null ? PixTools.class$("java.lang.Number") : class$java$lang$Number)) {
                throw new Exception();
            }
            dArray2[i] = ((Number)vector2.get(i)).doubleValue();
        }
        Double d = new Double(dArray[1] * dArray2[2] - dArray[2] * dArray2[1]);
        vector3.add(d);
        d = new Double(dArray[1] * dArray2[2] - dArray[2] * dArray2[1]);
        vector3.add(d);
        d = new Double(dArray[1] * dArray2[2] - dArray[2] * dArray2[1]);
        vector3.add(d);
        return vector3;
    }

    public double dotProduct(Vector3d vector3d, Vector3d vector3d2) throws Exception {
        double d = vector3d.x * vector3d2.x + vector3d.y * vector3d2.y + vector3d.z * vector3d2.z;
        return d;
    }

    public Vector3d crossProduct(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d(0.0, 0.0, 0.0);
        double d = vector3d.y * vector3d2.z - vector3d.z * vector3d2.y;
        double d2 = vector3d.z * vector3d2.x - vector3d.x * vector3d2.z;
        double d3 = vector3d.x * vector3d2.y - vector3d.y * vector3d2.x;
        vector3d3.x = d;
        vector3d3.y = d2;
        vector3d3.z = d3;
        return vector3d3;
    }

    public double PixRes(long l) {
        double d = 0.0;
        double d2 = Math.toDegrees(1.0);
        double d3 = 4.0 * PI * d2 * d2;
        double d4 = d3 * 3600.0 * 3600.0;
        long l2 = 12L * l * l;
        d = d4 / (double)l2;
        d = Math.sqrt(d);
        return d;
    }

    public long GetNSide(double d) {
        long[] lArray = new long[]{1L, 2L, 4L, 8L, 16L, 32L, 64L, 128L, 256L, 512L, 1024L, 2048L, 4096L, 8192L, 16384L, 32768L, 65536L, 131072L, 262144L, 524288L, 0x100000L};
        long l = 0L;
        double d2 = d * d;
        double d3 = Math.toDegrees(1.0);
        double d4 = 4.0 * PI * d3 * d3 * 3600.0 * 3600.0;
        long l2 = (long)(d4 / d2);
        long l3 = l2 / 12L;
        long l4 = (long)Math.sqrt(l3);
        long l5 = ns_max;
        int n = 0;
        for (int i = 0; i < lArray.length; ++i) {
            if (Math.abs(l4 - lArray[i]) <= l5) {
                l5 = Math.abs(l4 - lArray[i]);
                l = lArray[i];
                n = i;
            }
            if (l4 > l && l4 < (long)ns_max) {
                l = lArray[n + 1];
            }
            if (l4 <= (long)ns_max) continue;
            System.out.println("nside cannot be bigger than " + ns_max);
            return ns_max;
        }
        return l;
    }

    public double[] RaDecToPolar(double[] dArray) {
        double[] dArray2 = new double[]{0.0, 0.0};
        double d = dArray[0];
        double d2 = dArray[1];
        double d3 = PI / 2.0 - Math.toRadians(d2);
        double d4 = Math.toRadians(d);
        dArray2[0] = d3;
        dArray2[1] = d4;
        return dArray2;
    }

    public double[] PolarToRaDec(double[] dArray) {
        double d;
        double[] dArray2 = new double[]{0.0, 0.0};
        double d2 = dArray[1];
        double d3 = dArray[0];
        double d4 = Math.toDegrees(PI / 2.0 - d3);
        dArray2[0] = d = Math.toDegrees(d2);
        dArray2[1] = d4;
        return dArray2;
    }

    public double[] xyzToPolar(double d, double d2, double d3) {
        Vector3d vector3d = new Vector3d(d, d2, d3);
        double[] dArray = this.Vect2Ang(vector3d);
        return dArray;
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

