/*
 * Decompiled with CFR 0.152.
 */
package gov.fnal.eag.healpix;

import gov.fnal.eag.healpix.BitManipulation;
import gov.fnal.eag.healpix.PixTools;
import java.util.ArrayList;
import javax.vecmath.Vector3d;

public class Region {
    private static final double TWOPI = Math.PI * 2;
    private double raMin;
    private double raMax;
    private double decMin;
    private double decMax;
    private double tetMin;
    private double tetMax;
    private double phiMin;
    private double phiMax;
    private static final double epsilon = 1.0E-10;
    private ArrayList vertices;
    private double PI = Math.PI;
    private BitManipulation bm = new BitManipulation();

    public Region(double d, double d2, double d3, double d4) {
        this.raMin = d;
        this.raMax = d2;
        this.phiMin = Math.toRadians(this.raMin);
        this.phiMax = Math.toRadians(this.raMax);
        if (this.phiMin < 0.0) {
            this.phiMin += Math.PI * 2;
        }
        if (this.phiMax < 0.0) {
            this.phiMax += Math.PI * 2;
        }
        if (this.phiMax < this.phiMin) {
            this.phiMax += Math.PI * 2;
        }
        this.phiMin = this.bm.MODULO(this.phiMin, Math.PI * 2) - 1.0E-10;
        this.phiMax = this.bm.MODULO(this.phiMax, Math.PI * 2) + 1.0E-10;
        this.raMin = Math.toDegrees(this.phiMin);
        this.raMax = Math.toDegrees(this.phiMax);
        this.decMin = d3;
        this.decMax = d4;
        this.tetMax = this.PI / 2.0 - Math.toRadians(this.decMin);
        this.tetMin = this.PI / 2.0 - Math.toRadians(this.decMax);
        this.vertices = new ArrayList();
        PixTools pixTools = new PixTools();
        Vector3d vector3d = pixTools.Ang2Vec(this.tetMin, this.phiMin);
        this.vertices.add(vector3d);
        vector3d = pixTools.Ang2Vec(this.tetMin, this.phiMax);
        this.vertices.add(vector3d);
        vector3d = pixTools.Ang2Vec(this.tetMax, this.phiMin);
        this.vertices.add(vector3d);
        vector3d = pixTools.Ang2Vec(this.tetMax, this.phiMax);
        this.vertices.add(vector3d);
    }

    public boolean inReg(double d, double d2) {
        boolean bl = false;
        double d3 = d;
        double d4 = Math.toRadians(d);
        if (d4 < 0.0) {
            d4 += Math.PI * 2;
        }
        d4 = this.bm.MODULO(d4, Math.PI * 2) - 1.0E-10;
        d3 = Math.toDegrees(d4);
        if (d4 >= this.phiMin - 1.0E-10 && d4 <= this.phiMax + 1.0E-10 && d2 >= this.decMin - 1.0E-10 && d2 <= this.decMax + 1.0E-10) {
            bl = true;
        }
        return bl;
    }

    public boolean inRegPol(double d, double d2) {
        boolean bl = false;
        double d3 = d;
        if (d3 < 0.0) {
            d3 += Math.PI * 2;
        }
        if ((d3 = this.bm.MODULO(this.phiMin, Math.PI * 2) - 1.0E-10) >= this.phiMin - 1.0E-10 && d3 <= this.phiMax + 1.0E-10 && d2 >= this.tetMin - 1.0E-10 && d2 <= this.tetMax + 1.0E-10) {
            bl = true;
        }
        return bl;
    }

    public ArrayList getVertices() {
        return this.vertices;
    }

    public ArrayList pixelize(double d) throws Exception {
        ArrayList arrayList = new ArrayList();
        PixTools pixTools = new PixTools();
        long l = pixTools.GetNSide(d);
        long l2 = pixTools.RingNum(l, Math.cos(this.tetMin));
        long l3 = pixTools.RingNum(l, Math.cos(this.tetMax));
        for (long i = l2; i < l3; ++i) {
            ArrayList arrayList2 = new ArrayList();
            double d2 = (this.phiMin + this.phiMax) / 2.0;
            double d3 = (this.phiMax - this.phiMin) / 2.0;
            arrayList2 = pixTools.InRing(l, i, d2, d3, false);
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public double[][] getPolReg() {
        double[][] dArray = new double[4][2];
        dArray[0][1] = this.phiMin;
        dArray[0][0] = this.tetMin;
        dArray[1][1] = this.phiMax;
        dArray[1][0] = this.tetMin;
        dArray[2][1] = this.phiMin;
        dArray[2][0] = this.tetMax;
        dArray[3][1] = this.phiMax;
        dArray[3][0] = this.tetMax;
        return dArray;
    }
}

