/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.Component;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.MethodWindow;
import uk.ac.starlink.topcat.QueryWindow;
import uk.ac.starlink.topcat.RowSubset;
import uk.ac.starlink.topcat.SyntheticRowSubset;
import uk.ac.starlink.topcat.TopcatModel;

public abstract class AbstractSubsetQueryWindow
extends QueryWindow {
    private final TopcatModel tcModel_;
    private final JComboBox nameSelector_;
    private final JTextField exprField_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AbstractSubsetQueryWindow(TopcatModel tcModel, Component parent, String title) {
        super(title, parent);
        this.tcModel_ = tcModel;
        this.nameSelector_ = tcModel.createNewSubsetNameSelector();
        this.exprField_ = new JTextField();
        this.getToolBar().add(MethodWindow.getWindowAction(this, false));
        this.getToolBar().addSeparator();
        this.addHelp("SyntheticSubsetQueryWindow");
    }

    public JComponent getNameField() {
        return this.nameSelector_;
    }

    public void setSelectedName(String name) {
        for (int i = 0; i < this.nameSelector_.getItemCount(); ++i) {
            Object item = this.nameSelector_.getItemAt(i);
            RowSubset rset = (RowSubset)item;
            if (!rset.getName().equals(name)) continue;
            this.nameSelector_.setSelectedItem(rset);
            return;
        }
        this.nameSelector_.setSelectedItem(name);
    }

    public JTextField getExpressionField() {
        return this.exprField_;
    }

    protected boolean perform() {
        Object selected = this.nameSelector_.getSelectedItem();
        if (selected == null || selected.toString().length() == 0) {
            JOptionPane.showMessageDialog(this, "No subset name entered", "Missing Name Error", 0);
            return false;
        }
        String expr = this.getExpressionField().getText();
        if (expr == null || expr.trim().length() == 0) {
            JOptionPane.showMessageDialog(this, "No expression entered", "Missing Expression Error", 0);
            return false;
        }
        if (!($assertionsDisabled || selected instanceof RowSubset || selected instanceof String)) {
            throw new AssertionError();
        }
        String name = selected instanceof RowSubset ? ((RowSubset)selected).getName() : selected.toString();
        try {
            this.tcModel_.addSubset(new SyntheticRowSubset((StarTable)this.tcModel_.getDataModel(), this.tcModel_.getSubsets(), name, expr));
            return true;
        }
        catch (CompilationException e) {
            String[] msg = new String[]{"Syntax error in algebraic subset expression \"" + expr + "\":", e.getMessage()};
            JOptionPane.showMessageDialog(this, msg, "Expression Syntax Error", 0);
            return false;
        }
    }

    static {
        $assertionsDisabled = !AbstractSubsetQueryWindow.class.desiredAssertionStatus();
    }
}

