/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.LabelledComponentStack;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.Activator;
import uk.ac.starlink.topcat.ColumnComboBoxModel;
import uk.ac.starlink.topcat.ColumnSelector;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.CutoutSelector;
import uk.ac.starlink.topcat.MethodWindow;
import uk.ac.starlink.topcat.OptionsListModel;
import uk.ac.starlink.topcat.QueryWindow;
import uk.ac.starlink.topcat.RestrictedColumnComboBoxModel;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.func.Browsers;
import uk.ac.starlink.topcat.func.Spectrum;
import uk.ac.starlink.topcat.interop.ImageActivity;
import uk.ac.starlink.topcat.interop.RowActivity;
import uk.ac.starlink.topcat.interop.SkyPointActivity;
import uk.ac.starlink.topcat.interop.TopcatCommunicator;

public class ActivationQueryWindow
extends QueryWindow {
    private final TopcatModel tcModel_;
    private ActivatorFactory activeFactory_;
    private final TopcatCommunicator communicator_;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$net$URL;
    static /* synthetic */ Class class$java$net$URI;
    static /* synthetic */ Class class$java$io$File;

    public ActivationQueryWindow(TopcatModel tcModel, Component parent) {
        super("Set Activation Action", parent);
        this.tcModel_ = tcModel;
        this.communicator_ = ControlWindow.getInstance().getCommunicator();
        ActivatorFactory[] factories = new ActivatorFactory[]{new NopActivatorFactory(), new CutoutActivatorFactory(), new ImageActivatorFactory(), new SpectrumActivatorFactory(), new BrowserActivatorFactory(), new InteropHighlightActivatorFactory(), new InteropPointAtActivatorFactory(), new JELActivatorFactory()};
        GridBagLayout layer = new GridBagLayout();
        GridBagConstraints bc = new GridBagConstraints();
        bc.gridy = 0;
        bc.gridx = 0;
        bc.ipadx = 4;
        bc.ipady = 4;
        bc.insets = new Insets(2, 2, 2, 2);
        bc.anchor = 17;
        GridBagConstraints qc = (GridBagConstraints)bc.clone();
        ++qc.gridx;
        qc.fill = 1;
        qc.weightx = 1.0;
        JPanel mainBox = new JPanel(layer);
        this.getMainArea().add(mainBox);
        ButtonGroup buttGroup = new ButtonGroup();
        for (int i = 0; i < factories.length; ++i) {
            ActivatorFactory fact = factories[i];
            fact.setEnabled(false);
            JRadioButton butt = fact.button_;
            butt.setEnabled(fact.isPossible());
            buttGroup.add(butt);
            layer.setConstraints(butt, bc);
            mainBox.add(butt);
            JComponent query = fact.getQueryComponent();
            Border border = BorderFactory.createBevelBorder(0);
            border = BorderFactory.createCompoundBorder(border, BorderFactory.createEmptyBorder(5, 5, 5, 5));
            query.setBorder(border);
            layer.setConstraints(query, qc);
            mainBox.add(query);
            ++bc.gridy;
            ++qc.gridy;
        }
        factories[0].button_.setSelected(true);
        this.getToolBar().add(MethodWindow.getWindowAction(this, true));
        this.getToolBar().addSeparator();
        this.addHelp("ActivationQueryWindow");
    }

    public boolean perform() {
        Activator actor = this.activeFactory_.makeActivator();
        if (actor != null) {
            this.tcModel_.setActivator(actor);
            return true;
        }
        return false;
    }

    private String getWindowLabel(TableColumn tcol) {
        String tname = tcol instanceof StarTableColumn ? ((StarTableColumn)tcol).getColumnInfo().getName() : tcol.getHeaderValue().toString();
        return tname + "(" + this.tcModel_.getID() + ")";
    }

    private abstract class ColumnActivator
    implements Activator {
        final int icol_;
        final String funcName_;

        ColumnActivator(String funcName, TableColumn tcol) {
            this.icol_ = tcol.getModelIndex();
            this.funcName_ = funcName;
        }

        abstract String activateValue(Object var1);

        public String activateRow(long lrow) {
            Object value;
            try {
                value = ActivationQueryWindow.this.tcModel_.getDataModel().getCell(lrow, this.icol_);
            }
            catch (IOException e) {
                value = null;
            }
            return value == null ? null : this.activateValue(value);
        }

        public String toString() {
            String colName = ActivationQueryWindow.this.tcModel_.getDataModel().getColumnInfo(this.icol_).getName();
            return this.funcName_ + "( " + colName + " )";
        }
    }

    private class SpectrumActivatorFactory
    extends ColumnActivatorFactory {
        SpectrumActivatorFactory() {
            super("Spectrum");
        }

        Activator makeActivator(TableColumn tcol) {
            return new ColumnActivator(this, "spectrum", tcol, tcol){
                private final /* synthetic */ TableColumn val$tcol;
                private final /* synthetic */ SpectrumActivatorFactory this$1;
                {
                    this.this$1 = this$1;
                    this.val$tcol = val$tcol;
                    super(x0, x1);
                }

                String activateValue(Object val) {
                    return val == null ? null : Spectrum.displaySpectrum(ActivationQueryWindow.access$500(SpectrumActivatorFactory.access$700(this.this$1), this.val$tcol), val.toString());
                }
            };
        }

        boolean isPossible() {
            return super.isPossible() && TopcatUtils.canSplat();
        }

        static /* synthetic */ ActivationQueryWindow access$700(SpectrumActivatorFactory x0) {
            return x0.ActivationQueryWindow.this;
        }
    }

    private class ImageActivatorFactory
    extends ColumnActivatorFactory {
        final ImageActivity imageSender_;

        ImageActivatorFactory() {
            super("Image");
            this.imageSender_ = ActivationQueryWindow.this.communicator_.createImageActivity();
            this.selectColumnByUCD("VOX:Image_AccessReference");
            ArrayList<Component> eList = new ArrayList<Component>(Arrays.asList(this.enablables_));
            JComboBox formatSelector = this.imageSender_.getFormatSelector();
            JLabel formatLabel = new JLabel("Image Format: ");
            eList.add(formatLabel);
            eList.add(formatSelector);
            Box formatBox = Box.createHorizontalBox();
            formatBox.add(formatLabel);
            formatBox.add(formatSelector);
            this.queryPanel_.add(Box.createVerticalStrut(5));
            this.queryPanel_.add(formatBox);
            JComboBox viewerSelector = new JComboBox(this.imageSender_.getTargetSelector());
            JLabel viewerLabel = new JLabel("Image Viewer: ");
            eList.add(viewerLabel);
            eList.add(viewerSelector);
            Box viewerBox = Box.createHorizontalBox();
            viewerBox.add(viewerLabel);
            viewerBox.add(viewerSelector);
            this.queryPanel_.add(Box.createVerticalStrut(5));
            this.queryPanel_.add(viewerBox);
            this.enablables_ = eList.toArray(new Component[0]);
        }

        Activator makeActivator(TableColumn tcol) {
            String label = ActivationQueryWindow.this.getWindowLabel(tcol);
            return new ColumnActivator(this, "image", tcol, label){
                private final /* synthetic */ String val$label;
                private final /* synthetic */ ImageActivatorFactory this$1;
                {
                    this.this$1 = this$1;
                    this.val$label = val$label;
                    super(x0, x1);
                }

                String activateValue(Object val) {
                    String loc = val.toString();
                    if (val == null) {
                        return null;
                    }
                    try {
                        this.this$1.imageSender_.displayImage(loc, this.val$label);
                        return "view(" + loc + ")";
                    }
                    catch (IOException e) {
                        return "view(" + loc + ") - failed " + e;
                    }
                }
            };
        }

        static /* synthetic */ ActivationQueryWindow access$600(ImageActivatorFactory x0) {
            return x0.ActivationQueryWindow.this;
        }
    }

    private abstract class ColumnActivatorFactory
    extends ActivatorFactory {
        JComboBox colSelector_;

        ColumnActivatorFactory(String descrip) {
            super("View URL as " + descrip);
            this.colSelector_ = new RestrictedColumnComboBoxModel(this, ActivationQueryWindow.this.tcModel_.getColumnModel(), true){
                private final /* synthetic */ ColumnActivatorFactory this$1;
                {
                    this.this$1 = this$1;
                    super(x0, x1);
                }

                public boolean acceptColumn(ColumnInfo cinfo) {
                    Class clazz = cinfo.getContentClass();
                    return clazz == (class$java$lang$String == null ? (class$java$lang$String = ActivationQueryWindow.class$("java.lang.String")) : class$java$lang$String) || clazz == (class$java$net$URL == null ? (class$java$net$URL = ActivationQueryWindow.class$("java.net.URL")) : class$java$net$URL) || clazz == (class$java$net$URI == null ? (class$java$net$URI = ActivationQueryWindow.class$("java.net.URI")) : class$java$net$URI) || clazz == (class$java$io$File == null ? (class$java$io$File = ActivationQueryWindow.class$("java.io.File")) : class$java$io$File);
                }
            }.makeComboBox();
            this.colSelector_.setSelectedIndex(0);
            JLabel colLabel = new JLabel(descrip + " Location column: ");
            this.enablables_ = new Component[]{colLabel, this.colSelector_};
            Box colBox = Box.createHorizontalBox();
            colBox.add(colLabel);
            colBox.add(this.colSelector_);
            this.queryPanel_.setLayout(new BoxLayout(this.queryPanel_, 1));
            this.queryPanel_.add(colBox);
        }

        boolean isPossible() {
            return this.colSelector_.getItemCount() > 1;
        }

        Activator makeActivator() {
            TableColumn tcol = (TableColumn)this.colSelector_.getSelectedItem();
            if (tcol == ColumnComboBoxModel.NO_COLUMN) {
                tcol = null;
            }
            if (tcol != null) {
                return this.makeActivator(tcol);
            }
            JOptionPane.showMessageDialog(ActivationQueryWindow.this, "Must supply location column", "No Action Defined", 0);
            return null;
        }

        protected void selectColumnByUCD(String ucd) {
            for (int i = 0; i < this.colSelector_.getItemCount(); ++i) {
                ColumnInfo cinfo;
                TableColumn tcol = (TableColumn)this.colSelector_.getItemAt(i);
                if (!(tcol instanceof StarTableColumn) || !ucd.equals((cinfo = ((StarTableColumn)tcol).getColumnInfo()).getUCD())) continue;
                this.colSelector_.setSelectedIndex(i);
                break;
            }
        }

        abstract Activator makeActivator(TableColumn var1);
    }

    private class InteropPointAtActivatorFactory
    extends ActivatorFactory {
        final SkyPointActivity skyPointer_;
        final ColumnSelector raSelector_;
        final ColumnSelector decSelector_;

        InteropPointAtActivatorFactory() {
            super("Transmit Coordinates");
            this.skyPointer_ = ActivationQueryWindow.this.communicator_.createSkyPointActivity();
            this.raSelector_ = new ColumnSelector(ActivationQueryWindow.this.tcModel_.getColumnSelectorModel((ValueInfo)Tables.RA_INFO), false);
            this.decSelector_ = new ColumnSelector(ActivationQueryWindow.this.tcModel_.getColumnSelectorModel((ValueInfo)Tables.DEC_INFO), false);
            JComboBox appSelector = new JComboBox(this.skyPointer_.getTargetSelector());
            LabelledComponentStack stack = new LabelledComponentStack();
            stack.addLine("RA Column", (Component)this.raSelector_);
            stack.addLine("Dec Column", (Component)this.decSelector_);
            stack.addLine("Target Application", appSelector);
            this.queryPanel_.add((Component)stack);
            JLabel[] labels = stack.getLabels();
            this.enablables_ = new Component[]{this.raSelector_, this.decSelector_, appSelector, labels[0], labels[1], labels[2]};
        }

        Activator makeActivator() {
            ColumnData raData = this.raSelector_.getColumnData();
            ColumnData decData = this.decSelector_.getColumnData();
            if (raData == null || decData == null) {
                JOptionPane.showMessageDialog(ActivationQueryWindow.this, "Must give RA and Dec", "No Action Defined", 0);
                return null;
            }
            return new Activator(this, raData, decData){
                private final /* synthetic */ ColumnData val$raData;
                private final /* synthetic */ ColumnData val$decData;
                private final /* synthetic */ InteropPointAtActivatorFactory this$1;
                {
                    this.this$1 = this$1;
                    this.val$raData = val$raData;
                    this.val$decData = val$decData;
                }

                public String activateRow(long lrow) {
                    Object decObj;
                    Object raObj;
                    try {
                        raObj = this.val$raData.readValue(lrow);
                        decObj = this.val$decData.readValue(lrow);
                    }
                    catch (IOException e) {
                        return "Error reading position " + e;
                    }
                    if (raObj instanceof Number && decObj instanceof Number) {
                        double ra = ((Number)raObj).doubleValue();
                        double dec = ((Number)decObj).doubleValue();
                        if (!Double.isNaN(ra) && !Double.isNaN(dec)) {
                            ra = Math.toDegrees(ra);
                            dec = Math.toDegrees(dec);
                            try {
                                this.this$1.skyPointer_.pointAtSky(ra, dec);
                                return "(" + ra + ", " + dec + ")";
                            }
                            catch (IOException e) {
                                return "point failed: " + e;
                            }
                        }
                        return "No position at (" + raObj + ", " + decObj + ")";
                    }
                    return "No position";
                }

                public String toString() {
                    return "pointAt($ra, $dec)";
                }
            };
        }
    }

    private class InteropHighlightActivatorFactory
    extends ActivatorFactory {
        final RowActivity rowPointer_;

        InteropHighlightActivatorFactory() {
            super("Transmit Row");
            this.rowPointer_ = ActivationQueryWindow.this.communicator_.createRowActivity();
            JComboBox appSelector = new JComboBox(this.rowPointer_.getTargetSelector());
            LabelledComponentStack stack = new LabelledComponentStack();
            stack.addLine("Target Application", appSelector);
            this.queryPanel_.add((Component)stack);
            JLabel[] labels = stack.getLabels();
            this.enablables_ = new Component[]{appSelector, labels[0]};
        }

        Activator makeActivator() {
            return new Activator(this){
                private final /* synthetic */ InteropHighlightActivatorFactory this$1;
                {
                    this.this$1 = this$1;
                }

                public String activateRow(long lrow) {
                    try {
                        this.this$1.rowPointer_.highlightRow(ActivationQueryWindow.access$100(InteropHighlightActivatorFactory.access$400(this.this$1)), lrow);
                        return ActivationQueryWindow.access$100(InteropHighlightActivatorFactory.access$400(this.this$1)) + "(" + lrow + ")";
                    }
                    catch (IOException e) {
                        return "send (" + lrow + ") failed - " + e;
                    }
                }

                public String toString() {
                    return "transmitRow";
                }
            };
        }

        static /* synthetic */ ActivationQueryWindow access$400(InteropHighlightActivatorFactory x0) {
            return x0.ActivationQueryWindow.this;
        }
    }

    private class CutoutActivatorFactory
    extends ActivatorFactory {
        final CutoutSelector cutter_;

        CutoutActivatorFactory() {
            super("Display Cutout Image");
            this.cutter_ = new CutoutSelector(ActivationQueryWindow.this.tcModel_);
            Box cutterBox = Box.createHorizontalBox();
            cutterBox.add(this.cutter_);
            cutterBox.add(Box.createHorizontalGlue());
            this.queryPanel_.add(cutterBox);
            this.enablables_ = new Component[]{this.cutter_};
        }

        Activator makeActivator() {
            return this.cutter_.makeActivator();
        }
    }

    private class BrowserActivatorFactory
    extends ColumnActivatorFactory {
        final JComboBox browserChooser_;
        final String MOZILLA = "mozilla";
        final String NETSCAPE = "netscape";
        final String FIREFOX = "firefox";
        final String BASIC_BROWSER = "basic browser";
        final String SYSTEM_BROWSER = "system browser";

        BrowserActivatorFactory() {
            super("Web Page");
            this.MOZILLA = "mozilla";
            this.NETSCAPE = "netscape";
            this.FIREFOX = "firefox";
            this.BASIC_BROWSER = "basic browser";
            this.SYSTEM_BROWSER = "system browser";
            this.browserChooser_ = new JComboBox();
            this.browserChooser_.addItem("basic browser");
            this.browserChooser_.addItem("system browser");
            this.browserChooser_.addItem("mozilla");
            this.browserChooser_.addItem("netscape");
            this.browserChooser_.addItem("firefox");
            JLabel browserLabel = new JLabel("Browser Type: ");
            ArrayList<Component> eList = new ArrayList<Component>(Arrays.asList(this.enablables_));
            eList.add(browserLabel);
            eList.add(this.browserChooser_);
            this.enablables_ = eList.toArray(new Component[0]);
            Box browserBox = Box.createHorizontalBox();
            browserBox.add(browserLabel);
            browserBox.add(this.browserChooser_);
            this.queryPanel_.add(Box.createVerticalStrut(5));
            this.queryPanel_.add(browserBox);
        }

        Activator makeActivator(TableColumn tcol) {
            Object browser = this.browserChooser_.getSelectedItem();
            if ("basic browser".equals(browser)) {
                return new ColumnActivator(this, "basicBrowser", tcol){
                    private final /* synthetic */ BrowserActivatorFactory this$1;
                    {
                        this.this$1 = this$1;
                        super(x0, x1);
                    }

                    String activateValue(Object val) {
                        return val == null ? null : Browsers.basicBrowser(val.toString());
                    }
                };
            }
            if ("system browser".equals(browser)) {
                return new ColumnActivator(this, "systemBrowser", tcol){
                    private final /* synthetic */ BrowserActivatorFactory this$1;
                    {
                        this.this$1 = this$1;
                        super(x0, x1);
                    }

                    String activateValue(Object val) {
                        return val == null ? null : Browsers.systemBrowser(val.toString());
                    }
                };
            }
            if ("mozilla".equals(browser)) {
                return this.createMozalikeActivator("mozilla", tcol);
            }
            if ("netscape".equals(browser)) {
                return this.createMozalikeActivator("netscape", tcol);
            }
            if ("firefox".equals(browser)) {
                return this.createMozalikeActivator("firefox", tcol);
            }
            return null;
        }

        private Activator createMozalikeActivator(String cmdname, TableColumn tcol) {
            return new ColumnActivator(this, "document", tcol, cmdname){
                private final /* synthetic */ String val$cmdname;
                private final /* synthetic */ BrowserActivatorFactory this$1;
                {
                    this.this$1 = this$1;
                    this.val$cmdname = val$cmdname;
                    super(x0, x1);
                }

                String activateValue(Object val) {
                    return val == null ? null : Browsers.mozalike(this.val$cmdname, val.toString());
                }

                public String toString() {
                    String colName = ActivationQueryWindow.access$100(BrowserActivatorFactory.access$200(this.this$1)).getDataModel().getColumnInfo(this.icol_).getName();
                    return this.val$cmdname + "( " + colName + " )";
                }
            };
        }

        static /* synthetic */ ActivationQueryWindow access$200(BrowserActivatorFactory x0) {
            return x0.ActivationQueryWindow.this;
        }
    }

    private class JELActivatorFactory
    extends ActivatorFactory {
        JComboBox codeField_;

        JELActivatorFactory() {
            super("Execute Custom Code");
            this.codeField_ = ActivationQueryWindow.this.tcModel_.getActivatorList().makeComboBox();
            this.codeField_.setEditable(true);
            this.codeField_.validate();
            JLabel codeLabel = new JLabel("Executable Expression: ");
            this.enablables_ = new Component[]{this.codeField_, codeLabel};
            Box box = Box.createHorizontalBox();
            box.add(codeLabel);
            box.add(this.codeField_);
            this.queryPanel_.add(box);
        }

        Activator makeActivator() {
            Object sel = this.codeField_.getSelectedItem();
            String expr = sel == null ? null : sel.toString();
            try {
                Activator activ = ActivationQueryWindow.this.tcModel_.makeActivator(expr);
                OptionsListModel actlist = ActivationQueryWindow.this.tcModel_.getActivatorList();
                if (!actlist.contains(expr)) {
                    actlist.add(expr);
                }
                return activ;
            }
            catch (CompilationException e) {
                String[] msg = new String[]{"Syntax error in activation function \"" + expr + "\":", e.getMessage()};
                JOptionPane.showMessageDialog(ActivationQueryWindow.this, msg, "Syntax Error", 0);
                return null;
            }
        }
    }

    private class NopActivatorFactory
    extends ActivatorFactory {
        JComponent qcomp_;

        NopActivatorFactory() {
            super("No Action");
            this.qcomp_ = new JPanel();
        }

        Activator makeActivator() {
            return Activator.NOP;
        }
    }

    private abstract class ActivatorFactory
    implements ChangeListener {
        String description_;
        JRadioButton button_;
        JPanel queryPanel_;
        Component[] enablables_;

        ActivatorFactory(String desc) {
            this.description_ = desc;
            this.button_ = new JRadioButton(desc);
            this.button_.addChangeListener(this);
            this.queryPanel_ = new JPanel(new BorderLayout());
        }

        JComponent getQueryComponent() {
            return this.queryPanel_;
        }

        boolean isPossible() {
            return true;
        }

        public void setEnabled(boolean enabled) {
            if (this.enablables_ != null) {
                for (int i = 0; i < this.enablables_.length; ++i) {
                    this.enablables_[i].setEnabled(enabled);
                }
            }
        }

        abstract Activator makeActivator();

        public void stateChanged(ChangeEvent evt) {
            if (evt.getSource() == this.button_) {
                boolean active = this.button_.isSelected();
                this.setEnabled(active);
                if (active) {
                    ActivationQueryWindow.this.activeFactory_ = this;
                }
            }
        }
    }
}

