/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JToolBar;
import javax.swing.border.Border;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.TableSource;
import uk.ac.starlink.table.Tables;
import uk.ac.starlink.table.formats.AsciiTableWriter;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.BrowserHelpAction;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.Driver;
import uk.ac.starlink.topcat.HelpAction;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.SaveTableQueryWindow;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.util.gui.ErrorDialog;

public class AuxWindow
extends JFrame {
    private JMenu fileMenu;
    private JMenu helpMenu;
    private JToolBar toolBar;
    private JLabel headingLabel;
    private JPanel mainArea;
    private JPanel controlPanel;
    private JMenuBar menuBar;
    private Map saveWindows;
    private boolean closeIsExit;
    private boolean isStandalone;
    private boolean packed;
    private Action aboutAct;
    private Action controlAct;
    private Action closeAct;
    private Action exitAct;
    private static final Cursor busyCursor;
    private static final Logger logger;
    private static final Icon LOGO;
    static final /* synthetic */ boolean $assertionsDisabled;

    public AuxWindow(String title, Component parent) {
        this.setTitle(title);
        this.setDefaultCloseOperation(2);
        if (parent != null) {
            AuxWindow.positionAfter(parent, this);
        }
        this.saveWindows = new HashMap();
        this.menuBar = new JMenuBar();
        this.setJMenuBar(this.menuBar);
        this.fileMenu = new JMenu("File");
        this.fileMenu.setMnemonic(70);
        this.menuBar.add(this.fileMenu);
        this.controlAct = new AuxAction("Control Window", ResourceIcon.CONTROL, "Ensure Control Window is visible");
        this.closeAct = new AuxAction("Close", ResourceIcon.CLOSE, "Close this window");
        this.exitAct = new AuxAction("Exit", ResourceIcon.EXIT, "Exit the application");
        this.fileMenu.add(this.controlAct);
        JMenuItem closeItem = this.fileMenu.add(this.closeAct);
        closeItem.setMnemonic(67);
        this.isStandalone = Driver.isStandalone();
        if (this.isStandalone) {
            JMenuItem exitItem = this.fileMenu.add(this.exitAct);
            exitItem.setMnemonic(88);
        }
        this.toolBar = new JToolBar();
        this.toolBar.addSeparator();
        this.toolBar.setFloatable(false);
        this.getContentPane().add((Component)this.toolBar, "North");
        JPanel overPanel = new JPanel();
        overPanel.setLayout(new BoxLayout(overPanel, 1));
        this.headingLabel = new JLabel();
        this.headingLabel.setAlignmentX(0.0f);
        Box headingBox = new Box(0);
        headingBox.add(this.headingLabel);
        headingBox.add(Box.createHorizontalGlue());
        this.mainArea = new JPanel(new BorderLayout());
        this.controlPanel = new JPanel();
        overPanel.add(headingBox);
        overPanel.add(this.mainArea);
        overPanel.add(this.controlPanel);
        overPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.getContentPane().add((Component)overPanel, "Center");
    }

    public AuxWindow(final TopcatModel tcModel, final String viewName, Component parent) {
        this("TOPCAT(" + tcModel.getID() + "): " + viewName, parent);
        TopcatListener labelListener = new TopcatListener(){

            public void modelChanged(TopcatEvent evt) {
                if (evt.getCode() == 1) {
                    AuxWindow.this.setMainHeading(viewName + " for " + tcModel.toString());
                }
            }
        };
        labelListener.modelChanged(new TopcatEvent(tcModel, 1, null));
        tcModel.addTopcatListener(labelListener);
    }

    protected void addHelp(String helpID) {
        this.helpMenu = new JMenu("Help");
        this.helpMenu.setMnemonic(72);
        this.menuBar.add(this.helpMenu);
        HelpAction helpAct = new HelpAction(helpID, this);
        this.toolBar.add(helpAct);
        this.helpMenu.add(new HelpAction(null, this));
        if (helpID != null) {
            this.helpMenu.add(helpAct);
        }
        this.helpMenu.add(BrowserHelpAction.createManualAction(this));
        this.helpMenu.add(BrowserHelpAction.createManual1Action(this));
        if (helpID != null) {
            this.helpMenu.add(BrowserHelpAction.createIdAction(helpID, this));
        }
        this.helpMenu.addSeparator();
        this.aboutAct = new AuxAction("About TOPCAT", ResourceIcon.TOPCAT_LOGO_SMALL, null);
        this.helpMenu.add(this.aboutAct);
        this.toolBar.add(this.closeIsExit ? this.exitAct : this.closeAct);
        if (LOGO != null && LOGO.getIconWidth() > 0 && LOGO.getIconHeight() > 0) {
            this.toolBar.add(Box.createHorizontalGlue());
            this.toolBar.addSeparator();
            this.toolBar.add(new JLabel(LOGO));
        }
        this.toolBar.addSeparator();
    }

    public void setBusy(boolean busy) {
        this.setCursor(busy ? busyCursor : null);
    }

    public void makeVisible() {
        this.setState(0);
        this.setVisible(true);
    }

    public void setVisible(boolean isVis) {
        if (!this.packed && isVis) {
            this.pack();
            this.packed = true;
        }
        super.setVisible(isVis);
    }

    public JProgressBar placeProgressBar() {
        JProgressBar progBar = new JProgressBar();
        this.getContentPane().add((Component)progBar, "South");
        return progBar;
    }

    public void setCloseIsExit() {
        if (this.isStandalone) {
            this.closeIsExit = true;
            boolean exitFound = false;
            for (int i = this.fileMenu.getItemCount() - 1; i >= 0; --i) {
                JMenuItem item = this.fileMenu.getItem(i);
                if (item == null) continue;
                Action act = item.getAction();
                if (act == this.closeAct) {
                    this.fileMenu.remove(item);
                    continue;
                }
                if (act == this.exitAct) {
                    exitFound = true;
                    continue;
                }
                if (act != this.controlAct) continue;
                this.fileMenu.remove(item);
            }
            if (!$assertionsDisabled && !exitFound) {
                throw new AssertionError();
            }
        }
    }

    public JToolBar getToolBar() {
        return this.toolBar;
    }

    public JMenu getFileMenu() {
        return this.fileMenu;
    }

    public JMenu getHelpMenu() {
        return this.helpMenu;
    }

    public void setMainHeading(String text) {
        this.headingLabel.setText(text);
    }

    public JPanel getMainArea() {
        return this.mainArea;
    }

    public JPanel getControlPanel() {
        return this.controlPanel;
    }

    public boolean confirm(String message, String title) {
        return JOptionPane.showConfirmDialog(this, message, title, 2) == 0;
    }

    public Action createSaveTableAction(final String dataType, final TableSource tSrc) {
        return new BasicAction("Save as Table", ResourceIcon.SAVE, "Save " + dataType + " as a table to disk"){

            public void actionPerformed(ActionEvent evt) {
                if (!AuxWindow.this.saveWindows.containsKey(dataType)) {
                    StarTableOutput sto = ControlWindow.getInstance().getTableOutput();
                    SaveTableQueryWindow saveWindow = new SaveTableQueryWindow("Save " + dataType + " as table", AuxWindow.this, tSrc, sto, false);
                    AuxWindow.this.saveWindows.put(dataType, saveWindow);
                    saveWindow.setDefaultFormat(new AsciiTableWriter().getFormatName());
                }
                ((SaveTableQueryWindow)AuxWindow.this.saveWindows.get(dataType)).setVisible(true);
            }
        };
    }

    public Action createImportTableAction(String dataType, final TableSource tSrc, final String label) {
        return new BasicAction("Import as Table", ResourceIcon.IMPORT, "Import " + dataType + " into " + TopcatUtils.getApplicationName() + " as a new table"){

            public void actionPerformed(ActionEvent evt) {
                StarTable table = tSrc.getStarTable();
                try {
                    table = Tables.randomTable((StarTable)table);
                }
                catch (IOException e) {
                    ErrorDialog.showError((Component)AuxWindow.this, (String)"Table Conversion Error", (Throwable)e);
                    return;
                }
                catch (OutOfMemoryError e) {
                    TopcatUtils.memoryError(e);
                    return;
                }
                ControlWindow.getInstance().addTable(table, label, true);
            }
        };
    }

    public Image getIconImage() {
        return ResourceIcon.TOPCAT.getImage();
    }

    public static void beep() {
        Toolkit.getDefaultToolkit().beep();
    }

    public static Border makeTitledBorder(String title) {
        return BorderFactory.createTitledBorder(BorderFactory.createLineBorder(Color.BLACK), title);
    }

    public static void positionAfter(Component first, Window second) {
        GraphicsConfiguration gc = second.getGraphicsConfiguration();
        if (first == null || gc.equals(first.getGraphicsConfiguration())) {
            Point pos = null;
            if (first != null) {
                pos = first.getLocation();
            }
            if (pos == null) {
                pos = new Point(20, 20);
            }
            pos.x += 60;
            pos.y += 60;
            Rectangle newloc = new Rectangle(second.getBounds());
            newloc.setLocation(pos);
            Rectangle screen = gc.getBounds();
            if (screen.x <= newloc.x && screen.y <= newloc.y && screen.x + screen.width >= newloc.x + newloc.width && screen.y + screen.height >= newloc.y + newloc.height) {
                second.setLocation(pos);
            }
        }
    }

    public static void recursiveSetEnabled(Component comp, boolean enabled) {
        if (comp.isFocusable()) {
            comp.setEnabled(enabled);
        }
        if (comp instanceof Container) {
            Component[] subComps = ((Container)comp).getComponents();
            for (int i = 0; i < subComps.length; ++i) {
                Component subComp = subComps[i];
                if (subComp instanceof JLabel) continue;
                AuxWindow.recursiveSetEnabled(subComp, enabled);
            }
        }
    }

    private static Icon getBadge() {
        final ImageIcon starlinkIcon = new ImageIcon(ResourceIcon.STAR_LOGO.getImage().getScaledInstance(-1, 34, 4));
        long fadeStart = new GregorianCalendar(2006, 3, 1).getTimeInMillis();
        long fadeEnd = new GregorianCalendar(2006, 8, 1).getTimeInMillis();
        long now = new GregorianCalendar().getTimeInMillis();
        double fade = (double)(now - fadeStart) / (double)(fadeEnd - fadeStart);
        float alpha = 1.0f - Math.max(0.0f, Math.min(1.0f, (float)fade));
        final boolean visible = alpha > 0.0f;
        final AlphaComposite fadeComposite = visible ? AlphaComposite.getInstance(3, alpha) : null;
        return new Icon(){

            public int getIconHeight() {
                return visible ? starlinkIcon.getIconHeight() : 0;
            }

            public int getIconWidth() {
                return visible ? starlinkIcon.getIconWidth() : 0;
            }

            public void paintIcon(Component c, Graphics g, int x, int y) {
                if (visible && g instanceof Graphics2D) {
                    Graphics2D g2 = (Graphics2D)g;
                    Composite origComposite = g2.getComposite();
                    g2.setComposite(fadeComposite);
                    starlinkIcon.paintIcon(c, g2, x, y);
                    g2.setComposite(origComposite);
                }
            }
        };
    }

    private static Component getSponsorLogos() {
        Box box = Box.createHorizontalBox();
        int igap = 20;
        box.add(Box.createHorizontalGlue());
        JLabel starLogo = new JLabel(ResourceIcon.STAR_LOGO);
        starLogo.setToolTipText("Starlink project (deceased): http://www.starlink.ac.uk/");
        box.add(starLogo);
        box.add(Box.createHorizontalStrut(igap));
        JLabel agLogo = new JLabel(ResourceIcon.ASTROGRID_LOGO);
        agLogo.setToolTipText("AstroGrid project: http://www.astrogrid.org/");
        box.add(agLogo);
        box.add(Box.createHorizontalStrut(igap));
        JLabel brisLogo = new JLabel(ResourceIcon.BRISTOL_LOGO);
        brisLogo.setToolTipText("Bristol University, Astrophysics group: http://www.star.bris.ac.uk/");
        box.add(brisLogo);
        box.add(Box.createHorizontalStrut(igap));
        JLabel votechLogo = new JLabel(ResourceIcon.VOTECH_LOGO);
        votechLogo = new JLabel(ResourceIcon.VOTECH_LOGO);
        votechLogo.setToolTipText("VO-Tech project: http://www.eurovotech.org/");
        box.add(votechLogo);
        return box;
    }

    static {
        $assertionsDisabled = !AuxWindow.class.desiredAssertionStatus();
        busyCursor = new Cursor(3);
        logger = Logger.getLogger("uk.ac.starlink.topcat");
        LOGO = AuxWindow.getBadge();
    }

    private class AuxAction
    extends BasicAction {
        AuxAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this == AuxWindow.this.closeAct) {
                AuxWindow.this.dispose();
            } else if (this == AuxWindow.this.exitAct) {
                ControlWindow.getInstance().exit(true);
            }
            if (this == AuxWindow.this.controlAct) {
                ControlWindow.getInstance().makeVisible();
            } else if (this == AuxWindow.this.aboutAct) {
                Object[] msg = new Object[]{TopcatUtils.getAbout(), Box.createVerticalStrut(10), AuxWindow.getSponsorLogos()};
                JOptionPane.showMessageDialog(AuxWindow.this, msg, "About TOPCAT", 1, ResourceIcon.TOPCAT_LOGO);
            }
        }
    }
}

