/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.io.IOException;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.topcat.RowSubset;

public class BooleanColumnRowSubset
implements RowSubset {
    private StarTable startab;
    private int icol;
    private ColumnInfo colinfo;

    public BooleanColumnRowSubset(StarTable startab, int icol) {
        this.startab = startab;
        this.icol = icol;
        this.colinfo = startab.getColumnInfo(icol);
        if (this.colinfo.getContentClass() != Boolean.class) {
            throw new IllegalArgumentException("Column " + this.colinfo + " is not boolean");
        }
    }

    public String getName() {
        return this.colinfo.getName();
    }

    public boolean isIncluded(long lrow) {
        try {
            Object cellValue = this.startab.getCell(lrow, this.icol);
            return Boolean.TRUE.equals(cellValue);
        }
        catch (IOException e) {
            return false;
        }
    }

    public ColumnInfo getColumnInfo() {
        return this.colinfo;
    }

    public String toString() {
        return this.getName();
    }
}

