/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import edu.stanford.ejalbert.BrowserLauncher;
import edu.stanford.ejalbert.exception.BrowserLaunchingInitializingException;
import edu.stanford.ejalbert.exception.UnsupportedOperatingSystemException;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.interop.TopcatServer;
import uk.ac.starlink.util.gui.ErrorDialog;

public class BrowserHelpAction
extends AbstractAction {
    private final Component parent_;
    private final URL helpUrl_;
    private static final Logger logger_;
    private static BrowserLauncher launcher_;
    private static final TopcatServer server_;
    static final /* synthetic */ boolean $assertionsDisabled;

    private BrowserHelpAction(URL helpUrl, Component parent) {
        this.helpUrl_ = helpUrl;
        this.parent_ = parent;
        if (this.helpUrl_ == null) {
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (launcher_ == null) {
            try {
                launcher_ = new BrowserLauncher();
                launcher_.setNewWindowPolicy(false);
            }
            catch (BrowserLaunchingInitializingException e) {
                ErrorDialog.showError((Component)this.parent_, (String)"Browser Error", (Throwable)e);
                return;
            }
            catch (UnsupportedOperatingSystemException e) {
                ErrorDialog.showError((Component)this.parent_, (String)"Browser Error", (Throwable)e);
                return;
            }
        }
        launcher_.openURLinBrowser(this.helpUrl_.toString());
    }

    public static Action createIdAction(String helpId, Component parent) {
        BrowserHelpAction action = new BrowserHelpAction(BrowserHelpAction.getHelpUrl(helpId + ".html"), parent);
        action.putValue("Name", "Help for Window in Browser");
        action.putValue("SmallIcon", ResourceIcon.HELP_BROWSER);
        action.putValue("ShortDescription", "Attempt to display help for this window in a web browser");
        return action;
    }

    public static Action createManualAction(Component parent) {
        BrowserHelpAction action = new BrowserHelpAction(BrowserHelpAction.getHelpUrl("index.html"), parent);
        action.putValue("Name", "Help in Browser");
        action.putValue("SmallIcon", ResourceIcon.MANUAL_BROWSER);
        action.putValue("ShortDescription", "Attempt to display help for the application as a multiple-page HTML document in a web browser");
        return action;
    }

    public static Action createManual1Action(Component parent) {
        BrowserHelpAction action = new BrowserHelpAction(BrowserHelpAction.getHelpUrl("sun253.html"), parent);
        action.putValue("Name", "Help in Browser (single page)");
        action.putValue("SmallIcon", ResourceIcon.MANUAL1_BROWSER);
        action.putValue("ShortDescription", "Attempt to display help for the application as a single-page HTML document in a web browser");
        return action;
    }

    private static TopcatServer getTopcatServer() {
        try {
            return TopcatServer.getInstance();
        }
        catch (IOException e) {
            return null;
        }
    }

    private static URL getHelpUrl(String relUrl) {
        if (server_ != null) {
            URL url;
            try {
                url = new URL(server_.getTopcatPackageUrl(), "sun253/" + relUrl);
            }
            catch (MalformedURLException e) {
                if (!$assertionsDisabled) {
                    throw new AssertionError();
                }
                return null;
            }
            if (server_.isFound(url)) {
                return url;
            }
            logger_.warning("Can't locate help URL: " + url);
            return null;
        }
        return null;
    }

    static {
        $assertionsDisabled = !BrowserHelpAction.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.topcat");
        server_ = BrowserHelpAction.getTopcatServer();
    }
}

