/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Rectangle;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.DefaultListModel;
import javax.swing.DefaultListSelectionModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.ListModel;
import javax.swing.ListSelectionModel;
import javax.swing.Scrollable;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class CheckBoxStack
extends JPanel
implements ListSelectionListener,
ListDataListener,
Scrollable {
    private ListSelectionModel selModel;
    private ListModel listModel;
    private List entries;
    private final Annotator annotator_;

    public CheckBoxStack(ListModel listModel, Annotator annotator) {
        super(new GridBagLayout());
        this.annotator_ = annotator;
        this.setListModel(listModel);
        this.setSelectionModel(new DefaultListSelectionModel());
    }

    public CheckBoxStack(ListModel listModel) {
        this(listModel, null);
    }

    public CheckBoxStack() {
        this(new DefaultListModel());
        this.revalidate();
        this.repaint();
    }

    private void addItem(Object item) {
        final JCheckBox cbox = new JCheckBox(item.toString());
        final int pos = this.entries.size();
        if (this.selModel != null) {
            cbox.setSelected(this.selModel.isSelectedIndex(pos));
        }
        cbox.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent evt) {
                if (cbox.isSelected()) {
                    CheckBoxStack.this.selModel.addSelectionInterval(pos, pos);
                } else {
                    CheckBoxStack.this.selModel.removeSelectionInterval(pos, pos);
                }
            }
        });
        this.entries.add(cbox);
        this.addLine(cbox, this.annotator_ == null ? null : this.annotator_.createAnnotation(item));
    }

    private void addLine(Component c1, Component c2) {
        GridBagLayout layer = (GridBagLayout)this.getLayout();
        GridBagConstraints cons = new GridBagConstraints();
        cons.gridy = this.entries.size();
        cons.gridx = 0;
        cons.weightx = 1.0;
        cons.weighty = 1.0;
        cons.anchor = 17;
        layer.setConstraints(c1, cons);
        this.add(c1);
        ++cons.gridx;
        if (c2 != null) {
            layer.setConstraints(c2, cons);
            this.add(c2);
        }
        ++cons.gridx;
    }

    private void redoAllItems() {
        this.removeAll();
        this.entries = new ArrayList();
        for (int i = 0; i < this.listModel.getSize(); ++i) {
            this.addItem(this.listModel.getElementAt(i));
        }
    }

    public ListSelectionModel getSelectionModel() {
        return this.selModel;
    }

    public void setSelectionModel(ListSelectionModel selModel) {
        if (this.selModel != null) {
            this.selModel.removeListSelectionListener(this);
        }
        this.selModel = selModel;
        selModel.addListSelectionListener(this);
    }

    public ListModel getListModel() {
        return this.listModel;
    }

    public void setListModel(ListModel listModel) {
        if (this.listModel != null) {
            this.listModel.removeListDataListener(this);
        }
        this.listModel = listModel;
        this.redoAllItems();
        listModel.addListDataListener(this);
    }

    public void valueChanged(ListSelectionEvent evt) {
        for (int i = evt.getFirstIndex(); i <= evt.getLastIndex(); ++i) {
            ((JCheckBox)this.entries.get(i)).setSelected(this.selModel.isSelectedIndex(i));
        }
    }

    public void intervalAdded(ListDataEvent evt) {
        int index0 = evt.getIndex0();
        int index1 = evt.getIndex1();
        if (index0 == this.entries.size()) {
            for (int i = index0; i <= index1; ++i) {
                this.addItem(this.listModel.getElementAt(i));
            }
        } else {
            this.redoAllItems();
        }
        this.revalidate();
        this.repaint();
    }

    public void intervalRemoved(ListDataEvent evt) {
        this.redoAllItems();
        this.revalidate();
        this.repaint();
    }

    public void contentsChanged(ListDataEvent evt) {
        this.redoAllItems();
        this.revalidate();
        this.repaint();
    }

    public Dimension getPreferredScrollableViewportSize() {
        int width = this.getPreferredSize().width + 20;
        return new Dimension(Math.max(width, 120), this.getLineHeight() * 4);
    }

    public boolean getScrollableTracksViewportHeight() {
        return false;
    }

    public boolean getScrollableTracksViewportWidth() {
        return true;
    }

    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 0 ? visibleRect.width : this.getLineHeight();
    }

    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return orientation == 0 ? visibleRect.width : visibleRect.height;
    }

    private int getLineHeight() {
        return this.entries.size() > 0 ? ((Component)this.entries.get(0)).getHeight() : 0;
    }

    public static interface Annotator {
        public Component createAnnotation(Object var1);
    }
}

