/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import gnu.jel.CompilationException;
import java.awt.Component;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractListModel;
import javax.swing.ComboBoxEditor;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JOptionPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.plaf.basic.BasicComboBoxEditor;
import javax.swing.table.TableColumnModel;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.StarTableColumn;
import uk.ac.starlink.topcat.SyntheticColumn;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.ttools.convert.ValueConverter;
import uk.ac.starlink.ttools.jel.CustomCompilationException;
import uk.ac.starlink.util.gui.WeakTableColumnModelListener;

public class ColumnDataComboBoxModel
extends AbstractListModel
implements TableColumnModelListener,
ComboBoxModel {
    private final TopcatModel tcModel_;
    private final TableColumnModel colModel_;
    private final boolean hasNone_;
    private final boolean hasIndex_;
    private final Class dataClazz_;
    private List activeColumns_;
    private List modelColumns_;
    private ColumnData selected_;
    private static final ValueInfo INDEX_INFO = new DefaultValueInfo("index", Long.class, "Row index");

    public ColumnDataComboBoxModel(TopcatModel tcModel, Class dataClazz, boolean hasNone, boolean hasIndex) {
        this.tcModel_ = tcModel;
        this.colModel_ = tcModel.getColumnModel();
        this.hasNone_ = hasNone;
        this.hasIndex_ = hasIndex;
        this.dataClazz_ = dataClazz;
        this.colModel_.addColumnModelListener((TableColumnModelListener)new WeakTableColumnModelListener((TableColumnModelListener)this));
        this.activeColumns_ = new ArrayList();
        this.modelColumns_ = new ArrayList();
        if (this.hasNone_) {
            this.activeColumns_.add(null);
        }
        if (this.hasIndex_) {
            this.activeColumns_.add(new IndexColumnData(tcModel));
        }
        for (int i = 0; i < this.colModel_.getColumnCount(); ++i) {
            StarTableColumn tcol = (StarTableColumn)this.colModel_.getColumn(i);
            SelectedColumnData cdata = ColumnDataComboBoxModel.getColumnData(tcModel, tcol);
            this.modelColumns_.add(cdata);
            if (!this.acceptType(cdata.getColumnInfo().getContentClass())) continue;
            this.activeColumns_.add(cdata);
        }
    }

    public ColumnDataComboBoxModel(TopcatModel tcModel, Class dataClazz, boolean hasNone) {
        this(tcModel, dataClazz, hasNone, false);
    }

    private boolean acceptType(Class clazz) {
        return this.dataClazz_.isAssignableFrom(clazz);
    }

    public Object getElementAt(int index) {
        return this.activeColumns_.get(index);
    }

    public int getSize() {
        return this.activeColumns_.size();
    }

    public Object getSelectedItem() {
        return this.selected_;
    }

    public ColumnData stringToColumnData(String txt) throws CompilationException {
        if (txt == null || txt.trim().length() == 0) {
            return null;
        }
        int ncol = this.getSize();
        for (int i = 0; i < ncol; ++i) {
            ColumnData item = (ColumnData)this.getElementAt(i);
            if (item == null || !txt.equalsIgnoreCase(item.toString())) continue;
            return item;
        }
        SyntheticColumnData cdata = new SyntheticColumnData(this.tcModel_, txt);
        Class clazz = cdata.getColumnInfo().getContentClass();
        if (this.acceptType(clazz)) {
            return cdata;
        }
        throw new CustomCompilationException("Wrong data type for \"" + txt + "\"");
    }

    public void setSelectedItem(Object item) {
        if (item == null ? this.selected_ != null : !item.equals(this.selected_)) {
            this.selected_ = (ColumnData)item;
            this.fireContentsChanged(this, -1, -1);
        }
    }

    public ColumnData getColumnData(ValueInfo info) {
        int bestScore = 0;
        ColumnData bestData = null;
        for (int i = 0; i < this.getSize(); ++i) {
            ColumnData cdata;
            int score;
            Object item = this.getElementAt(i);
            if (!(item instanceof ColumnData) || (score = this.match(info, (ValueInfo)(cdata = (ColumnData)item).getColumnInfo())) <= bestScore) continue;
            bestScore = score;
            bestData = cdata;
        }
        return bestData;
    }

    private int match(ValueInfo targetInfo, ValueInfo testInfo) {
        int score = 0;
        String targetName = targetInfo.getName();
        String testName = testInfo.getName();
        if (targetName != null && testName != null) {
            targetName = targetName.toLowerCase();
            if ((testName = testName.toLowerCase()).equals(targetName)) {
                score += 5;
            } else if (testName.startsWith(targetName)) {
                score += 2;
            }
        }
        String targetUcd = targetInfo.getUCD();
        String testUcd = testInfo.getUCD();
        if (targetUcd != null && testUcd != null) {
            targetUcd = targetUcd.replace('_', '.').toLowerCase();
            if ((testUcd = testUcd.replace('_', '.').toLowerCase()).equals(targetUcd)) {
                score += 100;
            } else {
                String[] targetWords = targetUcd.split("\\.");
                String[] testWords = testUcd.split("\\.");
                int nword = Math.min(targetWords.length, testWords.length);
                for (int i = 0; i < nword; ++i) {
                    if (!targetWords[i].equals(testWords[i])) continue;
                    score += 10;
                }
            }
        }
        return score;
    }

    public void columnAdded(TableColumnModelEvent evt) {
        int index = evt.getToIndex();
        StarTableColumn tcol = (StarTableColumn)this.colModel_.getColumn(index);
        SelectedColumnData cdata = ColumnDataComboBoxModel.getColumnData(this.tcModel_, tcol);
        this.modelColumns_.add(cdata);
        if (this.acceptType(cdata.getColumnInfo().getContentClass())) {
            int pos = this.activeColumns_.size();
            this.activeColumns_.add(cdata);
            this.fireIntervalAdded(this, pos, pos);
        }
    }

    public void columnRemoved(TableColumnModelEvent evt) {
        int index = evt.getFromIndex();
        ColumnData cdata = (ColumnData)this.modelColumns_.get(index);
        this.modelColumns_.remove(cdata);
        int pos = this.activeColumns_.indexOf(cdata);
        if (pos >= 0) {
            this.activeColumns_.remove(pos);
            this.fireIntervalRemoved(this, pos, pos);
        }
    }

    public void columnMoved(TableColumnModelEvent evt) {
        int from = evt.getFromIndex();
        if (this.activeColumns_.contains(this.modelColumns_.get(from))) {
            List oldActive = this.activeColumns_;
            this.activeColumns_ = new ArrayList();
            this.modelColumns_ = new ArrayList();
            if (this.hasNone_) {
                this.activeColumns_.add(null);
            }
            if (this.hasIndex_) {
                this.activeColumns_.add(new IndexColumnData(this.tcModel_));
            }
            for (int i = 0; i < this.colModel_.getColumnCount(); ++i) {
                StarTableColumn tcol = (StarTableColumn)this.colModel_.getColumn(i);
                SelectedColumnData cdata = ColumnDataComboBoxModel.getColumnData(this.tcModel_, tcol);
                this.modelColumns_.add(cdata);
                if (!oldActive.contains((Object)cdata)) continue;
                this.activeColumns_.add(cdata);
            }
            int index0 = 0;
            if (this.hasNone_) {
                ++index0;
            }
            if (this.hasIndex_) {
                ++index0;
            }
            int index1 = this.activeColumns_.size() - 1;
            this.fireContentsChanged(this, index0, index1);
        }
    }

    public void columnMarginChanged(ChangeEvent evt) {
    }

    public void columnSelectionChanged(ListSelectionEvent evt) {
    }

    public static JComboBox createComboBox() {
        JComboBox comboBox = new JComboBox(){

            public void setModel(ComboBoxModel model) {
                super.setModel(model);
                if (model instanceof ColumnDataComboBoxModel) {
                    ColumnDataComboBoxModel emodel = (ColumnDataComboBoxModel)model;
                    this.setEditor(new ColumnDataEditor(emodel, this));
                }
            }
        };
        comboBox.setEditable(true);
        return comboBox;
    }

    private static SelectedColumnData getColumnData(TopcatModel tcModel, StarTableColumn tcol) {
        ColumnInfo info;
        if (Number.class.isAssignableFrom((info = tcol.getColumnInfo()).getContentClass())) {
            return new SelectedColumnData(tcModel, tcol);
        }
        ValueConverter conv = (ValueConverter)info.getAuxDatumValue(TopcatUtils.NUMERIC_CONVERTER_INFO, ValueConverter.class);
        if (conv != null) {
            return new ConvertedColumnData(tcModel, tcol, conv);
        }
        return new SelectedColumnData(tcModel, tcol);
    }

    private static class IndexColumnData
    extends ColumnData {
        final TopcatModel tcModel_;

        IndexColumnData(TopcatModel tcModel) {
            super(INDEX_INFO);
            this.tcModel_ = tcModel;
        }

        public Object readValue(long irow) {
            return new Long(irow + 1L);
        }

        public String toString() {
            return "index";
        }

        public boolean equals(Object o) {
            return o instanceof IndexColumnData && ((IndexColumnData)((Object)o)).tcModel_ == this.tcModel_;
        }

        public int hashCode() {
            return this.tcModel_.hashCode();
        }
    }

    private static class ConvertedColumnData
    extends SelectedColumnData {
        private final ValueConverter conv_;

        ConvertedColumnData(TopcatModel tcModel, StarTableColumn tcol, ValueConverter conv) {
            super(tcModel, tcol);
            ColumnInfo cinfo = new ColumnInfo(conv.getOutputInfo());
            cinfo.setAuxDatum(new DescribedValue(TopcatUtils.NUMERIC_CONVERTER_INFO, (Object)conv));
            this.setColumnInfo(cinfo);
            this.conv_ = conv;
        }

        public Object readValue(long irow) throws IOException {
            return this.conv_.convert(super.readValue(irow));
        }

        public boolean equals(Object o) {
            return o instanceof ConvertedColumnData && super.equals(o);
        }
    }

    private static class SelectedColumnData
    extends ColumnData {
        private final TopcatModel tcModel_;
        private final int icol_;
        private final StarTable dataModel_;

        SelectedColumnData(TopcatModel tcModel, StarTableColumn tcol) {
            super(tcol.getColumnInfo());
            this.tcModel_ = tcModel;
            this.icol_ = tcol.getModelIndex();
            this.dataModel_ = this.tcModel_.getDataModel();
        }

        public Object readValue(long irow) throws IOException {
            return this.dataModel_.getCell(irow, this.icol_);
        }

        public String toString() {
            return this.getColumnInfo().getName();
        }

        public boolean equals(Object o) {
            if (o instanceof SelectedColumnData) {
                SelectedColumnData other = (SelectedColumnData)((Object)o);
                return other.icol_ == this.icol_ && other.tcModel_ == this.tcModel_;
            }
            return false;
        }

        public int hashCode() {
            int code = this.icol_;
            code = code * 23 + this.tcModel_.hashCode();
            return code;
        }
    }

    private static class SyntheticColumnData
    extends SyntheticColumn {
        private final TopcatModel tcModel_;
        private String expr_;

        SyntheticColumnData(TopcatModel tcModel, String expr) throws CompilationException {
            super((ValueInfo)new DefaultValueInfo(expr), (StarTable)tcModel.getDataModel(), tcModel.getSubsets(), expr, null);
            this.tcModel_ = tcModel;
            this.expr_ = expr;
        }

        public String toString() {
            return this.expr_;
        }

        public boolean equals(Object o) {
            if (o instanceof SyntheticColumnData) {
                SyntheticColumnData other = (SyntheticColumnData)((Object)o);
                return other.tcModel_ == this.tcModel_ && other.expr_.equals(this.expr_);
            }
            return false;
        }

        public int hashCode() {
            int code = this.tcModel_.hashCode();
            code = code * 23 + this.expr_.hashCode();
            return code;
        }
    }

    private static class ColumnDataEditor
    extends BasicComboBoxEditor {
        private final ColumnDataComboBoxModel model_;
        private final Component parent_;
        private final ComboBoxEditor base_;
        private ColumnData data_;

        public ColumnDataEditor(ColumnDataComboBoxModel model, Component parent) {
            this.model_ = model;
            this.parent_ = parent;
            this.base_ = new JComboBox().getEditor();
        }

        public void setItem(Object obj) {
            this.base_.setItem(obj == null ? null : obj.toString());
            this.data_ = (ColumnData)obj;
        }

        public Object getItem() {
            String txt = (String)this.base_.getItem();
            if (this.data_ != null && txt.equals(this.data_.toString())) {
                return this.data_;
            }
            try {
                return this.model_.stringToColumnData(txt);
            }
            catch (CompilationException e) {
                this.base_.setItem(null);
                JOptionPane.showMessageDialog(this.parent_, e.getMessage(), "Evaluation error", 0);
                return null;
            }
        }

        public Component getEditorComponent() {
            return this.base_.getEditorComponent();
        }

        public void selectAll() {
            this.base_.selectAll();
        }

        public void removeActionListener(ActionListener listener) {
            this.base_.removeActionListener(listener);
        }

        public void addActionListener(ActionListener listener) {
            this.base_.addActionListener(listener);
        }
    }
}

