/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.ColumnConverter;
import uk.ac.starlink.topcat.ColumnDataComboBoxModel;
import uk.ac.starlink.topcat.ColumnSelectorModel;
import uk.ac.starlink.topcat.TopcatModel;

public class ColumnSelector
extends JComponent {
    private ColumnSelectorModel model_;
    private final ValueInfo info_;
    private final JComboBox colComboBox_;
    private final JComboBox convComboBox_;
    private final Component[] components_;
    private final JLabel label_;

    public ColumnSelector(ValueInfo info, boolean showLabel) {
        this.info_ = info;
        String units = this.info_.getUnitString();
        ArrayList<JComponent> compList = new ArrayList<JComponent>();
        this.label_ = new JLabel(this.info_.getName() + " column:");
        this.label_.setToolTipText("Select column for " + this.info_.getDescription());
        this.colComboBox_ = ColumnDataComboBoxModel.createComboBox();
        ColumnConverter[] converters = ColumnConverter.getConverters(this.info_);
        if (converters.length > 1) {
            this.convComboBox_ = new JComboBox<ColumnConverter>(converters);
            this.convComboBox_.setSelectedIndex(0);
            this.convComboBox_.setToolTipText("Units for column " + this.info_.getName());
        } else {
            this.convComboBox_ = null;
        }
        this.setLayout(new BoxLayout(this, 0));
        if (showLabel) {
            this.add(this.label_);
            compList.add(this.label_);
            this.add(Box.createHorizontalStrut(5));
        }
        this.add(this.colComboBox_);
        compList.add(this.colComboBox_);
        if (this.convComboBox_ != null) {
            this.add(Box.createHorizontalStrut(5));
            this.add(this.convComboBox_);
            compList.add(this.convComboBox_);
        } else if (units != null && units.toString().length() > 0) {
            this.add(Box.createHorizontalStrut(5));
            JLabel ulabel = new JLabel(" (" + units.trim() + ") ");
            this.add(ulabel);
            compList.add(ulabel);
        }
        this.components_ = compList.toArray(new Component[0]);
        this.setEnabled(false);
    }

    public ColumnSelector(ColumnSelectorModel model, boolean showLabel) {
        this(model.getValueInfo(), showLabel);
        this.setModel(model);
    }

    public void setModel(ColumnSelectorModel model) {
        if (model != null && model.getValueInfo() != this.info_) {
            throw new IllegalArgumentException("Model ValueInfo doesn't match this selector");
        }
        this.model_ = model;
        if (model == null) {
            this.setEnabled(false);
            DefaultComboBoxModel dummy = new DefaultComboBoxModel();
            this.colComboBox_.setModel(dummy);
            if (this.convComboBox_ != null) {
                this.convComboBox_.setModel(dummy);
            }
        } else {
            this.setEnabled(true);
            this.colComboBox_.setModel(model.getColumnModel());
            if (this.convComboBox_ != null) {
                this.convComboBox_.setModel(model.getConverterModel());
            }
        }
    }

    public void setTable(TopcatModel tcModel) {
        this.setModel(new ColumnSelectorModel(tcModel, this.info_));
    }

    public ColumnData getColumnData() {
        return this.model_ == null ? null : this.model_.getColumnData();
    }

    public void setColumnData(ColumnData colData) {
        this.model_.getColumnModel().setSelectedItem(colData);
    }

    public ColumnSelectorModel getModel() {
        return this.model_;
    }

    public JLabel getLabel() {
        return this.label_;
    }

    public void addActionListener(ActionListener listener) {
        this.colComboBox_.addActionListener(listener);
        this.convComboBox_.addActionListener(listener);
    }

    public void removeActionListener(ActionListener listener) {
        this.colComboBox_.removeActionListener(listener);
        this.convComboBox_.removeActionListener(listener);
    }

    public void setEnabled(boolean enabled) {
        for (int i = 0; i < this.components_.length; ++i) {
            this.components_[i].setEnabled(enabled);
        }
        super.setEnabled(enabled);
    }
}

