/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import uk.ac.starlink.table.ColumnData;
import uk.ac.starlink.table.ColumnInfo;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.topcat.ColumnConverter;
import uk.ac.starlink.topcat.ColumnDataComboBoxModel;
import uk.ac.starlink.topcat.TopcatModel;

public class ColumnSelectorModel {
    private final ValueInfo info_;
    private final ComboBoxModel convChooser_;
    private final ColumnConverter converter0_;
    private final Map convMap_ = new HashMap();
    private final SelectionListener selectionListener_;
    private TopcatModel tcModel_;
    private ComboBoxModel colChooser_;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$ColumnSelectorModel;

    public ColumnSelectorModel(TopcatModel tcModel, ValueInfo info) {
        this.info_ = info;
        this.selectionListener_ = new SelectionListener();
        String units = info.getUnitString();
        ColumnConverter[] converters = ColumnConverter.getConverters(info);
        if (converters.length > 1) {
            this.converter0_ = null;
            this.convChooser_ = new DefaultComboBoxModel<ColumnConverter>(converters);
            this.convChooser_.addListDataListener(this.selectionListener_);
        } else {
            this.convChooser_ = null;
            this.converter0_ = converters[0];
        }
        this.setTable(tcModel);
    }

    public void setTable(TopcatModel tcModel) {
        this.tcModel_ = tcModel;
        if (this.colChooser_ != null) {
            this.colChooser_.removeListDataListener(this.selectionListener_);
        }
        this.colChooser_ = ColumnSelectorModel.makeColumnModel(this.tcModel_, this.info_);
        this.colChooser_.addListDataListener(this.selectionListener_);
        ColumnData cdata = (ColumnData)this.colChooser_.getSelectedItem();
        if (cdata != null) {
            this.columnSelected(cdata);
        }
    }

    private ColumnConverter getConverter() {
        if (this.converter0_ != null) {
            return this.converter0_;
        }
        return (ColumnConverter)this.convChooser_.getSelectedItem();
    }

    public ValueInfo getValueInfo() {
        return this.info_;
    }

    public ComboBoxModel getColumnModel() {
        return this.colChooser_;
    }

    public ComboBoxModel getConverterModel() {
        return this.convChooser_;
    }

    public ColumnData getColumnData() {
        ColumnData cdata = (ColumnData)this.colChooser_.getSelectedItem();
        ColumnConverter conv = this.getConverter();
        return cdata == null ? null : new ConvertedColumnData(cdata, conv);
    }

    private void columnSelected(ColumnData cdata) {
        if (this.convChooser_ != null) {
            ColumnConverter storedConverter = (ColumnConverter)this.convMap_.get(cdata);
            if (storedConverter != null) {
                this.convChooser_.setSelectedItem(storedConverter);
            } else {
                this.convChooser_.setSelectedItem(this.guessConverter(cdata.getColumnInfo()));
            }
        }
    }

    private void converterSelected(ColumnConverter conv) {
        this.convMap_.put(this.colChooser_.getSelectedItem(), conv);
    }

    private ColumnConverter guessConverter(ColumnInfo cinfo) {
        block16: {
            if (this.converter0_ != null) {
                return this.converter0_;
            }
            String units = this.info_.getUnitString();
            String cunits = cinfo.getUnitString();
            if (units == null || cunits == null) break block16;
            units = units.toLowerCase();
            cunits = cunits.toLowerCase();
            int nconv = this.convChooser_.getSize();
            if (units.equals("radian") || units.equals("radians")) {
                if (cunits.startsWith("rad")) {
                    for (int i = 0; i < nconv; ++i) {
                        ColumnConverter conv = (ColumnConverter)this.convChooser_.getElementAt(i);
                        if (!conv.toString().toLowerCase().startsWith("rad")) continue;
                        return conv;
                    }
                } else if (cunits.startsWith("deg")) {
                    for (int i = 0; i < nconv; ++i) {
                        ColumnConverter conv = (ColumnConverter)this.convChooser_.getElementAt(i);
                        if (!conv.toString().toLowerCase().startsWith("deg")) continue;
                        return conv;
                    }
                } else if (cunits.startsWith("hour") || cunits.equals("hr") || cunits.equals("hrs")) {
                    for (int i = 0; i < nconv; ++i) {
                        ColumnConverter conv = (ColumnConverter)this.convChooser_.getElementAt(i);
                        if (!conv.toString().toLowerCase().startsWith("hour")) continue;
                        return conv;
                    }
                } else if (cunits.startsWith("arcmin")) {
                    for (int i = 0; i < nconv; ++i) {
                        ColumnConverter conv = (ColumnConverter)this.convChooser_.getElementAt(i);
                        if (!conv.toString().toLowerCase().startsWith("arcmin")) continue;
                        return conv;
                    }
                } else if (cunits.startsWith("arcsec")) {
                    for (int i = 0; i < nconv; ++i) {
                        ColumnConverter conv = (ColumnConverter)this.convChooser_.getElementAt(i);
                        if (!conv.toString().toLowerCase().startsWith("arcsec")) continue;
                        return conv;
                    }
                }
            }
        }
        return (ColumnConverter)this.convChooser_.getElementAt(0);
    }

    private static ComboBoxModel makeColumnModel(TopcatModel tcModel, ValueInfo argInfo) {
        String name;
        if (tcModel == null) {
            return new DefaultComboBoxModel<Object>(new Object[1]);
        }
        ColumnDataComboBoxModel model = new ColumnDataComboBoxModel(tcModel, argInfo.getContentClass(), argInfo.isNullable());
        ColumnData selected = null;
        String ucd = argInfo.getUCD();
        if (ucd != null) {
            for (int i = 0; i < model.getSize() && selected == null; ++i) {
                ColumnInfo info;
                ColumnData cdata = (ColumnData)model.getElementAt(i);
                if (cdata == null || (info = cdata.getColumnInfo()).getUCD() == null || !ColumnSelectorModel.matchUcds(info.getUCD(), ucd)) continue;
                selected = cdata;
            }
        }
        if ((name = argInfo.getName().toLowerCase()) != null) {
            for (int i = 0; i < model.getSize() && selected == null; ++i) {
                ColumnInfo info;
                String cname;
                ColumnData cdata = (ColumnData)model.getElementAt(i);
                if (cdata == null || (cname = (info = cdata.getColumnInfo()).getName()) == null || !cname.toLowerCase().startsWith(name)) continue;
                selected = cdata;
            }
        }
        if (selected != null) {
            model.setSelectedItem(selected);
        }
        return model;
    }

    private static boolean matchUcds(String u1, String u2) {
        return (u1 = u1.replace('_', '.').toLowerCase()).indexOf(u2 = u2.replace('_', '.').toLowerCase()) >= 0;
    }

    private static class ConvertedColumnData
    extends ColumnData {
        private final ColumnData base_;
        private final ColumnConverter converter_;

        ConvertedColumnData(ColumnData base, ColumnConverter converter) {
            super(base.getColumnInfo());
            this.base_ = base;
            this.converter_ = converter;
        }

        public Object readValue(long irow) throws IOException {
            return this.converter_.convertValue(this.base_.readValue(irow));
        }

        public boolean equals(Object o) {
            if (o instanceof ConvertedColumnData) {
                ConvertedColumnData other = (ConvertedColumnData)((Object)o);
                return this.base_ == other.base_ && this.converter_ == other.converter_;
            }
            return false;
        }

        public int hashCode() {
            int code = 9997;
            code = 23 * code + this.base_.hashCode();
            code = 23 * code + this.converter_.hashCode();
            return code;
        }
    }

    private class SelectionListener
    implements ListDataListener {
        static final /* synthetic */ boolean $assertionsDisabled;

        private SelectionListener() {
        }

        public void intervalAdded(ListDataEvent evt) {
        }

        public void intervalRemoved(ListDataEvent evt) {
        }

        public void contentsChanged(ListDataEvent evt) {
            if (evt.getSource() == ColumnSelectorModel.this.colChooser_) {
                ColumnData cdata = (ColumnData)ColumnSelectorModel.this.colChooser_.getSelectedItem();
                if (cdata != null) {
                    ColumnSelectorModel.this.columnSelected(cdata);
                }
            } else if (evt.getSource() == ColumnSelectorModel.this.convChooser_) {
                ColumnConverter conv = (ColumnConverter)ColumnSelectorModel.this.convChooser_.getSelectedItem();
                if (conv != null) {
                    ColumnSelectorModel.this.converterSelected(conv);
                }
            } else if (!$assertionsDisabled) {
                throw new AssertionError();
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$ColumnSelectorModel == null ? (class$uk$ac$starlink$topcat$ColumnSelectorModel = ColumnSelectorModel.class$("uk.ac.starlink.topcat.ColumnSelectorModel")) : class$uk$ac$starlink$topcat$ColumnSelectorModel).desiredAssertionStatus();
        }
    }
}

