/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import cds.tools.ExtApp;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.Enumeration;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.logging.Logger;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.ButtonModel;
import javax.swing.ComboBoxModel;
import javax.swing.DefaultButtonModel;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JMenu;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.ListModel;
import javax.swing.TransferHandler;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.event.TableColumnModelEvent;
import javax.swing.event.TableColumnModelListener;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableColumnModel;
import org.astrogrid.samp.SampUtils;
import uk.ac.starlink.plastic.PlasticUtils;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StarTableOutput;
import uk.ac.starlink.table.gui.PasteLoader;
import uk.ac.starlink.table.gui.TableLoadChooser;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.TextModelsAuthenticator;
import uk.ac.starlink.topcat.Activator;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ColumnInfoWindow;
import uk.ac.starlink.topcat.ConcatWindow;
import uk.ac.starlink.topcat.Driver;
import uk.ac.starlink.topcat.LoadQueryWindow;
import uk.ac.starlink.topcat.LogHandler;
import uk.ac.starlink.topcat.MethodWindow;
import uk.ac.starlink.topcat.MirageHandler;
import uk.ac.starlink.topcat.ParameterWindow;
import uk.ac.starlink.topcat.PlasticStarTable;
import uk.ac.starlink.topcat.ResourceIcon;
import uk.ac.starlink.topcat.SaveQueryWindow;
import uk.ac.starlink.topcat.StatsWindow;
import uk.ac.starlink.topcat.SubsetWindow;
import uk.ac.starlink.topcat.TableViewerWindow;
import uk.ac.starlink.topcat.TopcatEvent;
import uk.ac.starlink.topcat.TopcatExtApp;
import uk.ac.starlink.topcat.TopcatListener;
import uk.ac.starlink.topcat.TopcatModel;
import uk.ac.starlink.topcat.UpDownButton;
import uk.ac.starlink.topcat.ViewerTableModel;
import uk.ac.starlink.topcat.interop.PlasticCommunicator;
import uk.ac.starlink.topcat.interop.SampCommunicator;
import uk.ac.starlink.topcat.interop.TopcatCommunicator;
import uk.ac.starlink.topcat.interop.Transmitter;
import uk.ac.starlink.topcat.join.MatchWindow;
import uk.ac.starlink.topcat.plot.Cartesian3DWindow;
import uk.ac.starlink.topcat.plot.DensityWindow;
import uk.ac.starlink.topcat.plot.GraphicsWindow;
import uk.ac.starlink.topcat.plot.HistogramWindow;
import uk.ac.starlink.topcat.plot.LinesWindow;
import uk.ac.starlink.topcat.plot.PlotWindow;
import uk.ac.starlink.topcat.plot.SphereWindow;
import uk.ac.starlink.util.gui.DragListener;
import uk.ac.starlink.util.gui.ErrorDialog;

public class ControlWindow
extends AuxWindow
implements ListSelectionListener,
ListDataListener,
TableModelListener,
TableColumnModelListener,
TopcatListener {
    private static ControlWindow instance_;
    private static Logger logger_;
    static String interopType_;
    private final JList tablesList_;
    private final DefaultListModel tablesModel_;
    private final TableModelListener tableWatcher_ = this;
    private final TopcatListener topcatWatcher_ = this;
    private final ListSelectionListener selectionWatcher_ = this;
    private final ListDataListener tablesWatcher_ = this;
    private final TableColumnModelListener columnWatcher_ = this;
    private final WindowListener windowWatcher_ = new ControlWindowListener();
    private final StarTableOutput taboutput_ = new StarTableOutput();
    private final boolean canWrite_ = Driver.canWrite();
    private final boolean canRead_ = Driver.canRead();
    private final TransferHandler importTransferHandler_ = new ControlTransferHandler(true, false);
    private final TransferHandler exportTransferHandler_ = new ControlTransferHandler(false, true);
    private final TransferHandler bothTransferHandler_ = new ControlTransferHandler(true, true);
    private final Window window_ = this;
    private final ComboBoxModel dummyComboBoxModel_ = new DefaultComboBoxModel();
    private final ButtonModel dummyButtonModel_ = new DefaultButtonModel();
    private StarTableFactory tabfact_ = new StarTableFactory(true);
    private TableLoadChooser loadChooser_;
    private LoadQueryWindow loadWindow_;
    private ConcatWindow concatWindow_;
    private ExtApp extApp_;
    private final JTextField idField_ = new JTextField();
    private final JLabel indexLabel_ = new JLabel();
    private final JLabel locLabel_ = new JLabel();
    private final JLabel nameLabel_ = new JLabel();
    private final JLabel rowsLabel_ = new JLabel();
    private final JLabel colsLabel_ = new JLabel();
    private final JComboBox subsetSelector_ = new JComboBox();
    private final JComboBox sortSelector_ = new JComboBox();
    private final JToggleButton sortSenseButton_ = new UpDownButton();
    private final JButton activatorButton_ = new JButton();
    private final JCheckBox rowSendButton_ = new JCheckBox();
    private final TopcatCommunicator communicator_;
    private final Action readAct_;
    private final Action writeAct_;
    private final Action dupAct_;
    private final Action mirageAct_;
    private final Action removeAct_;
    private final Action concatAct_;
    private final Action logAct_;
    private final Action[] matchActs_;
    private final ShowAction[] showActs_;
    private final ModelViewAction[] viewActs_;
    private final Action[] graphicsActs_;
    static final /* synthetic */ boolean $assertionsDisabled;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$AuxWindow;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$TopcatModel;
    static /* synthetic */ Class class$java$awt$Component;
    static /* synthetic */ Class class$uk$ac$starlink$topcat$plot$GraphicsWindow;

    private ControlWindow() {
        super("TOPCAT", (Component)null);
        int i;
        this.tabfact_.getJDBCHandler().setAuthenticator((JDBCAuthenticator)new TextModelsAuthenticator());
        this.taboutput_.setJDBCHandler(this.tabfact_.getJDBCHandler());
        this.tablesModel_ = new DefaultListModel();
        this.tablesList_ = new JList(this.tablesModel_);
        this.tablesList_.addListSelectionListener(this.selectionWatcher_);
        this.tablesModel_.addListDataListener(this.tablesWatcher_);
        this.idField_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                ControlWindow.this.getCurrentModel().setLabel(ControlWindow.this.idField_.getText());
            }
        });
        InfoStack info = new InfoStack();
        info.setBorder(BorderFactory.createEmptyBorder(4, 4, 4, 4));
        info.addLine("Label", this.idField_);
        info.addLine("Location", this.locLabel_);
        info.addLine("Name", this.nameLabel_);
        info.addLine("Rows", this.rowsLabel_);
        info.addLine("Columns", this.colsLabel_);
        info.addLine("Sort Order", new Component[]{this.sortSenseButton_, this.sortSelector_});
        info.addLine("Row Subset", this.subsetSelector_);
        info.addLine("Activation Action", new Component[]{this.activatorButton_, this.rowSendButton_});
        this.activatorButton_.setText("           ");
        this.rowSendButton_.setText("Broadcast Row");
        info.fillIn();
        JPanel controlPanel = this.getControlPanel();
        controlPanel.setLayout(new BoxLayout(controlPanel, 0));
        JSplitPane splitter = new JSplitPane(1);
        JScrollPane listScroller = new JScrollPane(this.tablesList_);
        JScrollPane infoScroller = new JScrollPane(info);
        JPanel infoPanel = new JPanel(new BorderLayout());
        infoPanel.add((Component)infoScroller, "Center");
        listScroller.setBorder(ControlWindow.makeTitledBorder("Table List"));
        infoScroller.setBorder(ControlWindow.makeTitledBorder("Current Table Properties"));
        splitter.setLeftComponent(listScroller);
        splitter.setRightComponent(infoPanel);
        splitter.setPreferredSize(new Dimension(600, 250));
        splitter.setDividerLocation(192);
        this.getMainArea().add(splitter);
        this.tablesList_.setDragEnabled(true);
        this.tablesList_.setTransferHandler(this.bothTransferHandler_);
        this.communicator_ = ControlWindow.createCommunicator(this);
        JComponent interopPanel = this.communicator_.createInfoPanel();
        if (interopPanel != null) {
            infoPanel.add((Component)interopPanel, "South");
        }
        this.communicator_.addConnectionListener(new ChangeListener(){

            public void stateChanged(ChangeEvent evt) {
                ControlWindow.this.rowSendButton_.setEnabled(ControlWindow.this.communicator_.isConnected());
            }
        });
        this.rowSendButton_.setToolTipText("On Row Activation send a " + this.communicator_.getProtocolName() + " highlight row message" + " to all registered applications");
        this.rowSendButton_.setEnabled(this.communicator_.isConnected());
        this.removeAct_ = new ControlAction("Discard Table", ResourceIcon.DELETE, "Forget about the current table");
        this.readAct_ = new ControlAction("Load Table", ResourceIcon.LOAD, "Open a new table");
        this.concatAct_ = new ControlAction("Concatenate Tables", ResourceIcon.CONCAT, "Join tables by concatenating them");
        this.logAct_ = new ControlAction("View Log", ResourceIcon.LOG, "Display the log of events");
        this.readAct_.setEnabled(this.canRead_);
        this.logAct_.setEnabled(LogHandler.getInstance() != null);
        this.dupAct_ = new ExportAction("Duplicate Table", ResourceIcon.COPY, "Create a duplicate of the current table");
        this.mirageAct_ = new ExportAction("Export To Mirage", null, "Launch Mirage to display the current table");
        this.mirageAct_.setEnabled(MirageHandler.isMirageAvailable());
        final ModelViewWindowAction viewerAct = new ModelViewWindowAction("Table Data", ResourceIcon.VIEWER, "Display table cell data", TableViewerWindow.class);
        this.viewActs_ = new ModelViewAction[]{viewerAct, new ModelViewWindowAction("Table Parameters", ResourceIcon.PARAMS, "Display table metadata", ParameterWindow.class), new ModelViewWindowAction("Column Info", ResourceIcon.COLUMNS, "Display column metadata", ColumnInfoWindow.class), new ModelViewWindowAction("Row Subsets", ResourceIcon.SUBSETS, "Display row subsets", SubsetWindow.class), new ModelViewWindowAction("Column Statistics", ResourceIcon.STATS, "Display statistics for each column", StatsWindow.class)};
        this.graphicsActs_ = new Action[]{new GraphicsWindowAction("Histogram", ResourceIcon.HISTOGRAM, "Histogram", HistogramWindow.class), new GraphicsWindowAction("Plot", ResourceIcon.PLOT, "Scatter Plot", PlotWindow.class), new GraphicsWindowAction("3D", ResourceIcon.PLOT3D, "Three-dimensional scatter plot", Cartesian3DWindow.class), new GraphicsWindowAction("Sky", ResourceIcon.SPHERE, "Spherical polar scatter plot", SphereWindow.class), new GraphicsWindowAction("Lines", ResourceIcon.STACK, "Stacked line plot", LinesWindow.class), new GraphicsWindowAction("Density", ResourceIcon.DENSITY, "Density plot (2D histogram)", DensityWindow.class)};
        this.writeAct_ = new ModelViewAction("Save Table", ResourceIcon.SAVE, "Write out the current table"){

            public Window createWindow(TopcatModel tcModel) {
                return new SaveQueryWindow(tcModel, ControlWindow.this.getTableOutput(), ControlWindow.this.getLoadChooser(), ControlWindow.this);
            }
        };
        this.matchActs_ = new Action[]{new MatchWindowAction("Internal Match", ResourceIcon.MATCH1, "Perform row matching on a single table", 1), new MatchWindowAction("Pair Match", ResourceIcon.MATCH2, "Create new table by matching rows in two existing tables", 2), new MatchWindowAction("Triple Match", ResourceIcon.MATCHN, "Create new table by matching rows in three existing tables", 3), new MatchWindowAction("Quadruple Match", ResourceIcon.MATCHN, "Create new table by matching rows in four existing tables", 4)};
        Transmitter tableTransmitter = this.communicator_.getTableTransmitter();
        Action interopAct = this.communicator_.createWindowAction(this);
        PasteLoader pasteLoader = new PasteLoader(this){

            protected void tableLoaded(StarTable table, String loc) {
                ControlWindow.this.addTable(table, loc, true);
            }

            public StarTableFactory getTableFactory() {
                return ControlWindow.this.tabfact_;
            }
        };
        this.tablesList_.addMouseListener((MouseListener)pasteLoader);
        JButton readButton = new JButton(this.readAct_);
        readButton.setText(null);
        readButton.setTransferHandler(this.importTransferHandler_);
        readButton.addMouseListener((MouseListener)pasteLoader);
        this.tablesList_.addMouseListener(new MouseAdapter(){

            public void mouseClicked(MouseEvent evt) {
                if (evt.getClickCount() >= 2) {
                    ActionEvent aevt = new ActionEvent(evt.getSource(), evt.getID(), "Display Table");
                    viewerAct.actionPerformed(aevt);
                }
            }
        });
        Object actkey = viewerAct.getValue("Name");
        this.tablesList_.getInputMap().put(KeyStroke.getKeyStroke(10, 0), actkey);
        this.tablesList_.getActionMap().put(actkey, viewerAct);
        JToolBar toolBar = this.getToolBar();
        toolBar.setFloatable(true);
        toolBar.add(readButton);
        this.configureExportSource(toolBar.add(this.writeAct_));
        toolBar.add(tableTransmitter.getBroadcastAction());
        toolBar.addSeparator();
        for (i = 0; i < this.viewActs_.length; ++i) {
            toolBar.add(this.viewActs_[i]);
        }
        toolBar.addSeparator();
        for (i = 0; i < this.graphicsActs_.length; ++i) {
            toolBar.add(this.graphicsActs_[i]);
        }
        toolBar.addSeparator();
        toolBar.add(this.concatAct_);
        toolBar.add(this.matchActs_[0]);
        toolBar.add(this.matchActs_[1]);
        toolBar.addSeparator();
        if (interopAct != null) {
            toolBar.add(interopAct);
        }
        toolBar.add(MethodWindow.getWindowAction(this, false));
        toolBar.addSeparator();
        JMenu fileMenu = this.getFileMenu();
        int fileMenuPos = 0;
        fileMenu.insert(this.readAct_, fileMenuPos++);
        fileMenu.insert(this.writeAct_, fileMenuPos++);
        fileMenu.insert(this.dupAct_, fileMenuPos++);
        fileMenu.insert(this.removeAct_, fileMenuPos++);
        fileMenu.insertSeparator(fileMenuPos++);
        fileMenu.insert(tableTransmitter.getBroadcastAction(), fileMenuPos++);
        fileMenu.insert(tableTransmitter.createSendMenu(), fileMenuPos++);
        if (MirageHandler.isMirageAvailable()) {
            fileMenu.insert(this.mirageAct_, fileMenuPos++);
        }
        fileMenu.insertSeparator(fileMenuPos++);
        fileMenu.insert(this.logAct_, fileMenuPos++);
        fileMenu.insertSeparator(fileMenuPos++);
        JMenu viewMenu = new JMenu("Views");
        viewMenu.setMnemonic(86);
        for (int i2 = 0; i2 < this.viewActs_.length; ++i2) {
            viewMenu.add(this.viewActs_[i2]);
        }
        this.getJMenuBar().add(viewMenu);
        JMenu graphicsMenu = new JMenu("Graphics");
        graphicsMenu.setMnemonic(71);
        for (int i3 = 0; i3 < this.graphicsActs_.length; ++i3) {
            graphicsMenu.add(this.graphicsActs_[i3]);
        }
        this.getJMenuBar().add(graphicsMenu);
        JMenu joinMenu = new JMenu("Joins");
        joinMenu.setMnemonic(74);
        joinMenu.add(this.concatAct_);
        for (int i4 = 0; i4 < this.matchActs_.length; ++i4) {
            joinMenu.add(this.matchActs_[i4]);
        }
        this.getJMenuBar().add(joinMenu);
        JMenu winMenu = new JMenu("Windows");
        winMenu.setMnemonic(87);
        this.showActs_ = this.makeShowActions();
        for (int i5 = 0; i5 < this.showActs_.length; ++i5) {
            winMenu.add(this.showActs_[i5]);
        }
        this.getJMenuBar().add(winMenu);
        JMenu interopMenu = new JMenu("Interop");
        interopMenu.setMnemonic(73);
        if (interopAct != null) {
            interopMenu.add(interopAct);
        }
        Action[] commActions = this.communicator_.getInteropActions();
        for (int ia = 0; ia < commActions.length; ++ia) {
            interopMenu.add(commActions[ia]);
        }
        interopMenu.add(tableTransmitter.getBroadcastAction());
        interopMenu.add(tableTransmitter.createSendMenu());
        this.getJMenuBar().add(interopMenu);
        this.setCloseIsExit();
        this.addHelp("ControlWindow");
        JMenu helpMenu = this.getHelpMenu();
        int ihPos = helpMenu.getItemCount() - 1;
        helpMenu.insert(MethodWindow.getWindowAction(this, false), ihPos++);
        helpMenu.insertSeparator(ihPos++);
        this.setDefaultCloseOperation(0);
        this.addWindowListener(this.windowWatcher_);
        this.updateInfo();
        this.updateControls();
        this.pack();
        this.setVisible(true);
    }

    public static ControlWindow getInstance() {
        if (instance_ == null) {
            instance_ = new ControlWindow();
        }
        return instance_;
    }

    public ExtApp getExtApp() {
        if (this.extApp_ == null) {
            this.extApp_ = new TopcatExtApp(this);
        }
        return this.extApp_;
    }

    public TopcatCommunicator getCommunicator() {
        return this.communicator_;
    }

    public TopcatModel addTable(StarTable table, String location, boolean select) {
        TopcatModel tcModel = new TopcatModel(table, location, this);
        tcModel.setLabel(ControlWindow.shorten(location));
        this.tablesModel_.addElement(tcModel);
        logger_.info("Load new table " + tcModel + " from " + location);
        if (select || this.tablesList_.getSelectedValue() == null) {
            this.tablesList_.setSelectedValue(tcModel, true);
        }
        if (select) {
            this.makeVisible();
        }
        return tcModel;
    }

    public void removeTable(TopcatModel model) {
        if (this.tablesModel_.contains(model)) {
            this.setViewsVisible(model, false);
            this.tablesList_.clearSelection();
            this.tablesModel_.removeElement(model);
        }
    }

    public TopcatModel getCurrentModel() {
        return (TopcatModel)this.tablesList_.getSelectedValue();
    }

    public ListModel getTablesListModel() {
        return this.tablesModel_;
    }

    public LoadQueryWindow getLoader() {
        if (this.loadWindow_ == null) {
            this.loadWindow_ = new LoadQueryWindow(this.tabfact_, this.getLoadChooser(), this){

                protected void performLoading(StarTable st, String loc) {
                    ControlWindow.this.addTable(st, loc, true);
                }
            };
        }
        return this.loadWindow_;
    }

    public ConcatWindow getConcatWindow() {
        if (this.concatWindow_ == null) {
            this.concatWindow_ = new ConcatWindow((Component)this);
        }
        return this.concatWindow_;
    }

    public StarTableFactory getTableFactory() {
        return this.tabfact_;
    }

    public StarTableOutput getTableOutput() {
        return this.taboutput_;
    }

    public void setTableFactory(StarTableFactory tabfact) {
        this.tabfact_ = tabfact;
        this.taboutput_.setJDBCHandler(tabfact.getJDBCHandler());
    }

    public TableLoadChooser getLoadChooser() {
        if (this.loadChooser_ == null) {
            this.loadChooser_ = new TableLoadChooser(this.getTableFactory());
        }
        return this.loadChooser_;
    }

    public void setLoadChooser(TableLoadChooser chooser) {
        this.loadChooser_ = chooser;
    }

    public void setViewsVisible(TopcatModel tcModel, boolean visible) {
        for (int i = 0; i < this.viewActs_.length; ++i) {
            this.viewActs_[i].setViewVisible(tcModel, visible);
        }
    }

    public boolean exit(boolean confirm) {
        if (!confirm || this.tablesModel_.getSize() == 0 || this.confirm("Shut down TOPCAT", "Confirm Exit")) {
            this.removeWindowListener(this.windowWatcher_);
            if (Driver.isStandalone()) {
                System.exit(0);
            } else {
                Enumeration en = this.tablesModel_.elements();
                while (en.hasMoreElements()) {
                    this.removeTable((TopcatModel)en.nextElement());
                }
                this.dispose();
            }
            return true;
        }
        return false;
    }

    private void updateInfo() {
        int i;
        boolean hasModel;
        TopcatModel tcModel = this.getCurrentModel();
        boolean bl = hasModel = tcModel != null;
        if (hasModel) {
            PlasticStarTable dataModel = tcModel.getDataModel();
            ViewerTableModel viewModel = tcModel.getViewModel();
            TableColumnModel columnModel = tcModel.getColumnModel();
            long totCols = dataModel.getColumnCount();
            long totRows = dataModel.getRowCount();
            int visCols = columnModel.getColumnCount();
            int visRows = viewModel.getRowCount();
            String loc = tcModel.getLocation();
            String name = dataModel.getName();
            Activator activator = tcModel.getActivator();
            this.idField_.setText(tcModel.getLabel());
            this.indexLabel_.setText(tcModel.getID() + ": ");
            this.locLabel_.setText(loc);
            this.nameLabel_.setText(loc.equals(name) ? null : name);
            this.rowsLabel_.setText(totRows + ((long)visRows == totRows ? "" : " (" + visRows + " apparent)"));
            this.colsLabel_.setText(totCols + ((long)visCols == totCols ? "" : " (" + visCols + " apparent)"));
            this.sortSelector_.setModel(tcModel.getSortSelectionModel());
            this.subsetSelector_.setModel(tcModel.getSubsetSelectionModel());
            this.sortSenseButton_.setModel(tcModel.getSortSenseModel());
            this.activatorButton_.setAction(tcModel.getActivationAction());
            this.activatorButton_.setText(activator.toString());
            this.rowSendButton_.setModel(tcModel.getRowSendModel());
        } else {
            this.idField_.setText(null);
            this.indexLabel_.setText("0: ");
            this.locLabel_.setText(null);
            this.nameLabel_.setText(null);
            this.rowsLabel_.setText(null);
            this.colsLabel_.setText(null);
            this.sortSelector_.setModel(this.dummyComboBoxModel_);
            this.subsetSelector_.setModel(this.dummyComboBoxModel_);
            this.sortSenseButton_.setModel(this.dummyButtonModel_);
            this.activatorButton_.setModel(this.dummyButtonModel_);
            this.rowSendButton_.setModel(this.dummyButtonModel_);
        }
        this.rowSendButton_.setEnabled(this.communicator_.isConnected());
        this.writeAct_.setEnabled(hasModel && this.canWrite_);
        this.dupAct_.setEnabled(hasModel);
        this.communicator_.getTableTransmitter().setEnabled(hasModel);
        this.mirageAct_.setEnabled(hasModel);
        this.removeAct_.setEnabled(hasModel);
        this.subsetSelector_.setEnabled(hasModel);
        this.sortSelector_.setEnabled(hasModel);
        this.sortSenseButton_.setEnabled(hasModel);
        for (i = 0; i < this.viewActs_.length; ++i) {
            this.viewActs_[i].setEnabled(hasModel);
        }
        for (i = 0; i < this.showActs_.length; ++i) {
            ShowAction sact = this.showActs_[i];
            if (sact.selEffect == sact.otherEffect) continue;
            sact.setEnabled(hasModel);
        }
        this.idField_.setEnabled(hasModel);
        this.idField_.setEditable(hasModel);
    }

    public void updateControls() {
        int i;
        boolean hasTables = this.tablesModel_.getSize() > 0;
        this.concatAct_.setEnabled(hasTables);
        for (i = 0; i < this.matchActs_.length; ++i) {
            this.matchActs_[i].setEnabled(hasTables);
        }
        for (i = 0; i < this.graphicsActs_.length; ++i) {
            this.graphicsActs_[i].setEnabled(hasTables);
        }
    }

    public void valueChanged(ListSelectionEvent evt) {
        int watchCount = 0;
        for (int i = evt.getFirstIndex(); i <= evt.getLastIndex(); ++i) {
            if (i >= this.tablesModel_.size()) continue;
            TopcatModel tcModel = (TopcatModel)this.tablesModel_.getElementAt(i);
            ViewerTableModel viewModel = tcModel.getViewModel();
            TableColumnModel columnModel = tcModel.getColumnModel();
            if (this.tablesList_.isSelectedIndex(i)) {
                ++watchCount;
                tcModel.addTopcatListener(this.topcatWatcher_);
                viewModel.addTableModelListener(this.tableWatcher_);
                columnModel.addColumnModelListener(this.columnWatcher_);
                continue;
            }
            tcModel.removeTopcatListener(this.topcatWatcher_);
            viewModel.removeTableModelListener(this.tableWatcher_);
            columnModel.removeColumnModelListener(this.columnWatcher_);
        }
        if (!$assertionsDisabled && watchCount > 1) {
            throw new AssertionError();
        }
        this.updateInfo();
    }

    public void tableChanged(TableModelEvent evt) {
        this.updateInfo();
    }

    public void modelChanged(TopcatEvent evt) {
        switch (evt.getCode()) {
            case 1: {
                this.updateInfo();
                int index = this.tablesModel_.indexOf(evt.getModel());
                if (index < 0) break;
                ListDataEvent event = new ListDataEvent(this, 0, index, index);
                ListDataListener[] listWatchers = this.tablesModel_.getListDataListeners();
                for (int i = 0; i < listWatchers.length; ++i) {
                    listWatchers[i].contentsChanged(event);
                }
                break;
            }
            case 2: {
                this.updateInfo();
            }
        }
    }

    public void columnAdded(TableColumnModelEvent evt) {
        this.updateInfo();
    }

    public void columnRemoved(TableColumnModelEvent evt) {
        this.updateInfo();
    }

    public void columnMarginChanged(ChangeEvent evt) {
    }

    public void columnMoved(TableColumnModelEvent evt) {
    }

    public void columnSelectionChanged(ListSelectionEvent evt) {
    }

    public void contentsChanged(ListDataEvent evt) {
        this.updateControls();
    }

    public void intervalAdded(ListDataEvent evt) {
        this.updateControls();
    }

    public void intervalRemoved(ListDataEvent evt) {
        this.updateControls();
    }

    private static TopcatCommunicator createCommunicator(ControlWindow control) {
        TopcatCommunicator comm;
        if ("plastic".equals(interopType_)) {
            logger_.info("Run in PLASTIC mode by request");
            return new PlasticCommunicator(control);
        }
        if ("samp".equals(interopType_)) {
            logger_.info("Run in SAMP mode by request");
            try {
                return new SampCommunicator(control);
            }
            catch (IOException e) {
                throw new RuntimeException("SAMP config failed", e);
            }
        }
        if (!$assertionsDisabled && interopType_ != null) {
            throw new AssertionError();
        }
        if (SampUtils.getLockFile().exists()) {
            logger_.info("SAMP hub running - run in SAMP mode");
            try {
                return new SampCommunicator(control);
            }
            catch (IOException e) {
                logger_.warning("SAMP setup failed: " + e);
                logger_.info("Fall back to PLASTIC");
                return new PlasticCommunicator(control);
            }
        }
        if (PlasticUtils.isHubRunning()) {
            logger_.info("PLASTIC hub running - run in PLASTIC mode");
            return new PlasticCommunicator(control);
        }
        try {
            comm = new SampCommunicator(control);
        }
        catch (IOException e) {
            logger_.warning("SAMP setup failed: " + e);
            logger_.info("Fall back to PLASTIC");
            comm = new PlasticCommunicator(control);
        }
        logger_.info("Run in " + comm.getProtocolName() + " mode by default");
        return comm;
    }

    private ShowAction[] makeShowActions() {
        return new ShowAction[]{new ShowAction("Show Selected Views Only", "Show viewer windows for selected table only", WindowEffect.REVEAL, WindowEffect.HIDE), new ShowAction("Show Selected Views", "Show viewer windows for selected table", WindowEffect.REVEAL, WindowEffect.NOOP), new ShowAction("Show All Views", "Show viewer windows of all tables", WindowEffect.REVEAL, WindowEffect.REVEAL), new ShowAction("Hide Unselected Views", "Hide viewer windows for tables except selected one", WindowEffect.NOOP, WindowEffect.HIDE), new ShowAction("Hide Selected Views", "Hide viewer windows for selected table", WindowEffect.HIDE, WindowEffect.NOOP), new ShowAction("Hide All Views", "Hide viewer windows for all tables", WindowEffect.HIDE, WindowEffect.HIDE)};
    }

    private void configureExportSource(JComponent comp) {
        DragListener dragListener = new DragListener();
        comp.addMouseMotionListener((MouseMotionListener)dragListener);
        comp.addMouseListener((MouseListener)dragListener);
        comp.setTransferHandler(this.exportTransferHandler_);
    }

    private static String shorten(String label) {
        int sindex = label.lastIndexOf(47);
        if (sindex < 0 || sindex == label.length() - 1) {
            sindex = label.lastIndexOf(92);
        }
        if (sindex < 0 || sindex == label.length() - 1) {
            sindex = label.lastIndexOf(58);
        }
        if (sindex > 0 && sindex < label.length() - 1) {
            label = label.substring(sindex + 1);
        }
        if (label.length() > 48) {
            label = label.substring(0, 48) + "...";
        }
        return label;
    }

    static {
        $assertionsDisabled = !ControlWindow.class.desiredAssertionStatus();
        logger_ = Logger.getLogger("uk.ac.starlink.topcat");
    }

    private static class InfoStack
    extends JPanel {
        GridBagLayout layer = new GridBagLayout();
        GridBagConstraints c1 = new GridBagConstraints();
        GridBagConstraints c2 = new GridBagConstraints();

        InfoStack() {
            this.setLayout(this.layer);
            this.c1.gridx = 0;
            this.c1.ipadx = 2;
            this.c1.ipady = 2;
            this.c1.anchor = 13;
            this.c2.gridx = 1;
            this.c2.ipadx = 2;
            this.c2.weightx = 1.0;
            this.c2.fill = 0;
            this.c2.gridwidth = 0;
            this.c2.anchor = 17;
        }

        void addLine(String name, JComponent comp) {
            ++this.c1.gridy;
            ++this.c2.gridy;
            this.addItem(new JLabel(name + ": "), this.c1);
            GridBagConstraints c2c = (GridBagConstraints)this.c2.clone();
            if (comp instanceof JTextField) {
                c2c.fill = 2;
            }
            this.addItem(comp, c2c);
        }

        void addLine(String name, Component[] comps) {
            Box compBox = Box.createHorizontalBox();
            for (int i = 0; i < comps.length; ++i) {
                if (i > 0) {
                    compBox.add(Box.createHorizontalStrut(5));
                }
                compBox.add(comps[i]);
            }
            this.addLine(name, compBox);
        }

        void addItem(Component comp, GridBagConstraints c) {
            this.layer.setConstraints(comp, c);
            this.add(comp);
        }

        void fillIn() {
            ++this.c1.gridy;
            Box filler = Box.createHorizontalBox();
            this.c1.weighty = 1.0;
            this.layer.setConstraints(filler, this.c1);
            this.add(filler);
        }
    }

    private class ControlWindowListener
    extends WindowAdapter {
        private ControlWindowListener() {
        }

        public void windowClosing(WindowEvent evt) {
            ControlWindow.this.exit(true);
        }

        public void windowClosed(WindowEvent evt) {
            if (!ControlWindow.this.exit(true)) {
                ControlWindow.this.setVisible(true);
            }
        }
    }

    private class ControlTransferHandler
    extends TransferHandler {
        private boolean imprt;
        private boolean export;

        ControlTransferHandler(boolean imprt, boolean export) {
            this.imprt = imprt;
            this.export = export;
        }

        public int getSourceActions(JComponent comp) {
            return this.export && ControlWindow.this.getCurrentModel() != null ? 1 : 0;
        }

        public boolean canImport(JComponent comp, DataFlavor[] flavs) {
            return this.imprt && ControlWindow.this.tabfact_.canImport(flavs);
        }

        public Icon getVisualRepresentation() {
            return ResourceIcon.TABLE;
        }

        protected Transferable createTransferable(JComponent comp) {
            return ControlWindow.this.taboutput_.transferStarTable(ControlWindow.this.getCurrentModel().getApparentStarTable());
        }

        public boolean importData(JComponent comp, Transferable trans) {
            StarTable table;
            try {
                table = ControlWindow.this.tabfact_.makeStarTable(trans);
                if (table == null) {
                    return false;
                }
            }
            catch (IOException e) {
                ErrorDialog.showError((Component)ControlWindow.this.window_, (String)"Drop Error", (Throwable)e, (String)"Table drop operation failed");
                return false;
            }
            try {
                table = ControlWindow.this.tabfact_.randomTable(table);
                String loc = table.getName();
                loc = loc == null ? "dropped" : loc;
                ControlWindow.this.addTable(table, loc, true);
                return true;
            }
            catch (IOException e) {
                ErrorDialog.showError((Component)ControlWindow.this.window_, (String)"I/O Error", (Throwable)e, (String)"Can't randomise table");
                return false;
            }
        }
    }

    private class ExportAction
    extends BasicAction {
        static final /* synthetic */ boolean $assertionsDisabled;

        ExportAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            TopcatModel tcModel = ControlWindow.this.getCurrentModel();
            if (!$assertionsDisabled && tcModel == null) {
                throw new AssertionError((Object)"Action should be disabled!");
            }
            StarTable table = tcModel.getApparentStarTable();
            if (this == ControlWindow.this.dupAct_) {
                ControlWindow.this.addTable(table, "Copy of " + tcModel.getID(), true);
            } else if (this == ControlWindow.this.mirageAct_) {
                if (!$assertionsDisabled && !MirageHandler.isMirageAvailable()) {
                    throw new AssertionError();
                }
                try {
                    MirageHandler.invokeMirage(table, null);
                }
                catch (Exception e) {
                    ErrorDialog.showError((Component)ControlWindow.this.window_, (String)"Mirage Error", (Throwable)e);
                }
            }
        }

        static {
            $assertionsDisabled = !(class$uk$ac$starlink$topcat$ControlWindow == null ? (class$uk$ac$starlink$topcat$ControlWindow = ControlWindow.class$("uk.ac.starlink.topcat.ControlWindow")) : class$uk$ac$starlink$topcat$ControlWindow).desiredAssertionStatus();
        }
    }

    private static class WindowEffect {
        static final WindowEffect HIDE = new WindowEffect();
        static final WindowEffect REVEAL = new WindowEffect();
        static final WindowEffect NOOP = null;

        private WindowEffect() {
        }
    }

    private class ShowAction
    extends BasicAction {
        final WindowEffect selEffect;
        final WindowEffect otherEffect;

        ShowAction(String name, String shortdesc, WindowEffect selEffect, WindowEffect otherEffect) {
            super(name, null, shortdesc);
            this.selEffect = selEffect;
            this.otherEffect = otherEffect;
        }

        public void actionPerformed(ActionEvent evt) {
            int ntab = ControlWindow.this.tablesModel_.getSize();
            for (int i = 0; i < ntab; ++i) {
                WindowEffect effect;
                boolean isSelected = ControlWindow.this.tablesList_.isSelectedIndex(i);
                TopcatModel tcModel = (TopcatModel)ControlWindow.this.tablesModel_.getElementAt(i);
                WindowEffect windowEffect = effect = isSelected ? this.selEffect : this.otherEffect;
                if (effect == WindowEffect.HIDE) {
                    ControlWindow.this.setViewsVisible(tcModel, false);
                    continue;
                }
                if (effect != WindowEffect.REVEAL) continue;
                ControlWindow.this.setViewsVisible(tcModel, true);
            }
        }
    }

    private class GraphicsWindowAction
    extends BasicAction {
        final Constructor constructor_;

        GraphicsWindowAction(String name, Icon icon, String shortdesc, Class winClass) {
            super(name, icon, shortdesc);
            if (!(class$uk$ac$starlink$topcat$plot$GraphicsWindow == null ? (class$uk$ac$starlink$topcat$plot$GraphicsWindow = ControlWindow.class$("uk.ac.starlink.topcat.plot.GraphicsWindow")) : class$uk$ac$starlink$topcat$plot$GraphicsWindow).isAssignableFrom(winClass)) {
                throw new IllegalArgumentException();
            }
            try {
                this.constructor_ = winClass.getConstructor(class$java$awt$Component == null ? (class$java$awt$Component = ControlWindow.class$("java.awt.Component")) : class$java$awt$Component);
            }
            catch (NoSuchMethodException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("No suitable constructor").initCause(e);
            }
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                Object[] args = new Object[]{ControlWindow.this};
                try {
                    GraphicsWindow window = (GraphicsWindow)this.constructor_.newInstance(args);
                    TopcatModel tcModel = ControlWindow.this.getCurrentModel();
                    if (tcModel != null) {
                        int npoint = (int)Math.min(tcModel.getDataModel().getRowCount(), Integer.MAX_VALUE);
                        window.setGuidePointCount(npoint);
                    }
                    window.setVisible(true);
                    if (tcModel != null) {
                        window.setMainTable(tcModel);
                    }
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException("Window creation failed???", e);
            }
        }
    }

    private class ModelViewWindowAction
    extends ModelViewAction {
        AuxWindow window_;
        final Constructor constructor_;

        ModelViewWindowAction(String name, Icon icon, String shortdesc, Class winClass) {
            super(name, icon, shortdesc);
            if (!(class$uk$ac$starlink$topcat$AuxWindow == null ? (class$uk$ac$starlink$topcat$AuxWindow = ControlWindow.class$("uk.ac.starlink.topcat.AuxWindow")) : class$uk$ac$starlink$topcat$AuxWindow).isAssignableFrom(winClass)) {
                throw new IllegalArgumentException();
            }
            try {
                this.constructor_ = winClass.getConstructor(class$uk$ac$starlink$topcat$TopcatModel == null ? (class$uk$ac$starlink$topcat$TopcatModel = ControlWindow.class$("uk.ac.starlink.topcat.TopcatModel")) : class$uk$ac$starlink$topcat$TopcatModel, class$java$awt$Component == null ? (class$java$awt$Component = ControlWindow.class$("java.awt.Component")) : class$java$awt$Component);
            }
            catch (NoSuchMethodException e) {
                throw (IllegalArgumentException)new IllegalArgumentException("No suitable constructor").initCause(e);
            }
        }

        protected Window createWindow(TopcatModel tcModel) {
            try {
                Object[] args = new Object[]{tcModel, ControlWindow.this};
                try {
                    return (AuxWindow)this.constructor_.newInstance(args);
                }
                catch (InvocationTargetException e) {
                    throw e.getCause();
                }
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Error e) {
                throw e;
            }
            catch (Throwable e) {
                throw new RuntimeException("Window creation failed???", e);
            }
        }
    }

    private abstract class ModelViewAction
    extends BasicAction {
        private final Map modelWindows_;

        ModelViewAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
            this.modelWindows_ = new WeakHashMap();
        }

        public void actionPerformed(ActionEvent evt) {
            TopcatModel tcModel = ControlWindow.this.getCurrentModel();
            if (tcModel == null) {
                return;
            }
            Window window = (Window)this.modelWindows_.get(tcModel);
            if (window == null) {
                window = this.createWindow(tcModel);
                this.modelWindows_.put(tcModel, window);
            }
            window.setVisible(true);
        }

        public void setViewVisible(TopcatModel tcModel, boolean visible) {
            Window window = (Window)this.modelWindows_.get(tcModel);
            if (window != null) {
                if (visible) {
                    window.setVisible(true);
                } else {
                    window.dispose();
                }
            }
        }

        protected abstract Window createWindow(TopcatModel var1);
    }

    private class MatchWindowAction
    extends BasicAction {
        private final int nTable;
        private MatchWindow matchWin;

        MatchWindowAction(String name, Icon icon, String shortdesc, int nTable) {
            super(name, icon, shortdesc);
            this.nTable = nTable;
        }

        public void actionPerformed(ActionEvent evt) {
            if (this.matchWin == null) {
                this.matchWin = new MatchWindow((Component)ControlWindow.this, this.nTable);
            }
            this.matchWin.makeVisible();
        }
    }

    private class ControlAction
    extends BasicAction {
        ControlAction(String name, Icon icon, String shortdesc) {
            super(name, icon, shortdesc);
        }

        public void actionPerformed(ActionEvent evt) {
            if (this == ControlWindow.this.readAct_) {
                ControlWindow.this.getLoader().makeVisible();
            } else if (this == ControlWindow.this.removeAct_) {
                TopcatModel tcModel = ControlWindow.this.getCurrentModel();
                if (ControlWindow.this.confirm("Remove table \"" + tcModel + "\" from list?", "Confirm Remove")) {
                    ControlWindow.this.removeTable(tcModel);
                }
            } else if (this == ControlWindow.this.concatAct_) {
                ControlWindow.this.getConcatWindow().makeVisible();
            } else if (this == ControlWindow.this.logAct_) {
                LogHandler.getInstance().showWindow(ControlWindow.this);
            } else {
                throw new AssertionError();
            }
        }
    }
}

