/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.logging.Logger;
import javax.swing.ComboBoxModel;
import uk.ac.starlink.datanode.nodes.DataNode;
import uk.ac.starlink.datanode.nodes.DefaultDataNode;
import uk.ac.starlink.datanode.nodes.ErrorDataNode;
import uk.ac.starlink.datanode.nodes.ResourceListDataNode;
import uk.ac.starlink.datanode.tree.TreeTableLoadDialog;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.gui.TableConsumer;
import uk.ac.starlink.topcat.TopcatUtils;

public class DemoLoadDialog
extends TreeTableLoadDialog {
    private boolean initialized_;
    private static final Logger logger_ = Logger.getLogger("uk.ac.starlink.topcat");

    public String getName() {
        return "Browse Demo Data";
    }

    public String getDescription() {
        return "View a data hierarchy containing some demonstration tables";
    }

    public boolean isEnabled() {
        return true;
    }

    public boolean showLoadDialog(Component parent, StarTableFactory factory, ComboBoxModel formatModel, TableConsumer eater) {
        if (!this.initialized_) {
            this.clear();
            this.setRoot(DemoLoadDialog.getDemoNode());
            this.initialized_ = true;
        }
        return super.showLoadDialog(parent, factory, formatModel, eater);
    }

    private static DataNode getDemoNode() {
        ArrayList<String> demoList = new ArrayList<String>();
        InputStream strm = DemoLoadDialog.class.getClassLoader().getResourceAsStream(TopcatUtils.DEMO_LOCATION + "/" + TopcatUtils.DEMO_NODES);
        BufferedReader rdr = new BufferedReader(new InputStreamReader(strm));
        try {
            String line;
            while ((line = rdr.readLine()) != null) {
                demoList.add(TopcatUtils.DEMO_LOCATION + "/" + line);
            }
            rdr.close();
        }
        catch (IOException e) {
            return new ErrorDataNode((Throwable)e);
        }
        return demoList.size() > 0 ? new ResourceListDataNode(demoList) : new DefaultDataNode("No demo resources found");
    }
}

