/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.logging.ConsoleHandler;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.SwingUtilities;
import uk.ac.starlink.table.DefaultValueInfo;
import uk.ac.starlink.table.DescribedValue;
import uk.ac.starlink.table.StarTable;
import uk.ac.starlink.table.StarTableFactory;
import uk.ac.starlink.table.StoragePolicy;
import uk.ac.starlink.table.TableBuilder;
import uk.ac.starlink.table.TableFormatException;
import uk.ac.starlink.table.ValueInfo;
import uk.ac.starlink.table.gui.SQLReadDialog;
import uk.ac.starlink.table.gui.TableLoadChooser;
import uk.ac.starlink.table.gui.TableLoadDialog;
import uk.ac.starlink.table.jdbc.JDBCAuthenticator;
import uk.ac.starlink.table.jdbc.TextModelsAuthenticator;
import uk.ac.starlink.topcat.ControlWindow;
import uk.ac.starlink.topcat.LineFormatter;
import uk.ac.starlink.topcat.LogHandler;
import uk.ac.starlink.topcat.TopcatUtils;
import uk.ac.starlink.topcat.interop.TopcatCommunicator;
import uk.ac.starlink.topcat.soap.TopcatSOAPServer;
import uk.ac.starlink.ttools.Stilts;
import uk.ac.starlink.util.DataSource;
import uk.ac.starlink.util.Loader;
import uk.ac.starlink.util.URLUtils;
import uk.ac.starlink.util.gui.ErrorDialog;
import uk.ac.starlink.votable.VOElementFactory;

public class Driver {
    private static boolean standalone;
    private static boolean securityChecked;
    private static Boolean canRead;
    private static Boolean canWrite;
    private static StarTable[] demoTables;
    private static Logger logger;
    private static StarTableFactory tabfact;
    private static ControlWindow control;
    private static String[] extraLoaders;
    private static final ValueInfo DEMOLOC_INFO;
    private static String[] KNOWN_DIALOGS;
    static final /* synthetic */ boolean $assertionsDisabled;

    public static void setStandalone(boolean standalone) {
        Driver.standalone = standalone;
    }

    public static boolean isStandalone() {
        return standalone;
    }

    public static boolean canRead() {
        Driver.checkSecurity();
        return canRead;
    }

    public static boolean canWrite() {
        Driver.checkSecurity();
        return canWrite;
    }

    private static void checkSecurity() {
        if (!securityChecked) {
            SecurityManager sman = System.getSecurityManager();
            if (sman == null) {
                canRead = Boolean.TRUE;
                canWrite = Boolean.TRUE;
            } else {
                String writeDir;
                String readDir;
                try {
                    readDir = System.getProperty("user.home");
                }
                catch (SecurityException e) {
                    readDir = ".";
                }
                try {
                    writeDir = System.getProperty("java.io.tmpdir");
                }
                catch (SecurityException e) {
                    writeDir = ".";
                }
                try {
                    sman.checkRead(readDir);
                    canRead = Boolean.TRUE;
                }
                catch (SecurityException e) {
                    canRead = Boolean.FALSE;
                }
                try {
                    sman.checkWrite(new File(writeDir, "tOpCTeSt.tmp").toString());
                    canWrite = Boolean.TRUE;
                }
                catch (SecurityException e) {
                    canWrite = Boolean.FALSE;
                }
            }
            if (!$assertionsDisabled && canRead == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && canWrite == null) {
                throw new AssertionError();
            }
        }
    }

    public static void main(String[] args) {
        try {
            Loader.checkJ2se();
        }
        catch (ClassNotFoundException e) {
            for (int i = 0; i < args.length; ++i) {
                if (!args[i].toLowerCase().startsWith("-debug")) continue;
                e.printStackTrace(System.err);
            }
            System.err.println(e.getMessage());
            return;
        }
        Driver.runMain(args);
    }

    private static void runMain(String[] args) {
        String cmdname;
        tabfact = new StarTableFactory(true);
        try {
            Loader.loadProperties();
            cmdname = System.getProperty("uk.ac.starlink.topcat.cmdname");
        }
        catch (SecurityException e) {
            cmdname = null;
        }
        Loader.tweakGuiForMac();
        VOElementFactory.STRICT_DEFAULT = false;
        try {
            Logger.getLogger("uk.ac.starlink.hds").setLevel(Level.OFF);
            Logger.getLogger("uk.ac.starlink.ast").setLevel(Level.OFF);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (cmdname == null) {
            cmdname = "topcat";
        }
        String pre = "Usage: " + cmdname;
        String pad = pre.replaceAll(".", " ");
        String usage = pre + " [-help] [-version] [-stilts <stilts-args>]\n" + pad + " [-verbose] [-demo] [-disk]\n" + pad + " [-hub] [-exthub] [-samp] [-plastic] [-soap] [-noserv]\n" + pad + " [-tree] [-file] [-sql] [-cone] [-gavo]" + " [-registry] [-siap]\n" + pad + " [[-f <format>] table ...]";
        Driver.setStandalone(true);
        ArrayList<String> argList = new ArrayList<String>(Arrays.asList(args));
        ArrayList<String> loaderList = new ArrayList<String>();
        boolean demo = false;
        int verbosity = 0;
        boolean soapServe = false;
        boolean interopServe = true;
        boolean internalHub = false;
        boolean externalHub = false;
        boolean stiltsMode = false;
        Iterator it = argList.iterator();
        while (it.hasNext()) {
            String arg = (String)it.next();
            if (arg.equals("-h") || arg.equals("-help")) {
                System.out.println(Driver.getHelp(cmdname));
                return;
            }
            if (arg.equals("-version")) {
                it.remove();
                Logger.getLogger("uk.ac.starlink.topcat").setLevel(Level.WARNING);
                String[] about = TopcatUtils.getAbout();
                System.out.println();
                for (int i = 0; i < about.length; ++i) {
                    System.out.println("    " + about[i]);
                }
                System.out.println();
                return;
            }
            if (arg.equals("-stilts")) {
                it.remove();
                Stilts.main((String[])argList.toArray(new String[0]));
                return;
            }
            if (arg.equals("-v") || arg.equals("-verbose")) {
                it.remove();
                ++verbosity;
                continue;
            }
            if (arg.equals("-demo")) {
                it.remove();
                demo = true;
                continue;
            }
            if (arg.equals("-disk")) {
                it.remove();
                tabfact.setStoragePolicy(StoragePolicy.PREFER_DISK);
                continue;
            }
            if (arg.equals("-hub")) {
                it.remove();
                internalHub = true;
                continue;
            }
            if (arg.equals("-exthub")) {
                it.remove();
                externalHub = true;
                continue;
            }
            if (arg.equals("-samp")) {
                it.remove();
                interopServe = true;
                ControlWindow.interopType_ = "samp";
                continue;
            }
            if (arg.equals("-plastic")) {
                it.remove();
                interopServe = true;
                ControlWindow.interopType_ = "plastic";
                continue;
            }
            if (arg.equals("-noplastic")) {
                it.remove();
                interopServe = false;
                continue;
            }
            if (arg.equals("-soap")) {
                it.remove();
                soapServe = true;
                continue;
            }
            if (arg.equals("-nosoap")) {
                it.remove();
                soapServe = false;
                continue;
            }
            if (arg.startsWith("-noserv")) {
                it.remove();
                soapServe = false;
                interopServe = false;
                continue;
            }
            if (arg.equals("-f") || arg.equals("-format")) continue;
            if (arg.equals("-tree")) {
                it.remove();
                loaderList.add("uk.ac.starlink.datanode.tree.TreeTableLoadDialog");
                continue;
            }
            if (arg.equals("-file")) {
                it.remove();
                loaderList.add("uk.ac.starlink.table.gui.FileChooserLoader");
                continue;
            }
            if (arg.equals("-sql")) {
                it.remove();
                loaderList.add((class$uk$ac$starlink$table$gui$SQLReadDialog == null ? Driver.class$("uk.ac.starlink.table.gui.SQLReadDialog") : class$uk$ac$starlink$table$gui$SQLReadDialog).getName());
                continue;
            }
            if (arg.equals("-cone")) {
                it.remove();
                loaderList.add("uk.ac.starlink.vo.ConeSearchDialog");
                continue;
            }
            if (arg.equals("-gavo")) {
                it.remove();
                loaderList.add("uk.ac.starlink.topcat.contrib.GavoTableLoadDialog");
                continue;
            }
            if (arg.equals("-registry")) {
                it.remove();
                loaderList.add("uk.ac.starlink.vo.RegistryTableLoadDialog");
                continue;
            }
            if (arg.equals("-siap")) {
                it.remove();
                loaderList.add("uk.ac.starlink.vo.SiapTableLoadDialog");
                continue;
            }
            if (!arg.startsWith("-") || arg.length() <= 1) continue;
            System.err.println(usage);
            System.exit(1);
        }
        extraLoaders = loaderList.toArray(new String[0]);
        Driver.configureLogging(verbosity);
        tabfact.getJDBCHandler().setAuthenticator((JDBCAuthenticator)new TextModelsAuthenticator());
        URLUtils.installCustomHandlers();
        ArrayList<String> names = new ArrayList<String>();
        ArrayList<String> handlers = new ArrayList<String>();
        String handler = null;
        Iterator it2 = argList.iterator();
        while (it2.hasNext()) {
            String arg = (String)it2.next();
            if (arg.equals("-f") || arg.equals("-format")) {
                if (it2.hasNext()) {
                    handler = (String)it2.next();
                    if (!handler.equals("auto")) continue;
                    handler = null;
                    continue;
                }
                System.err.println(usage);
                System.exit(1);
                continue;
            }
            if (arg.startsWith("-") && arg.length() > 1) {
                System.err.println(usage);
                System.exit(1);
                continue;
            }
            names.add(arg);
            handlers.add(handler);
        }
        int nload = names.size();
        if (!$assertionsDisabled && nload != handlers.size()) {
            throw new AssertionError();
        }
        Driver.getControlWindow();
        if (demo) {
            StarTable[] demoTables = Driver.getDemoTables();
            for (int i = 0; i < demoTables.length; ++i) {
                StarTable table = demoTables[i];
                if (table == null) continue;
                String loc = table.getParameterByName(DEMOLOC_INFO.getName()).getValue().toString();
                Driver.addTableLater(table, "[Demo]:" + loc);
            }
        }
        for (int i = 0; i < nload; ++i) {
            final String name = (String)names.get(i);
            String hand = (String)handlers.get(i);
            try {
                StarTable startab = tabfact.makeStarTable(name, hand);
                Driver.addTableLater(tabfact.randomTable(startab), name);
                continue;
            }
            catch (OutOfMemoryError e) {
                TopcatUtils.memoryError(e);
                continue;
            }
            catch (Throwable e) {
                System.err.println(e.getMessage());
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        if (e instanceof TableFormatException) {
                            ErrorDialog.showError((Component)Driver.getControlWindow(), (String)"Load Error", (Throwable)e);
                        } else if (e instanceof FileNotFoundException) {
                            ErrorDialog.showError((Component)Driver.getControlWindow(), (String)"Load Error", (Throwable)e, (String)("No such file: " + name));
                        } else {
                            ErrorDialog.showError((Component)Driver.getControlWindow(), (String)"Load Error", (Throwable)e, (String)("Can't open table " + name));
                        }
                    }
                });
            }
        }
        Thread here = Thread.currentThread();
        try {
            here.setPriority((here.getPriority() + 1) / 2);
        }
        catch (SecurityException e) {
            // empty catch block
        }
        if (soapServe) {
            try {
                TopcatSOAPServer.initServices(Driver.getControlWindow());
            }
            catch (Throwable e) {
                logger.warning("No SOAP server: " + e);
            }
        }
        if (internalHub || externalHub) {
            TopcatCommunicator communicator = Driver.getControlWindow().getCommunicator();
            boolean isExternal = externalHub;
            try {
                communicator.startHub(isExternal);
            }
            catch (IOException e) {
                logger.warning("Can't start " + communicator.getProtocolName() + " hub: " + e);
            }
        }
        if (interopServe) {
            TopcatCommunicator communicator = Driver.getControlWindow().getCommunicator();
            boolean isReg = communicator.setActive();
            if (isReg) {
                logger.info("Registered as " + communicator.getProtocolName() + " client");
            } else {
                logger.info(communicator.getProtocolName() + " registration atttempt failed");
            }
        }
    }

    private static ControlWindow getControlWindow() {
        if (control == null) {
            TableLoadChooser chooser = Driver.makeLoadChooser();
            control = ControlWindow.getInstance();
            control.setTableFactory(tabfact);
            control.setLoadChooser(chooser);
        }
        return control;
    }

    private static void addTableLater(final StarTable table, final String location) {
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                Driver.getControlWindow().addTable(table, location, false);
            }
        });
    }

    private static TableLoadChooser makeLoadChooser() {
        ArrayList<TableLoadDialog> dList = new ArrayList<TableLoadDialog>();
        dList.addAll(Arrays.asList(TableLoadChooser.makeDefaultLoadDialogs()));
        ArrayList<String> nameList = new ArrayList<String>();
        Iterator it = dList.iterator();
        while (it.hasNext()) {
            nameList.add(it.next().getClass().getName());
        }
        for (int i = 0; i < extraLoaders.length; ++i) {
            String cname = extraLoaders[i];
            if (nameList.contains(cname)) continue;
            try {
                Class clazz = class$uk$ac$starlink$topcat$Driver == null ? Driver.class$("uk.ac.starlink.topcat.Driver") : class$uk$ac$starlink$topcat$Driver;
                TableLoadDialog tld = (TableLoadDialog)Class.forName(extraLoaders[i]).newInstance();
                dList.add(tld);
                continue;
            }
            catch (Throwable th) {
                System.err.println("Class loading error for optional loader:");
                th.printStackTrace(System.err);
                System.exit(1);
            }
        }
        TableLoadDialog[] dialogs = dList.toArray(new TableLoadDialog[0]);
        return new TableLoadChooser(tabfact, dialogs, KNOWN_DIALOGS);
    }

    static StarTable[] getDemoTables() {
        String base = TopcatUtils.DEMO_LOCATION + '/';
        String[] demoNames = new String[]{"6dfgs_mini.xml.bz2", "messier.xml"};
        int ntab = demoNames.length;
        if (demoTables == null) {
            demoTables = new StarTable[ntab];
            StarTableFactory demoFactory = new StarTableFactory(true);
            for (int i = 0; i < ntab; ++i) {
                String demoName = demoNames[i];
                try {
                    String frag;
                    String name;
                    int fragIndex = demoName.indexOf(35);
                    if (fragIndex > 0) {
                        name = demoName.substring(0, fragIndex);
                        frag = demoName.substring(fragIndex + 1);
                    } else {
                        name = demoName;
                        frag = null;
                    }
                    URL url = (class$uk$ac$starlink$topcat$Driver == null ? Driver.class$("uk.ac.starlink.topcat.Driver") : class$uk$ac$starlink$topcat$Driver).getClassLoader().getResource(base + name);
                    if (url != null) {
                        DataSource datsrc = DataSource.makeDataSource((String)url.toString());
                        if (frag != null) {
                            datsrc.setPosition(frag);
                        }
                        StarTable table = demoFactory.makeStarTable(datsrc);
                        table.getParameters().add(new DescribedValue(DEMOLOC_INFO, (Object)demoName));
                        Driver.demoTables[i] = demoFactory.randomTable(table);
                        continue;
                    }
                    logger.warning("Demo table resource not located: " + base + demoName);
                    continue;
                }
                catch (IOException e) {
                    logger.warning("Demo table " + demoName + " not loaded: " + e.toString());
                }
            }
        }
        return demoTables;
    }

    private static String getHelp(String cmdname) {
        StringBuffer buf = new StringBuffer();
        String p1 = "\n\n    ";
        String p2 = "\n        ";
        buf.append("Usage: ").append(cmdname).append(" <flags> [[-f <format>] <table> ...]");
        buf.append(p1 + "General flags:").append(p2 + "-help          print this message and exit").append(p2 + "-version       print component versions etc " + "and exit").append(p2 + "-verbose       increase verbosity of " + "reports to console").append(p2 + "-demo          start with demo data").append(p2 + "-disk          use disk backing store for " + "large tables").append(p2 + "-samp          use SAMP for tool interoperability").append(p2 + "-plastic       use PLASTIC for " + "tool interoperability").append(p2 + "-hub           run internal SAMP/PLASTIC hub").append(p2 + "-exthub        run external SAMP/PLASTIC hub").append(p2 + "-soap          start SOAP services").append(p2 + "-noserv        don't run any services" + " (PLASTIC, SAMP or SOAP)").append(p2 + "-stilts <args> run STILTS not TOPCAT");
        buf.append(p1 + "Optional load dialogue flags:").append(p2 + "-tree      hierarchy browser").append(p2 + "-file      basic file browser").append(p2 + "-sql       SQL query on relational database").append(p2 + "-cone      cone search dialogue").append(p2 + "-gavo      GAVO Millennium run database query").append(p2 + "-registry  VO registry query").append(p2 + "-siap      Simple Image Access Protocol queries");
        buf.append(p1 + "Useful Java flags:").append(p2).append("-classpath jar1:jar2..  specify additional classes").append(p2).append("-XmxnnnM                use nnn megabytes of memory").append(p2).append("-Dname=value            set system property");
        buf.append(p1 + "Auto-detected formats: ").append(p2);
        Iterator it = tabfact.getDefaultBuilders().iterator();
        while (it.hasNext()) {
            buf.append(((TableBuilder)it.next()).getFormatName().toLowerCase());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(p1 + "All known formats:").append(p2);
        it = tabfact.getKnownFormats().iterator();
        while (it.hasNext()) {
            buf.append(((String)it.next()).toLowerCase());
            if (!it.hasNext()) continue;
            buf.append(", ");
        }
        buf.append(p1 + "Useful system properties " + "(-Dname=value - lists are colon-separated):").append(p2).append("java.io.tmpdir          temporary filespace directory").append(p2).append("jdbc.drivers            JDBC driver classes").append(p2).append("jel.classes             custom algebraic function classes").append(p2).append("jel.classes.activation  custom action function classes").append(p2).append("star.connectors         custom remote filestore classes").append(p2).append("startable.load.dialogs  custom load dialogue classes").append(p2).append("startable.readers       custom table input handlers").append(p2).append("startable.writers       custom table output handlers").append(p2).append("startable.storage       default storage policy").append(p2).append("mark.workaround         work around mark/reset bug").append(p2).append("myspace.cache           MySpace performance workaround").append("");
        return "\n" + buf.toString() + "\n";
    }

    private static void configureLogging(int verbosity) {
        LogHandler customHandler = LogHandler.getInstance();
        if (customHandler == null) {
            return;
        }
        try {
            Logger rootLogger = Logger.getLogger("");
            rootLogger.addHandler(customHandler);
            int verbInt = Math.max(Level.ALL.intValue(), Level.WARNING.intValue() - verbosity * (Level.WARNING.intValue() - Level.INFO.intValue()));
            Level verbLevel = Level.parse(Integer.toString(verbInt));
            Handler[] rootHandlers = rootLogger.getHandlers();
            if (rootHandlers.length > 0 && rootHandlers[0] instanceof ConsoleHandler) {
                rootHandlers[0].setLevel(verbLevel);
                rootHandlers[0].setFormatter(new LineFormatter());
            }
            rootLogger.setLevel(verbLevel);
            Logger.getLogger("org.apache.axis.utils.JavaUtils").setLevel(Level.SEVERE);
        }
        catch (SecurityException e) {
            logger.warning("Logging configuration failed - security exception");
        }
    }

    static {
        $assertionsDisabled = !Driver.class.desiredAssertionStatus();
        standalone = false;
        logger = Logger.getLogger("uk.ac.starlink.topcat");
        DEMOLOC_INFO = new DefaultValueInfo("DemoLoc", String.class, "Demo file location");
        KNOWN_DIALOGS = new String[]{"uk.ac.starlink.table.gui.FileChooserLoader", "uk.ac.starlink.datanode.tree.TreeTableLoadDialog", SQLReadDialog.class.getName(), "uk.ac.starlink.vo.ConeSearchDialog", "uk.ac.starlink.topcat.contrib.GavoTableLoadDialog", "uk.ac.starlink.vo.RegistryTableLoadDialog", "uk.ac.starlink.vo.SiapTableLoadDialog"};
    }
}

