/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.net.URL;
import java.util.logging.Logger;
import javax.help.BadIDException;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.Map;
import javax.swing.AbstractAction;
import uk.ac.starlink.topcat.HelpWindow;
import uk.ac.starlink.topcat.ResourceIcon;

public class HelpAction
extends AbstractAction {
    private final String helpID_;
    private final Component parent_;
    private HelpWindow helpWin_;
    private static HelpSet hset_;
    private static final Logger logger_;

    public HelpAction(String helpID, Component parent) {
        this.helpID_ = helpID;
        this.parent_ = parent;
        this.putValue("Name", helpID == null ? "Help" : "Help for Window");
        this.putValue("SmallIcon", helpID == null ? ResourceIcon.MANUAL : ResourceIcon.HELP);
        this.putValue("ShortDescription", helpID == null ? "Display help browser" : "Display help for this window in browser");
        if (!HelpAction.helpIdExists(helpID)) {
            logger_.warning("Unknown help ID " + helpID);
            this.putValue("ShortDescription", this.getValue("ShortDescription") + " (unavailable)");
            this.setEnabled(false);
        }
    }

    public void actionPerformed(ActionEvent evt) {
        if (this.helpWin_ == null) {
            this.helpWin_ = HelpWindow.getInstance(this.parent_);
        }
        this.helpWin_.makeVisible();
        this.helpWin_.setID(this.helpID_);
    }

    public static boolean helpIdExists(String helpID) {
        if (hset_ == null) {
            URL hsResource = HelpWindow.class.getResource("help/sun253.hs");
            try {
                hset_ = new HelpSet(null, hsResource);
            }
            catch (HelpSetException e) {
                logger_.warning("Can't locate helpset at " + hsResource);
            }
        }
        try {
            Map.ID.create((String)helpID, (HelpSet)hset_);
            return true;
        }
        catch (BadIDException e) {
            return false;
        }
    }

    static {
        logger_ = Logger.getLogger("uk.ac.starlink.topcat");
    }
}

