/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.logging.Logger;
import javax.help.HelpSet;
import javax.help.HelpSetException;
import javax.help.InvalidHelpSetContextException;
import javax.help.JHelp;
import javax.help.JHelpContentViewer;
import javax.help.JHelpTOCNavigator;
import javax.help.Map;
import javax.help.event.HelpModelEvent;
import javax.help.event.HelpModelListener;
import javax.swing.Box;
import javax.swing.JLabel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.UIManager;
import uk.ac.starlink.topcat.AuxWindow;

public class HelpWindow
extends AuxWindow {
    public static final String HELPSET_LOCATION = "help/sun253.hs";
    private JLabel urlHead;
    private JTextField urlInfo;
    private JHelp jhelp;
    private HelpSet hset;
    private boolean fontSet;
    private static HelpWindow instance;
    private static Logger logger;

    private HelpWindow(Component parent) {
        super("TOPCAT Help", parent);
        JTextArea helpComponent;
        Box infoBox = new Box(0);
        this.urlHead = new JLabel(" External URL: ");
        this.urlInfo = new JTextField();
        this.urlInfo.setEditable(false);
        infoBox.add(this.urlHead);
        infoBox.add(this.urlInfo);
        this.externalURL(null);
        this.getContentPane().add((Component)infoBox, "South");
        try {
            URL hsResource = HelpWindow.class.getResource(HELPSET_LOCATION);
            this.hset = new HelpSet(null, hsResource);
            this.jhelp = new JHelp(this.hset);
            this.jhelp.setPreferredSize(new Dimension(700, 500));
            helpComponent = this.jhelp;
            HelpWindow.openTOC(this.jhelp);
            JHelpContentViewer cview = this.jhelp.getContentViewer();
            cview.addHelpModelListener(new HelpModelListener(){

                public void idChanged(HelpModelEvent evt) {
                    URL url = evt.getID() == null ? evt.getURL() : null;
                    HelpWindow.this.externalURL(url);
                }
            });
            cview.setSynch(true);
            this.pinchHelpToolBarTools(this.jhelp);
        }
        catch (HelpSetException e) {
            String msg;
            StringWriter swriter = new StringWriter();
            try {
                e.printStackTrace(new PrintWriter(swriter));
                swriter.close();
            }
            catch (IOException e2) {
                msg = e.toString();
            }
            msg = swriter.toString();
            helpComponent = new JTextArea(msg);
        }
        this.addHelp("HelpWindow");
        this.getContentPane().add(helpComponent);
    }

    public static HelpWindow getInstance(Component parent) {
        if (instance == null) {
            instance = new HelpWindow(parent);
        }
        return instance;
    }

    public JHelp getJHelp() {
        return this.jhelp;
    }

    public void setID(String helpID) {
        if (this.hset != null && helpID != null) {
            Map.ID mapID = Map.ID.create((String)helpID, (HelpSet)this.hset);
            if (mapID != null) {
                try {
                    Font font;
                    this.jhelp.setCurrentID(mapID);
                    if (!this.fontSet && (font = UIManager.getFont("TextField.font")) != null) {
                        this.jhelp.setFont(font);
                        this.fontSet = true;
                    }
                }
                catch (InvalidHelpSetContextException e) {
                    logger.info("Bad help ID: " + helpID);
                }
            } else {
                logger.info("Unknown help ID: " + helpID);
            }
        }
    }

    private void pinchHelpToolBarTools(JHelp helpComponent) {
        Component[] contents = helpComponent.getComponents();
        JToolBar jhBar = null;
        for (int i = 0; i < contents.length; ++i) {
            if (!(contents[i] instanceof JToolBar)) continue;
            jhBar = (JToolBar)contents[i];
            break;
        }
        if (jhBar != null) {
            Component tool;
            ArrayList<Component> tools = new ArrayList<Component>();
            int i = 0;
            while ((tool = jhBar.getComponentAtIndex(i)) != null) {
                tools.add(tool);
                ++i;
            }
            Iterator it = tools.iterator();
            while (it.hasNext()) {
                tool = (Component)it.next();
                jhBar.remove(tool);
                this.getToolBar().add(tool);
            }
            this.getToolBar().addSeparator();
            helpComponent.remove((Component)jhBar);
        }
    }

    private void externalURL(URL url) {
        boolean isActive = url != null;
        this.urlHead.setEnabled(isActive);
        this.urlInfo.setText(isActive ? url.toString() : null);
    }

    private static void openTOC(JHelp jhelp) {
        JHelpTOCNavigator tocnav = null;
        Enumeration en = jhelp.getHelpNavigators();
        while (en.hasMoreElements()) {
            Object nav = en.nextElement();
            if (!(nav instanceof JHelpTOCNavigator)) continue;
            tocnav = (JHelpTOCNavigator)nav;
            break;
        }
        if (tocnav == null) {
            return;
        }
        HelpSet hs = jhelp.getModel().getHelpSet();
        Enumeration en2 = hs.getCombinedMap().getAllIDs();
        while (en2.hasMoreElements()) {
            String id = ((Map.ID)en2.nextElement()).id;
            tocnav.expandID(id);
        }
    }

    static {
        logger = Logger.getLogger("uk.ac.starlink.topcat");
    }
}

