/*
 * Decompiled with CFR 0.152.
 */
package uk.ac.starlink.topcat;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.Icon;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import uk.ac.starlink.topcat.AuxWindow;
import uk.ac.starlink.topcat.BasicAction;
import uk.ac.starlink.topcat.ResourceIcon;

public class HtmlWindow
extends AuxWindow {
    private final JEditorPane textPane_;
    private final JLabel urlLabel_;
    private final List history_;
    private static final int HISTORY_LIMIT = 100;
    private int historyPoint_;
    private final Action forwardAct_;
    private final Action backAct_;
    static final /* synthetic */ boolean $assertionsDisabled;

    public HtmlWindow(Component parent) {
        super("Html Browser", parent);
        JPanel main = this.getMainArea();
        main.setLayout(new BorderLayout());
        this.textPane_ = new JEditorPane();
        this.textPane_.setEditable(false);
        JScrollPane scroller = new JScrollPane(this.textPane_);
        scroller.setPreferredSize(new Dimension(450, 400));
        main.add((Component)scroller, "Center");
        Box line = Box.createHorizontalBox();
        line.add(new JLabel("URL: "));
        this.urlLabel_ = new JLabel();
        line.add(this.urlLabel_);
        this.getContentPane().add((Component)line, "South");
        this.textPane_.addHyperlinkListener(new HyperlinkListener(){

            public void hyperlinkUpdate(HyperlinkEvent evt) {
                if (evt.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                    try {
                        HtmlWindow.this.setURL(evt.getURL());
                    }
                    catch (IOException e) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
            }
        });
        this.history_ = new ArrayList();
        this.historyPoint_ = -1;
        this.forwardAct_ = new AdvanceAction("Forward", ResourceIcon.FORWARD, "Go forward a page", 1);
        this.backAct_ = new AdvanceAction("Back", ResourceIcon.BACKWARD, "Go back a page", -1);
        this.configureActions();
        this.getToolBar().add(this.backAct_);
        this.getToolBar().add(this.forwardAct_);
        this.getToolBar().addSeparator();
        this.addHelp("documentViewers");
    }

    public void setURL(URL url) throws IOException {
        this.moveToURL(url);
        while (this.history_.size() > this.historyPoint_ + 1) {
            this.history_.remove(this.history_.size() - 1);
        }
        if (!$assertionsDisabled && this.historyPoint_ != this.history_.size() - 1) {
            throw new AssertionError();
        }
        this.history_.add(url);
        ++this.historyPoint_;
        while (this.history_.size() > 100 && this.historyPoint_ >= 0) {
            this.history_.remove(0);
            --this.historyPoint_;
        }
        this.configureActions();
    }

    private void moveToURL(URL url) throws IOException {
        this.textPane_.setPage(url);
        this.urlLabel_.setText(url.toString());
    }

    private void configureActions() {
        this.backAct_.setEnabled(this.historyPoint_ > 0);
        this.forwardAct_.setEnabled(this.historyPoint_ < this.history_.size() - 1);
    }

    static {
        $assertionsDisabled = !HtmlWindow.class.desiredAssertionStatus();
    }

    private class AdvanceAction
    extends BasicAction {
        private final int increment_;

        public AdvanceAction(String name, Icon icon, String description, int increment) {
            super(name, icon, description);
            this.increment_ = increment;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                HtmlWindow.this.moveToURL((URL)HtmlWindow.this.history_.get(HtmlWindow.this.historyPoint_ + this.increment_));
                HtmlWindow.this.historyPoint_ += this.increment_;
                HtmlWindow.this.configureActions();
            }
            catch (IOException e) {
                Toolkit.getDefaultToolkit().beep();
            }
        }
    }
}

